/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.base;

import com.pcbsys.foundation.base.fBaseTransportObject;
import com.pcbsys.foundation.base.fMissingKeyHandler;
import com.pcbsys.foundation.base.fRuntime;
import com.pcbsys.foundation.base.fStringEntry;
import com.pcbsys.foundation.collections.SortedObject;
import com.pcbsys.foundation.collections.SortedVector;
import com.pcbsys.foundation.collections.SortedVectorIterator;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fEventInputStream;
import com.pcbsys.foundation.io.fEventOutputStream;
import com.pcbsys.foundation.utils.fStringByteConverter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class fEventDictionary
extends fBaseTransportObject {
    private static final byte c_String = 0;
    private static final byte c_Long = 1;
    private static final byte c_Double = 2;
    private static final byte c_Boolean = 3;
    private static final byte c_Integer = 4;
    private static final byte c_Float = 5;
    private static final byte c_Char = 6;
    private static final byte c_Byte = 7;
    private static final byte c_Short = 8;
    private static final byte c_Dictionary = 9;
    private static final byte c_Array = 100;
    private static final String sMyDelimiter = "<delimiter>";
    private static final String IS_COMPRESSED = "is_compressed";
    private static final String COMPRESSED_BODY = "compressed_body";
    private static final int SIZE_ESTIMATE = 96;
    private static final int MAP_PER_KEY_USAGE_ESTIMATE = 80;
    private static final int MAP_USAGE_ESTIMATE = 80;
    private static final int INTEGER_OBJ_SIZE = 16;
    private static final int FLOAT_OBJ_SIZE = 16;
    private static final int SHORT_OBJ_SIZE = 16;
    private static final int CHAR_OBJ_SIZE = 16;
    private static final int BYTE_OBJ_SIZE = 16;
    private static final int BOOLEAN_OBJ_SIZE = 16;
    private static final int DOUBLE_OBJ_SIZE = 24;
    private static final int LONG_OBJ_SIZE = 24;
    private static final int ARRAY_OBJ_SIZE = 16;
    private int heapUsageEstimate = 96;
    private final LinkedHashMap<fStringEntry, Object> myHash = new LinkedHashMap();
    private boolean isValidDictionary;
    private boolean enableCaching = true;
    private fMissingKeyHandler myMissingHandler;
    private boolean mySortOnWrite = false;
    private SortedVector mySortedKeys;
    private boolean isWriteLocked;

    public fEventDictionary() {
        this.isValidDictionary = true;
        this.isWriteLocked = false;
    }

    public fEventDictionary(String string) {
        if (string.contains("EventDictionaryFlag")) {
            this.isValidDictionary = true;
            this.deserialize(string);
        } else {
            this.isValidDictionary = false;
        }
        this.isWriteLocked = false;
    }

    public void setMissingKeyHandler(fMissingKeyHandler fMissingKeyHandler2) {
        this.myMissingHandler = fMissingKeyHandler2;
    }

    public boolean hasMissingKeyHandler() {
        return this.myMissingHandler != null;
    }

    public void setReadOnly(boolean bl) {
        this.isWriteLocked = bl;
    }

    public void setSortOnWrite(boolean bl) {
        this.mySortOnWrite = bl;
    }

    private boolean getSortOnWrite() {
        return this.mySortOnWrite;
    }

    public boolean containsKey(String string) {
        return this.getObjectFromHash(string) != null;
    }

    public void remove(String string) {
        this.isWriteLocked();
        this.removeObjectFromHash(string);
        this.mySortedKeys = null;
    }

    public void merge(fEventDictionary fEventDictionary2, boolean bl) {
        this.isWriteLocked();
        this.merge(fEventDictionary2, bl, true);
    }

    public void merge(fEventDictionary fEventDictionary2, boolean bl, boolean bl2) {
        this.isWriteLocked();
        LinkedHashMap<fStringEntry, Object> linkedHashMap = fEventDictionary2.myHash;
        Iterator<Map.Entry<fStringEntry, Object>> iterator = linkedHashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<fStringEntry, Object> entry = iterator.next();
            Object object = entry.getValue();
            if (object instanceof fEventDictionary) {
                if (this.myHash.containsKey(entry.getKey())) {
                    Object object2 = this.myHash.get(entry.getKey());
                    if (object2 instanceof fEventDictionary) {
                        fEventDictionary fEventDictionary3 = new fEventDictionary();
                        fEventDictionary3.merge((fEventDictionary)object2, bl);
                        fEventDictionary3.merge((fEventDictionary)object, bl, false);
                        this.myHash.put(entry.getKey(), fEventDictionary3);
                        continue;
                    }
                    if (!bl) continue;
                    this.myHash.remove(entry.getKey());
                    this.myHash.put(entry.getKey(), object);
                    continue;
                }
                this.myHash.put(entry.getKey(), object);
                continue;
            }
            if (!this.myHash.containsKey(entry.getKey())) {
                this.myHash.put(entry.getKey(), object);
                continue;
            }
            if (!bl) continue;
            boolean bl3 = false;
            if ((object instanceof String || object instanceof fStringEntry) && object.toString().equals("<NRVUPD_KEY_DELETED>")) {
                this.myHash.remove(entry.getKey());
                bl3 = true;
            }
            if (bl3) continue;
            if (!this.myHash.get(entry.getKey()).equals(object)) {
                this.myHash.remove(entry.getKey());
                this.myHash.put(entry.getKey(), object);
                continue;
            }
            if (!bl2) continue;
            if (fEventDictionary2.isWriteLocked) {
                throw new Error("Dictionary is currently write locked");
            }
            iterator.remove();
        }
        this.mySortedKeys = null;
    }

    public void copy(fEventDictionary fEventDictionary2) {
        this.isWriteLocked();
        this.myHash.clear();
        this.myHash.putAll(fEventDictionary2.myHash);
        this.isValidDictionary = true;
        this.mySortedKeys = null;
    }

    public void copy(fEventDictionary fEventDictionary2, boolean bl) {
        this.isWriteLocked();
        if (!bl) {
            this.copy(fEventDictionary2);
            return;
        }
        this.myHash.clear();
        LinkedHashMap<fStringEntry, Object> linkedHashMap = fEventDictionary2.myHash;
        for (Map.Entry<fStringEntry, Object> entry : linkedHashMap.entrySet()) {
            Object object = entry.getValue();
            if (object instanceof fEventDictionary) {
                fEventDictionary fEventDictionary3 = (fEventDictionary)object;
                object = new fEventDictionary();
                ((fEventDictionary)object).copy(fEventDictionary3, true);
            }
            this.myHash.put(entry.getKey(), object);
        }
        this.isValidDictionary = true;
        this.mySortedKeys = null;
    }

    public boolean isEnableCaching() {
        return this.enableCaching;
    }

    public void setEnableCaching(boolean bl) {
        this.enableCaching = bl;
    }

    public Iterator<fStringEntry> getKeyIterator() {
        return this.myHash.keySet().iterator();
    }

    public Iterator<Object> getValueIterator() {
        return this.myHash.values().iterator();
    }

    public Collection<Object> values() {
        return this.myHash.values();
    }

    public Iterator<Map.Entry<fStringEntry, Object>> getEntrySet() {
        return this.myHash.entrySet().iterator();
    }

    public Enumeration<fStringEntry> getKeys() {
        Vector<fStringEntry> vector = new Vector<fStringEntry>();
        for (fStringEntry fStringEntry2 : this.myHash.keySet()) {
            vector.add(fStringEntry2);
        }
        return vector.elements();
    }

    public Set<fStringEntry> getKeySet() {
        return this.myHash.keySet();
    }

    public Enumeration<Object> getValues() {
        Vector<Object> vector = new Vector<Object>();
        for (Object object : this.myHash.values()) {
            vector.add(object);
        }
        return vector.elements();
    }

    public Enumeration<String> getKeysAsStrings() {
        Vector<String> vector = new Vector<String>();
        for (fStringEntry fStringEntry2 : this.myHash.keySet()) {
            vector.add(fStringEntry2.toString());
        }
        return vector.elements();
    }

    public String getClass(String string) {
        Object object = this.getObjectFromHash(string);
        if (object == null) {
            return null;
        }
        return object.getClass().toString();
    }

    public Object get(String string) {
        String[] stringArray = this.getObjectFromHash(string);
        if (stringArray instanceof fStringEntry) {
            stringArray = ((fStringEntry)stringArray).getString();
        } else if (stringArray instanceof fStringEntry[]) {
            stringArray = fEventDictionary.convertToStringArray((fStringEntry[])stringArray);
        }
        return stringArray;
    }

    public Object get(byte[] byArray) {
        String[] stringArray = this.getObjectFromHash(byArray);
        if (stringArray instanceof fStringEntry) {
            stringArray = ((fStringEntry)stringArray).getString();
        } else if (stringArray instanceof fStringEntry[]) {
            stringArray = fEventDictionary.convertToStringArray((fStringEntry[])stringArray);
        }
        return stringArray;
    }

    public Object getNative(fStringEntry fStringEntry2) {
        return this.getObjectFromHash(fStringEntry2);
    }

    public Object getRaw(String string) {
        Object object = this.getObjectFromHash(string);
        if (object instanceof fStringEntry) {
            object = ((fStringEntry)object).getBytes();
        }
        return object;
    }

    public void put(String string, fEventDictionary fEventDictionary2) {
        this.putObjectInHash(string, (Object)fEventDictionary2);
    }

    public void put(String string, Object object) {
        this.putObjectInHash(string, object);
    }

    public void put(byte[] byArray, Object object) {
        this.putObjectInHash(byArray, object);
    }

    public void put(String string, fEventDictionary[] fEventDictionaryArray) {
        this.putObjectInHash(string, (Object)fEventDictionaryArray);
    }

    public fEventDictionary getDictionary(String string) {
        Object object = this.getObjectFromHash(string);
        if (!(object instanceof fEventDictionary)) {
            return null;
        }
        return (fEventDictionary)object;
    }

    public fEventDictionary getDictionary(byte[] byArray) {
        Object object = this.getObjectFromHash(byArray);
        if (!(object instanceof fEventDictionary)) {
            return null;
        }
        return (fEventDictionary)object;
    }

    public fEventDictionary[] getDictionaryArray(String string) {
        Object object = this.getObjectFromHash(string);
        if (!(object instanceof fEventDictionary[])) {
            return null;
        }
        return (fEventDictionary[])object;
    }

    public void put(String string, String string2) {
        this.putObjectInHash(string, (Object)new fStringEntry(string2));
    }

    public void put(byte[] byArray, String string) {
        this.putObjectInHash(byArray, (Object)new fStringEntry(string));
    }

    public void put(byte[] byArray, byte[] byArray2) {
        this.putObjectInHash(byArray, (Object)new fStringEntry(byArray2));
    }

    public void put(String string, String[] stringArray) {
        if (stringArray != null) {
            fStringEntry[] fStringEntryArray = new fStringEntry[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                fStringEntryArray[i] = new fStringEntry(stringArray[i]);
            }
            this.putObjectInHash(string, (Object)fStringEntryArray);
        }
    }

    public void put(String string, short s) {
        this.putObjectInHash(string, (Object)s);
    }

    public void put(String string, short[] sArray) {
        this.putObjectInHash(string, (Object)sArray);
    }

    public void put(String string, byte by) {
        this.putObjectInHash(string, (Object)by);
    }

    public void put(byte[] byArray, byte by) {
        this.putObjectInHash(byArray, (Object)by);
    }

    public void put(String string, byte[] byArray) {
        this.putObjectInHash(string, (Object)byArray);
    }

    public byte getByte(String string) {
        Object object = this.getObjectFromHash(string);
        if (object == null || !(object instanceof Long) && !(object instanceof Short) && !(object instanceof Byte) && !(object instanceof Integer)) {
            return 0;
        }
        if (object instanceof Byte) {
            return (Byte)object;
        }
        if (object instanceof Long) {
            return ((Long)object).byteValue();
        }
        if (object instanceof Short) {
            return ((Short)object).byteValue();
        }
        return ((Integer)object).byteValue();
    }

    public byte[] getByteArray(String string) {
        Object object = this.getObjectFromHash(string);
        if (!(object instanceof byte[])) {
            return null;
        }
        return (byte[])object;
    }

    public short getShort(String string) {
        Object object = this.getObjectFromHash(string);
        if (object == null || !(object instanceof Long) && !(object instanceof Short) && !(object instanceof Byte) && !(object instanceof Integer)) {
            return 0;
        }
        if (object instanceof Short) {
            return (Short)object;
        }
        if (object instanceof Byte) {
            return ((Byte)object).shortValue();
        }
        if (object instanceof Integer) {
            return ((Integer)object).shortValue();
        }
        return ((Long)object).shortValue();
    }

    public short[] getShortArray(String string) {
        Object object = this.getObjectFromHash(string);
        if (!(object instanceof short[])) {
            return null;
        }
        return (short[])object;
    }

    public void put(String string, char c) {
        this.putObjectInHash(string, (Object)Character.valueOf(c));
    }

    public void put(byte[] byArray, char c) {
        this.putObjectInHash(byArray, (Object)Character.valueOf(c));
    }

    public void put(String string, char[] cArray) {
        this.putObjectInHash(string, (Object)cArray);
    }

    public char getChar(String string) {
        Object object = this.getObjectFromHash(string);
        if (!(object instanceof Character)) {
            return '\u0000';
        }
        return ((Character)object).charValue();
    }

    public char[] getCharArray(String string) {
        Object object = this.getObjectFromHash(string);
        if (!(object instanceof char[])) {
            return null;
        }
        return (char[])object;
    }

    public void put(String string, boolean bl) {
        this.putObjectInHash(string, (Object)bl);
    }

    public void put(byte[] byArray, boolean bl) {
        this.putObjectInHash(byArray, (Object)bl);
    }

    public void put(String string, boolean[] blArray) {
        this.putObjectInHash(string, (Object)blArray);
    }

    public void put(String string, int n) {
        this.putObjectInHash(string, (Object)n);
    }

    public void put(byte[] byArray, int n) {
        this.putObjectInHash(byArray, (Object)n);
    }

    public void put(String string, int[] nArray) {
        this.putObjectInHash(string, (Object)nArray);
    }

    public int getInt(String string) {
        Object object = this.getObjectFromHash(string);
        if (object == null || !(object instanceof Long) && !(object instanceof Short) && !(object instanceof Byte) && !(object instanceof Integer)) {
            return 0;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Byte) {
            return ((Byte)object).intValue();
        }
        if (object instanceof Short) {
            return ((Short)object).intValue();
        }
        return ((Long)object).intValue();
    }

    public int getInt(byte[] byArray) {
        Object object = this.getObjectFromHash(byArray);
        if (object == null || !(object instanceof Long) && !(object instanceof Short) && !(object instanceof Byte) && !(object instanceof Integer)) {
            return 0;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Byte) {
            return ((Byte)object).intValue();
        }
        if (object instanceof Short) {
            return ((Short)object).intValue();
        }
        return ((Long)object).intValue();
    }

    public int[] getIntArray(String string) {
        Object object = this.getObjectFromHash(string);
        if (!(object instanceof int[])) {
            return null;
        }
        return (int[])object;
    }

    public void put(String string, long l) {
        this.putObjectInHash(string, (Object)l);
    }

    public void put(byte[] byArray, long l) {
        this.putObjectInHash(byArray, (Object)l);
    }

    public void put(String string, long[] lArray) {
        this.putObjectInHash(string, (Object)lArray);
    }

    public void put(String string, float f) {
        this.putObjectInHash(string, (Object)Float.valueOf(f));
    }

    public void put(byte[] byArray, float f) {
        this.putObjectInHash(byArray, (Object)Float.valueOf(f));
    }

    public void put(String string, float[] fArray) {
        this.putObjectInHash(string, (Object)fArray);
    }

    public float getFloat(String string) {
        Object object = this.getObjectFromHash(string);
        if (!(object instanceof Float) && !(object instanceof Double)) {
            return 0.0f;
        }
        if (object instanceof Float) {
            return ((Float)object).floatValue();
        }
        return ((Double)object).floatValue();
    }

    public float getFloat(byte[] byArray) {
        Object object = this.getObjectFromHash(byArray);
        if (!(object instanceof Float) && !(object instanceof Double)) {
            return 0.0f;
        }
        if (object instanceof Float) {
            return ((Float)object).floatValue();
        }
        return ((Double)object).floatValue();
    }

    public float[] getFloatArray(String string) {
        Object object = this.getObjectFromHash(string);
        if (!(object instanceof float[])) {
            return null;
        }
        return (float[])object;
    }

    public void put(String string, double d) {
        this.putObjectInHash(string, (Object)d);
    }

    public void put(String string, double[] dArray) {
        this.putObjectInHash(string, (Object)dArray);
    }

    public String getString(String string) {
        Object object = this.get(string);
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public byte[] getStringAsBytes(String string) {
        Object object = this.get(string);
        if (object == null) {
            return null;
        }
        if (object instanceof fStringEntry) {
            return ((fStringEntry)object).getBytes();
        }
        return fStringByteConverter.convert(object.toString());
    }

    public String[] getStringArray(String string) {
        Object object = this.getObjectFromHash(string);
        if (object == null) {
            return null;
        }
        if (!(object instanceof fStringEntry[])) {
            return null;
        }
        return fEventDictionary.convertToStringArray((fStringEntry[])object);
    }

    public static String[] convertToStringArray(fStringEntry[] fStringEntryArray) {
        String[] stringArray = new String[fStringEntryArray.length];
        for (int i = 0; i < fStringEntryArray.length; ++i) {
            if (fStringEntryArray[i] == null) continue;
            stringArray[i] = fStringEntryArray[i].getString();
        }
        return stringArray;
    }

    public String getString(byte[] byArray) {
        Object object = this.getObjectFromHash(byArray);
        if (!(object instanceof fStringEntry)) {
            if (object != null) {
                return object.toString();
            }
            return null;
        }
        return ((fStringEntry)object).getString();
    }

    public long getLong(String string) {
        Object object = this.getObjectFromHash(string);
        if (object == null || !(object instanceof Long) && !(object instanceof Short) && !(object instanceof Byte) && !(object instanceof Integer)) {
            return 0L;
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Short) {
            return ((Short)object).longValue();
        }
        if (object instanceof Integer) {
            return ((Integer)object).longValue();
        }
        return ((Byte)object).longValue();
    }

    public long getLong(byte[] byArray) {
        Object object = this.getObjectFromHash(byArray);
        if (object == null || !(object instanceof Long) && !(object instanceof Short) && !(object instanceof Byte) && !(object instanceof Integer)) {
            return 0L;
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Short) {
            return ((Short)object).longValue();
        }
        if (object instanceof Integer) {
            return ((Integer)object).longValue();
        }
        return ((Byte)object).longValue();
    }

    public long[] getLongArray(String string) {
        Object object = this.getObjectFromHash(string);
        if (!(object instanceof long[])) {
            return null;
        }
        return (long[])object;
    }

    public boolean getBoolean(String string) {
        Object object = this.getObjectFromHash(string);
        if (!(object instanceof Boolean)) {
            return false;
        }
        return (Boolean)object;
    }

    public boolean getBoolean(byte[] byArray) {
        Object object = this.getObjectFromHash(byArray);
        if (!(object instanceof Boolean)) {
            return false;
        }
        return (Boolean)object;
    }

    public boolean[] getBooleanArray(String string) {
        Object object = this.getObjectFromHash(string);
        if (!(object instanceof boolean[])) {
            return null;
        }
        return (boolean[])object;
    }

    public double getDouble(String string) {
        Object object = this.getObjectFromHash(string);
        if (!(object instanceof Float) && !(object instanceof Double)) {
            return 0.0;
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        return ((Float)object).doubleValue();
    }

    public double getDouble(byte[] byArray) {
        Object object = this.getObjectFromHash(byArray);
        if (!(object instanceof Float) && !(object instanceof Double)) {
            return 0.0;
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        return ((Float)object).doubleValue();
    }

    public double[] getDoubleArray(String string) {
        Object object = this.getObjectFromHash(string);
        if (!(object instanceof double[])) {
            return null;
        }
        return (double[])object;
    }

    public String toString() {
        Iterator<fStringEntry> iterator = this.getKeyIterator();
        StringBuilder stringBuilder = new StringBuilder("EventDictionaryFlag : ");
        while (iterator.hasNext()) {
            fStringEntry fStringEntry2 = iterator.next();
            stringBuilder.append(fStringEntry2.toString()).append(sMyDelimiter);
            Object object = this.myHash.get(fStringEntry2);
            if (object == null) continue;
            stringBuilder.append(this.myHash.get(fStringEntry2).toString()).append(",");
        }
        return stringBuilder.toString();
    }

    public boolean isValid() {
        return this.isValidDictionary;
    }

    public int getSize() {
        return this.myHash.size();
    }

    public int estimateHeapUsage() {
        return this.heapUsageEstimate;
    }

    @Override
    public void readExternal(fEventInputStream fEventInputStream2) throws IOException {
        Object object;
        Object object2;
        int n = fEventInputStream2.readInt();
        for (int i = 0; i < n; ++i) {
            object2 = fEventInputStream2.readByteArray();
            object = null;
            byte by = fEventInputStream2.readByte();
            switch (by) {
                case 100: {
                    object = this.readArray(fEventInputStream2);
                    this.heapUsageEstimate += 16;
                    break;
                }
                case 9: {
                    object = new fEventDictionary();
                    ((fEventDictionary)object).readExternal(fEventInputStream2);
                    this.heapUsageEstimate += ((fEventDictionary)object).estimateHeapUsage();
                    break;
                }
                case 0: {
                    object = new fStringEntry(fEventInputStream2.readByteArray());
                    this.heapUsageEstimate += 40;
                    break;
                }
                case 1: {
                    object = fEventInputStream2.readLong();
                    this.heapUsageEstimate += 24;
                    break;
                }
                case 2: {
                    object = fEventInputStream2.readDouble();
                    this.heapUsageEstimate += 24;
                    break;
                }
                case 3: {
                    object = fEventInputStream2.readBoolean();
                    this.heapUsageEstimate += 16;
                    break;
                }
                case 4: {
                    object = fEventInputStream2.readInt();
                    this.heapUsageEstimate += 16;
                    break;
                }
                case 5: {
                    object = Float.valueOf(fEventInputStream2.readFloat());
                    this.heapUsageEstimate += 16;
                    break;
                }
                case 8: {
                    object = fEventInputStream2.readShort();
                    this.heapUsageEstimate += 16;
                    break;
                }
                case 6: {
                    String string = fEventInputStream2.readString();
                    object = Character.valueOf(string.charAt(0));
                    this.heapUsageEstimate += 16;
                    break;
                }
                case 7: {
                    object = fEventInputStream2.readByte();
                    this.heapUsageEstimate += 16;
                    break;
                }
                default: {
                    fConstants.logger.error("Unknown dictionary entry type while reading dictionary: " + by);
                }
            }
            try {
                this.myHash.put(new fStringEntry((byte[])object2), object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.mySortedKeys = null;
        }
        if (n > 0) {
            this.heapUsageEstimate += n * 80 + 80;
        }
        if (this.containsKey(IS_COMPRESSED) && this.getBoolean(IS_COMPRESSED)) {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.getByteArray(COMPRESSED_BODY));
                object2 = new GZIPInputStream(byteArrayInputStream);
                object = new fEventInputStream((InputStream)object2);
                fEventDictionary fEventDictionary2 = new fEventDictionary();
                fEventDictionary2.readExternal((fEventInputStream)object);
                this.myHash.clear();
                this.myHash.putAll(fEventDictionary2.myHash);
                this.remove(IS_COMPRESSED);
                this.remove(COMPRESSED_BODY);
                try {
                    ((GZIPInputStream)object2).close();
                    ((fEventInputStream)object).close();
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                fConstants.logger.error("Error while decompressing dictionary");
                fConstants.logger.error(throwable);
            }
        }
    }

    private void writeItem(fEventOutputStream fEventOutputStream2, fStringEntry fStringEntry2, Object object) throws IOException {
        fEventOutputStream2.writeByteArray(fStringEntry2.getBytes());
        if (object instanceof fEventDictionary) {
            fEventOutputStream2.writeByte((byte)9);
            ((fEventDictionary)object).setSortOnWrite(this.getSortOnWrite());
            ((fEventDictionary)object).writeExternal(fEventOutputStream2);
        } else if (object instanceof fStringEntry) {
            fEventOutputStream2.writeByte((byte)0);
            fEventOutputStream2.writeByteArray(((fStringEntry)object).getBytes());
        } else if (object instanceof String) {
            fEventOutputStream2.writeByte((byte)0);
            fEventOutputStream2.writeByteArray(fStringByteConverter.convert((String)object));
        } else if (object instanceof Long) {
            fEventOutputStream2.writeByte((byte)1);
            fEventOutputStream2.writeLong((Long)object);
        } else if (object instanceof Double) {
            fEventOutputStream2.writeByte((byte)2);
            fEventOutputStream2.writeDouble((Double)object);
        } else if (object instanceof Boolean) {
            fEventOutputStream2.writeByte((byte)3);
            fEventOutputStream2.writeBoolean((Boolean)object);
        } else if (object instanceof Byte) {
            fEventOutputStream2.writeByte((byte)7);
            fEventOutputStream2.writeByte((Byte)object);
        } else if (object instanceof Integer) {
            fEventOutputStream2.writeByte((byte)4);
            fEventOutputStream2.writeInt((Integer)object);
        } else if (object instanceof Float) {
            fEventOutputStream2.writeByte((byte)5);
            fEventOutputStream2.writeFloat(((Float)object).floatValue());
        } else if (object instanceof Character) {
            fEventOutputStream2.writeByte((byte)6);
            fEventOutputStream2.writeString(object.toString());
        } else if (object instanceof Short) {
            fEventOutputStream2.writeByte((byte)8);
            fEventOutputStream2.writeShort((Short)object);
        } else if (object == null) {
            fEventOutputStream2.writeByte((byte)0);
            fEventOutputStream2.writeByteArray(null);
        } else {
            fEventOutputStream2.writeByte((byte)100);
            this.writeArray(fEventOutputStream2, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(fEventOutputStream fEventOutputStream2) throws IOException {
        if (fEventOutputStream2.isBufferCompressionEnabled() && !this.containsKey(IS_COMPRESSED)) {
            byte[] byArray = fEventDictionary.compress(this);
            fEventDictionary fEventDictionary2 = new fEventDictionary();
            fEventDictionary2.put(COMPRESSED_BODY, byArray);
            fEventDictionary2.put(IS_COMPRESSED, true);
            fEventDictionary2.writeExternal(fEventOutputStream2);
        } else {
            fEventOutputStream2.writeInt(this.myHash.size());
            if (this.mySortOnWrite) {
                Object object;
                Iterator<Map.Entry<fStringEntry, Object>> iterator = this.myHash.entrySet().iterator();
                fEventDictionary fEventDictionary3 = this;
                synchronized (fEventDictionary3) {
                    if (this.mySortedKeys == null) {
                        this.mySortedKeys = new SortedVector();
                        while (iterator.hasNext()) {
                            try {
                                object = iterator.next();
                                this.mySortedKeys.add(new SortedString((fStringEntry)object.getKey(), object.getValue()));
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                fEventDictionary3 = this;
                synchronized (fEventDictionary3) {
                    object = new SortedVectorIterator(this.mySortedKeys);
                    while (object.hasNext()) {
                        SortedString sortedString = (SortedString)object.next();
                        this.writeItem(fEventOutputStream2, sortedString.getKey(), sortedString.getVal());
                    }
                }
            }
            Iterator<Map.Entry<fStringEntry, Object>> iterator = this.myHash.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<fStringEntry, Object> entry;
                Map.Entry<fStringEntry, Object> entry2 = entry = iterator.next();
                this.writeItem(fEventOutputStream2, entry2.getKey(), entry2.getValue());
            }
        }
    }

    private static byte[] compress(fEventDictionary fEventDictionary2) {
        byte[] byArray = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            fEventOutputStream fEventOutputStream2 = new fEventOutputStream(gZIPOutputStream);
            fEventDictionary2.writeExternal(fEventOutputStream2);
            fEventOutputStream2.flush();
            gZIPOutputStream.finish();
            byArray = byteArrayOutputStream.toByteArray();
            fConstants.logger.info("Compressed dictionary to " + byArray.length + " bytes");
            try {
                fEventOutputStream2.close();
                gZIPOutputStream.close();
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            fConstants.logger.error("Error while compressing dictionary");
            fConstants.logger.error(throwable);
        }
        return byArray;
    }

    private void removeObjectFromHash(String string) {
        this.isWriteLocked();
        this.myHash.remove(new fStringEntry(string));
    }

    public void clear() {
        this.isWriteLocked();
        this.myHash.clear();
    }

    private Object getObjectFromHash(String string) {
        Object object = this.myHash.get(new fStringEntry(string));
        if (object != null) {
            return object;
        }
        if (this.myMissingHandler != null) {
            return this.myMissingHandler.getObjectFromString(string);
        }
        return null;
    }

    private Object getObjectFromHash(byte[] byArray) {
        Object object = this.myHash.get(new fStringEntry(byArray));
        if (object != null) {
            return object;
        }
        if (this.myMissingHandler != null) {
            return this.myMissingHandler.getObjectFromBytes(byArray);
        }
        return null;
    }

    private Object getObjectFromHash(fStringEntry fStringEntry2) {
        Object object = this.myHash.get(fStringEntry2);
        if (object != null) {
            return object;
        }
        if (this.myMissingHandler != null) {
            return this.myMissingHandler.getObjectFromBytes(fStringEntry2.getBytes());
        }
        return null;
    }

    private void putObjectInHash(String string, Object object) {
        this.isWriteLocked();
        try {
            this.myHash.put(new fStringEntry(string), object);
            this.mySortedKeys = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void putObjectInHash(byte[] byArray, Object object) {
        this.isWriteLocked();
        try {
            this.myHash.put(new fStringEntry(byArray), object);
            this.mySortedKeys = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void isWriteLocked() {
        if (this.isWriteLocked) {
            fConstants.logger.log("Error: Dictionary is currently write locked");
            if (fRuntime.sThrowErrorOnReadOnly) {
                throw new Error("Dictionary is currently write locked");
            }
        }
    }

    private Object readArray(fEventInputStream fEventInputStream2) throws IOException {
        int n = fEventInputStream2.readInt();
        byte by = fEventInputStream2.readByte();
        switch (by) {
            case 7: {
                byte[] byArray = new byte[n];
                fEventInputStream2.read(byArray);
                return byArray;
            }
            case 6: {
                char[] cArray = new char[n];
                for (int i = 0; i < n; ++i) {
                    cArray[i] = (char)fEventInputStream2.read();
                }
                return cArray;
            }
            case 3: {
                boolean[] blArray = new boolean[n];
                for (int i = 0; i < n; ++i) {
                    blArray[i] = fEventInputStream2.readBoolean();
                }
                return blArray;
            }
            case 8: {
                short[] sArray = new short[n];
                for (int i = 0; i < n; ++i) {
                    sArray[i] = fEventInputStream2.readShort();
                }
                return sArray;
            }
            case 4: {
                int[] nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    nArray[i] = fEventInputStream2.readInt();
                }
                return nArray;
            }
            case 1: {
                long[] lArray = new long[n];
                for (int i = 0; i < n; ++i) {
                    lArray[i] = fEventInputStream2.readLong();
                }
                return lArray;
            }
            case 5: {
                float[] fArray = new float[n];
                for (int i = 0; i < n; ++i) {
                    fArray[i] = fEventInputStream2.readFloat();
                }
                return fArray;
            }
            case 2: {
                double[] dArray = new double[n];
                for (int i = 0; i < n; ++i) {
                    dArray[i] = fEventInputStream2.readDouble();
                }
                return dArray;
            }
            case 0: {
                fStringEntry[] fStringEntryArray = new fStringEntry[n];
                for (int i = 0; i < n; ++i) {
                    fStringEntryArray[i] = new fStringEntry(fEventInputStream2.readByteArray());
                }
                return fStringEntryArray;
            }
            case 9: {
                fEventDictionary[] fEventDictionaryArray = new fEventDictionary[n];
                for (int i = 0; i < n; ++i) {
                    fEventDictionary fEventDictionary2 = new fEventDictionary();
                    fEventDictionary2.readExternal(fEventInputStream2);
                    fEventDictionaryArray[i] = fEventDictionary2;
                }
                return fEventDictionaryArray;
            }
        }
        return null;
    }

    private void writeArray(fEventOutputStream fEventOutputStream2, Object object) throws IOException {
        block11: {
            block19: {
                block18: {
                    block17: {
                        block16: {
                            block15: {
                                block14: {
                                    block13: {
                                        block12: {
                                            block10: {
                                                if (!(object instanceof byte[])) break block10;
                                                byte[] byArray = (byte[])object;
                                                fEventOutputStream2.writeInt(byArray.length);
                                                fEventOutputStream2.writeByte((byte)7);
                                                fEventOutputStream2.write(byArray);
                                                break block11;
                                            }
                                            if (!(object instanceof char[])) break block12;
                                            char[] cArray = (char[])object;
                                            fEventOutputStream2.writeInt(cArray.length);
                                            fEventOutputStream2.writeByte((byte)6);
                                            for (char c : cArray) {
                                                fEventOutputStream2.write(c);
                                            }
                                            break block11;
                                        }
                                        if (!(object instanceof boolean[])) break block13;
                                        boolean[] blArray = (boolean[])object;
                                        fEventOutputStream2.writeInt(blArray.length);
                                        fEventOutputStream2.writeByte((byte)3);
                                        for (boolean bl : blArray) {
                                            fEventOutputStream2.writeBoolean(bl);
                                        }
                                        break block11;
                                    }
                                    if (!(object instanceof short[])) break block14;
                                    short[] sArray = (short[])object;
                                    fEventOutputStream2.writeInt(sArray.length);
                                    fEventOutputStream2.writeByte((byte)8);
                                    for (short s : sArray) {
                                        fEventOutputStream2.writeShort(s);
                                    }
                                    break block11;
                                }
                                if (!(object instanceof int[])) break block15;
                                int[] nArray = (int[])object;
                                fEventOutputStream2.writeInt(nArray.length);
                                fEventOutputStream2.writeByte((byte)4);
                                for (int n : nArray) {
                                    fEventOutputStream2.writeInt(n);
                                }
                                break block11;
                            }
                            if (!(object instanceof long[])) break block16;
                            long[] lArray = (long[])object;
                            fEventOutputStream2.writeInt(lArray.length);
                            fEventOutputStream2.writeByte((byte)1);
                            for (long l : lArray) {
                                fEventOutputStream2.writeLong(l);
                            }
                            break block11;
                        }
                        if (!(object instanceof float[])) break block17;
                        float[] fArray = (float[])object;
                        fEventOutputStream2.writeInt(fArray.length);
                        fEventOutputStream2.writeByte((byte)5);
                        for (float f : fArray) {
                            fEventOutputStream2.writeFloat(f);
                        }
                        break block11;
                    }
                    if (!(object instanceof double[])) break block18;
                    double[] dArray = (double[])object;
                    fEventOutputStream2.writeInt(dArray.length);
                    fEventOutputStream2.writeByte((byte)2);
                    for (double d : dArray) {
                        fEventOutputStream2.writeDouble(d);
                    }
                    break block11;
                }
                if (!(object instanceof fStringEntry[])) break block19;
                fStringEntry[] fStringEntryArray = (fStringEntry[])object;
                fEventOutputStream2.writeInt(fStringEntryArray.length);
                fEventOutputStream2.writeByte((byte)0);
                for (fStringEntry fStringEntry2 : fStringEntryArray) {
                    if (fStringEntry2 == null) {
                        fEventOutputStream2.writeByteArray(null);
                        continue;
                    }
                    fEventOutputStream2.writeByteArray(fStringEntry2.getBytes());
                }
                break block11;
            }
            if (!(object instanceof fEventDictionary[])) break block11;
            fEventDictionary[] fEventDictionaryArray = (fEventDictionary[])object;
            fEventOutputStream2.writeInt(fEventDictionaryArray.length);
            fEventOutputStream2.writeByte((byte)9);
            for (fEventDictionary fEventDictionary2 : fEventDictionaryArray) {
                fEventDictionary2.setSortOnWrite(this.getSortOnWrite());
                fEventDictionary2.writeExternal(fEventOutputStream2);
            }
        }
    }

    public byte getType(Object object) {
        if (object instanceof fStringEntry) {
            return 0;
        }
        if (object instanceof String) {
            return 0;
        }
        if (object instanceof Long) {
            return 1;
        }
        if (object instanceof Double) {
            return 2;
        }
        if (object instanceof Boolean) {
            return 3;
        }
        if (object instanceof Byte) {
            return 7;
        }
        if (object instanceof Integer) {
            return 4;
        }
        if (object instanceof Float) {
            return 5;
        }
        if (object instanceof Character) {
            return 6;
        }
        if (object instanceof Short) {
            return 8;
        }
        if (object instanceof fEventDictionary) {
            return 9;
        }
        if (object == null) {
            return 0;
        }
        return 100;
    }

    public boolean validateDictionaryValue(Object object) {
        boolean bl = false;
        if (object instanceof fStringEntry) {
            bl = true;
        } else if (object instanceof String) {
            bl = true;
        } else if (object instanceof Long) {
            bl = true;
        } else if (object instanceof Double) {
            bl = true;
        } else if (object instanceof Boolean) {
            bl = true;
        } else if (object instanceof Byte) {
            bl = true;
        } else if (object instanceof Integer) {
            bl = true;
        } else if (object instanceof Float) {
            bl = true;
        } else if (object instanceof Character) {
            bl = true;
        } else if (object instanceof Short) {
            bl = true;
        } else if (object instanceof fEventDictionary) {
            bl = true;
        } else if (object instanceof fStringEntry[]) {
            bl = true;
        } else if (object instanceof String[]) {
            bl = true;
        } else if (object instanceof Long[]) {
            bl = true;
        } else if (object instanceof Double[]) {
            bl = true;
        } else if (object instanceof Boolean[]) {
            bl = true;
        } else if (object instanceof Byte[]) {
            bl = true;
        } else if (object instanceof Integer[]) {
            bl = true;
        } else if (object instanceof Float[]) {
            bl = true;
        } else if (object instanceof Character[]) {
            bl = true;
        } else if (object instanceof Short[]) {
            bl = true;
        } else if (object instanceof fEventDictionary[]) {
            bl = true;
        } else if (object == null) {
            bl = true;
        }
        return bl;
    }

    private void deserialize(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        String string2 = stringTokenizer.nextToken();
        if (!string2.equalsIgnoreCase("dbEventFilterTag")) {
            this.put("TAG", string);
            this.isValidDictionary = false;
            return;
        }
        while (stringTokenizer.hasMoreElements()) {
            this.extractKeyPair(stringTokenizer.nextToken());
        }
    }

    private void extractKeyPair(String string) {
        int n = string.indexOf(sMyDelimiter);
        if (n != -1) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + sMyDelimiter.length());
            this.put(string2, string3);
        }
    }

    public boolean compareTo(fEventDictionary fEventDictionary2) {
        for (Map.Entry<fStringEntry, Object> entry : fEventDictionary2.myHash.entrySet()) {
            Object object = this.get(entry.getKey().getBytes());
            Object object2 = entry.getValue();
            if (object == null && object2 != null || object != null && object2 == null) {
                return false;
            }
            if (object == null || object.equals(object2)) continue;
            if (object instanceof byte[] && object2 instanceof byte[]) {
                if (Arrays.equals((byte[])object, (byte[])object2)) continue;
                return false;
            }
            if (object instanceof char[] && object2 instanceof char[]) {
                if (Arrays.equals((char[])object, (char[])object2)) continue;
                return false;
            }
            if (object instanceof boolean[] && object2 instanceof boolean[]) {
                if (Arrays.equals((boolean[])object, (boolean[])object2)) continue;
                return false;
            }
            if (object instanceof short[] && object2 instanceof short[]) {
                if (Arrays.equals((short[])object, (short[])object2)) continue;
                return false;
            }
            if (object instanceof int[] && object2 instanceof int[]) {
                if (Arrays.equals((int[])object, (int[])object2)) continue;
                return false;
            }
            if (object instanceof long[] && object2 instanceof long[]) {
                if (Arrays.equals((long[])object, (long[])object2)) continue;
                return false;
            }
            if (object instanceof float[] && object2 instanceof float[]) {
                if (Arrays.equals((float[])object, (float[])object2)) continue;
                return false;
            }
            if (object instanceof double[] && object2 instanceof double[]) {
                if (Arrays.equals((double[])object, (double[])object2)) continue;
                return false;
            }
            if (object instanceof String[] && object2 instanceof String[]) {
                if (Arrays.equals((String[])object, (String[])object2)) continue;
                return false;
            }
            if (object instanceof fEventDictionary[] && object2 instanceof fEventDictionary[]) {
                if (((fEventDictionary[])object).length != ((fEventDictionary[])object2).length) {
                    return false;
                }
                fEventDictionary[] fEventDictionaryArray = (fEventDictionary[])object;
                fEventDictionary[] fEventDictionaryArray2 = (fEventDictionary[])object2;
                for (int i = 0; i < fEventDictionaryArray.length; ++i) {
                    if (fEventDictionaryArray[i].compareTo(fEventDictionaryArray2[i])) continue;
                    return false;
                }
                continue;
            }
            if ((object instanceof String && object2 instanceof fStringEntry || object instanceof fStringEntry && object2 instanceof String) && object.toString().equals(object2.toString())) continue;
            return false;
        }
        return true;
    }

    public int calculateSize() {
        Iterator<Map.Entry<fStringEntry, Object>> iterator = this.getEntrySet();
        int n = 0;
        while (iterator.hasNext()) {
            Map.Entry<fStringEntry, Object> entry = iterator.next();
            n += entry.getKey().getBytes().length + fEventDictionary.getEntrySize(entry.getValue());
        }
        return n;
    }

    private static int getEntrySize(Object object) {
        Class<?> clazz = object.getClass();
        int n = 0;
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            n = 4;
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            n = 2;
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            n = 1;
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            n = 2;
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            n = 8;
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            n = 4;
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            n = 8;
        }
        if (clazz == Byte[].class) {
            n = ((Byte[])object).length;
        }
        if (clazz == byte[].class) {
            n = ((byte[])object).length;
        }
        if (clazz == fStringEntry.class) {
            n = ((fStringEntry)object).getBytes().length;
        }
        if (clazz == fEventDictionary.class) {
            n += ((fEventDictionary)object).calculateSize();
        }
        if (clazz == fStringEntry[].class) {
            for (fStringEntry object2 : (fStringEntry[])object) {
                n += object2.getBytes().length;
            }
        }
        if (clazz == fEventDictionary[].class) {
            for (fEventDictionary fEventDictionary2 : (fEventDictionary[])object) {
                n += fEventDictionary2.calculateSize();
            }
        }
        return n;
    }

    private static class SortedString
    implements SortedObject {
        private final fStringEntry key;
        private final Object obj;

        public SortedString(fStringEntry fStringEntry2, Object object) {
            this.key = fStringEntry2;
            this.obj = object;
        }

        public fStringEntry getKey() {
            return this.key;
        }

        public Object getVal() {
            return this.obj;
        }

        @Override
        public boolean equals(long l) {
            return false;
        }

        @Override
        public boolean lessThan(long l) {
            return false;
        }

        @Override
        public boolean lessThan(Object object) {
            if (object instanceof SortedString) {
                return this.key.compare(((SortedString)object).key) < 0;
            }
            return this.key.compare(object) < 0;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object instanceof SortedString) {
                return this.key.compare(((SortedString)object).key) == 0;
            }
            return this.key.compare(object) == 0;
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }
}

