/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.base;

import com.pcbsys.foundation.base.CreateFileOperation;
import com.pcbsys.foundation.base.fBaseApplication;
import com.pcbsys.foundation.base.fFileInputStream;
import com.pcbsys.foundation.base.fFileOutputStream;
import com.pcbsys.foundation.base.fRandomAccessFile;
import com.pcbsys.foundation.drivers.jdk.fJDKHelper;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.utils.fEnvironment;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.LinkedHashMap;

public class fFile {
    private static final int MAX_RENAME_ATTEMPTS = 10;
    private static final long RENAME_WAIT_TIME_MS = 500L;
    private static final LinkedHashMap<String, FileDetails> myAllocationDetails = new LinkedHashMap();
    private static final boolean sDebug;
    private static final boolean sMonitorFileAccess;

    public static boolean exists(String string) {
        return fFile.exists(string, false);
    }

    public static boolean exists(String string, boolean bl) {
        return fFile.exists(new File(string), bl);
    }

    public static boolean exists(File file) {
        return fFile.exists(file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exists(File file, boolean bl) {
        boolean bl2 = false;
        if (!bl) {
            return file.exists();
        }
        InputStream inputStream = null;
        try {
            if (!file.exists()) {
                inputStream = new FileInputStream(file);
                inputStream.close();
                bl2 = true;
            } else {
                bl2 = true;
            }
        }
        catch (IOException iOException) {
            fFile.checkException(iOException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return bl2;
    }

    public static FileInputStream openFileInputStream(String string) throws IOException {
        return fFile.openFileInputStream(new File(string));
    }

    public static FileInputStream openFileInputStream(File file) throws IOException {
        try {
            FileInputStream fileInputStream;
            if (sDebug) {
                fFile.log("OpenFileInputStream for file " + file.toString());
            }
            if (sMonitorFileAccess) {
                String string = file.getAbsolutePath() + "_Input";
                fileInputStream = new fFileInputStream(string, file);
                fFile.checkAccess(new FileDetails(string));
            } else {
                fileInputStream = new FileInputStream(file);
            }
            return fileInputStream;
        }
        catch (IOException iOException) {
            if (sDebug) {
                fFile.log("OpenFileInputStream for file raised exception :" + file.toString());
                fFile.log(iOException);
            }
            fFile.checkException(iOException);
            throw iOException;
        }
    }

    public static FileOutputStream openFileOutputStream(String string, boolean bl) throws IOException {
        return fFile.openFileOutputStream(new File(string), bl);
    }

    public static FileOutputStream openFileOutputStream(String string) throws IOException {
        return fFile.openFileOutputStream(new File(string), false);
    }

    public static FileOutputStream openFileOutputStream(File file) throws IOException {
        return fFile.openFileOutputStream(file, false);
    }

    public static FileOutputStream openFileOutputStream(File file, boolean bl) throws IOException {
        try {
            FileOutputStream fileOutputStream;
            if (sDebug) {
                fFile.log("OpenFileOutputStream for file " + file.toString() + " With Flag:" + bl);
            }
            if (!file.exists() && file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            if (sMonitorFileAccess) {
                String string = file.getAbsolutePath() + "_Output";
                fileOutputStream = new fFileOutputStream(string, file, bl);
                fFile.checkAccess(new FileDetails(string));
            } else {
                fileOutputStream = new FileOutputStream(file, bl);
            }
            return fileOutputStream;
        }
        catch (IOException iOException) {
            if (sDebug) {
                fFile.log("OpenFileInputStream for file raised exception :" + file.toString());
                fFile.log(iOException);
            }
            fFile.checkException(iOException);
            throw iOException;
        }
    }

    public static RandomAccessFile openRandomAccessFile(final File file, final String string) throws IOException {
        try {
            RandomAccessFile randomAccessFile;
            if (sDebug) {
                fFile.log("openRandomAccessFile for file " + file.toString() + " With Mode:" + string);
            }
            if (sMonitorFileAccess) {
                final String string2 = file.getAbsolutePath() + "_Random";
                randomAccessFile = fFile.executeFileOperation(new CreateFileOperation(){

                    @Override
                    public RandomAccessFile operation() throws IOException {
                        return new fRandomAccessFile(string2, file, string);
                    }
                });
                fFile.checkAccess(new FileDetails(string2));
            } else {
                randomAccessFile = fFile.executeFileOperation(new CreateFileOperation(){

                    @Override
                    public RandomAccessFile operation() throws IOException {
                        return new RandomAccessFile(file, string);
                    }
                });
            }
            return randomAccessFile;
        }
        catch (IOException iOException) {
            if (sDebug) {
                fFile.log("openRandomAccessFile for file raised exception :" + file.toString());
                fFile.log(iOException);
            }
            fFile.checkException(iOException);
            throw iOException;
        }
    }

    public static RandomAccessFile openRandomAccessFile(String string, String string2) throws IOException {
        return fFile.openRandomAccessFile(new File(string), string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkAccess(FileDetails fileDetails) {
        LinkedHashMap<String, FileDetails> linkedHashMap = myAllocationDetails;
        synchronized (linkedHashMap) {
            FileDetails fileDetails2 = myAllocationDetails.get(fileDetails.getName());
            if (fileDetails2 != null) {
                fFile.log("Opening file that already has been opened, previously opened " + fileDetails2.toString());
                fFile.log("Opening now by " + fileDetails.toString());
            }
            myAllocationDetails.put(fileDetails.getName(), fileDetails);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void lookupFile(File file, String string) {
        LinkedHashMap<String, FileDetails> linkedHashMap = myAllocationDetails;
        synchronized (linkedHashMap) {
            String string2 = file.getName();
            for (String string3 : myAllocationDetails.keySet()) {
                FileDetails fileDetails;
                if (!string3.startsWith(string2) || (fileDetails = myAllocationDetails.get(string3)) == null) continue;
                fFile.log(string + fileDetails.toString());
                Exception exception = new Exception("Mismatched file access");
                exception.fillInStackTrace();
                fFile.log(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeFile(String string) {
        if (sMonitorFileAccess) {
            LinkedHashMap<String, FileDetails> linkedHashMap = myAllocationDetails;
            synchronized (linkedHashMap) {
                myAllocationDetails.remove(string);
            }
        }
    }

    public static void mappingFile(String string) {
        if (sMonitorFileAccess) {
            String string2 = string + "_Mapping";
            fFile.checkAccess(new FileDetails(string2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unmappingFile(String string) {
        if (sMonitorFileAccess) {
            String string2 = string + "_Mapping";
            LinkedHashMap<String, FileDetails> linkedHashMap = myAllocationDetails;
            synchronized (linkedHashMap) {
                myAllocationDetails.remove(string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean rename(File file, File file2) {
        if (sDebug) {
            fFile.log("Renaming " + file + " to " + file2);
        }
        if (!file.exists()) {
            if (sDebug) {
                fFile.log("Old file " + file + " does not exist, unable to rename");
            }
            return false;
        }
        if (sMonitorFileAccess) {
            LinkedHashMap<String, FileDetails> linkedHashMap = myAllocationDetails;
            synchronized (linkedHashMap) {
                fFile.lookupFile(file2, "Attempting to rename to a file that is currently open ");
                fFile.lookupFile(file, "Attempting to rename from a file that is currently open ");
            }
        }
        if (file2.exists()) {
            if (sDebug) {
                fFile.log("New file " + file2 + " exist, attempting to delete");
            }
            if (!fFile.delete(file2)) {
                if (sDebug) {
                    fFile.log("New file " + file2 + " unable to delete");
                }
                return false;
            }
        }
        int n = 10;
        long l = 500L;
        int n2 = 0;
        if (fBaseApplication.getApplication() != null) {
            n = fBaseApplication.getApplication().getFileRetryCount();
            l = fBaseApplication.getApplication().getFileTimeout();
        }
        while (n2 < n && !file.renameTo(file2)) {
            if (sDebug) {
                fFile.log("Attempted to rename " + file + " to " + file2 + " failed, attempt # " + n2);
            }
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        if (n2 >= n && fBaseApplication.getApplication() != null) {
            if (sMonitorFileAccess) {
                LinkedHashMap<String, FileDetails> linkedHashMap = myAllocationDetails;
                synchronized (linkedHashMap) {
                    fFile.lookupFile(file2, "Attempting to rename to a file that is currently open ");
                    fFile.lookupFile(file, "Attempting to rename from a file that is currently open ");
                }
            }
            fBaseApplication.getApplication().fileOperationFailure("Unable to rename " + file.toString() + " to " + file2.toString());
        }
        return n2 < n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rename(File file, File file2, boolean bl, int n, long l) throws IOException {
        Object object;
        if (sDebug) {
            fFile.log("Renaming " + file + " to " + file2);
        }
        if (sMonitorFileAccess) {
            object = myAllocationDetails;
            synchronized (object) {
                fFile.lookupFile(file2, "Attempting to rename to a file that is currently open ");
                fFile.lookupFile(file, "Attempting to rename from a file that is currently open ");
            }
        }
        object = fBaseApplication.getApplication();
        if (n <= 0) {
            n = object != null ? ((fBaseApplication)object).getFileRetryCount() : 10;
        }
        if (l < 0L) {
            l = object != null ? ((fBaseApplication)object).getFileTimeout() : 500L;
        }
        for (int i = 1; i <= n; ++i) {
            try {
                fJDKHelper.getFileSupport().renameFile(file, file2, bl);
                break;
            }
            catch (IOException iOException) {
                if (sDebug) {
                    fFile.log("Attempted to rename " + file + " to " + file2 + " failed, attempt # " + i);
                }
                if (i == n) {
                    if (fBaseApplication.getApplication() != null && sMonitorFileAccess) {
                        LinkedHashMap<String, FileDetails> linkedHashMap = myAllocationDetails;
                        synchronized (linkedHashMap) {
                            fFile.lookupFile(file2, "Attempting to rename to a file that is currently open ");
                            fFile.lookupFile(file, "Attempting to rename from a file that is currently open ");
                        }
                    }
                    throw iOException;
                }
                try {
                    Thread.sleep(l);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                continue;
            }
        }
    }

    public static byte[] readAllBytes(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("File " + file.toString() + ": not found");
        }
        byte[] byArray = new byte[(int)file.length()];
        try (FileInputStream fileInputStream = null;){
            fileInputStream = new FileInputStream(file);
            fileInputStream.read(byArray, 0, byArray.length);
        }
        return byArray;
    }

    public static boolean delete(File file) {
        int n = 0;
        int n2 = 10;
        long l = 500L;
        if (sMonitorFileAccess) {
            fFile.lookupFile(file, "Attempting to delete to a file that is currently open ");
        }
        if (fBaseApplication.getApplication() != null) {
            n2 = fBaseApplication.getApplication().getFileRetryCount();
            l = fBaseApplication.getApplication().getFileTimeout();
        }
        while (n < n2 && !file.delete() && file.exists()) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
        if (n >= n2 && fBaseApplication.getApplication() != null && file.exists()) {
            fBaseApplication.getApplication().fileOperationFailure("Unable to delete " + file.toString());
        }
        return n < n2;
    }

    public static void checkException(IOException iOException) {
        if (!(iOException.getMessage().contains("No such file or directory") || iOException.getMessage().contains("The system cannot find the file specified") || iOException.getMessage().contains("A file or directory in the path name does not exist"))) {
            fBaseApplication.getApplication().fileDescriptorError(iOException.getMessage());
        } else if (iOException.getMessage().contains("Permission denied") && fBaseApplication.getApplication() != null) {
            fBaseApplication.getApplication().fileOperationFailure(iOException.getMessage());
        }
    }

    private static void log(String string) {
        fConstants.logger.log("FileAccess>" + string);
        System.err.println(string);
    }

    private static void log(Throwable throwable) {
        fConstants.logger.log(throwable);
        throwable.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpFileTable(PrintWriter printWriter) {
        if (sMonitorFileAccess) {
            LinkedHashMap<String, FileDetails> linkedHashMap = myAllocationDetails;
            synchronized (linkedHashMap) {
                if (myAllocationDetails.size() > 0) {
                    StringBuilder stringBuilder = new StringBuilder("\nCurrently open files:\n");
                    stringBuilder.append("=====================\n");
                    for (FileDetails fileDetails : myAllocationDetails.values()) {
                        stringBuilder.append(fileDetails.toString());
                    }
                    printWriter.println(stringBuilder.toString());
                }
            }
        }
    }

    private static RandomAccessFile executeFileOperation(CreateFileOperation createFileOperation) throws IOException {
        RandomAccessFile randomAccessFile = null;
        for (int i = 0; i < 10; ++i) {
            try {
                randomAccessFile = createFileOperation.operation();
                break;
            }
            catch (IOException iOException) {
                if (i >= 9) {
                    throw iOException;
                }
                fFile.log("Unable to perform file operation! Retrying...");
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        return randomAccessFile;
    }

    static {
        sMonitorFileAccess = sDebug = fEnvironment.isDebugEnabled("FileAccess");
    }

    private static final class FileDetails {
        private String myFileName;
        private String myDateAllocated;
        private String myAllocatingThread;
        private String[] myAllocatingPath;

        public FileDetails(String string) {
            this.myFileName = string;
            this.myDateAllocated = new Date().toString();
            this.myAllocatingThread = Thread.currentThread().getName();
            Exception exception = new Exception();
            exception.fillInStackTrace();
            StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
            this.myAllocatingPath = new String[stackTraceElementArray.length];
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                this.myAllocatingPath[i] = stackTraceElementArray[i].toString();
            }
        }

        public String getName() {
            return this.myFileName;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("FileName : " + this.myFileName + "\n");
            stringBuffer.append("Allocated : ").append(this.myDateAllocated).append("\n");
            stringBuffer.append("  by Thread : ").append(this.myAllocatingThread).append("\n");
            stringBuffer.append("Stack Path").append("\n");
            for (int i = 0; i < this.myAllocatingPath.length; ++i) {
                stringBuffer.append("\t").append(this.myAllocatingPath[i]).append("\n");
            }
            return stringBuffer.toString();
        }
    }
}

