/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.base;

import com.pcbsys.foundation.utils.fStringByteConverter;
import java.util.Arrays;

public class fStringEntry {
    private static final byte[] NULLBYTES = new byte[0];
    private static final String EMPTY_STRING = "";
    private byte[] myData;
    private String myString;
    private int hash;
    public static final int SIZE_ESTIMATE = 40;

    public fStringEntry(byte[] byArray) {
        this.myData = byArray == null ? NULLBYTES : byArray;
    }

    public fStringEntry(String string) {
        this.myString = string;
    }

    public String getString() {
        if (this.myString != null) {
            return this.myString;
        }
        if (this.myData == null || this.myData.length == 0) {
            return EMPTY_STRING;
        }
        this.myString = fStringByteConverter.convert(this.myData);
        return this.myString;
    }

    public byte[] getBytes() {
        if (this.myData == null) {
            this.myData = this.myString == null ? NULLBYTES : fStringByteConverter.convert(this.myString);
        }
        return this.myData;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof fStringEntry)) {
            return false;
        }
        fStringEntry fStringEntry2 = (fStringEntry)object;
        if (!fStringEntry2.canEqual(this)) {
            return false;
        }
        if (this.myString != null && fStringEntry2.myString != null) {
            return this.myString.equals(fStringEntry2.myString);
        }
        return Arrays.equals(this.getBytes(), fStringEntry2.getBytes());
    }

    public boolean canEqual(Object object) {
        return object instanceof fStringEntry;
    }

    public int hashCode() {
        if (this.hash == 0) {
            for (byte by : this.getBytes()) {
                this.hash = by < 0 ? 31 * this.hash + (256 + by) : 31 * this.hash + by;
            }
        }
        return this.hash;
    }

    protected int compare(Object object) {
        if (object == null) {
            return -1;
        }
        if (object instanceof fStringEntry) {
            fStringEntry fStringEntry2 = (fStringEntry)object;
            return fStringEntry.compareBytes(this.getBytes(), fStringEntry2.getBytes());
        }
        if (object instanceof String) {
            String string = (String)object;
            try {
                return fStringEntry.compareBytes(this.getBytes(), fStringByteConverter.convert(string));
            }
            catch (Exception exception) {
                return -1;
            }
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            return fStringEntry.compareBytes(this.getBytes(), byArray);
        }
        return this.compare(object.toString());
    }

    public fStringEntry copy() {
        if (this.myString != null) {
            return new fStringEntry(this.myString);
        }
        byte[] byArray = new byte[this.getBytes().length];
        System.arraycopy(this.myData, 0, byArray, 0, this.myData.length);
        return new fStringEntry(byArray);
    }

    public String toString() {
        return this.getString();
    }

    private static int compareBytes(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        int n2 = byArray2.length;
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            byte by = byArray[i];
            byte by2 = byArray2[i];
            if (by == by2) continue;
            return by - by2;
        }
        return n - n2;
    }
}

