/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.base;

import com.pcbsys.foundation.fConstants;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class fThreadMethodAccessLogger {
    private final AtomicBoolean closed;
    private final AtomicBoolean access = new AtomicBoolean(false);
    private final AtomicInteger loop;
    private Thread currentThread;
    private Exception active;
    private Exception close;

    public fThreadMethodAccessLogger() {
        this.closed = new AtomicBoolean(false);
        this.loop = new AtomicInteger(0);
    }

    public synchronized void beginAccess() {
        if (this.closed.get()) {
            Exception exception = new Exception("Access requested on a closed Object");
            exception.fillInStackTrace();
            fConstants.logger.log(this.close);
            fConstants.logger.log(exception);
            return;
        }
        this.loop.incrementAndGet();
        if (!this.access.getAndSet(true)) {
            this.currentThread = Thread.currentThread();
            this.active = new Exception("Initial Access");
            this.active.fillInStackTrace();
        } else if (this.currentThread != Thread.currentThread()) {
            Exception exception = this.active;
            if (exception == null) {
                return;
            }
            exception.printStackTrace(System.err);
            Exception exception2 = new Exception("MultiThreaded access detected");
            exception2.fillInStackTrace();
            exception2.printStackTrace(System.err);
            fConstants.logger.log(exception);
            fConstants.logger.log(exception2);
        }
    }

    public synchronized void completeAccess() {
        if (this.loop.decrementAndGet() == 0) {
            this.access.set(false);
            this.active = null;
        }
    }

    public void close() {
        boolean bl = this.closed.compareAndSet(false, true);
        if (bl) {
            fConstants.logger.log("Closed called on already closed object!");
        }
    }
}

