/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.base;

import com.pcbsys.foundation.base.fMinuteListener;
import com.pcbsys.foundation.concurrent.CacheLinePadAtomicLong;
import com.pcbsys.foundation.vm.VMHelper;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;

public final class fTimer {
    private static final long sMyTick = 20L;
    private static final long myInitialMilliseconds;
    private static final CacheLinePadAtomicLong myTicks;
    private static final CopyOnWriteArrayList<fMinuteListener> myMinuteListeners;
    private static final CacheLinePadAtomicLong myLastMilliseconds;

    public static long getTicks() {
        return myTicks.get();
    }

    public static long convertTickToMillis(long l) {
        return myInitialMilliseconds + l;
    }

    public static long convertMillisToTick(long l) {
        return l - myInitialMilliseconds;
    }

    public static long currentTimeMillis() {
        return myLastMilliseconds.get();
    }

    public static long nanoTime() {
        return System.nanoTime();
    }

    public static void addMinuteListener(fMinuteListener fMinuteListener2) {
        myMinuteListeners.add(fMinuteListener2);
    }

    public static void delMinuteListener(fMinuteListener fMinuteListener2) {
        myMinuteListeners.remove(fMinuteListener2);
    }

    static {
        myTicks = new CacheLinePadAtomicLong();
        myMinuteListeners = new CopyOnWriteArrayList();
        myLastMilliseconds = new CacheLinePadAtomicLong();
        myInitialMilliseconds = System.currentTimeMillis();
        myLastMilliseconds.set(System.currentTimeMillis());
        Timer timer = VMHelper.getTimer("UM Transport high accuracy tick timer");
        VMHelper.scheduleAtFixedRate(timer, new TickTimer(), 20L, 20L);
        VMHelper.scheduleAtFixedRate(timer, new MinuteTimer(), 60000L, 60000L);
    }

    private static class TickTimer
    extends TimerTask {
        private TickTimer() {
        }

        @Override
        public void run() {
            myTicks.addAndGet(20L);
            myLastMilliseconds.set(System.currentTimeMillis());
        }
    }

    private static class MinuteTimer
    extends TimerTask {
        private MinuteTimer() {
        }

        @Override
        public void run() {
            long l = System.currentTimeMillis();
            l = l - l % 60000L + 60000L;
            for (fMinuteListener fMinuteListener2 : myMinuteListeners) {
                fMinuteListener2.tick(l);
            }
        }
    }
}

