/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.collections;

import com.pcbsys.foundation.collections.MergeManager;
import com.pcbsys.foundation.collections.SortedObject;
import com.pcbsys.foundation.collections.Vector;
import com.pcbsys.foundation.collections.fDuplicateHandler;
import com.pcbsys.foundation.collections.fPageArray;
import com.pcbsys.foundation.collections.fVector;
import com.pcbsys.foundation.collections.fVectorEnumeration;
import com.pcbsys.foundation.fConstants;
import java.util.Enumeration;

public class SortedVector<T extends SortedObject> {
    private final fVector<T> myVector;
    private fDuplicateHandler myDuplicateHandler = null;

    public SortedVector() {
        this.myVector = new Vector<T>();
    }

    public SortedVector(int n) {
        this.myVector = new fPageArray(n);
    }

    public SortedVector(fVector<T> fVector2) {
        this.myVector = fVector2;
    }

    public fDuplicateHandler getDuplicateHandler() {
        return this.myDuplicateHandler;
    }

    public void setDuplicateHandler(fDuplicateHandler fDuplicateHandler2) {
        this.myDuplicateHandler = fDuplicateHandler2;
    }

    public Enumeration<T> elements() {
        return new fVectorEnumeration<T>(this.myVector);
    }

    public int indexOf(Object object) {
        return this.myVector.indexOf(object);
    }

    public synchronized void trimToSize() {
        this.myVector.trimToSize();
    }

    public synchronized void add(T t) throws Exception {
        int n;
        if (this.size() > 0) {
            if (((SortedObject)this.myVector.lastElement()).lessThan(t)) {
                this.insertAtEnd(t);
                return;
            }
            if (t.lessThan(this.elementAt(0))) {
                this.myVector.insertElementAt(t, 0);
                return;
            }
        }
        if ((n = this.insertIndex(t)) >= 0) {
            this.myVector.insertElementAt(t, n);
        }
    }

    public synchronized void insertAtEnd(T t) throws Exception {
        this.insertAtEnd(t, true);
    }

    public synchronized void insertAtEnd(T t, boolean bl) throws Exception {
        if (bl && this.myVector.size() != 0) {
            if (((SortedObject)this.myVector.lastElement()).lessThan(t)) {
                this.myVector.addElement(t);
                return;
            }
            throw new Exception("Elements not in order");
        }
        this.myVector.addElement(t);
    }

    public synchronized void removeBlock(int n, int n2) {
        this.myVector.removeBlock(n, n2);
    }

    public synchronized T find(Object object) {
        return this.get(object);
    }

    public synchronized T find(long l) {
        return this.get(l);
    }

    public synchronized int findIdx(long l) {
        return this.findIndex(l);
    }

    public synchronized int findIdx(Object object) {
        return this.findIndex(object);
    }

    public synchronized T get(Object object) {
        int n = this.findIndex(object);
        if (n != -1) {
            return (T)((SortedObject)this.myVector.elementAt(n));
        }
        return null;
    }

    public synchronized T get(long l) {
        int n = this.findIndex(l);
        if (n != -1) {
            return (T)((SortedObject)this.myVector.elementAt(n));
        }
        return null;
    }

    public synchronized T remove(int n) {
        return (T)((SortedObject)this.myVector.remove(n));
    }

    public synchronized T remove(Object object) {
        int n = this.findIndex(object);
        if (n != -1) {
            return this.remove(n);
        }
        return null;
    }

    public synchronized T remove(long l) {
        int n = this.findIndex(l);
        if (n != -1) {
            return this.remove(n);
        }
        return null;
    }

    public synchronized void removeAllElements() {
        this.myVector.removeAllElements();
    }

    public synchronized T elementAt(int n) {
        return (T)((SortedObject)this.myVector.elementAt(n));
    }

    public synchronized int size() {
        return this.myVector.size();
    }

    public synchronized Object[] extractBlock(int n, int n2) {
        return this.myVector.extractBlock(n, n2);
    }

    private int insertIndex(T t) throws Exception {
        SortedObject sortedObject;
        int n = 0;
        if (this.myVector.size() > 1) {
            n = this.indexLookup(t, 0, this.myVector.size());
        } else if (this.myVector.size() == 1 && this.compare(sortedObject = (SortedObject)this.myVector.elementAt(0), t) == 0) {
            if (this.myDuplicateHandler != null) {
                this.myDuplicateHandler.merge(sortedObject, (SortedObject)t);
                return -1;
            }
            throw new Exception("Duplicates not allowed");
        }
        return n;
    }

    public int findNextNearest(long l) throws Exception {
        int n = 0;
        if (this.myVector.size() > 1) {
            n = this.nearestNextLookup(l, 0, this.myVector.size());
        }
        return n;
    }

    private int nearestNextLookup(long l, int n, int n2) throws Exception {
        if (n2 - n < 5) {
            for (int i = n; i < n2; ++i) {
                int n3 = this.compare((T)((SortedObject)this.myVector.elementAt(i)), l);
                if (n3 == -1) continue;
                return i;
            }
            return n2;
        }
        int n4 = (n2 - n) / 2 + n;
        int n5 = this.compare((T)((SortedObject)this.myVector.elementAt(n4)), l);
        if (n5 == -1) {
            return this.nearestNextLookup(l, n4, n2);
        }
        if (n5 == 0) {
            return n4;
        }
        return this.nearestNextLookup(l, n, n4);
    }

    public void merge(SortedVector<T> sortedVector) {
        this.merge(sortedVector, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(SortedVector<T> sortedVector, MergeManager mergeManager) {
        SortedObject[] sortedObjectArray;
        SortedVector<T> sortedVector2 = sortedVector;
        synchronized (sortedVector2) {
            sortedObjectArray = new SortedObject[sortedVector.size()];
            for (int i = 0; i != sortedObjectArray.length; ++i) {
                sortedObjectArray[i] = sortedVector.elementAt(i);
            }
        }
        this.merge(sortedObjectArray, mergeManager);
    }

    private synchronized void merge(SortedObject[] sortedObjectArray, MergeManager mergeManager) {
        Object object;
        int n = 0;
        int n2 = 0;
        while (n < this.size() && n2 < sortedObjectArray.length) {
            SortedObject sortedObject;
            object = this.elementAt(n);
            if (object.equals(sortedObject = sortedObjectArray[n2])) {
                if (mergeManager != null) {
                    mergeManager.merge((SortedObject)object, sortedObject);
                }
                ++n;
                ++n2;
                continue;
            }
            if (object.lessThan(sortedObject)) {
                this.remove(n);
                if (mergeManager == null) continue;
                mergeManager.deleted((SortedObject)object);
                continue;
            }
            try {
                this.add(sortedObject);
                if (mergeManager == null) continue;
                mergeManager.added(sortedObject);
            }
            catch (Exception exception) {
                fConstants.logger.fatal(exception);
            }
        }
        while (this.size() > n) {
            object = this.remove(n);
            if (mergeManager == null) continue;
            mergeManager.deleted((SortedObject)object);
        }
        while (sortedObjectArray.length > n2) {
            object = sortedObjectArray[n2];
            ++n2;
            try {
                this.add(object);
                if (mergeManager == null) continue;
                mergeManager.added((SortedObject)object);
            }
            catch (Exception exception) {
                fConstants.logger.fatal(exception);
            }
        }
    }

    public int findPreviousNearest(long l) {
        int n = 0;
        if (this.myVector.size() > 1) {
            n = this.nearestPreviousLookup(l, 0, this.myVector.size());
        }
        return n;
    }

    private int nearestPreviousLookup(long l, int n, int n2) {
        if (n2 - n < 5) {
            for (int i = n; i < n2; ++i) {
                int n3 = this.compare((T)((SortedObject)this.myVector.elementAt(i)), l);
                if (n3 == 1) {
                    return n - 1;
                }
                if (n3 != 0) continue;
                return i - 1;
            }
            return n - 1;
        }
        int n4 = (n2 - n) / 2 + n;
        int n5 = this.compare((T)((SortedObject)this.myVector.elementAt(n4)), l);
        if (n5 == -1) {
            return this.nearestPreviousLookup(l, n4, n2);
        }
        if (n5 == 0) {
            return n4 - 1;
        }
        return this.nearestPreviousLookup(l, n, n4);
    }

    private int indexLookup(T t, int n, int n2) throws Exception {
        if (n2 - n < 5) {
            for (int i = n; i < n2; ++i) {
                SortedObject sortedObject = (SortedObject)this.myVector.elementAt(i);
                int n3 = this.compare(sortedObject, t);
                switch (n3) {
                    case 0: {
                        if (this.myDuplicateHandler != null) {
                            this.myDuplicateHandler.merge(sortedObject, (SortedObject)t);
                            return -1;
                        }
                        throw new Exception("Duplicates not allowed");
                    }
                    case 1: {
                        return i;
                    }
                }
            }
            return n2;
        }
        int n4 = (n2 - n) / 2 + n;
        SortedObject sortedObject = (SortedObject)this.myVector.elementAt(n4);
        int n5 = this.compare(sortedObject, t);
        switch (n5) {
            case -1: {
                return this.indexLookup(t, n4, n2);
            }
            case 0: {
                if (this.myDuplicateHandler != null) {
                    this.myDuplicateHandler.merge(sortedObject, (SortedObject)t);
                    return -1;
                }
                throw new Exception("Duplicates not allowed");
            }
        }
        return this.indexLookup(t, n, n4);
    }

    private int findIndex(Object object) {
        if (this.myVector.size() > 10) {
            if (this.compare((SortedObject)this.myVector.elementAt(0), object) == 0) {
                return 0;
            }
            if (this.compare((SortedObject)this.myVector.elementAt(this.myVector.size() - 1), object) == 0) {
                return this.myVector.size() - 1;
            }
        }
        return this.binaryLookup(object, 0, this.myVector.size());
    }

    private int findIndex(long l) {
        if (this.myVector.size() > 10) {
            if (this.compare((T)((SortedObject)this.myVector.elementAt(0)), l) == 0) {
                return 0;
            }
            if (this.compare((T)((SortedObject)this.myVector.elementAt(this.myVector.size() - 1)), l) == 0) {
                return this.myVector.size() - 1;
            }
        }
        return this.binaryLookup(l, 0, this.myVector.size());
    }

    private int binaryLookup(Object object, int n, int n2) {
        if (n2 - n < 5) {
            for (int i = n; i < n2; ++i) {
                int n3 = this.compare((SortedObject)this.myVector.elementAt(i), object);
                switch (n3) {
                    case 0: {
                        return i;
                    }
                    case 1: {
                        return -1;
                    }
                }
            }
            return -1;
        }
        int n4 = (n2 - n) / 2 + n;
        int n5 = this.compare((SortedObject)this.myVector.elementAt(n4), object);
        switch (n5) {
            case -1: {
                return this.binaryLookup(object, n4, n2);
            }
            case 0: {
                return n4;
            }
        }
        return this.binaryLookup(object, n, n4);
    }

    private int binaryLookup(long l, int n, int n2) {
        if (n2 - n < 5) {
            for (int i = n; i < n2; ++i) {
                int n3 = this.compare((T)((SortedObject)this.myVector.elementAt(i)), l);
                switch (n3) {
                    case 0: {
                        return i;
                    }
                    case 1: {
                        return -1;
                    }
                }
            }
            return -1;
        }
        int n4 = (n2 - n) / 2 + n;
        int n5 = this.compare((T)((SortedObject)this.myVector.elementAt(n4)), l);
        switch (n5) {
            case -1: {
                return this.binaryLookup(l, n4, n2);
            }
            case 0: {
                return n4;
            }
        }
        return this.binaryLookup(l, n, n4);
    }

    private int compare(T t, Object object) {
        if (t.lessThan(object)) {
            return -1;
        }
        if (t.equals(object)) {
            return 0;
        }
        return 1;
    }

    private int compare(T t, long l) {
        if (t.lessThan(l)) {
            return -1;
        }
        if (t.equals(l)) {
            return 0;
        }
        return 1;
    }
}

