/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.collections;

public class fBitOffSet
implements Cloneable {
    private static final int UNIT_ADDRESS_BIT_SIZE = 6;
    private static final int UNIT_SIZE_IN_BITS = 64;
    private static final int INDEXMASK = 63;
    private transient int myUnitsInUse = 0;
    private long[] myDataArray;
    private long myOffset;
    private int mySize;

    public fBitOffSet(int n, long l) {
        this.myOffset = l;
        this.myDataArray = new long[fBitOffSet.CalculateUnitIndex(n - 1) + 1];
        this.mySize = n;
    }

    public fBitOffSet(long l, int n, long[] lArray) {
        this.myOffset = l;
        this.myDataArray = lArray;
        this.myUnitsInUse = this.myDataArray.length;
        this.mySize = n;
    }

    public long getOffset() {
        return this.myOffset;
    }

    public final long[] getData() {
        return this.myDataArray;
    }

    public boolean get(long l) {
        int n = this.calcOffset(l);
        if (n < 0) {
            throw new IndexOutOfBoundsException("Invalid bit index: " + Integer.toString(n));
        }
        boolean bl = false;
        int n2 = fBitOffSet.CalculateUnitIndex(n);
        if (n2 < this.myUnitsInUse) {
            bl = (this.myDataArray[n2] & fBitOffSet.CalculateBit(n)) != 0L;
        }
        return bl;
    }

    public int length() {
        if (this.myUnitsInUse == 0) {
            return 0;
        }
        int n = (this.myUnitsInUse - 1) * 64;
        long l = this.myDataArray[this.myUnitsInUse - 1];
        while (l > 0L) {
            l >>>= 1;
            ++n;
        }
        return n;
    }

    public void set(long l) {
        int n = this.calcOffset(l);
        if (n < 0) {
            throw new IndexOutOfBoundsException("Invalid bit index: " + Integer.toString(n));
        }
        int n2 = fBitOffSet.CalculateUnitIndex(n);
        int n3 = n2 + 1;
        if (this.myUnitsInUse > n3) {
            int n4 = n2;
            this.myDataArray[n4] = this.myDataArray[n4] | fBitOffSet.CalculateBit(n);
        } else {
            this.updateCapacity(n3);
            int n5 = n2;
            this.myDataArray[n5] = this.myDataArray[n5] | fBitOffSet.CalculateBit(n);
            this.myUnitsInUse = n3;
        }
    }

    public void clear(long l) {
        int n = this.calcOffset(l);
        if (n < 0) {
            throw new IndexOutOfBoundsException("Invalid bit index: " + Integer.toString(n));
        }
        int n2 = fBitOffSet.CalculateUnitIndex(n);
        if (n2 >= this.myUnitsInUse) {
            return;
        }
        int n3 = n2;
        this.myDataArray[n3] = this.myDataArray[n3] & (fBitOffSet.CalculateBit(n) ^ 0xFFFFFFFFFFFFFFFFL);
        if (this.myDataArray[this.myUnitsInUse - 1] == 0L) {
            this.recalculateUnitsUsed();
        }
    }

    private int calcOffset(long l) {
        return (int)(l - this.myOffset);
    }

    private static int CalculateUnitIndex(int n) {
        return n >> 6;
    }

    private static long CalculateBit(int n) {
        return 1L << (n & 0x3F);
    }

    private void recalculateUnitsUsed() {
        int n;
        for (n = this.myUnitsInUse - 1; n >= 0 && this.myDataArray[n] == 0L; --n) {
        }
        this.myUnitsInUse = n + 1;
    }

    private void updateCapacity(int n) {
        if (this.myDataArray.length < n) {
            int n2 = Math.max(2 * this.myDataArray.length, n);
            long[] lArray = new long[n2];
            System.arraycopy(this.myDataArray, 0, lArray, 0, this.myUnitsInUse);
            this.myDataArray = lArray;
        }
    }

    public int size() {
        return this.mySize;
    }

    public Object clone() {
        fBitOffSet fBitOffSet2 = null;
        try {
            fBitOffSet2 = (fBitOffSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Clone not supported");
        }
        fBitOffSet2.myDataArray = new long[this.myDataArray.length];
        System.arraycopy(this.myDataArray, 0, fBitOffSet2.myDataArray, 0, this.myUnitsInUse);
        return fBitOffSet2;
    }

    public String toString() {
        int n = this.myUnitsInUse << 6;
        StringBuffer stringBuffer = new StringBuffer(8 * n + 2);
        String string = "";
        stringBuffer.append('[');
        for (int i = 0; i < n; ++i) {
            if (!this.get((long)i + this.myOffset)) continue;
            stringBuffer.append(string);
            string = ", ";
            stringBuffer.append((long)i + this.myOffset);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public int hashCode() {
        long l = 1234L;
        int n = this.myDataArray.length;
        while (--n >= 0) {
            l ^= this.myDataArray[n] * (long)(n + 1);
        }
        return (int)(l >> 32 ^ l);
    }

    public boolean equals(Object object) {
        int n;
        if (!(object instanceof fBitOffSet)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        fBitOffSet fBitOffSet2 = (fBitOffSet)object;
        int n2 = Math.min(this.myUnitsInUse, fBitOffSet2.myUnitsInUse);
        for (n = 0; n < n2; ++n) {
            if (this.myDataArray[n] == fBitOffSet2.myDataArray[n]) continue;
            return false;
        }
        if (this.myUnitsInUse > n2) {
            for (n = n2; n < this.myUnitsInUse; ++n) {
                if (this.myDataArray[n] == 0L) continue;
                return false;
            }
        } else {
            for (n = n2; n < fBitOffSet2.myUnitsInUse; ++n) {
                if (fBitOffSet2.myDataArray[n] == 0L) continue;
                return false;
            }
        }
        return true;
    }
}

