/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.collections;

import com.pcbsys.foundation.collections.fQueue;
import com.pcbsys.foundation.utils.fUtilities;

public class fCircularQueue<T>
implements fQueue<T> {
    private Object[] myBuffer;
    private long myEndIdx;
    private long myStartIdx;
    private int myMask;
    private boolean allowOverwrite;
    private boolean allowAutoResize;

    public fCircularQueue(int n) {
        this(n, true);
    }

    public fCircularQueue(int n, boolean bl) {
        this(n, bl, false);
    }

    public fCircularQueue(int n, boolean bl, boolean bl2) {
        this.myBuffer = new Object[fUtilities.findNextPowerOfTwo(n)];
        this.allowOverwrite = bl;
        this.allowAutoResize = bl2;
        this.myMask = this.myBuffer.length - 1;
        this.reset();
    }

    public fCircularQueue(fCircularQueue fCircularQueue2) {
        this.myBuffer = new Object[fCircularQueue2.myBuffer.length];
        this.myEndIdx = fCircularQueue2.myEndIdx;
        this.myStartIdx = fCircularQueue2.myStartIdx;
        this.allowOverwrite = fCircularQueue2.allowOverwrite;
        System.arraycopy(fCircularQueue2.myBuffer, 0, this.myBuffer, 0, this.myBuffer.length);
    }

    public void resize(int n) {
        fCircularQueue<T> fCircularQueue2 = new fCircularQueue<T>(n);
        try {
            while (this.myEndIdx != this.myStartIdx) {
                fCircularQueue2.put(this.get());
            }
            this.myBuffer = fCircularQueue2.myBuffer;
            this.myEndIdx = fCircularQueue2.myEndIdx;
            this.myStartIdx = fCircularQueue2.myStartIdx;
            this.myMask = this.myBuffer.length - 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void put(T t) {
        if (t == null) {
            return;
        }
        int n = (int)(this.myEndIdx & (long)this.myMask);
        if (this.myBuffer[n] != null && this.allowAutoResize && !this.allowOverwrite) {
            this.resize(this.myBuffer.length * 2);
            n = (int)(this.myEndIdx & (long)this.myMask);
        }
        if (this.myBuffer[n] != null) {
            if (!this.allowOverwrite) {
                throw new Error("Overwrite disabled");
            }
            if (this.myEndIdx == this.myStartIdx) {
                this.myBuffer[n] = null;
                ++this.myStartIdx;
            }
            ++this.myStartIdx;
        }
        this.myBuffer[n] = t;
        ++this.myEndIdx;
    }

    @Override
    public T pop() {
        return this.get();
    }

    @Override
    public T top() {
        return this.look();
    }

    public boolean wouldOverwrite() {
        return this.myBuffer[(int)(this.myEndIdx & (long)this.myMask)] != null;
    }

    public int length() {
        return this.myBuffer.length;
    }

    @Override
    public int size() {
        return (int)(this.myEndIdx - this.myStartIdx);
    }

    public T look() {
        return (T)this.myBuffer[(int)(this.myStartIdx & (long)this.myMask)];
    }

    public T get() {
        int n = (int)this.myStartIdx & this.myMask;
        Object object = null;
        if (this.myBuffer[n] != null) {
            object = this.myBuffer[n];
            this.myBuffer[n] = null;
            ++this.myStartIdx;
        }
        return (T)object;
    }

    public void reset() {
        for (int i = 0; i < this.myBuffer.length; ++i) {
            this.myBuffer[i] = null;
        }
        this.myEndIdx = 0L;
        this.myStartIdx = 0L;
    }

    public boolean contains(T t) {
        for (Object object : this.myBuffer) {
            if (object != t) continue;
            return true;
        }
        return false;
    }

    public Object look(int n) {
        if (n >= this.myBuffer.length) {
            return null;
        }
        int n2 = ((int)(this.myStartIdx & (long)this.myMask) + n) % this.myBuffer.length;
        return this.myBuffer[n2];
    }
}

