/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.collections;

import com.pcbsys.foundation.collections.SortedObject;
import com.pcbsys.foundation.collections.fVector;
import com.pcbsys.foundation.memory.fMemoryManager;
import java.util.NoSuchElementException;

public class fPageArray<T extends SortedObject>
implements fVector<T> {
    private fPage[] myData;
    private final int myPageSize;
    private int size = 0;
    private int lastUsedPage = 0;
    private int insertActive = -1;
    private int insertMin = -1;
    private int insertMax = -1;
    private int readActive = -1;
    private int readMin = -1;
    private int readMax = -1;

    fPageArray(int n) {
        this(n, 1);
    }

    private fPageArray(int n, int n2) {
        this.myPageSize = n % 2 == 1 ? n + 1 : n;
        this.myData = new fPage[n2];
        for (int i = 0; i < this.myData.length; ++i) {
            this.myData[i] = new fPage(this.myPageSize);
        }
    }

    @Override
    public T remove(int n) {
        if (n >= this.size) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = n;
        if (n == 0) {
            this.readActive = 0;
            this.readMin = 0;
            this.readMax = this.myData[this.readActive].size();
        } else {
            n2 = this.setActivePage(n);
        }
        SortedObject sortedObject = null;
        if (this.readActive != -1) {
            sortedObject = (SortedObject)this.myData[this.readActive].remove(n2);
            if (this.myData[this.readActive].isEmpty() && this.lastUsedPage != this.readActive && this.myData.length > 1) {
                this.removePage(this.readActive);
                --this.lastUsedPage;
            }
        }
        if (sortedObject != null) {
            --this.size;
            --this.readMax;
            this.insertActive = -1;
        }
        return (T)sortedObject;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void trimToSize() {
        int n;
        for (n = this.myData.length - 1; this.myData[n].isEmpty() && n != 0; --n) {
        }
        if (n > 0 && n < this.myData.length - 1) {
            fPage[] fPageArray2 = new fPage[n + 1];
            System.arraycopy(this.myData, 0, fPageArray2, 0, n + 1);
            this.myData = fPageArray2;
        }
    }

    public SortedObject get(int n) {
        if (n >= this.size) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.elementAt(n);
    }

    @Override
    public T elementAt(int n) {
        if (n >= this.size) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = this.setActivePage(n);
        if (this.readActive != -1) {
            return (T)((SortedObject)this.myData[this.readActive].elementAt(n2));
        }
        return null;
    }

    @Override
    public T lastElement() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        int n = this.size - 1;
        try {
            return (T)this.elementAt(this.size - 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (this.size != 0) {
                return (T)this.elementAt(this.size - 1);
            }
            return null;
        }
    }

    @Override
    public void removeElementAt(int n) {
        if (n >= this.size()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        this.remove(n);
        this.insertActive = -1;
    }

    @Override
    public void removeAllElements() {
        for (int i = 0; i < this.myData.length; ++i) {
            this.myData[i].removeAllElements();
            this.myData[i] = null;
        }
        this.myData = new fPage[1];
        this.myData[0] = new fPage(this.myPageSize);
        this.size = 0;
        this.readActive = -1;
        this.insertActive = -1;
        this.lastUsedPage = 0;
    }

    @Override
    public int indexOf(Object object) {
        int n = -1;
        for (int i = 0; i <= this.lastUsedPage; ++i) {
            fPage fPage2 = this.myData[i];
            if (fPage2.isEmpty()) continue;
            int n2 = fPage2.contains(object);
            if (n2 != -1) {
                if (n == -1) {
                    n = 0;
                }
                return n += n2;
            }
            n += fPage2.size();
        }
        return n;
    }

    @Override
    public void addElement(T t) {
        if (t == null) {
            throw new NullPointerException("Expected a value to be added, NULL is not supported");
        }
        if (this.myData[this.lastUsedPage].isFull()) {
            ++this.lastUsedPage;
            if (this.lastUsedPage == this.myData.length) {
                fPage[] fPageArray2 = new fPage[this.myData.length + 10];
                System.arraycopy(this.myData, 0, fPageArray2, 0, this.myData.length);
                for (int i = this.myData.length; i < fPageArray2.length; ++i) {
                    fPageArray2[i] = new fPage(this.myPageSize);
                }
                this.myData = fPageArray2;
            }
        }
        this.myData[this.lastUsedPage].add(t);
        ++this.size;
    }

    @Override
    public void insertElementAt(T t, int n) {
        if (t == null) {
            throw new NullPointerException("Expected a value to be added, NULL is not supported");
        }
        if (n > this.size && this.size > 0) {
            throw new ArrayIndexOutOfBoundsException(n + " > " + this.size);
        }
        int n2 = n;
        if (n == this.size) {
            this.addElement(t);
        } else if (n == 0) {
            this.insertActive = 0;
            this.insertMin = 0;
            this.insertMax = this.myData[0].size();
        } else {
            n2 = this.getInsertPage(n);
        }
        if (this.insertActive != -1) {
            if (this.myData[this.insertActive].isFull()) {
                this.splitPage(this.insertActive);
                this.insertElementAt(t, n);
            } else {
                this.myData[this.insertActive].insertElementAt(t, n2);
                ++this.insertMax;
                if (this.insertMax > this.myPageSize) {
                    this.insertActive = -1;
                }
                ++this.size;
            }
        }
    }

    @Override
    public void removeBlock(int n, int n2) {
        if (n > this.size()) {
            throw new IndexOutOfBoundsException(n + " >= " + this.size);
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException(n2 + " >= " + this.size);
        }
        for (int i = n; i <= n2; ++i) {
            this.remove(n);
        }
    }

    @Override
    public Object[] extractBlock(int n, int n2) {
        if (n > this.size()) {
            throw new IndexOutOfBoundsException(n + " >= " + this.size);
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException(n2 + " >= " + this.size);
        }
        Object[] objectArray = new Object[n2 - n + 1];
        int n3 = 0;
        for (int i = n; i <= n2; ++i) {
            objectArray[n3] = this.remove(n);
            ++n3;
        }
        return objectArray;
    }

    private void splitPage(int n) {
        fPage fPage2 = this.myData[n];
        fPage fPage3 = new fPage(fPage2.size());
        System.arraycopy(fPage2.myData, fPage2.size() / 2, fPage3.myData, 0, fPage2.size() / 2);
        for (int i = fPage2.size() / 2; i < fPage2.size(); ++i) {
            ((fPage)fPage2).myData[i] = null;
        }
        fPage2.endIdx = fPage2.size() / 2;
        fPage3.endIdx = fPage2.endIdx;
        fPage[] fPageArray2 = new fPage[this.myData.length + 1];
        if (n + 1 == this.myData.length) {
            System.arraycopy(this.myData, 0, fPageArray2, 0, n + 1);
            fPageArray2[this.readActive + 1] = fPage3;
        } else if (n == 0) {
            fPageArray2[0] = this.myData[0];
            fPageArray2[1] = fPage3;
            System.arraycopy(this.myData, n + 1, fPageArray2, n + 2, this.myData.length - (n + 1));
        } else {
            System.arraycopy(this.myData, 0, fPageArray2, 0, n + 1);
            fPageArray2[n + 1] = fPage3;
            System.arraycopy(this.myData, n + 1, fPageArray2, n + 2, this.myData.length - (n + 1));
        }
        this.myData = fPageArray2;
        ++this.lastUsedPage;
        this.readActive = -1;
        this.insertActive = -1;
    }

    private void removePage(int n) {
        fPage[] fPageArray2 = new fPage[this.myData.length - 1];
        if (n == 0) {
            System.arraycopy(this.myData, 1, fPageArray2, 0, fPageArray2.length);
        } else if (n < fPageArray2.length) {
            System.arraycopy(this.myData, 0, fPageArray2, 0, n);
            System.arraycopy(this.myData, n + 1, fPageArray2, n, fPageArray2.length - n);
        } else {
            System.arraycopy(this.myData, 0, fPageArray2, 0, fPageArray2.length);
        }
        this.myData = fPageArray2;
    }

    private int getInsertPage(int n) {
        if (this.insertActive != -1 && n >= this.insertMin && n < this.insertMax) {
            return n - this.insertMin;
        }
        this.insertActive = -1;
        int n2 = n;
        int n3 = 0;
        while (this.insertActive == -1 && n3 <= this.lastUsedPage) {
            if (n2 < this.myData[n3].size()) {
                this.insertMin = n - n2;
                this.insertMax = this.insertMin + this.myData[n3].size();
                this.insertActive = n3;
                continue;
            }
            n2 -= this.myData[n3].size();
            ++n3;
        }
        return n2;
    }

    private int setActivePage(int n) {
        if (this.readActive != -1 && n >= this.readMin && n < this.readMax) {
            return n - this.readMin;
        }
        this.readActive = -1;
        int n2 = n;
        if (n == this.size - 1) {
            if (this.lastUsedPage >= this.myData.length) {
                this.lastUsedPage = this.myData.length - 1;
            }
            while (this.myData[this.lastUsedPage].isEmpty() && this.lastUsedPage > 0) {
                --this.lastUsedPage;
            }
            n2 = this.myData[this.lastUsedPage].size() - 1;
            this.readActive = this.lastUsedPage;
            this.readMin = n - this.myData[this.lastUsedPage].size() + 1;
            this.readMax = n;
            if (this.readMax > this.myPageSize) {
                this.readMax = this.myPageSize;
            }
        } else {
            int n3 = 0;
            while (this.readActive == -1 && n3 <= this.lastUsedPage) {
                if (n2 < this.myData[n3].size()) {
                    this.readMin = n - n2;
                    this.readMax = this.readMin + this.myData[n3].size();
                    this.readActive = n3;
                    continue;
                }
                n2 -= this.myData[n3].size();
                ++n3;
            }
        }
        return n2;
    }

    public static class fPage<T> {
        private final Object[] myData;
        private int endIdx = 0;

        public fPage(int n) {
            this.myData = fMemoryManager.getInstance().allocateObjectArray(n);
        }

        public boolean isFull() {
            return this.myData.length == this.endIdx;
        }

        public void add(T t) {
            this.myData[this.endIdx] = t;
            ++this.endIdx;
        }

        public int size() {
            return this.endIdx;
        }

        public T remove(int n) {
            Object object = this.myData[n];
            if (n != this.endIdx - 1) {
                System.arraycopy(this.myData, n + 1, this.myData, n, this.myData.length - n - 1);
                --this.endIdx;
                this.myData[this.endIdx] = null;
            } else {
                this.myData[n] = null;
                --this.endIdx;
            }
            return (T)object;
        }

        public boolean isEmpty() {
            return this.endIdx == 0;
        }

        public T elementAt(int n) {
            return (T)this.myData[n];
        }

        public void removeAllElements() {
            for (int i = 0; i < this.myData.length; ++i) {
                this.myData[i] = null;
            }
            this.endIdx = 0;
        }

        public int contains(Object object) {
            for (int i = 0; i < this.endIdx; ++i) {
                if (!object.equals(this.myData[i])) continue;
                return i;
            }
            return -1;
        }

        public void insertElementAt(T t, int n) {
            System.arraycopy(this.myData, n, this.myData, n + 1, this.endIdx - n);
            this.myData[n] = t;
            ++this.endIdx;
        }
    }
}

