/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.collections.fast;

import com.pcbsys.foundation.utils.fUtilities;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class Long2ObjectOpenAddressingHashMap<V>
implements Map<Long, V> {
    private final double loadFactor;
    private int capacity;
    private int mask;
    private int size;
    private int resizeThreshold;
    private long[] keys;
    private Object[] values;
    private ValueCollection<V> valuesCollection;
    private KeySet keySet;
    private MapEntrySet<V> entrySet;

    public Long2ObjectOpenAddressingHashMap() {
        this(8, 0.67);
    }

    public Long2ObjectOpenAddressingHashMap(int n, double d) {
        this.loadFactor = d;
        this.capacity = fUtilities.findNextPowerOfTwo(n);
        this.mask = this.capacity - 1;
        this.resizeThreshold = (int)((double)this.capacity * d);
        this.keys = new long[this.capacity];
        this.values = new Object[this.capacity];
    }

    public Long2ObjectOpenAddressingHashMap(Long2ObjectOpenAddressingHashMap<V> long2ObjectOpenAddressingHashMap) {
        this.loadFactor = long2ObjectOpenAddressingHashMap.loadFactor;
        this.capacity = fUtilities.findNextPowerOfTwo(long2ObjectOpenAddressingHashMap.capacity);
        this.mask = this.capacity - 1;
        this.resizeThreshold = (int)((double)this.capacity * this.loadFactor);
        this.keys = new long[this.capacity];
        this.values = new Object[this.capacity];
        System.arraycopy(long2ObjectOpenAddressingHashMap.keys, 0, this.keys, 0, this.capacity);
        System.arraycopy(long2ObjectOpenAddressingHashMap.values, 0, this.values, 0, this.capacity);
    }

    private int hash(long l) {
        int n = (int)(l ^ l >>> 32);
        return (n *= 29) & this.mask;
    }

    public double getLoadFactor() {
        return this.loadFactor;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getResizeThreshold() {
        return this.resizeThreshold;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size;
    }

    @Override
    public boolean containsKey(Object object) {
        Long l = (Long)object;
        return this.containsKey(l);
    }

    public boolean containsKey(long l) {
        int n = this.hash(l);
        while (null != this.values[n]) {
            if (l == this.keys[n]) {
                return true;
            }
            ++n;
            n &= this.mask;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        for (Object object2 : this.values) {
            if (null == object2 || !object.equals(object2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object object) {
        Long l = (Long)object;
        return this.get(l);
    }

    public V get(long l) {
        Object object;
        int n = this.hash(l);
        while (null != (object = this.values[n])) {
            if (l == this.keys[n]) {
                return (V)object;
            }
            ++n;
            n &= this.mask;
        }
        return null;
    }

    @Override
    public V put(Long l, V v) {
        return this.put((long)l, v);
    }

    @Override
    public V put(long l, V v) {
        if (null == v) {
            throw new NullPointerException("Value cannot be null");
        }
        Object object = null;
        int n = this.hash(l);
        while (null != this.values[n]) {
            if (l == this.keys[n]) {
                object = this.values[n];
                break;
            }
            ++n;
            n &= this.mask;
        }
        if (null == object) {
            ++this.size;
            this.keys[n] = l;
        }
        this.values[n] = v;
        if (this.size > this.resizeThreshold) {
            this.resize();
        }
        return (V)object;
    }

    private void resize() {
        int n = this.capacity << 1;
        if (n < 0) {
            throw new IllegalStateException("Max capacity reached at size=" + this.size);
        }
        this.capacity = n;
        this.mask = n - 1;
        this.resizeThreshold = (int)((double)n * this.loadFactor);
        long[] lArray = new long[this.capacity];
        Object[] objectArray = new Object[this.capacity];
        int n2 = this.values.length;
        for (int i = 0; i < n2; ++i) {
            Object object = this.values[i];
            if (null == object) continue;
            long l = this.keys[i];
            int n3 = this.hash(l);
            while (null != objectArray[n3]) {
                ++n3;
                n3 &= this.mask;
            }
            lArray[n3] = l;
            objectArray[n3] = object;
        }
        this.keys = lArray;
        this.values = objectArray;
    }

    @Override
    public V remove(Object object) {
        Long l = (Long)object;
        return this.remove(l);
    }

    public V remove(long l) {
        Object object;
        int n = this.hash(l);
        while (null != (object = this.values[n])) {
            if (l == this.keys[n]) {
                this.values[n] = null;
                --this.size;
                this.handleDeletion(n);
                return (V)object;
            }
            ++n;
            n &= this.mask;
        }
        return null;
    }

    private void handleDeletion(int n) {
        int n2 = n;
        while (true) {
            ++n2;
            if (null == this.values[n2 &= this.mask]) {
                return;
            }
            int n3 = this.hash(this.keys[n2]);
            if ((n2 >= n3 || n3 > n && n > n2) && (n3 > n || n > n2)) continue;
            this.keys[n] = this.keys[n2];
            this.values[n] = this.values[n2];
            this.values[n2] = null;
            n = n2;
        }
    }

    @Override
    public void clear() {
        this.size = 0;
        int n = this.values.length;
        for (int i = 0; i < n; ++i) {
            this.values[i] = null;
        }
    }

    @Override
    public void putAll(Map<? extends Long, ? extends V> map) {
        for (Map.Entry<Long, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public KeySet keySet() {
        if (null == this.keySet) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (null == this.valuesCollection) {
            this.valuesCollection = new ValueCollection();
        }
        return this.valuesCollection;
    }

    public Iterator<V> iterator() {
        return this.values().iterator();
    }

    @Override
    public Set<Map.Entry<Long, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    public MapEntrySet<V> mapEntrySet() {
        if (null == this.entrySet) {
            this.entrySet = new MapEntrySet();
        }
        return this.entrySet;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        MapEntryIterator<V> mapEntryIterator = this.mapEntrySet().mapEntryIterator();
        while (mapEntryIterator.hasNext()) {
            Object object = mapEntryIterator.next();
            stringBuilder.append(object.getLongKey());
            stringBuilder.append('=');
            stringBuilder.append(object.getValue());
            stringBuilder.append(", ");
        }
        if (stringBuilder.length() > 1) {
            stringBuilder.setLength(stringBuilder.length() - 2);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public final class MapEntryIteratorImpl<T>
    extends MapIterator<Long2ObjectEntry<T>>
    implements Long2ObjectEntry<T>,
    MapEntryIterator<T> {
        @Override
        public Long2ObjectEntry<T> next() {
            this.findNext();
            return this;
        }

        @Override
        public Long getKey() {
            return Long2ObjectOpenAddressingHashMap.this.keys[this.getIndex()];
        }

        @Override
        public long getLongKey() {
            return Long2ObjectOpenAddressingHashMap.this.keys[this.getIndex()];
        }

        @Override
        public T getValue() {
            return (T)Long2ObjectOpenAddressingHashMap.this.values[this.getIndex()];
        }

        @Override
        public T setValue(T t) {
            if (null == t) {
                throw new NullPointerException();
            }
            int n = this.getIndex();
            Object object = Long2ObjectOpenAddressingHashMap.this.values[n];
            ((Long2ObjectOpenAddressingHashMap)Long2ObjectOpenAddressingHashMap.this).values[n] = t;
            return (T)object;
        }
    }

    public static interface MapEntryIterator<T>
    extends Iterator<Long2ObjectEntry<T>> {
        @Override
        public Long2ObjectEntry<T> next();
    }

    public static interface Long2ObjectEntry<T>
    extends Map.Entry<Long, T> {
        public long getLongKey();
    }

    public final class KeyIterator
    extends MapIterator<Long> {
        @Override
        public Long next() {
            this.findNext();
            return Long2ObjectOpenAddressingHashMap.this.keys[this.getIndex()];
        }

        public long nextLong() {
            this.findNext();
            return Long2ObjectOpenAddressingHashMap.this.keys[this.getIndex()];
        }
    }

    public final class ValueIterator<T>
    extends MapIterator<T> {
        @Override
        public T next() {
            this.findNext();
            return (T)Long2ObjectOpenAddressingHashMap.this.values[this.getIndex()];
        }
    }

    private abstract class MapIterator<T>
    implements Iterator<T> {
        private int index;
        private boolean validIndex;

        private MapIterator() {
            this.index = Long2ObjectOpenAddressingHashMap.this.capacity;
            this.validIndex = false;
        }

        protected int getIndex() {
            return this.index;
        }

        @Override
        public boolean hasNext() {
            for (int i = this.index - 1; i >= 0; --i) {
                if (null == Long2ObjectOpenAddressingHashMap.this.values[i]) continue;
                return true;
            }
            return false;
        }

        protected void findNext() {
            this.validIndex = false;
            for (int i = this.index - 1; i >= 0; --i) {
                if (null == Long2ObjectOpenAddressingHashMap.this.values[i]) continue;
                this.index = i;
                this.validIndex = true;
                return;
            }
            throw new NoSuchElementException();
        }

        @Override
        public abstract T next();

        @Override
        public void remove() {
            if (!this.validIndex) {
                throw new IllegalStateException();
            }
            Long2ObjectOpenAddressingHashMap.this.remove(Long2ObjectOpenAddressingHashMap.this.keys[this.index]);
            this.validIndex = false;
        }
    }

    public final class MapEntrySet<T>
    extends AbstractSet<Map.Entry<Long, V>> {
        @Override
        public int size() {
            return Long2ObjectOpenAddressingHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return Long2ObjectOpenAddressingHashMap.this.isEmpty();
        }

        @Override
        public Iterator<Map.Entry<Long, V>> iterator() {
            throw new UnsupportedOperationException();
        }

        public MapEntryIterator<T> mapEntryIterator() {
            return new MapEntryIteratorImpl();
        }

        @Override
        public void clear() {
            Long2ObjectOpenAddressingHashMap.this.clear();
        }
    }

    public final class ValueCollection<V>
    extends AbstractCollection<V> {
        @Override
        public int size() {
            return Long2ObjectOpenAddressingHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return Long2ObjectOpenAddressingHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return Long2ObjectOpenAddressingHashMap.this.containsValue(object);
        }

        @Override
        public ValueIterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public void clear() {
            Long2ObjectOpenAddressingHashMap.this.clear();
        }
    }

    public final class KeySet
    extends AbstractSet<Long> {
        @Override
        public int size() {
            return Long2ObjectOpenAddressingHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return Long2ObjectOpenAddressingHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return Long2ObjectOpenAddressingHashMap.this.containsKey(object);
        }

        public boolean contains(long l) {
            return Long2ObjectOpenAddressingHashMap.this.containsKey(l);
        }

        public KeyIterator iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean remove(Object object) {
            return null != Long2ObjectOpenAddressingHashMap.this.remove(object);
        }

        public boolean remove(long l) {
            return null != Long2ObjectOpenAddressingHashMap.this.remove(l);
        }

        @Override
        public void clear() {
            Long2ObjectOpenAddressingHashMap.this.clear();
        }
    }
}

