/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.collections.fast;

import com.pcbsys.foundation.utils.fUtilities;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class String2ObjectOpenAddressingHashMap<V>
implements Map<String, V> {
    private final double loadFactor;
    private int capacity;
    private int size;
    private int mask;
    private int resizeThreshold;
    private String[] keys;
    private Object[] values;
    private ValueCollection<V> valuesCollection;
    private KeySet keySet;
    private MapEntrySet<V> mapEntrySet;

    public String2ObjectOpenAddressingHashMap() {
        this(8, 0.67);
    }

    public String2ObjectOpenAddressingHashMap(int n, double d) {
        this.loadFactor = d;
        this.capacity = fUtilities.findNextPowerOfTwo(n);
        this.mask = this.capacity - 1;
        this.resizeThreshold = (int)((double)this.capacity * d);
        this.keys = new String[this.capacity];
        this.values = new Object[this.capacity];
    }

    private int hash(String string) {
        int n = string.hashCode();
        return n & this.mask;
    }

    public double getLoadFactor() {
        return this.loadFactor;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getResizeThreshold() {
        return this.resizeThreshold;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.containsKey((String)object);
    }

    public boolean containsKey(String string) {
        int n = this.hash(string);
        while (null != this.values[n]) {
            String string2 = this.keys[n];
            if (string.equals(string2)) {
                return true;
            }
            ++n;
            n &= this.mask;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        for (Object object2 : this.values) {
            if (null == object2 || !object.equals(object2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object object) {
        return this.get((String)object);
    }

    public V get(String string) {
        Object object;
        int n = this.hash(string);
        while (null != (object = this.values[n])) {
            String string2 = this.keys[n];
            if (string.equals(string2)) {
                return (V)object;
            }
            ++n;
            n &= this.mask;
        }
        return null;
    }

    @Override
    public V put(String string, V v) {
        if (null == v) {
            throw new NullPointerException("Value cannot be null");
        }
        Object object = null;
        int n = this.hash(string);
        while (null != this.values[n]) {
            String string2 = this.keys[n];
            if (string.equals(string2)) {
                object = this.values[n];
                break;
            }
            ++n;
            n &= this.mask;
        }
        if (null == object) {
            ++this.size;
            this.keys[n] = string;
        }
        this.values[n] = v;
        if (this.size > this.resizeThreshold) {
            this.resize();
        }
        return (V)object;
    }

    @Override
    public V remove(Object object) {
        return this.remove((String)object);
    }

    public V remove(String string) {
        Object object;
        int n = this.hash(string);
        while (null != (object = this.values[n])) {
            String string2 = this.keys[n];
            if (string.equals(string2)) {
                this.keys[n] = null;
                this.values[n] = null;
                --this.size;
                this.handleDeletion(n);
                return (V)object;
            }
            ++n;
            n &= this.mask;
        }
        return null;
    }

    private void handleDeletion(int n) {
        int n2 = n;
        while (true) {
            ++n2;
            if (null == this.values[n2 &= this.mask]) {
                return;
            }
            int n3 = this.hash(this.keys[n2]);
            if ((n2 >= n3 || n3 > n && n > n2) && (n3 > n || n > n2)) continue;
            this.keys[n] = this.keys[n2];
            this.values[n] = this.values[n2];
            this.keys[n2] = null;
            this.values[n2] = null;
            n = n2;
        }
    }

    private void resize() {
        int n = this.capacity << 1;
        if (n < 0) {
            throw new IllegalStateException("Max capacity reached at size=" + this.size);
        }
        this.capacity = n;
        this.mask = n - 1;
        this.resizeThreshold = (int)((double)n * this.loadFactor);
        String[] stringArray = new String[this.capacity];
        Object[] objectArray = new Object[this.capacity];
        int n2 = this.values.length;
        for (int i = 0; i < n2; ++i) {
            Object object = this.values[i];
            if (null == object) continue;
            String string = this.keys[i];
            int n3 = this.hash(string);
            while (null != objectArray[n3]) {
                ++n3;
                n3 &= this.mask;
            }
            stringArray[n3] = string;
            objectArray[n3] = object;
        }
        this.keys = stringArray;
        this.values = objectArray;
    }

    @Override
    public void clear() {
        this.size = 0;
        int n = this.values.length;
        for (int i = 0; i < n; ++i) {
            this.values[i] = null;
        }
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> map) {
        for (Map.Entry<String, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public KeySet keySet() {
        if (null == this.keySet) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (null == this.valuesCollection) {
            this.valuesCollection = new ValueCollection();
        }
        return this.valuesCollection;
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        if (null == this.mapEntrySet) {
            this.mapEntrySet = new MapEntrySet();
        }
        return this.mapEntrySet;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        for (Map.Entry<String, V> entry : this.entrySet()) {
            stringBuilder.append(entry.getKey());
            stringBuilder.append('=');
            stringBuilder.append(entry.getValue());
            stringBuilder.append(", ");
        }
        if (stringBuilder.length() > 1) {
            stringBuilder.setLength(stringBuilder.length() - 2);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public final class MapEntryIterator<V>
    extends MapIterator<Map.Entry<String, V>>
    implements Map.Entry<String, V> {
        @Override
        public Map.Entry<String, V> next() {
            this.findNext();
            return this;
        }

        @Override
        public String getKey() {
            return String2ObjectOpenAddressingHashMap.this.keys[this.getIndex()];
        }

        @Override
        public V getValue() {
            return (V)String2ObjectOpenAddressingHashMap.this.values[this.getIndex()];
        }

        @Override
        public V setValue(V v) {
            if (null == v) {
                throw new NullPointerException();
            }
            int n = this.getIndex();
            Object object = String2ObjectOpenAddressingHashMap.this.values[n];
            ((String2ObjectOpenAddressingHashMap)String2ObjectOpenAddressingHashMap.this).values[n] = v;
            return (V)object;
        }
    }

    public final class KeyIterator
    extends MapIterator<String> {
        @Override
        public String next() {
            this.findNext();
            return String2ObjectOpenAddressingHashMap.this.keys[this.getIndex()];
        }
    }

    public final class ValueIterator<T>
    extends MapIterator<T> {
        @Override
        public T next() {
            this.findNext();
            return (T)String2ObjectOpenAddressingHashMap.this.values[this.getIndex()];
        }
    }

    private abstract class MapIterator<T>
    implements Iterator<T> {
        private int index;
        private boolean validIndex;

        private MapIterator() {
            this.index = String2ObjectOpenAddressingHashMap.this.capacity;
            this.validIndex = false;
        }

        protected int getIndex() {
            return this.index;
        }

        @Override
        public boolean hasNext() {
            for (int i = this.index - 1; i >= 0; --i) {
                if (null == String2ObjectOpenAddressingHashMap.this.values[i]) continue;
                return true;
            }
            return false;
        }

        protected void findNext() {
            this.validIndex = false;
            for (int i = this.index - 1; i >= 0; --i) {
                if (null == String2ObjectOpenAddressingHashMap.this.values[i]) continue;
                this.index = i;
                this.validIndex = true;
                return;
            }
            throw new NoSuchElementException();
        }

        @Override
        public abstract T next();

        @Override
        public void remove() {
            if (!this.validIndex) {
                throw new IllegalStateException();
            }
            String2ObjectOpenAddressingHashMap.this.remove(String2ObjectOpenAddressingHashMap.this.keys[this.index]);
            this.validIndex = false;
        }
    }

    public final class MapEntrySet<V>
    extends AbstractSet<Map.Entry<String, V>> {
        @Override
        public int size() {
            return String2ObjectOpenAddressingHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return String2ObjectOpenAddressingHashMap.this.isEmpty();
        }

        @Override
        public Iterator<Map.Entry<String, V>> iterator() {
            return new MapEntryIterator();
        }

        @Override
        public void clear() {
            String2ObjectOpenAddressingHashMap.this.clear();
        }
    }

    public final class ValueCollection<V>
    extends AbstractCollection<V> {
        @Override
        public int size() {
            return String2ObjectOpenAddressingHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return String2ObjectOpenAddressingHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return String2ObjectOpenAddressingHashMap.this.containsValue(object);
        }

        @Override
        public ValueIterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public void clear() {
            String2ObjectOpenAddressingHashMap.this.clear();
        }
    }

    public final class KeySet
    extends AbstractSet<String> {
        @Override
        public int size() {
            return String2ObjectOpenAddressingHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return String2ObjectOpenAddressingHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return String2ObjectOpenAddressingHashMap.this.containsKey(object);
        }

        public KeyIterator iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean remove(Object object) {
            return null != String2ObjectOpenAddressingHashMap.this.remove((String)object);
        }

        @Override
        public void clear() {
            String2ObjectOpenAddressingHashMap.this.clear();
        }
    }
}

