/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.collections.multiq;

import com.pcbsys.foundation.collections.Queue;
import com.pcbsys.foundation.collections.fPopStrategy;
import com.pcbsys.foundation.collections.fPutStrategy;
import com.pcbsys.foundation.collections.fQueue;

public abstract class fAbstractMultiQueue<T>
implements fQueue<T> {
    final fQueue[] myQueues;
    private final int myQueueNumber;
    private final int myInitialQueueSize;
    private final fPutStrategy<T> myPutStrategy;
    private final fPopStrategy<T> myPopStrategy;
    private int mySize = 0;

    public fAbstractMultiQueue(int n, int n2) {
        this.myQueueNumber = n;
        this.myInitialQueueSize = n2;
        this.myQueues = new fQueue[n];
        for (int i = 0; i < n; ++i) {
            this.myQueues[i] = new Queue(n2);
        }
        this.myPopStrategy = this.initPopStrategy();
        this.myPutStrategy = this.initPutStrategy();
    }

    protected abstract fPopStrategy<T> initPopStrategy();

    protected abstract fPutStrategy<T> initPutStrategy();

    @Override
    public synchronized void put(T t) {
        if (t == null) {
            return;
        }
        this.myPutStrategy.put(t);
        ++this.mySize;
    }

    @Override
    public synchronized T pop() {
        if (this.mySize == 0) {
            return null;
        }
        T t = this.myPopStrategy.pop();
        --this.mySize;
        return t;
    }

    @Override
    public synchronized T top() {
        return this.myPopStrategy.top();
    }

    @Override
    public int size() {
        return this.mySize;
    }

    public int innerQueueCount() {
        return this.myQueueNumber;
    }

    public int innerQueueSize() {
        return this.myInitialQueueSize;
    }
}

