/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.collections.multiq;

import com.pcbsys.foundation.base.fPrioritized;
import com.pcbsys.foundation.collections.fQueue;
import com.pcbsys.foundation.concurrent.Sequence;
import java.util.concurrent.atomic.AtomicReference;

public class fConcurrentLinkedPriorityQueue
implements fQueue<fPrioritized> {
    private final int myPriorityLevels;
    private final AtomicReference<fLinkedNode>[] myHeads;
    private final AtomicReference<fLinkedNode>[] myTails;
    private fLinkedNode<fPrioritized> myPreviousTop;
    private final Sequence putCount;
    private long pullCount;

    public fConcurrentLinkedPriorityQueue(int n) {
        this.myPriorityLevels = n;
        this.myHeads = new AtomicReference[this.myPriorityLevels];
        this.myTails = new AtomicReference[this.myPriorityLevels];
        this.putCount = new Sequence();
        this.pullCount = 0L;
        for (int i = 0; i < this.myPriorityLevels; ++i) {
            fLinkedNode fLinkedNode2 = new fLinkedNode();
            fLinkedNode2.next = new AtomicReference();
            this.myHeads[i] = new AtomicReference(fLinkedNode2);
            this.myTails[i] = new AtomicReference(fLinkedNode2);
        }
    }

    @Override
    public void put(fPrioritized fPrioritized2) {
        fLinkedNode fLinkedNode2;
        if (fPrioritized2 == null) {
            return;
        }
        fLinkedNode fLinkedNode3 = new fLinkedNode();
        fLinkedNode3.value = fPrioritized2;
        fLinkedNode3.next = new AtomicReference();
        int n = fPrioritized2.getPriority();
        if (n < 0 || n > 9) {
            n = 0;
        }
        while (true) {
            fLinkedNode2 = this.myTails[n].get();
            fLinkedNode fLinkedNode4 = fLinkedNode2.next.get();
            if (fLinkedNode2 != this.myTails[n].get()) continue;
            if (fLinkedNode4 == null) {
                if (!fLinkedNode2.next.compareAndSet(fLinkedNode4, fLinkedNode3)) continue;
                break;
            }
            this.myTails[n].compareAndSet(fLinkedNode2, fLinkedNode4);
        }
        this.myTails[n].compareAndSet(fLinkedNode2, fLinkedNode3);
        this.putCount.incrementAndGet();
    }

    @Override
    public final fPrioritized pop() {
        if (this.myPreviousTop != null) {
            fPrioritized fPrioritized2 = (fPrioritized)this.myPreviousTop.value;
            int n = fPrioritized2.getPriority();
            if (n < 0 || n > 9) {
                n = 0;
            }
            this.myHeads[n].set(this.myPreviousTop);
            this.myPreviousTop = null;
            ++this.pullCount;
            return fPrioritized2;
        }
        for (int i = this.myPriorityLevels - 1; i >= 0; --i) {
            fPrioritized fPrioritized3 = this.pop(i);
            if (fPrioritized3 == null) continue;
            ++this.pullCount;
            return fPrioritized3;
        }
        return null;
    }

    public final fPrioritized pop(int n) {
        fLinkedNode fLinkedNode2;
        while (true) {
            fLinkedNode fLinkedNode3 = this.myHeads[n].get();
            fLinkedNode fLinkedNode4 = this.myTails[n].get();
            fLinkedNode2 = fLinkedNode3.next.get();
            if (fLinkedNode3 != this.myHeads[n].get()) continue;
            if (fLinkedNode3 == fLinkedNode4) {
                if (fLinkedNode2 == null) {
                    return null;
                }
                this.myTails[n].compareAndSet(fLinkedNode4, fLinkedNode2);
                continue;
            }
            if (fLinkedNode2 != null) break;
        }
        this.myHeads[n].set(fLinkedNode2);
        return (fPrioritized)fLinkedNode2.value;
    }

    @Override
    public fPrioritized top() {
        block0: for (int i = this.myPriorityLevels - 1; i >= 0; --i) {
            while (true) {
                fLinkedNode fLinkedNode2 = this.myHeads[i].get();
                fLinkedNode fLinkedNode3 = this.myTails[i].get();
                fLinkedNode fLinkedNode4 = fLinkedNode2.next.get();
                if (fLinkedNode2 != this.myHeads[i].get()) continue;
                if (fLinkedNode2 == fLinkedNode3) {
                    if (fLinkedNode4 == null) continue block0;
                    this.myTails[i].compareAndSet(fLinkedNode3, fLinkedNode4);
                    continue;
                }
                this.myPreviousTop = fLinkedNode4;
                if (this.myPreviousTop != null) break;
            }
            return (fPrioritized)this.myPreviousTop.value;
        }
        return null;
    }

    @Override
    public int size() {
        return (int)(this.putCount.get() - this.pullCount);
    }

    private static final class fLinkedNode<T> {
        T value;
        AtomicReference<fLinkedNode> next;

        private fLinkedNode() {
        }
    }
}

