/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.collections.multiq;

import com.pcbsys.foundation.base.fPrioritized;
import com.pcbsys.foundation.collections.fPopStrategy;
import com.pcbsys.foundation.collections.fPutStrategy;
import com.pcbsys.foundation.collections.fQueue;
import com.pcbsys.foundation.collections.multiq.fAbstractMultiQueue;
import com.pcbsys.foundation.collections.multiq.fConcurrentLinkedPriorityQueue;
import com.pcbsys.foundation.io.fConnectionSettings;

public final class fPriorityQueueFactory {
    public static int sPriorityQueueNumber = 10;
    public static int sPriorityQueueSize = fConnectionSettings.getHWMark();

    private fPriorityQueueFactory() {
    }

    public static fQueue<fPrioritized> createPriorityQueue() {
        return new fConcurrentLinkedPriorityQueue(sPriorityQueueNumber);
    }

    public static fQueue<fPrioritized> createPriorityQueue(int n, int n2) {
        return new fPriorityQueue(n, n2);
    }

    public static class fReversePopStrategy<T>
    implements fPopStrategy<T> {
        private fAbstractMultiQueue myMultiQueue;
        private int currentTop = -1;

        public fReversePopStrategy(fAbstractMultiQueue fAbstractMultiQueue2) {
            this.myMultiQueue = fAbstractMultiQueue2;
        }

        @Override
        public T pop() {
            if (this.currentTop != -1) {
                Object t = this.myMultiQueue.myQueues[this.currentTop].pop();
                this.currentTop = -1;
                return t;
            }
            for (int i = this.myMultiQueue.innerQueueCount() - 1; i >= 0; --i) {
                if (this.myMultiQueue.myQueues[i].size() <= 0) continue;
                return this.myMultiQueue.myQueues[i].pop();
            }
            return null;
        }

        @Override
        public T top() {
            for (int i = this.myMultiQueue.innerQueueCount() - 1; i >= 0; --i) {
                if (this.myMultiQueue.myQueues[i].size() <= 0) continue;
                this.currentTop = i;
                return this.myMultiQueue.myQueues[i].top();
            }
            return null;
        }
    }

    private static class fPriorityPutStrategy<T extends fPrioritized>
    implements fPutStrategy<T> {
        private fAbstractMultiQueue<T> myMultiQueue;

        public fPriorityPutStrategy(fAbstractMultiQueue<T> fAbstractMultiQueue2) {
            this.myMultiQueue = fAbstractMultiQueue2;
        }

        @Override
        public void put(T t) {
            int n = fPriorityPutStrategy.calcQueueNumber(t.getPriority(), this.myMultiQueue.innerQueueCount());
            this.myMultiQueue.myQueues[n].put(t);
        }

        private static int calcQueueNumber(int n, int n2) {
            double d = n * n2;
            return (int)Math.ceil(d / 10.0) - 1;
        }
    }

    private static class fPriorityQueue
    extends fAbstractMultiQueue<fPrioritized> {
        public fPriorityQueue(int n, int n2) {
            super(n, n2);
        }

        @Override
        protected fPopStrategy<fPrioritized> initPopStrategy() {
            return new fReversePopStrategy<fPrioritized>(this);
        }

        @Override
        protected fPutStrategy<fPrioritized> initPutStrategy() {
            return new fPriorityPutStrategy<fPrioritized>(this);
        }
    }
}

