/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.concurrent;

import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.utils.fEnvironment;
import com.pcbsys.foundation.utils.fSystemConfiguration;

public class Constants {
    private static final long DEFAULT_SPIN_COUNT = 1L;
    private static final long DEFAULT_LOCK_WAIT = 500000L;
    public static final long SPIN_COUNT;
    public static final long LOCK_WAIT;
    public static final boolean sEnabled;

    static {
        int n;
        boolean bl = Boolean.parseBoolean(fSystemConfiguration.getProperty("CORE_SPIN", fEnvironment.getCoreSpin()));
        if (bl) {
            n = 8;
            try {
                n = Integer.parseInt(fSystemConfiguration.getProperty("CORE_COUNT", fEnvironment.getCoreCount()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            boolean bl2 = bl = Runtime.getRuntime().availableProcessors() >= n;
            if (!bl) {
                fConstants.logger.log("Environment:> Disabling Spin threads as there is not enough CPU cores detected. To obtain the best low latency result more than " + n + " cores are needed, however if you wish to override this set -DCORE_COUNT=n where n is the desired number of cores");
                System.err.println("Environment:> Disabling Spin threads as there is not enough CPU cores detected. To obtain the best low latency result more than " + n + " cores are needed, however if you wish to override this set -DCORE_COUNT=n where n is the desired number of cores");
            }
        } else {
            fConstants.logger.log("Environment:> Disabling high performance threads due to CORE_SPIN not being set, if low latency is required please set -DCORE_SPIN=true");
            System.err.println("Environment:> Disabling high performance threads due to CORE_SPIN not being set, if low latency is required please set -DCORE_SPIN=true");
        }
        n = 1;
        boolean bl3 = true;
        long l = 1L;
        long l2 = 500000L;
        try {
            l = Long.parseLong(fSystemConfiguration.getProperty("SPIN_COUNT"));
            n = 0;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            l2 = Long.parseLong(fSystemConfiguration.getProperty("SPIN_WAIT"));
            bl3 = false;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (bl) {
            if (n != 0) {
                long l3 = System.nanoTime() + 10000000L;
                long l4 = 0L;
                while (l3 > System.nanoTime()) {
                    ++l4;
                }
                l = l4;
                l3 = System.nanoTime();
                for (int i = 0; i < 1000000; ++i) {
                    l4 = System.nanoTime();
                }
                l3 = l * (System.nanoTime() - l3) / 1000000L;
                l = l3 * 2L;
            }
            if (bl3) {
                l2 = 1L;
            }
        }
        sEnabled = bl;
        LOCK_WAIT = (int)l2;
        SPIN_COUNT = l;
    }
}

