/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.concurrent;

import com.pcbsys.foundation.drivers.jdk.fJDKHelperBase;
import com.pcbsys.foundation.drivers.jdk.fUnSafe;

public final class Sequence {
    private static final fUnSafe unsafe;
    private static final long valueOffset;
    private final long[] array = new long[15];

    public Sequence() {
    }

    public Sequence(long l) {
        this.setOrdered(l);
    }

    public void orderedIncrement(long l) {
        if (unsafe != null) {
            unsafe.putOrderedLong(this.array, valueOffset, this.get() + l);
        } else {
            this.array[0] = this.array[0] + l;
        }
    }

    public long get() {
        if (unsafe != null) {
            return unsafe.getLongVolatile(this.array, valueOffset);
        }
        return this.array[0];
    }

    public void setOrdered(long l) {
        if (unsafe != null) {
            unsafe.putOrderedLong(this.array, valueOffset, l);
        } else {
            this.array[0] = l;
        }
    }

    public boolean compareAndSet(long l, long l2) {
        if (unsafe != null) {
            return unsafe.compareAndSwapLong(this.array, valueOffset, l, l2);
        }
        this.array[0] = l2;
        return true;
    }

    public long incrementAndGet() {
        return this.addAndGet(1L);
    }

    public long decrementAndGet() {
        return this.subAndGet(1L);
    }

    public long getAndIncrement() {
        return this.getAndAdd(1L);
    }

    public long getAndAdd(long l) {
        long l2;
        long l3;
        while (!this.compareAndSet(l3 = this.get(), l2 = l3 + l)) {
        }
        return l3;
    }

    public long addAndGet(long l) {
        long l2;
        long l3;
        while (!this.compareAndSet(l3 = this.get(), l2 = l3 + l)) {
        }
        return l2;
    }

    public long subAndGet(long l) {
        long l2;
        long l3;
        while (!this.compareAndSet(l3 = this.get(), l2 = l3 - l)) {
        }
        return l2;
    }

    public String toString() {
        return Long.toString(this.get());
    }

    static {
        try {
            unsafe = fJDKHelperBase.getUnsafe();
            if (unsafe != null) {
                int n = unsafe.arrayBaseOffset(long[].class);
                int n2 = unsafe.arrayIndexScale(long[].class);
                valueOffset = n + n2 * 7;
            } else {
                valueOffset = 0L;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

