/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.configuration;

import com.pcbsys.foundation.base.fFile;
import com.pcbsys.foundation.configuration.fConfigException;
import com.pcbsys.foundation.configuration.fConfigObject;
import com.pcbsys.foundation.configuration.fConfigurationListener;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fEventInputStream;
import com.pcbsys.foundation.utils.fEnvironment;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class fConfigManager {
    private static ArrayList<fConfigObject> groups = new ArrayList();

    private static fConfigObject find(String string) {
        for (fConfigObject fConfigObject2 : groups) {
            if (!fConfigObject2.getGroupName().equals(string)) continue;
            return fConfigObject2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static fConfigObject getGroup(String string) throws fConfigException {
        fConfigObject fConfigObject2 = fConfigManager.find(string);
        if (fConfigObject2 == null) {
            String string2 = fConfigManager.getDataDir() + File.separator + string + ".cfg";
            if (fFile.exists(string2)) {
                try {
                    fConfigObject fConfigObject3 = new fConfigObject();
                    FileInputStream fileInputStream = fFile.openFileInputStream(string2);
                    fEventInputStream fEventInputStream2 = new fEventInputStream(fileInputStream);
                    try {
                        fConfigObject3.readExternalFromDisk(fEventInputStream2);
                    }
                    finally {
                        fEventInputStream2.close();
                        fileInputStream.close();
                    }
                    groups.add(fConfigObject3);
                    Collections.sort(groups);
                    fConfigObject3.afile = string2;
                    return fConfigObject3;
                }
                catch (Exception exception) {
                    throw new fConfigException(exception.toString(), exception);
                }
            }
            throw new fConfigException("Group : " + string + " is not bound");
        }
        return fConfigObject2;
    }

    public static Iterator<fConfigObject> getGroups() {
        return groups.iterator();
    }

    public static String getDataDir() throws fConfigException {
        return fEnvironment.getDataDir() + File.separator + "RealmSpecific";
    }

    public static fConfigObject createGroup(String string, String string2, boolean bl, boolean bl2) throws fConfigException {
        if (fConfigManager.find(string) != null) {
            throw new fConfigException("Group : " + string + " already bound");
        }
        return new fConfigObject(string, string2, bl, bl2);
    }

    public static void addGroupConfig(String string, String string2, String string3, int n, long l, long l2, boolean bl) throws fConfigException {
        fConfigObject fConfigObject2 = fConfigManager.find(string);
        if (fConfigObject2 == null) {
            throw new fConfigException("Group : " + string + " is not bound");
        }
        fConfigObject2.addKeyValuePair(string2, string3, n, l, l2, bl);
    }

    public static void addGroupConfig(String string, String string2, String string3, String string4, String string5, int n, long l, long l2, boolean bl) throws fConfigException {
        fConfigObject fConfigObject2 = fConfigManager.find(string);
        if (fConfigObject2 == null) {
            throw new fConfigException("Groupv : " + string + " is not bound");
        }
        fConfigObject2.addKeyValuePair(string2, string3, string4, string5, n, l, l2, bl);
    }

    public static void updateGroupConfig(String string, String string2, String string3, boolean bl) throws fConfigException {
        fConfigObject fConfigObject2 = fConfigManager.find(string);
        if (fConfigObject2 == null) {
            throw new fConfigException("Group : " + string + " is not bound");
        }
        if (!fConfigObject2.isReadOnly()) {
            fConfigObject2.changeKeyValuePair(string2, string3, bl);
        }
    }

    public static void persistGroupConfig(String string) throws fConfigException {
        fConfigObject fConfigObject2 = fConfigManager.find(string);
        if (fConfigObject2 == null) {
            throw new fConfigException("Group : " + string + " is not bound");
        }
        fConfigObject2.write();
    }

    public static void updateGroupConfig(fConfigObject fConfigObject2, boolean bl) throws fConfigException {
        fConfigObject fConfigObject3 = fConfigManager.find(fConfigObject2.getGroupName());
        if (fConfigObject3 == null) {
            throw new fConfigException("Group : " + fConfigObject2.getGroupName() + " is not bound");
        }
        fConfigObject3.updateItems(fConfigObject2, bl);
    }

    public static void updateGroup(String string) throws fConfigException {
        fConfigObject fConfigObject2 = fConfigManager.find(string);
        if (fConfigObject2 == null) {
            throw new fConfigException("Group : " + string + " is not bound");
        }
        if (!fConfigObject2.isReadOnly()) {
            fConfigObject2.update(null);
        }
    }

    public static void addConfigListener(String string, fConfigurationListener fConfigurationListener2) throws fConfigException {
        fConfigObject fConfigObject2 = fConfigManager.find(string);
        if (fConfigObject2 == null) {
            throw new fConfigException("Group : " + string + " is not bound");
        }
        fConfigObject2.addListener(fConfigurationListener2);
    }

    public static void removeConfigListener(String string, fConfigurationListener fConfigurationListener2) throws fConfigException {
        fConfigObject fConfigObject2 = fConfigManager.find(string);
        if (fConfigObject2 == null) {
            throw new fConfigException("Group : " + string + " is not bound");
        }
        fConfigObject2.removeListener(fConfigurationListener2);
    }

    protected static void addGroup(String string, fConfigObject fConfigObject2) throws fConfigException {
        if (fConfigManager.find(string) != null) {
            throw new fConfigException("Group : " + string + " already bound");
        }
        groups.add(fConfigObject2);
        Collections.sort(groups);
        fConstants.logger.info("fConfigManager: Config group " + string + " registered itself with config manager.");
    }
}

