/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.configuration;

import com.pcbsys.foundation.base.fBaseTransportObject;
import com.pcbsys.foundation.base.fFile;
import com.pcbsys.foundation.configuration.fConfigException;
import com.pcbsys.foundation.configuration.fConfigManager;
import com.pcbsys.foundation.configuration.fConfigObjectItem;
import com.pcbsys.foundation.configuration.fConfigurationListener;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fEventInputStream;
import com.pcbsys.foundation.io.fEventOutputStream;
import com.pcbsys.foundation.utils.fEnvironment;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class fConfigObject
extends fBaseTransportObject
implements Comparable<fConfigObject> {
    private ArrayList<fConfigObjectItem> myList = new ArrayList();
    private ArrayList<fConfigurationListener> mylisteners = new ArrayList();
    private String mygroup = null;
    private String mydescription = null;
    protected String afile = null;
    private boolean isReadOnly = false;
    private boolean isGlobal = false;
    private boolean waitForWrite = false;
    private boolean writePending = false;
    public static final long fConfig_NO_MIN = Long.MIN_VALUE;
    public static final long fConfig_NO_MAX = Long.MAX_VALUE;
    public static final int fConfig_UNKNONW = -100;
    public static final int fConfig_STRING = 0;
    public static final int fConfig_INT = 1;
    public static final int fConfig_LONG = 2;
    public static final int fConfig_BOOLEAN = 3;
    public static final int fConfig_ENUM = 4;
    public static final int fConfig_RANGE = 5;

    public fConfigObject() {
    }

    public fConfigObject(String string, String string2, boolean bl, boolean bl2) throws fConfigException {
        this.mygroup = string;
        this.mydescription = string2;
        try {
            this.afile = fConfigManager.getDataDir() + File.separator + string + ".cfg";
        }
        catch (fConfigException fConfigException2) {
            this.afile = fEnvironment.getBaseDir() + File.separator + string + ".cfg";
        }
        this.loadOrCreate();
        this.isReadOnly = bl;
        this.isGlobal = bl2;
    }

    private void loadOrCreate() throws fConfigException {
        if (fFile.exists(this.afile) && this.afile.length() > 0) {
            boolean bl = true;
            try {
                FileInputStream fileInputStream = fFile.openFileInputStream(this.afile);
                fEventInputStream fEventInputStream2 = new fEventInputStream(fileInputStream);
                try {
                    this.readExternal(fEventInputStream2);
                }
                catch (Exception exception) {
                    bl = false;
                }
                fEventInputStream2.close();
                fileInputStream.close();
                if (bl) {
                    this.afile = this.afile;
                    fConfigManager.addGroup(this.mygroup, this);
                }
                fFile.delete(new File(this.afile));
                this.loadOrCreate();
            }
            catch (Exception exception) {
                throw new fConfigException(exception.getMessage());
            }
        } else {
            fConfigManager.addGroup(this.mygroup, this);
            this.write();
        }
    }

    public fConfigObjectItem find(String string) {
        for (fConfigObjectItem fConfigObjectItem2 : this.myList) {
            if (!fConfigObjectItem2.getKey().equals(string)) continue;
            return fConfigObjectItem2;
        }
        return null;
    }

    private void add(fConfigObjectItem fConfigObjectItem2) {
        this.myList.add(fConfigObjectItem2);
        Collections.sort(this.myList);
    }

    private boolean remove(String string) {
        for (int i = 0; i < this.myList.size(); ++i) {
            if (!this.myList.get(i).getKey().equals(string)) continue;
            this.myList.remove(i);
            return true;
        }
        return false;
    }

    public String getGroupName() {
        return this.mygroup;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public String getGroupDescription() {
        return this.mydescription;
    }

    public int getSize() {
        return this.myList.size();
    }

    public List<fConfigObjectItem> getObjects() {
        return this.myList;
    }

    public boolean contains(String string) {
        return this.find(string) != null;
    }

    public String toString() {
        return this.getGroupName();
    }

    public void addKeyValuePair(String string, String string2, String string3, String string4, int n, long l, long l2, boolean bl) throws fConfigException {
        fConfigObjectItem fConfigObjectItem2 = this.find(string);
        if (fConfigObjectItem2 == null) {
            this.add(new fConfigObjectItem(string, string2, string3, string4, n, l, l2, bl));
            this.write();
        }
    }

    public void addKeyValuePair(String string, String string2, int n, long l, long l2, boolean bl) throws fConfigException {
        if (this.contains(string)) {
            throw new fConfigException("Key : " + string + " already bound");
        }
        this.add(new fConfigObjectItem(string, string2, null, null, n, l, l2, bl));
        this.write();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeKeyValuePair(String string, String string2, boolean bl, String string3) throws fConfigException {
        this.changeKeyValuePair(string, string2);
        this.write();
        if (bl) {
            fConfigObject fConfigObject2 = this;
            synchronized (fConfigObject2) {
                this.update(string3);
            }
        }
    }

    public void changeKeyDescription(String string, String string2) throws fConfigException {
        fConfigObjectItem fConfigObjectItem2 = this.find(string);
        if (fConfigObjectItem2 == null) {
            throw new fConfigException("Key : " + string + " is not bound");
        }
        if (fConfigObjectItem2.getDescription().equals(string2)) {
            return;
        }
        fConfigObjectItem2.setDescription(string2);
    }

    private void changeKeyValuePair(String string, String string2) throws fConfigException {
        fConfigObjectItem fConfigObjectItem2 = this.find(string);
        if (fConfigObjectItem2 == null) {
            throw new fConfigException("Key : " + string + " is not bound");
        }
        if (fConfigObjectItem2.getValue().equals(string2)) {
            return;
        }
        fConfigObjectItem2.setValue(string2);
    }

    public void changeKeyValuePair(String string, String string2, boolean bl) throws fConfigException {
        this.changeKeyValuePair(string, string2, bl, null);
    }

    public void removeKey(String string) throws fConfigException {
        if (!this.remove(string)) {
            throw new fConfigException("Key : " + string + " is not bound");
        }
    }

    @Override
    public void writeExternal(fEventOutputStream fEventOutputStream2) throws IOException {
        fEventOutputStream2.writeString(this.mygroup);
        fEventOutputStream2.writeString(this.mydescription);
        fEventOutputStream2.writeBoolean(this.isReadOnly);
        fEventOutputStream2.writeBoolean(this.isGlobal);
        fEventOutputStream2.writeInt(this.myList.size());
        for (fConfigObjectItem fConfigObjectItem2 : this.myList) {
            fConfigObjectItem2.writeExternal(fEventOutputStream2);
        }
    }

    private void read(fEventInputStream fEventInputStream2, boolean bl) throws IOException {
        this.mygroup = fEventInputStream2.readString();
        this.mydescription = fEventInputStream2.readString();
        this.isReadOnly = fEventInputStream2.readBoolean();
        this.isGlobal = fEventInputStream2.readBoolean();
        int n = fEventInputStream2.readInt();
        for (int i = 0; i < n; ++i) {
            fConfigObjectItem fConfigObjectItem2 = new fConfigObjectItem();
            if (bl) {
                fConfigObjectItem2.readExternalFromDisk(fEventInputStream2);
            } else {
                fConfigObjectItem2.readExternal(fEventInputStream2);
            }
            this.add(fConfigObjectItem2);
        }
    }

    public void readExternalFromDisk(fEventInputStream fEventInputStream2) throws IOException {
        this.read(fEventInputStream2, true);
    }

    @Override
    public void readExternal(fEventInputStream fEventInputStream2) throws IOException {
        this.read(fEventInputStream2, false);
    }

    protected void addListener(fConfigurationListener fConfigurationListener2) throws fConfigException {
        if (this.mylisteners.contains(fConfigurationListener2)) {
            throw new fConfigException("Listener : " + fConfigurationListener2.getName() + " is already bound");
        }
        this.mylisteners.add(fConfigurationListener2);
    }

    protected void removeListener(fConfigurationListener fConfigurationListener2) throws fConfigException {
        if (!this.mylisteners.contains(fConfigurationListener2)) {
            throw new fConfigException("Listener : " + fConfigurationListener2.getName() + " is not known to group " + this.mygroup);
        }
        this.mylisteners.remove(fConfigurationListener2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateItems(fConfigObject fConfigObject2, boolean bl) throws fConfigException {
        if (this.isReadOnly) {
            return;
        }
        for (fConfigObjectItem fConfigObjectItem2 : fConfigObject2.getObjects()) {
            this.changeKeyValuePair(fConfigObjectItem2.getKey(), fConfigObjectItem2.getValue());
        }
        this.write();
        if (bl) {
            fConfigObject fConfigObject3 = this;
            synchronized (fConfigObject3) {
                this.update(null);
            }
        }
    }

    protected void update(String string) {
        for (fConfigurationListener fConfigurationListener2 : this.mylisteners) {
            fConfigurationListener2.configure(this);
            if (string != null) {
                fConstants.logger.info(string + "Updated configuration for : " + fConfigurationListener2.getName());
                continue;
            }
            fConstants.logger.info("Updated configuration for : " + fConfigurationListener2.getName());
        }
    }

    public void setWaitForWrite(boolean bl) throws fConfigException {
        if (bl != this.waitForWrite) {
            this.waitForWrite = bl;
            if (!bl && this.writePending) {
                this.write();
            }
        }
    }

    synchronized void write() throws fConfigException {
        if (this.waitForWrite) {
            this.writePending = true;
            return;
        }
        if (this.afile != null) {
            this.writePending = false;
            fConstants.logger.log("Writing file update to configuration " + this.mygroup);
            try {
                FileOutputStream fileOutputStream = fFile.openFileOutputStream(this.afile);
                fEventOutputStream fEventOutputStream2 = new fEventOutputStream(fileOutputStream);
                fEventOutputStream2.writeString(this.mygroup);
                fEventOutputStream2.writeString(this.mydescription);
                fEventOutputStream2.writeBoolean(this.isReadOnly);
                fEventOutputStream2.writeBoolean(this.isGlobal);
                fEventOutputStream2.writeInt(this.myList.size());
                for (fConfigObjectItem fConfigObjectItem2 : this.myList) {
                    fConfigObjectItem2.writeExternalToDisk(fEventOutputStream2);
                }
                fEventOutputStream2.flush();
                fEventOutputStream2.close();
                fileOutputStream.close();
            }
            catch (Exception exception) {
                throw new fConfigException(exception.toString());
            }
        }
    }

    @Override
    public int compareTo(fConfigObject fConfigObject2) {
        return this.mygroup.compareTo(fConfigObject2.mygroup);
    }
}

