/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers;

import com.pcbsys.foundation.drivers.fDriver;
import java.io.IOException;
import java.io.InputStream;

public class MonitoredInputStream
extends InputStream {
    private InputStream myIs;
    private fDriver myDriver;

    public MonitoredInputStream(InputStream inputStream, fDriver fDriver2) {
        this.myDriver = fDriver2;
        this.myDriver.setLastRead();
        this.myIs = inputStream;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        this.myDriver.setLastRead();
        int n = this.myIs.read(byArray);
        if (n != -1) {
            this.myDriver.updateReceived(n);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.myDriver.setLastRead();
        int n3 = this.myIs.read(byArray, n, n2);
        if (n3 != -1) {
            this.myDriver.updateReceived(n3);
        }
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        this.myDriver.setLastRead();
        return this.myIs.skip(l);
    }

    @Override
    public int available() throws IOException {
        this.myDriver.setLastRead();
        return this.myIs.available();
    }

    @Override
    public void close() throws IOException {
        this.myDriver.setLastRead();
        this.myIs.close();
    }

    @Override
    public synchronized void mark(int n) {
        this.myDriver.setLastRead();
        this.myIs.mark(n);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.myDriver.setLastRead();
        this.myIs.reset();
    }

    @Override
    public boolean markSupported() {
        this.myDriver.setLastRead();
        return this.myIs.markSupported();
    }

    @Override
    public int read() throws IOException {
        this.myDriver.setLastRead();
        int n = this.myIs.read();
        if (n != -1) {
            this.myDriver.updateReceived(n);
        }
        return n;
    }
}

