/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers;

import com.pcbsys.foundation.drivers.fDriver;
import java.io.IOException;
import java.io.OutputStream;

public class MonitoredOutputStream
extends OutputStream {
    private OutputStream myOs;
    private fDriver myDriver;

    public MonitoredOutputStream(OutputStream outputStream, fDriver fDriver2) {
        this.myDriver = fDriver2;
        this.myDriver.setLastWrite();
        this.myOs = outputStream;
    }

    public OutputStream getBaseOutputStream() {
        return this.myOs;
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.myDriver.setLastWrite();
        this.myOs.write(byArray);
        if (byArray != null) {
            this.myDriver.updateSent(byArray.length);
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.myDriver.setLastWrite();
        this.myOs.write(byArray, n, n2);
        if (byArray != null) {
            this.myDriver.updateSent(n2);
        }
    }

    @Override
    public void flush() throws IOException {
        this.myDriver.setLastWrite();
        this.myOs.flush();
    }

    @Override
    public void close() throws IOException {
        this.myDriver.setLastWrite();
        this.myOs.close();
    }

    @Override
    public void write(int n) throws IOException {
        this.myDriver.setLastWrite();
        this.myOs.write(n);
        this.myDriver.updateSent(1);
    }
}

