/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.configuration;

import com.pcbsys.foundation.drivers.configuration.fBaseDriverConfig;
import com.pcbsys.foundation.drivers.configuration.fCustomHeader;
import com.pcbsys.foundation.drivers.configuration.fPluginConfig;
import com.pcbsys.foundation.io.fEventInputStream;
import com.pcbsys.foundation.io.fEventOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Vector;

public class fHTTPConfig
extends fBaseDriverConfig {
    private Vector<fPluginConfig> plugins = new Vector();
    private Long AjaxLPActiveDelay = 100L;
    private Long AjaxLPIdleDelay = 60000L;
    private ArrayList<fCustomHeader> myCustomHeaders = new ArrayList();
    private String myAllowedOrigins = "*";
    private String[] myAllowedOriginsArray;
    private boolean myAllowedOriginsAll;
    private boolean myAllowCrossOriginCredentials = true;
    private int myMinimumBytesBeforeGZIP = 1000;

    public fHTTPConfig() {
    }

    public fHTTPConfig(String string, String string2, int n) {
        this(string, string2, n, true);
    }

    public fHTTPConfig(String string, String string2, int n, boolean bl) {
        super(string, "nhp", string2, n, bl);
    }

    public Vector<fPluginConfig> getPlugin() {
        return this.plugins;
    }

    public void setPlugin(Vector<fPluginConfig> vector) {
        this.plugins = vector;
    }

    public boolean isHTTP11Enabled() {
        return this.enableHTTP1_1;
    }

    public void setHTTP11Enabled(boolean bl) {
        this.enableHTTP1_1 = bl;
    }

    public boolean isWebSocketEnabled() {
        return this.enableWebSockets;
    }

    public void setWebSocketEnabled(boolean bl) {
        this.enableWebSockets = bl;
    }

    public Long getAjaxLPActiveDelay() {
        return this.AjaxLPActiveDelay;
    }

    public void setAjaxLPActiveDelay(Long l) {
        this.AjaxLPActiveDelay = l;
    }

    public Long getAjaxLPIdleDelay() {
        return this.AjaxLPIdleDelay;
    }

    public void setAjaxLPIdleDelay(Long l) {
        this.AjaxLPIdleDelay = l;
    }

    public String getAllowedOrigins() {
        return this.myAllowedOrigins;
    }

    public String[] getAllowedOriginsAsArray() {
        if (!this.myAllowedOriginsAll && this.myAllowedOrigins != null && this.myAllowedOriginsArray == null) {
            if (this.myAllowedOrigins.trim().equals("*")) {
                this.myAllowedOriginsAll = true;
            } else {
                this.myAllowedOriginsArray = this.myAllowedOrigins.split(",");
                for (int i = 0; i < this.myAllowedOriginsArray.length; ++i) {
                    this.myAllowedOriginsArray[i] = this.myAllowedOriginsArray[i].trim();
                }
            }
        }
        return this.myAllowedOriginsArray;
    }

    public boolean isAllowedAllOrigins() {
        return this.myAllowedOriginsAll;
    }

    public void setAllowedOrigins(String string) {
        this.myAllowedOrigins = string;
        this.myAllowedOriginsArray = null;
        this.myAllowedOriginsAll = false;
    }

    public boolean isAllowCrossOriginCredentials() {
        return this.myAllowCrossOriginCredentials;
    }

    public void setAllowCrossOriginCredentials(boolean bl) {
        this.myAllowCrossOriginCredentials = bl;
    }

    public boolean getEnableGZIP() {
        return this.myEnableGZIP;
    }

    public void setEnableGZIP(boolean bl) {
        this.myEnableGZIP = bl;
    }

    public int getMinimumBytesBeforeGZIP() {
        return this.myMinimumBytesBeforeGZIP;
    }

    public void setMinimumBytesBeforeGZIP(int n) {
        this.myMinimumBytesBeforeGZIP = n;
    }

    public boolean isNativeCometAllowed() {
        return this.nativeCometAllowed;
    }

    public void setNativeCometAllowed(boolean bl) {
        this.nativeCometAllowed = bl;
    }

    public ArrayList<fCustomHeader> getCustomHeaders() {
        return this.myCustomHeaders;
    }

    public void setCustomHeaders(ArrayList<fCustomHeader> arrayList) {
        this.myCustomHeaders = arrayList;
    }

    @Override
    public boolean deepEquals(Object object) {
        if (object instanceof fHTTPConfig) {
            fHTTPConfig fHTTPConfig2 = (fHTTPConfig)object;
            return super.deepEquals(object) && Objects.equals(this.AjaxLPActiveDelay, fHTTPConfig2.AjaxLPActiveDelay) && Objects.equals(this.AjaxLPIdleDelay, fHTTPConfig2.AjaxLPIdleDelay) && Objects.equals(this.myCustomHeaders, fHTTPConfig2.myCustomHeaders) && Objects.equals(this.myAllowedOrigins, fHTTPConfig2.myAllowedOrigins) && Arrays.equals(this.myAllowedOriginsArray, fHTTPConfig2.myAllowedOriginsArray) && this.myAllowedOriginsAll == fHTTPConfig2.myAllowedOriginsAll && this.myAllowCrossOriginCredentials == fHTTPConfig2.myAllowCrossOriginCredentials && this.myMinimumBytesBeforeGZIP == fHTTPConfig2.myMinimumBytesBeforeGZIP;
        }
        return false;
    }

    @Override
    public void writeExternal(fEventOutputStream fEventOutputStream2) throws IOException {
        this.hasExtraConfig = this.myCustomHeaders != null && this.myCustomHeaders.size() != 0;
        this.hasCORSConfig = this.myAllowedOrigins != null && this.myAllowedOrigins.length() > 0;
        super.writeExternal(fEventOutputStream2);
        fEventOutputStream2.writeInt(this.plugins.size());
        for (int i = 0; i < this.plugins.size(); ++i) {
            fPluginConfig object = this.plugins.elementAt(i);
            object.writeExternal(fEventOutputStream2);
        }
        if (this.nativeCometAllowed) {
            fEventOutputStream2.writeLong(this.getAjaxLPActiveDelay());
            fEventOutputStream2.writeLong(this.getAjaxLPIdleDelay());
            fEventOutputStream2.writeString("");
            if (this.hasExtraConfig) {
                fEventOutputStream2.writeInt(this.myCustomHeaders.size());
                for (fCustomHeader fCustomHeader2 : this.myCustomHeaders) {
                    fCustomHeader2.writeExternal(fEventOutputStream2);
                }
            }
            if (this.hasCORSConfig) {
                fEventOutputStream2.writeString(this.myAllowedOrigins);
                fEventOutputStream2.writeBoolean(this.myAllowCrossOriginCredentials);
                fEventOutputStream2.writeInt(0);
            }
            if (this.myEnableGZIP) {
                fEventOutputStream2.writeInt(this.getMinimumBytesBeforeGZIP());
            }
        }
    }

    @Override
    public void readExternal(fEventInputStream fEventInputStream2) throws IOException {
        int n;
        super.readExternal(fEventInputStream2);
        int n2 = fEventInputStream2.readInt();
        for (n = 0; n < n2; ++n) {
            fPluginConfig fPluginConfig2 = new fPluginConfig();
            fPluginConfig2.readExternal(fEventInputStream2);
            this.plugins.addElement(fPluginConfig2);
        }
        if (this.nativeCometAllowed) {
            this.setAjaxLPActiveDelay(fEventInputStream2.readLong());
            this.setAjaxLPIdleDelay(fEventInputStream2.readLong());
            fEventInputStream2.readString();
            if (this.hasExtraConfig) {
                n = fEventInputStream2.readInt();
                for (int i = 0; i < n; ++i) {
                    fCustomHeader fCustomHeader2 = new fCustomHeader();
                    fCustomHeader2.readExternal(fEventInputStream2);
                    this.myCustomHeaders.add(fCustomHeader2);
                }
            }
            if (this.hasCORSConfig) {
                this.myAllowedOrigins = fEventInputStream2.readString();
                this.myAllowCrossOriginCredentials = fEventInputStream2.readBoolean();
                fEventInputStream2.readInt();
            }
            if (this.myEnableGZIP) {
                this.setMinimumBytesBeforeGZIP(fEventInputStream2.readInt());
            }
        }
    }

    @Override
    public void readOldExternal(fEventInputStream fEventInputStream2) throws IOException {
        super.readOldExternal(fEventInputStream2);
        int n = fEventInputStream2.readInt();
        for (int i = 0; i < n; ++i) {
            fPluginConfig fPluginConfig2 = new fPluginConfig();
            fPluginConfig2.readExternal(fEventInputStream2);
            this.plugins.addElement(fPluginConfig2);
        }
    }

    @Override
    public void readOrigExternal(fEventInputStream fEventInputStream2) throws IOException {
        super.readOrigExternal(fEventInputStream2);
        int n = fEventInputStream2.readInt();
        for (int i = 0; i < n; ++i) {
            fPluginConfig fPluginConfig2 = new fPluginConfig();
            fPluginConfig2.readExternal(fEventInputStream2);
            this.plugins.addElement(fPluginConfig2);
        }
    }

    protected fHTTPConfig(String string, String string2, String string3, int n, boolean bl) {
        super(string, string2, string3, n, bl);
    }
}

