/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.configuration;

import com.pcbsys.foundation.drivers.configuration.fDriverConfig;
import com.pcbsys.foundation.io.fEventInputStream;
import com.pcbsys.foundation.io.fEventOutputStream;
import java.io.IOException;
import java.util.Objects;

public class fMulticastConfig
extends fDriverConfig {
    public static final byte sNoSignature = 0;
    public static final byte sCRC32Signature = 1;
    public static final byte sMD5Signature = 2;
    public static final byte sSHASignature = 3;
    public static final byte sNoEncryption = 0;
    public static final byte sAES_128 = 1;
    public static final byte sAES_192 = 2;
    public static final byte sAES_256 = 3;
    public static final byte sAckMode = 0;
    public static final byte sNackMode = 1;
    public static final byte sBroadcast = 2;
    public static final String[] sMode = new String[]{"ACK-Window", "NACK-Window", "Broadcast"};
    public static final String[] sDigestNames = new String[]{"None", "CRC", "MD5", "SHA"};
    public static final String[] sEncryptionType = new String[]{"", "AES", "AES", "AES"};
    public static final int[] sEncryptionLevel = new int[]{0, 128, 192, 256};
    public static final String[] sEncryptionName = new String[]{"None", "AES-128", "AES-192", "AES-256"};
    public static String sEncryptionAESEncryptionPadding = "AES/CBC/PKCS5Padding";
    public static final byte sClusterUse = 1;
    public static final byte sDataGroupUse = 2;
    public static final byte sChannelUse = 4;
    public static final byte sStatusUpdateUse = 8;
    private String myMulticastAddress;
    private int myOutstandingPacketsQueueSize;
    private int myActivePort;
    private int myAckWindowSize;
    private long myClientEstablishmentTimeout;
    private int myServerUnAckedWindowSize;
    private int myRotateEncryptionKeyCount;
    private int myRotateEncryptionKeyTime;
    private int myFlusherInterval;
    private int myKeepAliveInterval;
    private int maxOutstandingPackets;
    private int myPeakTime;
    private int myPeakTimeIntervals;
    private int myPeakTimeDelay;
    private int myPeakTimeThreshold;
    private byte myCRCType;
    private byte myEncryptionLevel;
    private byte myMode;
    private byte myMulticastUse;
    private boolean allowLoopback;
    private String myLocalBindingAdapter;

    public fMulticastConfig() {
        this.setup();
    }

    public fMulticastConfig(String string, String string2, int n) {
        this(string, string2, n, true);
        this.setup();
    }

    public fMulticastConfig(String string, String string2, int n, boolean bl) {
        this(string, "multicast", string2, n, bl);
        this.setup();
    }

    public fMulticastConfig(String string, String string2, String string3, int n, boolean bl) {
        super(string, string2, string3, n, bl);
        this.setup();
    }

    public fMulticastConfig(fMulticastConfig fMulticastConfig2) {
        super(fMulticastConfig2);
        this.myMulticastAddress = fMulticastConfig2.myMulticastAddress;
        this.myOutstandingPacketsQueueSize = fMulticastConfig2.myOutstandingPacketsQueueSize;
        this.myActivePort = fMulticastConfig2.myActivePort;
        this.myAckWindowSize = fMulticastConfig2.myActivePort;
        this.myClientEstablishmentTimeout = fMulticastConfig2.myClientEstablishmentTimeout;
        this.myServerUnAckedWindowSize = fMulticastConfig2.myServerUnAckedWindowSize;
        this.myRotateEncryptionKeyCount = fMulticastConfig2.myRotateEncryptionKeyCount;
        this.myRotateEncryptionKeyTime = fMulticastConfig2.myRotateEncryptionKeyTime;
        this.myFlusherInterval = fMulticastConfig2.myFlusherInterval;
        this.myKeepAliveInterval = fMulticastConfig2.myKeepAliveInterval;
        this.maxOutstandingPackets = fMulticastConfig2.maxOutstandingPackets;
        this.myPeakTime = fMulticastConfig2.myPeakTime;
        this.myPeakTimeDelay = fMulticastConfig2.myPeakTimeDelay;
        this.myPeakTimeIntervals = fMulticastConfig2.myPeakTimeIntervals;
        this.myPeakTimeThreshold = fMulticastConfig2.myPeakTimeThreshold;
        this.myCRCType = fMulticastConfig2.myCRCType;
        this.myEncryptionLevel = fMulticastConfig2.myEncryptionLevel;
        this.myMode = fMulticastConfig2.myMode;
        this.myMulticastUse = fMulticastConfig2.myMulticastUse;
        this.myLocalBindingAdapter = fMulticastConfig2.myLocalBindingAdapter;
        this.allowLoopback = fMulticastConfig2.allowLoopback;
    }

    public void update(fMulticastConfig fMulticastConfig2) {
        this.myOutstandingPacketsQueueSize = fMulticastConfig2.myOutstandingPacketsQueueSize;
        this.myAckWindowSize = fMulticastConfig2.myAckWindowSize;
        this.myClientEstablishmentTimeout = fMulticastConfig2.myClientEstablishmentTimeout;
        this.myServerUnAckedWindowSize = fMulticastConfig2.myServerUnAckedWindowSize;
        this.myRotateEncryptionKeyCount = fMulticastConfig2.myRotateEncryptionKeyCount;
        this.myRotateEncryptionKeyTime = fMulticastConfig2.myRotateEncryptionKeyTime;
        this.myCRCType = fMulticastConfig2.myCRCType;
        this.myEncryptionLevel = fMulticastConfig2.myEncryptionLevel;
        this.myFlusherInterval = fMulticastConfig2.myFlusherInterval;
        this.myKeepAliveInterval = fMulticastConfig2.myKeepAliveInterval;
        this.maxOutstandingPackets = fMulticastConfig2.maxOutstandingPackets;
        this.myPeakTime = fMulticastConfig2.myPeakTime;
        this.myPeakTimeIntervals = fMulticastConfig2.myPeakTimeIntervals;
        this.myPeakTimeDelay = fMulticastConfig2.myPeakTimeDelay;
        this.myPeakTimeThreshold = fMulticastConfig2.myPeakTimeThreshold;
        this.myMulticastUse = fMulticastConfig2.myMulticastUse;
        this.selectorPoolSize = fMulticastConfig2.selectorPoolSize;
        this.myMode = fMulticastConfig2.myMode;
        this.allowLoopback = fMulticastConfig2.allowLoopback;
    }

    public String getMulticastAddress() {
        return this.myMulticastAddress;
    }

    public void setMulticastAddress(String string) {
        this.myMulticastAddress = string;
    }

    public String getBindingAdapter() {
        return this.myAdapter;
    }

    public void setBindingAdapter(String string) {
        this.myAdapter = string;
    }

    public int getPacketSize() {
        return this.myWriteBufferSize;
    }

    public void setPacketSize(int n) {
        this.myWriteBufferSize = n;
    }

    public int getAdapeterBufferSize() {
        return this.myReadBufferSize;
    }

    public void setAdapterBufferSize(int n) {
        this.myReadBufferSize = n;
    }

    public int getFirstPort() {
        return this.myPort;
    }

    public void setFirstPort(int n) {
        this.myPort = n;
    }

    public int getLastPort() {
        return this.myPoolSize;
    }

    public void setLastPort(int n) {
        this.myPoolSize = n;
    }

    public byte getQOS() {
        return (byte)this.myBacklog;
    }

    public void setQOS(byte by) {
        this.myBacklog = by;
    }

    public short getTTL() {
        return (short)this.myAuthTimeOut;
    }

    public void setTTL(short s) {
        this.myAuthTimeOut = s;
    }

    public int getUnAckedWindowSize() {
        return this.myServerUnAckedWindowSize;
    }

    public void setUnAckedWindowSize(int n) {
        this.myServerUnAckedWindowSize = n;
    }

    public int getRotateEncryptionKeyCount() {
        return this.myRotateEncryptionKeyCount;
    }

    public void setRotateEncryptionKeyCount(int n) {
        this.myRotateEncryptionKeyCount = n;
    }

    public int getRotateEncryptionKeyTime() {
        return this.myRotateEncryptionKeyTime;
    }

    public void setRotateEncryptionKeyTime(int n) {
        this.myRotateEncryptionKeyTime = n;
    }

    public byte getSignatureType() {
        return this.myCRCType;
    }

    public void setSignatureType(byte by) {
        if (by < sDigestNames.length && by >= 0) {
            this.myCRCType = by;
        }
    }

    public byte getMode() {
        return this.myMode;
    }

    public void setMode(byte by) {
        this.myMode = by;
    }

    public boolean enableCompression() {
        return this.enableWebSockets;
    }

    public void setEnableCompression(boolean bl) {
        this.enableWebSockets = bl;
    }

    public byte getEncryptionLevel() {
        return this.myEncryptionLevel;
    }

    public void setsEncryptionLevel(byte by) {
        if (by < sEncryptionType.length && by >= 0) {
            this.myEncryptionLevel = by;
        }
    }

    public void setUniqueSessionIdSize(int n) {
        this.selectorPoolSize = n;
    }

    public int getUniqueSessionIdSize() {
        return this.selectorPoolSize;
    }

    public int getFlushInterval() {
        return this.myFlusherInterval;
    }

    public void setFlushInterval(int n) {
        this.myFlusherInterval = n;
    }

    public int getOutstandingPacketsQueueSize() {
        return this.myOutstandingPacketsQueueSize;
    }

    public void setOutstandingPacketsQueueSize(int n) {
        this.myOutstandingPacketsQueueSize = n;
    }

    public boolean enableEncryption() {
        return this.allowNIO;
    }

    public void setEnableEncryption(boolean bl) {
        this.allowNIO = bl;
    }

    public int getKeepAliveTime() {
        return this.myKeepAliveInterval;
    }

    public void setKeepAliveTime(int n) {
        this.myKeepAliveInterval = n;
    }

    public int getActivePort() {
        return this.myActivePort;
    }

    public void setActivePort(int n) {
        this.myActivePort = n;
    }

    public int getMaxOutstandingPackets() {
        return this.maxOutstandingPackets;
    }

    public void setMaxOutstandingPackets(int n) {
        this.maxOutstandingPackets = n;
    }

    public int getPeakTime() {
        return this.myPeakTime;
    }

    public void setPeakTime(int n) {
        this.myPeakTime = n;
    }

    public int getPeakTimeIntervals() {
        return this.myPeakTimeIntervals;
    }

    public void setPeakTimeIntervals(int n) {
        this.myPeakTimeIntervals = n;
    }

    public int getPeakTimeDelay() {
        return this.myPeakTimeDelay;
    }

    public void setPeakTimeDelay(int n) {
        this.myPeakTimeDelay = n;
    }

    public int getPeakTimeThreshold() {
        return this.myPeakTimeThreshold;
    }

    public void setPeakTimeThreshold(int n) {
        this.myPeakTimeThreshold = n;
    }

    public void setAckWindowSize(int n) {
        this.myAckWindowSize = n;
    }

    public int getAckWindowSize() {
        return this.myAckWindowSize;
    }

    public void setMulticastUse(byte by) {
        this.myMulticastUse = by;
    }

    public byte getMulticastUse() {
        return this.myMulticastUse;
    }

    public long getClientEstablishmentTimeout() {
        return this.myClientEstablishmentTimeout;
    }

    public void setClientEstablishmentTimeout(long l) {
        this.myClientEstablishmentTimeout = l;
    }

    public String getLocalBindingAdapter() {
        return this.myLocalBindingAdapter;
    }

    public void setLocalBindingAdapter(String string) {
        this.myLocalBindingAdapter = string;
    }

    public boolean isAllowLoopback() {
        return this.allowLoopback;
    }

    public void setAllowLoopback(boolean bl) {
        this.allowLoopback = bl;
    }

    private void setup() {
        this.myWriteBufferSize = 1450;
        this.myReadBufferSize = this.myWriteBufferSize * 100000;
        this.myMode = 0;
        this.myPort = 1;
        this.myPoolSize = 65000;
        this.myBacklog = 16;
        this.myAuthTimeOut = 255;
        this.enableWebSockets = false;
        this.selectorPoolSize = 32;
        this.myClientEstablishmentTimeout = 60000L;
        this.myServerUnAckedWindowSize = 9000;
        this.myRotateEncryptionKeyCount = 5000;
        this.myRotateEncryptionKeyTime = 600000;
        this.myCRCType = 0;
        this.myFlusherInterval = 10;
        this.myKeepAliveInterval = 1000;
        this.myPeakTime = 100;
        this.myPeakTimeIntervals = 10;
        this.myPeakTimeDelay = 1000;
        this.myPeakTimeThreshold = 100;
        this.myActivePort = -1;
        this.myOutstandingPacketsQueueSize = 20000;
        this.maxOutstandingPackets = 20000;
        this.myAckWindowSize = 500;
        this.myMulticastUse = 0;
        this.myLocalBindingAdapter = "";
        this.allowLoopback = false;
    }

    @Override
    public boolean deepEquals(Object object) {
        if (object instanceof fMulticastConfig) {
            fMulticastConfig fMulticastConfig2 = (fMulticastConfig)object;
            return super.deepEquals(object) && this.myOutstandingPacketsQueueSize == fMulticastConfig2.myOutstandingPacketsQueueSize && this.myActivePort == fMulticastConfig2.myActivePort && this.myAckWindowSize == fMulticastConfig2.myAckWindowSize && this.myClientEstablishmentTimeout == fMulticastConfig2.myClientEstablishmentTimeout && this.myServerUnAckedWindowSize == fMulticastConfig2.myServerUnAckedWindowSize && this.myRotateEncryptionKeyCount == fMulticastConfig2.myRotateEncryptionKeyCount && this.myRotateEncryptionKeyTime == fMulticastConfig2.myRotateEncryptionKeyTime && this.myFlusherInterval == fMulticastConfig2.myFlusherInterval && this.myKeepAliveInterval == fMulticastConfig2.myKeepAliveInterval && this.maxOutstandingPackets == fMulticastConfig2.maxOutstandingPackets && this.myPeakTime == fMulticastConfig2.myPeakTime && this.myPeakTimeIntervals == fMulticastConfig2.myPeakTimeIntervals && this.myPeakTimeDelay == fMulticastConfig2.myPeakTimeDelay && this.myPeakTimeThreshold == fMulticastConfig2.myPeakTimeThreshold && this.myCRCType == fMulticastConfig2.myCRCType && this.myEncryptionLevel == fMulticastConfig2.myEncryptionLevel && this.myMode == fMulticastConfig2.myMode && this.myMulticastUse == fMulticastConfig2.myMulticastUse && this.allowLoopback == fMulticastConfig2.allowLoopback && Objects.equals(this.myLocalBindingAdapter, fMulticastConfig2.myLocalBindingAdapter) && Objects.equals(this.myMulticastAddress, fMulticastConfig2.myMulticastAddress);
        }
        return false;
    }

    public String toString() {
        return "Multicast Address : " + this.myMulticastAddress + " Bound to physical : " + this.myAdapter + " Is for Cluster: " + ((this.myMulticastUse & 1) != 0) + " Is for DataGroups: " + ((this.myMulticastUse & 2) != 0) + " Is for Channel: " + ((this.myMulticastUse & 4) != 0);
    }

    @Override
    public void readExternal(fEventInputStream fEventInputStream2) throws IOException {
        super.readExternal(fEventInputStream2);
        this.myMulticastAddress = fEventInputStream2.readString();
        this.myServerUnAckedWindowSize = fEventInputStream2.readInt();
        this.myRotateEncryptionKeyCount = fEventInputStream2.readInt();
        this.myRotateEncryptionKeyTime = fEventInputStream2.readInt();
        this.myCRCType = fEventInputStream2.readByte();
        this.myMode = (byte)(this.myCRCType >> 4);
        this.myCRCType = (byte)(this.myCRCType & 0xF);
        this.myEncryptionLevel = fEventInputStream2.readByte();
        this.myFlusherInterval = fEventInputStream2.readInt();
        this.myKeepAliveInterval = fEventInputStream2.readInt();
        this.myPeakTime = fEventInputStream2.readInt();
        this.myPeakTimeIntervals = fEventInputStream2.readInt();
        this.myPeakTimeDelay = fEventInputStream2.readInt();
        this.myPeakTimeThreshold = fEventInputStream2.readInt();
        this.myOutstandingPacketsQueueSize = fEventInputStream2.readInt();
        this.myActivePort = fEventInputStream2.readInt();
        this.maxOutstandingPackets = fEventInputStream2.readInt();
        this.myAckWindowSize = fEventInputStream2.readInt();
        this.myMulticastUse = fEventInputStream2.readByte();
        if ((this.myMulticastUse & 0x80) != 0) {
            this.myMulticastUse = (byte)(this.myMulticastUse & 0x7F);
            this.allowLoopback = true;
        }
        this.myClientEstablishmentTimeout = fEventInputStream2.readLong();
        int n = 16;
        if (fEventInputStream2.readBoolean()) {
            n = 4;
        }
        for (int i = 0; i < n; ++i) {
            fEventInputStream2.readByte();
        }
    }

    @Override
    public void writeExternal(fEventOutputStream fEventOutputStream2) throws IOException {
        super.writeExternal(fEventOutputStream2);
        fEventOutputStream2.writeString(this.myMulticastAddress);
        fEventOutputStream2.writeInt(this.myServerUnAckedWindowSize);
        fEventOutputStream2.writeInt(this.myRotateEncryptionKeyCount);
        fEventOutputStream2.writeInt(this.myRotateEncryptionKeyTime);
        byte by = this.myCRCType;
        by = (byte)(this.myMode << 4 | by);
        fEventOutputStream2.writeByte(by);
        fEventOutputStream2.writeByte(this.myEncryptionLevel);
        fEventOutputStream2.writeInt(this.myFlusherInterval);
        fEventOutputStream2.writeInt(this.myKeepAliveInterval);
        fEventOutputStream2.writeInt(this.myPeakTime);
        fEventOutputStream2.writeInt(this.myPeakTimeIntervals);
        fEventOutputStream2.writeInt(this.myPeakTimeDelay);
        fEventOutputStream2.writeInt(this.myPeakTimeThreshold);
        fEventOutputStream2.writeInt(this.myOutstandingPacketsQueueSize);
        fEventOutputStream2.writeInt(this.myActivePort);
        fEventOutputStream2.writeInt(this.maxOutstandingPackets);
        fEventOutputStream2.writeInt(this.myAckWindowSize);
        byte by2 = this.myMulticastUse;
        if (this.allowLoopback) {
            by2 = (byte)(this.myMulticastUse | 0x80);
        }
        fEventOutputStream2.writeByte(by2);
        fEventOutputStream2.writeLong(this.myClientEstablishmentTimeout);
        fEventOutputStream2.writeBoolean(true);
        fEventOutputStream2.writeByte((byte)0);
        fEventOutputStream2.writeByte((byte)0);
        fEventOutputStream2.writeByte((byte)0);
        fEventOutputStream2.writeByte((byte)0);
    }

    public fMulticastConfig getClone() {
        fMulticastConfig fMulticastConfig2 = new fMulticastConfig();
        fMulticastConfig2.myMulticastAddress = this.myMulticastAddress;
        fMulticastConfig2.myServerUnAckedWindowSize = this.myServerUnAckedWindowSize;
        fMulticastConfig2.myRotateEncryptionKeyCount = this.myRotateEncryptionKeyCount;
        fMulticastConfig2.myRotateEncryptionKeyTime = this.myRotateEncryptionKeyTime;
        fMulticastConfig2.myCRCType = this.myCRCType;
        fMulticastConfig2.myEncryptionLevel = this.myEncryptionLevel;
        fMulticastConfig2.myFlusherInterval = this.myFlusherInterval;
        fMulticastConfig2.myKeepAliveInterval = this.myKeepAliveInterval;
        fMulticastConfig2.myPeakTime = this.myPeakTime;
        fMulticastConfig2.myPeakTimeIntervals = this.myPeakTimeIntervals;
        fMulticastConfig2.myPeakTimeDelay = this.myPeakTimeDelay;
        fMulticastConfig2.myPeakTimeThreshold = this.myPeakTimeThreshold;
        fMulticastConfig2.myOutstandingPacketsQueueSize = this.myOutstandingPacketsQueueSize;
        fMulticastConfig2.myActivePort = this.myActivePort;
        fMulticastConfig2.maxOutstandingPackets = this.maxOutstandingPackets;
        fMulticastConfig2.myAckWindowSize = this.myAckWindowSize;
        fMulticastConfig2.myMulticastUse = this.myMulticastUse;
        fMulticastConfig2.myClientEstablishmentTimeout = this.myClientEstablishmentTimeout;
        fMulticastConfig2.myMode = this.myMode;
        fMulticastConfig2.myAdapter = this.myAdapter;
        fMulticastConfig2.myWriteBufferSize = this.myWriteBufferSize;
        fMulticastConfig2.myReadBufferSize = this.myReadBufferSize;
        fMulticastConfig2.myPort = this.myPort;
        fMulticastConfig2.myPoolSize = this.myPoolSize;
        fMulticastConfig2.myBacklog = this.myBacklog;
        fMulticastConfig2.myAuthTimeOut = this.myAuthTimeOut;
        fMulticastConfig2.enableWebSockets = this.enableWebSockets;
        fMulticastConfig2.selectorPoolSize = this.selectorPoolSize;
        fMulticastConfig2.allowNIO = this.allowNIO;
        fMulticastConfig2.myName = this.myName;
        fMulticastConfig2.myAutoStart = this.myAutoStart;
        fMulticastConfig2.myProtocol = this.myProtocol;
        fMulticastConfig2.myAdvertise = this.myAdvertise;
        fMulticastConfig2.myPort = this.myPort;
        fMulticastConfig2.myPoolSize = this.myPoolSize;
        fMulticastConfig2.myAdapterAlias = this.myAdapterAlias;
        fMulticastConfig2.allowClientConnections = this.allowClientConnections;
        fMulticastConfig2.allowInterRealm = this.allowInterRealm;
        fMulticastConfig2.hasExtraConfig = this.hasExtraConfig;
        fMulticastConfig2.selectorPoolSize = this.selectorPoolSize;
        fMulticastConfig2.enablePolicyServer = this.enablePolicyServer;
        fMulticastConfig2.enableHTTP1_1 = this.enableHTTP1_1;
        fMulticastConfig2.nativeCometAllowed = this.nativeCometAllowed;
        fMulticastConfig2.allowLoopback = this.allowLoopback;
        return fMulticastConfig2;
    }
}

