/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers;

import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.security.fConnectionValidator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.SocketAddress;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.util.Set;

public class fCRLHandler
implements fConnectionValidator {
    private File myCRLFile;
    private X509CRL myCRL;
    private long myLoadTime;
    private long mySize;

    public fCRLHandler(String string) throws Exception {
        if (string.length() > 0) {
            this.myCRLFile = new File(string);
            if (this.myCRLFile.exists()) {
                this.loadCRL();
            } else {
                fConstants.logger.log("CRL file " + string + " could not be located");
                throw new IOException("CRL File not found " + string);
            }
        }
    }

    protected void loadCRL() throws Exception {
        if (this.myLoadTime != this.myCRLFile.lastModified() || this.mySize != this.myCRLFile.length()) {
            this.myLoadTime = this.myCRLFile.lastModified();
            this.mySize = this.myCRLFile.length();
            if (this.myCRLFile.length() > 0L) {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                try (FileInputStream fileInputStream = new FileInputStream(this.myCRLFile);){
                    this.myCRL = (X509CRL)certificateFactory.generateCRL(fileInputStream);
                }
                Set<? extends X509CRLEntry> set = this.myCRL.getRevokedCertificates();
                if (set != null) {
                    fConstants.logger.log("Loaded " + this.myCRL.getRevokedCertificates().size() + " revoked certificates from " + this.myCRLFile.getName());
                } else {
                    fConstants.logger.log("Certificate revocation list is empty");
                }
                this.displayCRL();
            } else {
                fConstants.logger.log("Certificate revocation list is empty");
                this.myCRL = null;
            }
        }
    }

    protected void displayCRL() {
        fConstants.logger.info("---CRL---");
        fConstants.logger.info("type = " + this.myCRL.getType());
        fConstants.logger.info("version = " + this.myCRL.getVersion());
        fConstants.logger.info("issuer = " + this.myCRL.getIssuerDN().getName());
        fConstants.logger.info("signing algorithm = " + this.myCRL.getSigAlgName());
        fConstants.logger.info("signing OID = " + this.myCRL.getSigAlgOID());
        fConstants.logger.info("this update = " + this.myCRL.getThisUpdate());
        fConstants.logger.info("next update = " + this.myCRL.getNextUpdate());
        fConstants.logger.info("---Entries---");
        Set<? extends X509CRLEntry> set = this.myCRL.getRevokedCertificates();
        if (set != null && !set.isEmpty()) {
            for (X509CRLEntry x509CRLEntry : set) {
                fConstants.logger.info("serial number = " + x509CRLEntry.getSerialNumber());
                fConstants.logger.info("revocation date = " + x509CRLEntry.getRevocationDate());
                fConstants.logger.info("extensions = " + x509CRLEntry.hasExtensions());
            }
        }
    }

    public boolean isValid(SocketAddress socketAddress, Certificate[] certificateArray) {
        try {
            this.loadCRL();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.myCRL == null) {
            return true;
        }
        for (int i = 0; i < certificateArray.length; ++i) {
            if (!this.myCRL.isRevoked(certificateArray[i])) continue;
            fConstants.logger.info("Certificate [" + i + "] validation requested for " + certificateArray[i].toString() + " from " + socketAddress.toString() + " has been revoked");
            return false;
        }
        return true;
    }

    @Override
    public boolean isValid(String string, SocketAddress socketAddress, Certificate[] certificateArray) {
        return this.isValid(socketAddress, certificateArray);
    }
}

