/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers;

import com.pcbsys.foundation.base.fBaseObject;
import com.pcbsys.foundation.base.fExternalable;
import com.pcbsys.foundation.collections.SortedObject;
import com.pcbsys.foundation.io.fEventInputStream;
import com.pcbsys.foundation.io.fEventOutputStream;
import com.pcbsys.foundation.logger.fLogger;
import com.pcbsys.foundation.utils.StringUtils;
import com.pcbsys.foundation.utils.fEnvironment;
import com.pcbsys.foundation.utils.fSystemConfiguration;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;

public class fConnectionDetails
extends fBaseObject
implements SortedObject,
fExternalable {
    public static final boolean sAllowBandwidthMonitoring = Boolean.parseBoolean(fSystemConfiguration.getProperty("EnableBandwidthMonitoring", "false"));
    public static boolean sEnableConnectionDebug = fEnvironment.isDebugEnabled("comms");
    public static final int s_nsp = 0;
    public static final int s_nhp = 1;
    public static final int s_nsps = 2;
    public static final int s_nhps = 3;
    public static final int s_nrsp = 4;
    public static final int s_nrsps = 5;
    public static final int s_loop = 6;
    public static final int s_amqp = 7;
    public static final int s_raw = 8;
    public static final int s_comet = 9;
    public static final int s_lp = 10;
    public static final int s_mqtt = 11;
    public static final int s_shm = 12;
    public static final int s_rdma = 13;
    public static final int s_mlt = 14;
    public static final int s_stomp = 15;
    public static final int s_xmpp = 16;
    public static final int s_ProtocolEnd = 17;
    public static boolean sEnableReverseDNSLookups = true;
    private static String[] sProtocolStrings = new String[]{"nsp", "nhp", "nsps", "nhps", "nrsp", "nrsps", "loop", "amqp", "raw", "comet", "lp", "mqtt", "shm", "rdma", "mlt", "stomp", "xmpp"};
    private static int[] sConnectionWeights = new int[]{100, 200, 20, 80, 10, 12, 1000, 1010, 1020, 1040, 1041, 1042, 10000, 20000, 30000, 40000, 50000};
    private int myType;
    private String myHost;
    private int myPort;
    private String myFile;
    private int myWeight;
    private String myVirtualName;
    private boolean connect;
    private boolean interRealmComms;
    private boolean advertise;
    private boolean canClientsConnect;

    public fConnectionDetails() {
    }

    public fConnectionDetails(String string) throws IOException {
        this.parseUrl(string);
        this.myWeight = sConnectionWeights[this.myType];
    }

    public fConnectionDetails(int n, String string, int n2, String string2) {
        this.myType = n;
        this.myHost = string;
        this.myPort = n2;
        this.myFile = string2 != null ? string2 : "";
        this.myWeight = sConnectionWeights[n];
        this.connect = false;
    }

    public int getType() {
        return this.myType;
    }

    public String getHost() {
        return this.myHost;
    }

    public int getPort() {
        return this.myPort;
    }

    public String getFile() {
        return this.myFile;
    }

    public int getWeight() {
        return this.myWeight;
    }

    public boolean useConnect() {
        return this.connect;
    }

    public boolean getAllowForInterRealm() {
        return this.interRealmComms;
    }

    public void setAllowForInterRealm(boolean bl) {
        this.interRealmComms = bl;
    }

    public boolean getAdvertise() {
        return this.advertise;
    }

    public void setAdvertise(boolean bl) {
        this.advertise = bl;
    }

    public boolean getClientConnectFlag() {
        return this.canClientsConnect;
    }

    public void setClientConnectFlag(boolean bl) {
        this.canClientsConnect = bl;
    }

    public String toString() {
        String string = fConnectionDetails.getProtocolString(this.myType);
        if (this.connect) {
            string = string + "c";
        }
        if (this.myFile == null) {
            this.myFile = "";
        }
        if (this.myType == 12) {
            return string + "://" + this.myHost + this.myFile;
        }
        return fConnectionDetails.getURL(string, this.myHost, this.myPort, this.myFile);
    }

    public static String getProtocolString(int n) {
        return sProtocolStrings[n];
    }

    public static int getProtocolType(String string) throws IOException {
        for (int i = 0; i < sProtocolStrings.length; ++i) {
            if (!sProtocolStrings[i].equalsIgnoreCase(string)) continue;
            return i;
        }
        throw new IOException("Unknown protocol");
    }

    public static String getURL(String string, String string2, int n, String string3) {
        try {
            URI uRI = new URI(string, null, string2, n, string3, null, null);
            return uRI.toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            fLogger.log.report(3, uRISyntaxException);
            fLogger.log.report(3, "type :" + string + " myHost: " + string2 + " myPort: " + n + " myFile: " + string3);
            return string + "://" + string2 + ":" + n + string3;
        }
    }

    public boolean isVirtual() {
        return this.myVirtualName != null;
    }

    public String getVirtualName() {
        return this.myVirtualName;
    }

    public void setVirtualName(String string) {
        this.myVirtualName = string;
    }

    private void parseUrl(String string) throws IOException {
        URI uRI;
        try {
            if (string.startsWith("shm")) {
                string = string.replace("\\", "/");
            }
            uRI = URI.create(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException("No protocol supplied", illegalArgumentException);
        }
        if (uRI.getScheme() != null && uRI.getScheme().startsWith(sProtocolStrings[3]) && uRI.getScheme().endsWith("c")) {
            this.connect = true;
            this.myType = 3;
        } else {
            this.connect = false;
            this.myType = fConnectionDetails.getProtocolType(uRI.getScheme());
        }
        if (this.myType == 12) {
            try {
                this.myFile = this.parseSHMPath(string.substring(6)).split("\\?")[0];
                this.myHost = "";
            }
            catch (Exception exception) {
                throw new IOException(exception);
            }
        } else {
            this.myHost = uRI.getHost();
            if (this.myHost == null) {
                throw new IOException("No host supplied");
            }
            this.myHost = StringUtils.strip(uRI.getHost(), '[', ']');
            this.myPort = uRI.getPort() == -1 ? this.getDefaultPort(this.myType) : uRI.getPort();
            this.myFile = uRI.getPath();
            if (this.myFile == null) {
                this.myFile = "";
            }
            if (uRI.getQuery() != null) {
                String[] stringArray;
                String string2 = uRI.getQuery();
                for (String string3 : stringArray = string2.split("&")) {
                    String[] stringArray2 = string3.split("=");
                    if (string3.equalsIgnoreCase("inter=true")) {
                        this.interRealmComms = true;
                        continue;
                    }
                    if (!stringArray2[0].trim().equalsIgnoreCase("virtualrealm")) continue;
                    this.myVirtualName = stringArray2[1].trim();
                }
            }
        }
    }

    private int getDefaultPort(int n) {
        switch (n) {
            case 0: {
                return 9000;
            }
            case 1: {
                return 80;
            }
            case 2: {
                return 9443;
            }
            case 3: {
                return 443;
            }
            case 13: {
                return 9100;
            }
        }
        return -1;
    }

    private String parseSHMPath(String string) {
        if (string.startsWith("/")) {
            return string;
        }
        if (!string.contains(":")) {
            String[] stringArray = string.split("/", 2);
            return "/" + stringArray[1];
        }
        if (Pattern.matches("[a-zA-Z]:.*", string)) {
            return string;
        }
        throw new IllegalArgumentException("Invalid path : " + string);
    }

    @Override
    public boolean equals(long l) {
        return (long)this.myWeight == l;
    }

    @Override
    public boolean lessThan(long l) {
        return (long)this.myWeight < l;
    }

    @Override
    public boolean lessThan(Object object) {
        return this.compare(object) > 0;
    }

    public boolean isMatch(Object object) {
        return this.compare(object) == 0;
    }

    public boolean equals(Object object) {
        return this.isMatch(object);
    }

    public int hashCode() {
        return this.myWeight;
    }

    private int compare(Object object) {
        if (object instanceof fConnectionDetails) {
            fConnectionDetails fConnectionDetails2 = (fConnectionDetails)object;
            return fConnectionDetails2.myWeight - this.myWeight;
        }
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            return n - this.myWeight;
        }
        return 1;
    }

    public int getSize() {
        int n = 4;
        n += 4;
        n += 4;
        n += 4 + this.myHost.length();
        n += 4;
        if (this.myFile != null) {
            n += this.myFile.length();
        }
        return n;
    }

    @Override
    public void writeExternal(fEventOutputStream fEventOutputStream2) throws IOException {
        fEventOutputStream2.writeInt(this.myType);
        fEventOutputStream2.writeInt(this.myPort);
        fEventOutputStream2.writeInt(this.myWeight);
        fEventOutputStream2.writeString(this.myHost);
        fEventOutputStream2.writeString(this.myFile);
        byte by = 0;
        if (this.connect) {
            by = (byte)(by + 2);
        }
        if (this.interRealmComms) {
            by = (byte)(by + 4);
        }
        if (this.advertise) {
            by = (byte)(by + 8);
        }
        if (this.canClientsConnect) {
            by = (byte)(by + 16);
        }
        fEventOutputStream2.writeByte(by);
    }

    @Override
    public void readExternal(fEventInputStream fEventInputStream2) throws IOException {
        byte by;
        this.myType = fEventInputStream2.readInt();
        this.myPort = fEventInputStream2.readInt();
        this.myWeight = fEventInputStream2.readInt();
        this.myHost = fEventInputStream2.readString();
        this.myFile = fEventInputStream2.readString();
        if (this.myFile == null) {
            this.myFile = "";
        }
        this.connect = ((by = fEventInputStream2.readByte()) & 2) != 0;
        this.interRealmComms = (by & 4) != 0;
        this.advertise = (by & 8) != 0;
        this.canClientsConnect = (by & 0x10) != 0;
    }
}

