/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers;

import com.pcbsys.foundation.drivers.jdk.fNSSHelper;
import com.pcbsys.foundation.fConstants;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class fCustomNSSSocketFactory
extends SSLSocketFactory {
    private final SSLSocketFactory sslFact;
    private final String[] enabledCiphers;
    private static final String keyStoreType = "PKCS11";

    public fCustomNSSSocketFactory(String string, String string2, String string3, String string4, String[] stringArray) throws ProviderException, CertificateException, UnrecoverableKeyException, NoSuchAlgorithmException, IOException, KeyManagementException, KeyStoreException {
        try {
            fNSSHelper.loadPKCS11NSSFIPSProvider(string2, string3);
            this.sslFact = this.createCustomNSSSocketFactory(string, string4);
            this.enabledCiphers = stringArray;
        }
        catch (Exception exception) {
            if (exception instanceof CertificateException) {
                throw (CertificateException)exception;
            }
            if (exception instanceof UnrecoverableKeyException) {
                throw (UnrecoverableKeyException)exception;
            }
            if (exception instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)exception;
            }
            if (exception instanceof KeyManagementException) {
                throw (KeyManagementException)exception;
            }
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            IOException iOException = new IOException(exception.getMessage());
            iOException.initCause(exception);
            throw iOException;
        }
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.sslFact.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sslFact.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException {
        Socket socket2 = this.sslFact.createSocket(socket, string, n, bl);
        this.setEnabledCipherSuites(socket2);
        return socket2;
    }

    @Override
    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        Socket socket = this.sslFact.createSocket(string, n);
        this.setEnabledCipherSuites(socket);
        return socket;
    }

    @Override
    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        Socket socket = this.sslFact.createSocket(string, n, inetAddress, n2);
        this.setEnabledCipherSuites(socket);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        Socket socket = this.sslFact.createSocket(inetAddress, n);
        this.setEnabledCipherSuites(socket);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        Socket socket = this.sslFact.createSocket(inetAddress, n, inetAddress2, n2);
        this.setEnabledCipherSuites(socket);
        return socket;
    }

    @Override
    public Socket createSocket() throws IOException {
        Socket socket = this.sslFact.createSocket();
        this.setEnabledCipherSuites(socket);
        return socket;
    }

    private void setEnabledCipherSuites(Socket socket) throws IOException {
        try {
            if (this.enabledCiphers != null) {
                ((SSLSocket)socket).setEnabledCipherSuites(this.enabledCiphers);
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Error setting cipher suite on socket");
            iOException.initCause(new SSLException("Could not set cipher suite - check exception cause").initCause(exception));
            throw iOException;
        }
    }

    private String getDefaultProtocol() {
        return "TLS";
    }

    private void logMessage(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("--- Custom SSL Values ---" + System.lineSeparator());
        if (string != null) {
            stringBuilder.append("Protocol: " + string + System.lineSeparator());
        }
        fConstants.logger.info(stringBuilder.toString());
    }

    private TrustManager[] constructTrustManager(String string) throws Exception {
        try {
            char[] cArray = string == null ? null : string.toCharArray();
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            keyStore.load(null, cArray);
            trustManagerFactory.init(keyStore);
            return trustManagerFactory.getTrustManagers();
        }
        catch (Exception exception) {
            if (exception.getCause() == null || !(exception.getCause() instanceof UnrecoverableKeyException)) {
                throw exception;
            }
            SSLKeyException sSLKeyException = new SSLKeyException("Invalid TrustStore Password - " + string);
            sSLKeyException.initCause(exception.getCause());
            throw sSLKeyException;
        }
    }

    private KeyManager[] constructKeyManager(String string) throws Exception {
        KeyManager[] keyManagerArray;
        try {
            char[] cArray = string == null ? null : string.toCharArray();
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            keyStore.load(null, cArray);
            keyManagerFactory.init(keyStore, null);
            keyManagerArray = keyManagerFactory.getKeyManagers();
        }
        catch (Exception exception) {
            if (exception.getCause() == null || !(exception.getCause() instanceof UnrecoverableKeyException)) {
                throw exception;
            }
            SSLKeyException sSLKeyException = new SSLKeyException("Invalid KeyStore Password - " + string);
            sSLKeyException.initCause(exception.getCause());
            throw sSLKeyException;
        }
        return keyManagerArray;
    }

    private SSLSocketFactory createCustomNSSSocketFactory(String string, String string2) throws Exception {
        try {
            fConstants.logger.log("Constructing Custom NSS SocketFactory");
            if (string2 == null) {
                string2 = this.getDefaultProtocol();
            }
            this.logMessage(string2);
            SSLContext sSLContext = SSLContext.getInstance(string2);
            KeyManager[] keyManagerArray = this.constructKeyManager(string);
            TrustManager[] trustManagerArray = this.constructTrustManager(string);
            sSLContext.init(keyManagerArray, trustManagerArray, null);
            return sSLContext.getSocketFactory();
        }
        catch (Exception exception) {
            fConstants.logger.error("Failed to construct SSL SocketFactory - " + exception.getMessage());
            throw exception;
        }
    }
}

