/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers;

import com.pcbsys.foundation.base.fFile;
import com.pcbsys.foundation.drivers.fCustomKeyManager;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.logger.fLogLevel;
import com.pcbsys.foundation.utils.fSystemConfiguration;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;

public class fCustomSSLSocketFactory
extends SSLSocketFactory {
    private static final String lineSeparator = fSystemConfiguration.getProperty("line.separator", "\n");
    private SSLSocketFactory sslFact;
    private String[] enabledCiphers;

    public fCustomSSLSocketFactory() {
        this.sslFact = null;
        this.enabledCiphers = null;
    }

    public fCustomSSLSocketFactory(String string, String string2, String string3, String string4, String string5, String string6, String[] stringArray) throws CertificateException, UnrecoverableKeyException, NoSuchAlgorithmException, IOException, KeyManagementException, KeyStoreException {
        this.init(string, string2, string3, string4, string5, string6, stringArray);
    }

    public void init(String string, String string2, String string3, String string4, String string5, String string6, String[] stringArray) throws CertificateException, UnrecoverableKeyException, NoSuchAlgorithmException, IOException, KeyManagementException, KeyStoreException {
        try {
            this.sslFact = this.createCustomSSLSocketFactory(string, string2, string3, string4, string5, string6);
            this.enabledCiphers = stringArray;
        }
        catch (Exception exception) {
            if (exception instanceof CertificateException) {
                throw (CertificateException)exception;
            }
            if (exception instanceof UnrecoverableKeyException) {
                throw (UnrecoverableKeyException)exception;
            }
            if (exception instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)exception;
            }
            if (exception instanceof KeyManagementException) {
                throw (KeyManagementException)exception;
            }
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            IOException iOException = new IOException(exception.getMessage());
            iOException.initCause(exception);
            throw iOException;
        }
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.sslFact.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sslFact.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException {
        Socket socket2 = this.sslFact.createSocket(socket, string, n, bl);
        this.setEnabledCipherSuites(socket2);
        return socket2;
    }

    @Override
    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        Socket socket = this.sslFact.createSocket(string, n);
        this.setEnabledCipherSuites(socket);
        return socket;
    }

    @Override
    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        Socket socket = this.sslFact.createSocket(string, n, inetAddress, n2);
        this.setEnabledCipherSuites(socket);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        Socket socket = this.sslFact.createSocket(inetAddress, n);
        this.setEnabledCipherSuites(socket);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        Socket socket = this.sslFact.createSocket(inetAddress, n, inetAddress2, n2);
        this.setEnabledCipherSuites(socket);
        return socket;
    }

    @Override
    public Socket createSocket() throws IOException {
        Socket socket = this.sslFact.createSocket();
        this.setEnabledCipherSuites(socket);
        return socket;
    }

    private void setEnabledCipherSuites(Socket socket) throws IOException {
        try {
            if (this.enabledCiphers != null) {
                ((SSLSocket)socket).setEnabledCipherSuites(this.enabledCiphers);
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Error setting cipher suite on socket");
            iOException.initCause(new SSLException("Could not set cipher suite - check exception cause").initCause(exception));
            throw iOException;
        }
    }

    private String getDefaultProtocol() {
        return "TLS";
    }

    private void logMessage(String string, String string2, String string3, String string4) {
        if (fConstants.logger.canLog(fLogLevel.TRACE)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("--- Custom SSL Values ---").append(lineSeparator);
            if (string != null) {
                stringBuilder.append("KeyStorePath: ").append(string).append(lineSeparator);
            }
            if (string2 != null) {
                stringBuilder.append("KeyStoreCertificate: ").append(string2).append(lineSeparator);
            }
            if (string3 != null) {
                stringBuilder.append("TrustStorePath: ").append(string3).append(lineSeparator);
            }
            if (string4 != null) {
                stringBuilder.append("Protocol: ").append(string4).append(lineSeparator);
            }
            fConstants.logger.info(stringBuilder.toString());
        }
    }

    private TrustManager[] constructTrustManager(String string, String string2) throws Exception {
        if (string != null) {
            try {
                char[] cArray = string2 == null ? null : string2.toCharArray();
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                FileInputStream fileInputStream = fFile.openFileInputStream(string);
                keyStore.load(fileInputStream, cArray);
                fileInputStream.close();
                trustManagerFactory.init(keyStore);
                return trustManagerFactory.getTrustManagers();
            }
            catch (FileNotFoundException fileNotFoundException) {
                SSLKeyException sSLKeyException = new SSLKeyException("Invalid TrustStore Path - " + string);
                sSLKeyException.initCause(fileNotFoundException);
                throw sSLKeyException;
            }
            catch (Exception exception) {
                if (exception.getCause() == null || !(exception.getCause() instanceof UnrecoverableKeyException)) {
                    throw exception;
                }
                SSLKeyException sSLKeyException = new SSLKeyException("Invalid TrustStore Password");
                sSLKeyException.initCause(exception.getCause());
                throw sSLKeyException;
            }
        }
        return null;
    }

    private KeyManager[] constructKeyManager(String string, String string2, String string3) throws Exception {
        if (string != null) {
            KeyManager[] keyManagerArray;
            try (FileInputStream fileInputStream = null;){
                char[] cArray = string2 == null ? null : string2.toCharArray();
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                fileInputStream = fFile.openFileInputStream(string);
                keyStore.load(fileInputStream, cArray);
                fileInputStream.close();
                fileInputStream = null;
                keyManagerFactory.init(keyStore, cArray);
                keyManagerArray = keyManagerFactory.getKeyManagers();
            }
            if (string3 != null) {
                if (((X509KeyManager)keyManagerArray[0]).getCertificateChain(string3) == null) {
                    throw new SSLException("No certificate chain exists for alias - " + string3);
                }
                keyManagerArray = new KeyManager[]{new fCustomKeyManager((X509KeyManager)keyManagerArray[0], string3)};
            }
            return keyManagerArray;
        }
        return null;
    }

    private SSLSocketFactory createCustomSSLSocketFactory(String string, String string2, String string3, String string4, String string5, String string6) throws Exception {
        try {
            fConstants.logger.info("Constructing Custom SSL SocketFactory");
            if (string6 == null) {
                string6 = this.getDefaultProtocol();
            }
            this.logMessage(string, string3, string4, string6);
            SSLContext sSLContext = SSLContext.getInstance(string6);
            KeyManager[] keyManagerArray = this.constructKeyManager(string, string2, string3);
            TrustManager[] trustManagerArray = this.constructTrustManager(string4, string5);
            sSLContext.init(keyManagerArray, trustManagerArray, null);
            return sSLContext.getSocketFactory();
        }
        catch (Exception exception) {
            fConstants.logger.error("Failed to construct SSL SocketFactory - " + exception.getMessage());
            throw exception;
        }
    }
}

