/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers;

import com.pcbsys.foundation.base.fBaseObject;
import com.pcbsys.foundation.base.fException;
import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.concurrent.CacheLinePaddedLong;
import com.pcbsys.foundation.drivers.MonitoredInputStream;
import com.pcbsys.foundation.drivers.MonitoredOutputStream;
import com.pcbsys.foundation.drivers.fAsyncReadListener;
import com.pcbsys.foundation.drivers.fConnectionDetails;
import com.pcbsys.foundation.drivers.fVendorDriver;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.security.auth.fAuthenticationException;
import com.pcbsys.foundation.security.fLoginContext;
import com.pcbsys.foundation.security.fLoginResponse;
import com.pcbsys.foundation.security.fSubject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class fDriver
extends fBaseObject {
    protected final fLoginContext myAuthHandler;
    public fVendorDriver myServer;
    fConnectionDetails myConnDet;
    protected String myID;
    protected String myLocalID;
    protected String myType;
    protected String myProtocolId;
    protected fSubject mySubject;
    protected fAsyncReadListener myListener;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private fDriver myChainedDriver;
    protected InputStream myInputStream;
    private CacheLinePaddedLong myLastRead;
    private CacheLinePaddedLong myLastWrite;
    protected OutputStream myOutputStream;

    public static void log(String string) {
        Date date = new Date();
        String string2 = date.toString() + " Comms>" + string;
        System.err.println(string2);
    }

    static void debugLog(String string) {
        if (fConnectionDetails.sEnableConnectionDebug) {
            fConstants.logger.info("UM:Driver Debug> " + string);
        }
    }

    public fDriver(fLoginContext fLoginContext2) {
        this.myAuthHandler = fLoginContext2;
        this.setClosed(false);
        this.myType = "Unknown";
        this.myLastRead = new CacheLinePaddedLong(fTimer.getTicks());
        this.myLastWrite = new CacheLinePaddedLong(fTimer.getTicks());
    }

    public void resumeReading() {
    }

    public void open() throws IOException, fException {
        fLoginResponse fLoginResponse2 = this.myAuthHandler.login(this);
        if (fConnectionDetails.sEnableConnectionDebug) {
            fDriver.log("Opening connection for " + this.myID);
        }
        if (!fLoginResponse2.authenticated() && !fLoginResponse2.isPolicyRequest()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("An error occurred while authenticating driver ");
            stringBuilder.append(this.getId());
            if (this.getSubject() != null) {
                stringBuilder.append(", with subject ");
                stringBuilder.append(this.getSubject());
            } else if (this.myAuthHandler.getSubject() != null) {
                stringBuilder.append(", with subject ");
                stringBuilder.append(this.myAuthHandler.getSubject());
            }
            throw new fAuthenticationException(stringBuilder.toString());
        }
        if (fLoginResponse2.isPolicyRequest()) {
            throw new fException("Policy request received");
        }
        if (fConnectionDetails.sEnableConnectionDebug) {
            fDriver.log("Protocol: " + this.getType() + ": " + this.getId() + " connected.");
        }
    }

    public void close() throws IOException, fException {
        if (fConnectionDetails.sEnableConnectionDebug) {
            fDriver.log("Closing connection for " + this.myID);
        }
        this.setClosed(true);
        if (this.myChainedDriver != null) {
            this.myChainedDriver.close();
        }
        if (this.myAuthHandler != null) {
            this.myAuthHandler.logout(this);
        }
        this.remove();
    }

    public void setChain(fDriver fDriver2) {
        this.myChainedDriver = fDriver2;
    }

    public void abortAllIO() {
        if (fConnectionDetails.sEnableConnectionDebug) {
            fDriver.log("Abort All I/O for connection " + this.myID);
        }
    }

    public boolean isIPC() {
        return false;
    }

    public boolean isNative() {
        return true;
    }

    public void registerListener(fAsyncReadListener fAsyncReadListener2) throws Exception {
        if (!this.supportAsyncReading()) {
            throw new Exception("Driver does not support async reading");
        }
        this.myListener = fAsyncReadListener2;
    }

    public void registerListener(fAsyncReadListener fAsyncReadListener2, boolean bl) throws Exception {
        this.registerListener(fAsyncReadListener2);
    }

    public fAsyncReadListener getListener() {
        return this.myListener;
    }

    public void updateResource(String string, Object[] objectArray) throws fException {
    }

    public fVendorDriver getVendingDriver() {
        return this.myServer;
    }

    public abstract InputStream getInputStream() throws IOException;

    public abstract OutputStream getOutputStream() throws IOException;

    public long getLastRead() {
        return this.myLastRead.get();
    }

    public long getLastWrite() {
        return this.myLastWrite.get();
    }

    public void setLastWrite() {
        this.myLastWrite.set(fTimer.getTicks());
    }

    public void setLastRead() {
        this.myLastRead.set(fTimer.getTicks());
        this.myLastWrite.set(fTimer.getTicks());
    }

    protected synchronized InputStream createInputStream(InputStream inputStream) {
        if (this.myInputStream == null) {
            this.myInputStream = fConnectionDetails.sAllowBandwidthMonitoring ? new MonitoredInputStream(inputStream, this) : inputStream;
        }
        return this.myInputStream;
    }

    protected synchronized OutputStream createOutputStream(OutputStream outputStream) {
        if (this.myOutputStream == null) {
            this.myOutputStream = fConnectionDetails.sAllowBandwidthMonitoring ? new MonitoredOutputStream(outputStream, this) : outputStream;
        }
        return this.myOutputStream;
    }

    public abstract void setTimeout(int var1);

    public abstract int getTimeout();

    public abstract String getId();

    public abstract String getLocalId();

    public abstract int getLocalPort();

    public abstract boolean supportAsyncReading();

    public abstract boolean supportAsyncWriting();

    public boolean sendTimeOutEvent() {
        return true;
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    protected void remove() {
        if (this.myServer != null) {
            this.myServer.remove(this);
        }
    }

    public fSubject getSubject() {
        return this.mySubject;
    }

    public void setSubject(fSubject fSubject2) {
        this.mySubject = fSubject2;
    }

    public String getType() {
        return this.myType;
    }

    public abstract fConnectionDetails getConnectionDetails();

    public void setProtocolId(String string) {
        this.myProtocolId = string;
    }

    protected void setID(String string) {
        this.myID = string;
        if (this.myLocalID == null) {
            this.myLocalID = string;
        }
    }

    public abstract boolean isSecure();

    public abstract boolean isRequireClientAuth();

    public void updateReceived(int n) {
        try {
            if (fConnectionDetails.sAllowBandwidthMonitoring && this.myServer != null) {
                this.myServer.getUsage().updateRead(n);
            }
        }
        catch (Exception exception) {
            fConstants.logger.warn(exception);
        }
    }

    public void updateSent(int n) {
        try {
            if (fConnectionDetails.sAllowBandwidthMonitoring && this.myServer != null) {
                this.myServer.getUsage().updateWrite(n);
            }
        }
        catch (Exception exception) {
            fConstants.logger.warn(exception);
        }
    }

    protected boolean setClosed(boolean bl) {
        return this.isClosed.getAndSet(bl);
    }
}

