/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers;

import com.pcbsys.foundation.base.fBaseObject;
import com.pcbsys.foundation.base.fException;
import com.pcbsys.foundation.collections.Vector;
import com.pcbsys.foundation.drivers.configuration.fSslCertificateConfiguration;
import com.pcbsys.foundation.drivers.fConnectionDetails;
import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.drivers.fSSLSocketDriver;
import com.pcbsys.foundation.drivers.fSSLSocketFactory;
import com.pcbsys.foundation.drivers.fSocketDriver;
import com.pcbsys.foundation.drivers.fURLDriver;
import com.pcbsys.foundation.drivers.jdk.fHTTPSettingsFactory;
import com.pcbsys.foundation.drivers.jdk.fJDKHelper;
import com.pcbsys.foundation.drivers.jdk.fProxyInfo;
import com.pcbsys.foundation.drivers.rdma.fRDMADriver;
import com.pcbsys.foundation.drivers.shm.fSHMDriver;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fConnectionSettings;
import com.pcbsys.foundation.security.auth.fAuthenticationException;
import com.pcbsys.foundation.security.fClientLoginContext;
import com.pcbsys.foundation.security.fLoginContext;
import com.pcbsys.foundation.security.fLoginContextSSLAttributes;
import com.pcbsys.foundation.utils.fSystemConfiguration;
import java.io.IOException;
import java.net.Socket;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;

public class fDriverFactory
extends fBaseObject {
    private static final long SLEEP_CONNRETRY = Long.parseLong(fSystemConfiguration.getProperty("Nirvana.drivers.connretry.sleep", "1000"));
    protected final Vector<fConnectionDetails> myConnectionList = new Vector();
    protected final String myUsername;
    protected final String myPassword;
    private boolean customSocketFactorySet = false;
    private String[] myPrincipals = null;
    private String keyStorePath = null;
    private String keyStorePass = null;
    private String keyStoreCert = null;
    private String trustStorePath = null;
    private String trustStorePass = null;
    private String sslProtocol = null;
    private String[] enabledCiphers = null;
    private String pkcs11NSSConfigFile = null;
    private String pkcs11NSSName = null;

    public fDriverFactory(String string, String string2) {
        this.myUsername = string;
        this.myPassword = string2 != null && string2.length() == 0 ? null : string2;
    }

    public fDriverFactory() {
        this(null, null);
    }

    public fDriverFactory(String string) {
        this(string, null);
    }

    public void configureSSL(fSslCertificateConfiguration fSslCertificateConfiguration2) {
        if (fSslCertificateConfiguration2.isSSLConfigured()) {
            this.setTrustStore(fSslCertificateConfiguration2.getTrustStorePath(), fSslCertificateConfiguration2.getTrustStorePassword());
            this.setKeyStore(fSslCertificateConfiguration2.getKeyStorePath(), fSslCertificateConfiguration2.getKeyStorePassword(), fSslCertificateConfiguration2.getCertificateAlias());
            this.setEnabledCiphers(fSslCertificateConfiguration2.getEnabledCiphers());
            this.setSSLProtocol(fSslCertificateConfiguration2.getSslProtocol());
        }
    }

    private void setTrustStore(String string, String string2) {
        if (string == null) {
            string = fSystemConfiguration.getProperty("javax.net.ssl.trustStore");
            if (string2 == null) {
                string2 = fSystemConfiguration.getProperty("javax.net.ssl.trustStorePassword");
            }
        }
        this.trustStorePath = string;
        this.trustStorePass = string2;
    }

    private void setKeyStore(String string, String string2, String string3) {
        if (string == null) {
            string = fSystemConfiguration.getProperty("javax.net.ssl.keyStore");
            if (string2 == null) {
                string2 = fSystemConfiguration.getProperty("javax.net.ssl.keyStorePassword");
            }
        }
        if (string3 == null) {
            string3 = fConnectionSettings.sCertificateAlias;
        }
        this.keyStorePath = string;
        this.keyStorePass = string2;
        this.keyStoreCert = string3;
    }

    private void setSSLProtocol(String string) {
        this.sslProtocol = string;
    }

    private void setEnabledCiphers(String[] stringArray) {
        this.enabledCiphers = stringArray;
    }

    public void setPKCS11NSSName(String string) {
        this.pkcs11NSSName = string;
    }

    public void addConnection(String string) throws fException {
        try {
            this.myConnectionList.add(new fConnectionDetails(string));
        }
        catch (Exception exception) {
            throw new fException(exception.getMessage());
        }
    }

    public void addConnection(fConnectionDetails fConnectionDetails2) {
        this.myConnectionList.add(fConnectionDetails2);
    }

    public void addConnection(int n, String string, int n2, String string2) throws fException {
        try {
            this.myConnectionList.add(new fConnectionDetails(n, string, n2, string2));
        }
        catch (Exception exception) {
            throw new fException(exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean incrementConnectionList() {
        Vector<fConnectionDetails> vector = this.myConnectionList;
        synchronized (vector) {
            if (this.myConnectionList.size() > 1) {
                this.myConnectionList.add((fConnectionDetails)this.myConnectionList.remove(0));
                return true;
            }
        }
        return false;
    }

    public List<fConnectionDetails> getConnectionList() {
        return Collections.unmodifiableList(this.myConnectionList);
    }

    public void clearAndSetConnectionList(List<fConnectionDetails> list) {
        this.myConnectionList.clear();
        this.myConnectionList.addAll(list);
    }

    public fDriver connect(int n) throws fException {
        return this.connect(n, false);
    }

    public fDriver connect(int n, boolean bl) throws fException {
        int n2 = 0;
        long l = SLEEP_CONNRETRY;
        fDriver fDriver2 = null;
        while (fDriver2 == null) {
            fDriver2 = this.doConnect(this.myConnectionList, this.myUsername, this.myPassword, this.myPrincipals, bl);
            if (fDriver2 != null) continue;
            if (++n2 >= n) {
                throw new fException("Retry count=" + n + " exceeded attempting to connect to host - " + this.myConnectionList);
            }
            if (fConstants.logger.isDebugEnabled()) {
                fConstants.logger.debug("Failed to connect to remote host - retrying " + this.myConnectionList);
            }
            try {
                Thread.sleep(l);
                l *= 2L;
            }
            catch (InterruptedException interruptedException) {
                throw new fException("Interrupt Exception raised releasing attempts", interruptedException);
            }
        }
        if (fConstants.logger.isDebugEnabled()) {
            fConstants.logger.debug("Connected to remote server, we have a driver...");
        }
        return fDriver2;
    }

    private fDriver doConnect(Vector<fConnectionDetails> vector, String string, String string2, String[] stringArray, boolean bl) throws fException {
        for (int i = 0; i < vector.size(); ++i) {
            fDriver fDriver2;
            fConnectionDetails fConnectionDetails2 = (fConnectionDetails)vector.elementAt(i);
            if (fConnectionDetails2.getType() == 3 && fConnectionDetails2.useConnect() && fJDKHelper.getHTTPFactory() != null) {
                fHTTPSettingsFactory fHTTPSettingsFactory2 = fJDKHelper.getHTTPFactory();
                try {
                    URL uRL = new URL("https://" + fConnectionDetails2.getHost() + ":" + fConnectionDetails2.getPort());
                    fProxyInfo fProxyInfo2 = fHTTPSettingsFactory2.getProxyInfo(uRL);
                    if (fProxyInfo2 != null) {
                        fConnectionDetails fConnectionDetails3;
                        Socket socket = fJDKHelper.getProxySocket(fProxyInfo2, uRL);
                        if (socket != null) {
                            socket.setSoTimeout(0);
                        }
                        if ((fDriver2 = this.attemptConnection(fConnectionDetails3 = new fConnectionDetails(2, fConnectionDetails2.getHost(), fConnectionDetails2.getPort(), ""), string, string2, stringArray, socket, bl)) != null) {
                            fConstants.logger.log("Connection: Direct connect to server via proxy successful");
                            return fDriver2;
                        }
                        if (socket != null) {
                            socket.close();
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((fDriver2 = this.attemptConnection(fConnectionDetails2, string, string2, stringArray, null, bl)) == null) continue;
            return fDriver2;
        }
        return null;
    }

    private fDriver attemptConnection(fConnectionDetails fConnectionDetails2, String string, String string2, String[] stringArray, Socket socket, boolean bl) throws fException {
        fConstants.logger.info("Attempting connection to " + fConnectionDetails2.toString());
        fDriver fDriver2 = null;
        try {
            fLoginContext fLoginContext2 = string2 != null ? fClientLoginContext.getInstance(fConnectionDetails.getProtocolString(fConnectionDetails2.getType()), string, string2) : fClientLoginContext.getInstance(fConnectionDetails.getProtocolString(fConnectionDetails2.getType()), string);
            if (fLoginContext2 instanceof fLoginContextSSLAttributes) {
                ((fLoginContextSSLAttributes)((Object)fLoginContext2)).setKeyStore(this.keyStorePath, this.keyStorePass, this.keyStoreCert);
                ((fLoginContextSSLAttributes)((Object)fLoginContext2)).setTrustStore(this.trustStorePath, this.trustStorePass);
                ((fLoginContextSSLAttributes)((Object)fLoginContext2)).setEnabledCiphers(this.enabledCiphers);
                ((fLoginContextSSLAttributes)((Object)fLoginContext2)).setSSLProtocol(this.sslProtocol);
                ((fLoginContextSSLAttributes)((Object)fLoginContext2)).setPKCS11NSSConfigFile(this.pkcs11NSSConfigFile);
                ((fLoginContextSSLAttributes)((Object)fLoginContext2)).setPKCS11NSSName(this.pkcs11NSSName);
            }
            if (fConnectionDetails2.getVirtualName() != null && fLoginContext2 instanceof fClientLoginContext) {
                ((fClientLoginContext)fLoginContext2).setVirtualHostName(fConnectionDetails2.getVirtualName());
            }
            if (fLoginContext2 instanceof fClientLoginContext && stringArray != null) {
                ((fClientLoginContext)fLoginContext2).setPrincipals(stringArray);
            }
            switch (fConnectionDetails2.getType()) {
                case 13: {
                    fDriver2 = new fRDMADriver(fConnectionDetails2.getHost(), fConnectionDetails2.getPort(), fLoginContext2);
                    break;
                }
                case 12: {
                    fDriver2 = new fSHMDriver(fConnectionDetails2.getFile(), fLoginContext2);
                    break;
                }
                case 0: {
                    fDriver2 = new fSocketDriver(fConnectionDetails2.getHost(), fConnectionDetails2.getPort(), fLoginContext2);
                    break;
                }
                case 2: {
                    if (socket == null) {
                        fDriver2 = new fSSLSocketDriver(fConnectionDetails2.getHost(), fConnectionDetails2.getPort(), fLoginContext2);
                        break;
                    }
                    fDriver2 = new fSSLSocketDriver(fConnectionDetails2.getHost(), fConnectionDetails2.getPort(), fLoginContext2, socket);
                    break;
                }
                case 1: {
                    fDriver2 = new fURLDriver(fConnectionDetails2.getHost(), fConnectionDetails2.getPort(), fConnectionDetails2.getFile(), fLoginContext2, false);
                    break;
                }
                case 3: {
                    if (fConnectionSettings.sCertificateAlias != null && fConnectionSettings.sCertificateAlias.length() != 0 && !this.customSocketFactorySet) {
                        this.customSocketFactorySet = true;
                        HttpsURLConnection.setDefaultSSLSocketFactory(new fSSLSocketFactory());
                    }
                    fDriver2 = new fURLDriver(fConnectionDetails2.getHost(), fConnectionDetails2.getPort(), fConnectionDetails2.getFile(), fLoginContext2, true);
                    break;
                }
            }
            if (fDriver2 != null) {
                fDriver2.setTimeout(fConnectionSettings.getSocketConnectTimeout());
                fDriver2.open();
                fDriver2.setTimeout(0);
            }
        }
        catch (Exception exception) {
            if (fDriver2 != null) {
                try {
                    fDriver2.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            if (fAuthenticationException.isReason(exception, 1)) {
                return this.attemptConnection(fConnectionDetails2, string, null, stringArray, socket, bl);
            }
            if (exception instanceof fAuthenticationException) {
                throw (fAuthenticationException)exception;
            }
            for (Throwable throwable = exception; throwable != null; throwable = throwable.getCause()) {
                if (!(throwable instanceof fAuthenticationException)) continue;
                throw new fAuthenticationException(exception);
            }
            if (exception instanceof SSLException || exception.getCause() != null && exception.getCause() instanceof SSLException) {
                throw new fException("SSL exception received when connecting to - " + this.myConnectionList + " (check cause for underlying exception)", exception);
            }
            if (exception instanceof IOException || exception instanceof fException && exception.getCause() instanceof IOException) {
                String string3 = "";
                if (fConnectionDetails2.getType() == 12) {
                    string3 = ":shm=" + fConnectionDetails2.getFile();
                }
                fConstants.logger.error(exception);
            } else {
                fConstants.logger.warn(exception);
            }
            fDriver2 = null;
        }
        return fDriver2;
    }

    public String getUserName() {
        return this.myUsername;
    }

    public void setPrincipals(String[] stringArray) {
        this.myPrincipals = stringArray;
    }

    public String toString() {
        return this.myConnectionList.toString();
    }
}

