/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers;

import com.pcbsys.foundation.base.fException;
import com.pcbsys.foundation.base.fExceptionHandler;
import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.drivers.fAsyncReadListener;
import com.pcbsys.foundation.drivers.fConnectionDetails;
import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.drivers.fHTTPInstanceDriver;
import com.pcbsys.foundation.drivers.http.fHTTPDriver;
import com.pcbsys.foundation.drivers.http.fHTTPHeader;
import com.pcbsys.foundation.drivers.http.fServerHTTPBaseDriver;
import com.pcbsys.foundation.drivers.jdk.fJDKHelper;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.PipedInputStream;
import com.pcbsys.foundation.io.PipedOutputStream;
import com.pcbsys.foundation.security.fLoginContext;
import com.pcbsys.foundation.security.fSubject;
import com.pcbsys.foundation.utils.fStringByteConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class fHTTPDSession
extends fHTTPInstanceDriver {
    private static final byte sReturn = 13;
    private static int sMyBufferSize = 5120;
    private final boolean isSSL;
    private final boolean isRequireClientAuth;
    private final int bufSize = sMyBufferSize;
    private final OutputStream myOutputStream;
    private final long myKey;
    private final byte[] myLengthBuffer = new byte[10];
    private final String myClientHost;
    private final long myCreationTime;
    private final byte[] myCookie;
    private final PipedInputStream myPis;
    private final PipedOutputStream myPos;
    private final byte[] myBuffer = new byte[this.bufSize];
    private final fDriver myLowerDriver;
    private final fServerHTTPBaseDriver myBase;
    private int myLengthBufferIdx;
    private int notifyCount;
    private boolean inWrite;
    private Throwable myCloseException;

    fHTTPDSession(fDriver fDriver2, fLoginContext fLoginContext2, fSubject fSubject2, long l, String string, fServerHTTPBaseDriver fServerHTTPBaseDriver2, byte[] byArray) throws IOException {
        super(fLoginContext2);
        this.myKey = l;
        this.myCookie = byArray;
        this.myClientHost = string;
        this.myCreationTime = fTimer.getTicks();
        this.myLowerDriver = fDriver2;
        this.myOutputStream = this.myLowerDriver.getOutputStream();
        this.myPis = new PipedInputStream(sMyBufferSize);
        this.myPos = new PipedOutputStream(this.myPis);
        this.myBase = fServerHTTPBaseDriver2;
        this.mySubject = fSubject2;
        if (fDriver2 instanceof fHTTPDriver && ((fHTTPDriver)((Object)fDriver2)).getLowerDriver().isSecure()) {
            this.isSSL = true;
            this.myType = fConnectionDetails.getProtocolString(3);
            this.isRequireClientAuth = fDriver2.isRequireClientAuth();
        } else {
            this.isSSL = false;
            this.isRequireClientAuth = false;
            this.myType = fConnectionDetails.getProtocolString(1);
        }
        this.myLowerDriver.setProtocolId(this.myType);
    }

    @Override
    public boolean isSecure() {
        return this.isSSL;
    }

    @Override
    public boolean isRequireClientAuth() {
        return this.isRequireClientAuth;
    }

    @Override
    public boolean supportAsyncReading() {
        return this.myLowerDriver.supportAsyncReading();
    }

    @Override
    public boolean supportAsyncWriting() {
        return this.myLowerDriver.supportAsyncWriting();
    }

    @Override
    public String getId() {
        if (this.myLowerDriver != null) {
            return this.myLowerDriver.getId();
        }
        return "[Closed]";
    }

    @Override
    public int getLocalPort() {
        return this.myLowerDriver.getLocalPort();
    }

    @Override
    public String getLocalId() {
        if (this.myLowerDriver != null) {
            return this.myLowerDriver.getLocalId();
        }
        return "[Closed]";
    }

    @Override
    public fConnectionDetails getConnectionDetails() {
        return this.myLowerDriver.getConnectionDetails();
    }

    public fDriver getRawDriver() {
        return this.myLowerDriver;
    }

    @Override
    public long getLastRead() {
        return this.myLowerDriver.getLastRead();
    }

    @Override
    public long getLastWrite() {
        return this.myLowerDriver.getLastWrite();
    }

    @Override
    public void setLastWrite() {
        this.myLowerDriver.setLastWrite();
    }

    @Override
    public void setLastRead() {
        this.myLowerDriver.setLastRead();
    }

    @Override
    public int getTimeout() {
        return this.myLowerDriver.getTimeout();
    }

    public String getClientHost() {
        return this.myClientHost;
    }

    @Override
    public void setTimeout(int n) {
        try {
            this.myLowerDriver.setTimeout(n);
        }
        catch (Exception exception) {
            fConstants.logger.error(exception);
        }
    }

    @Override
    public void open() throws IOException, fException {
        super.open();
        if (fConstants.logger.isDebugEnabled()) {
            String string = this.isSSL ? "NHPS" : "NHP";
            fConstants.logger.debug("Protocol: " + string + ": " + this.getId() + " connected.");
        }
    }

    @Override
    public synchronized void registerListener(fAsyncReadListener fAsyncReadListener2) throws Exception {
        if (this.myLowerDriver instanceof fHTTPDriver) {
            ((fHTTPDriver)((Object)this.myLowerDriver)).getLowerDriver().registerListener(new AsyncListener());
        }
        super.registerListener(fAsyncReadListener2);
        if (this.myListener != null && this.myPis.available() != 0) {
            this.myListener.dataReady();
        }
    }

    @Override
    public InputStream getInputStream() {
        return this.myPis;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.myOutputStream;
    }

    @Override
    public void close() throws IOException, fException {
        if (this.setClosed(true)) {
            return;
        }
        if (fConstants.logger.isDebugEnabled()) {
            String string = this.isSSL ? "NHPS" : "NHP";
            fConstants.logger.debug("Protocol: " + string + ": " + this.getId() + " disconnected.");
        }
        this.myBase.closeDriver(this);
        this.myLowerDriver.close();
        this.myPis.close();
        super.close();
        this.myPos.close();
        this.myOutputStream.close();
        if (this.myListener != null) {
            if (this.myListener instanceof fExceptionHandler && this.myCloseException != null) {
                ((fExceptionHandler)((Object)this.myListener)).setException(this.myCloseException);
            }
            this.myListener.close();
        }
        int n = 0;
        while (this.inWrite && n < 20) {
            ++n;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public fSubject getSubject() {
        if (this.mySubject != null) {
            return this.mySubject;
        }
        this.mySubject = this.myLowerDriver.getSubject();
        return this.mySubject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean pushData(InputStream inputStream, fHTTPDriver fHTTPDriver2, fHTTPHeader fHTTPHeader2) throws IOException {
        int n = fHTTPHeader2.ContentLength();
        byte[] byArray = fHTTPHeader2.getBuffer();
        int n2 = fHTTPHeader2.getEndoOfHeaderLocation();
        int n3 = fHTTPHeader2.getEndOfBuffer();
        this.myLowerDriver.setLastRead();
        long l = fTimer.currentTimeMillis() + 100L;
        while (this.inWrite && l > fTimer.currentTimeMillis()) {
            fJDKHelper.park(1L);
        }
        if (this.inWrite) {
            fConstants.logger.error("HTTP: Stalled in data transfer, closing connection");
            try {
                this.close();
                return true;
            }
            catch (fException fException2) {
                // empty catch block
            }
            return true;
        }
        fHTTPDSession fHTTPDSession2 = this;
        synchronized (fHTTPDSession2) {
            try {
                if (this.isClosed()) {
                    fConstants.logger.error("HTTP: Partial data pushed as connection was closed");
                    boolean bl = true;
                    return bl;
                }
                this.inWrite = true;
                this.notifyCount = 0;
                if (fHTTPHeader2.isChunkedInput()) {
                    this.pushDataChunked(inputStream, byArray, n2, n3);
                } else {
                    this.pushDataNormal(inputStream, n, byArray, n2, n3);
                }
                if (this.notifyCount != 0) return true;
                if (this.myListener == null) return true;
                this.myListener.dataReady();
            }
            finally {
                this.inWrite = false;
            }
            return true;
        }
    }

    private synchronized void pushDataChunked(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        for (n3 = 0; n3 < this.myLengthBuffer.length; ++n3) {
            this.myLengthBuffer[n3] = 0;
        }
        this.myLengthBufferIdx = 0;
        try {
            int n4;
            boolean bl = false;
            for (n3 = n; n3 < n2 && !bl; ++n3) {
                if (!this.findLen(byArray[n3])) continue;
                n4 = Integer.parseInt(fStringByteConverter.convert(this.myLengthBuffer, 0, this.myLengthBufferIdx - 1), 16);
                bl = true;
                this.pushDataNormal(inputStream, n4, byArray, n3 + 1, n2);
            }
            int n5 = 0;
            while (n5 != -1) {
                n5 = inputStream.read();
                if (n5 == -1 || !this.findLen((byte)n5)) continue;
                n4 = Integer.parseInt(fStringByteConverter.convert(this.myLengthBuffer, 0, this.myLengthBufferIdx), 16);
                inputStream.read();
                this.pushDataNormal(inputStream, n4, null, n2, n2);
                this.myLengthBufferIdx = 0;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean findLen(byte by) {
        if (by == 13) {
            return true;
        }
        this.myLengthBuffer[this.myLengthBufferIdx] = by;
        ++this.myLengthBufferIdx;
        return false;
    }

    private synchronized void pushDataNormal(InputStream inputStream, int n, byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5 = n;
        int n6 = n3 - n2;
        if (n < n6) {
            n6 = n;
        }
        boolean bl = false;
        if (n2 < n3) {
            if (this.myPis.available() == 0) {
                this.pushAllWithNotify(byArray, n2, n6);
                bl = true;
            } else {
                if (this.myListener != null) {
                    this.myListener.dataReady();
                    ++this.notifyCount;
                }
                this.pushAll(byArray, n2, n6);
            }
        }
        if ((n5 -= (n4 = n6)) == 0) {
            this.myPos.flush();
            if (!bl && this.myListener != null) {
                this.myListener.dataReady();
                ++this.notifyCount;
            }
            return;
        }
        int n7 = 0;
        while (n5 != 0) {
            int n8 = n5 < this.bufSize ? inputStream.read(this.myBuffer, 0, n5) : inputStream.read(this.myBuffer, 0, this.bufSize);
            if (n8 == 0 && ++n7 > 100) {
                fConstants.logger.error("HTTP: Unable to read data from stream");
                n8 = -1;
            }
            if (n8 != -1) {
                n5 -= n8;
                n7 = 0;
                if ((n4 += n8) >= n) {
                    n8 -= n4 - n;
                }
                this.pushAllWithNotify(this.myBuffer, 0, n8);
                continue;
            }
            if (n4 == n) continue;
            fConstants.logger.error("HTTP: Partial data received before connection closed");
            try {
                this.close();
                return;
            }
            catch (Exception exception) {
            }
        }
    }

    private void pushAll(byte[] byArray, int n, int n2) throws IOException {
        this.myPos.write(byArray, n, n2);
        this.myPos.flush();
    }

    private void pushAllWithNotify(byte[] byArray, int n, int n2) throws IOException {
        if (n2 > 10) {
            this.pushAll(byArray, n, 10);
            n += 10;
            n2 -= 10;
            if (this.myListener != null) {
                this.myListener.dataReady();
                ++this.notifyCount;
            }
            this.pushAll(byArray, n, n2);
        } else {
            this.pushAll(byArray, n, n2);
            if (this.myListener != null) {
                this.myListener.dataReady();
                ++this.notifyCount;
            }
        }
    }

    @Override
    public long getKey() {
        return this.myKey;
    }

    @Override
    public byte[] getCookieAsBytes() {
        return this.myCookie;
    }

    public long getCreationTime() {
        return this.myCreationTime;
    }

    public void setException(Throwable throwable) {
        this.myCloseException = throwable;
    }

    public Throwable getException() {
        return this.myCloseException;
    }

    public class AsyncListener
    implements fAsyncReadListener {
        AsyncListener() {
        }

        @Override
        public void dataReady() throws IOException {
            try {
                fHTTPDSession.this.myLowerDriver.getInputStream().available();
            }
            catch (IOException iOException) {
                fHTTPDSession.this.setException(iOException);
                this.close();
            }
        }

        @Override
        public void close() {
            try {
                fHTTPDSession.this.close();
            }
            catch (Exception exception) {
                fConstants.logger.warn(exception);
            }
        }
    }
}

