/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers;

import com.pcbsys.foundation.base.fException;
import com.pcbsys.foundation.drivers.fAsyncReadListener;
import com.pcbsys.foundation.drivers.fConnectionDetails;
import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.drivers.fMultiplexManager;
import com.pcbsys.foundation.io.fByteArrayQueueInputStream;
import com.pcbsys.foundation.security.fLoginContext;
import com.pcbsys.foundation.security.fSubject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class fMultiplexDriver
extends fDriver {
    private int myId;
    private fMultiplexManager myManager;
    private OutputStream myOutputStream;
    private fByteArrayQueueInputStream myInputStream;

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.createOutputStream(this.myOutputStream);
    }

    @Override
    public String getId() {
        if (this.myId == 0) {
            return this.myManager.getID();
        }
        return this.myManager.getID() + "-" + this.myId;
    }

    @Override
    public void close() throws IOException, fException {
        if (this.isClosed()) {
            return;
        }
        try {
            for (int i = 0; this.myInputStream.available() != 0 && i < 10; ++i) {
                if (this.myListener != null) {
                    this.myListener.dataReady();
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.close();
        try {
            this.myManager.close(this.myId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.myOutputStream.close();
        this.myInputStream.close();
        if (this.myListener != null) {
            this.myListener.dataReady();
        }
    }

    public fMultiplexManager getManager() {
        return this.myManager;
    }

    @Override
    public void registerListener(fAsyncReadListener fAsyncReadListener2) throws Exception {
        super.registerListener(fAsyncReadListener2);
        if (this.myInputStream.available() != 0 && fAsyncReadListener2 != null) {
            fAsyncReadListener2.dataReady();
        }
    }

    @Override
    public String getType() {
        return this.myManager.getType();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.createInputStream(this.myInputStream);
    }

    @Override
    public void setTimeout(int n) {
    }

    @Override
    public int getTimeout() {
        return 0;
    }

    @Override
    public String getLocalId() {
        return this.myManager.getLocalId() + "-" + this.myId;
    }

    @Override
    public int getLocalPort() {
        return 0;
    }

    @Override
    public boolean supportAsyncReading() {
        return true;
    }

    @Override
    public boolean supportAsyncWriting() {
        return false;
    }

    @Override
    public fConnectionDetails getConnectionDetails() {
        return this.myManager.getConnectionDetails();
    }

    @Override
    public boolean isSecure() {
        return this.myManager.isSecure();
    }

    @Override
    public boolean isRequireClientAuth() {
        return false;
    }

    @Override
    public fSubject getSubject() {
        if (this.mySubject == null) {
            return this.myManager.getSubject();
        }
        return this.mySubject;
    }

    protected fMultiplexDriver(int n, fMultiplexManager fMultiplexManager2, fLoginContext fLoginContext2) {
        super(fLoginContext2);
        this.myId = n;
        this.myManager = fMultiplexManager2;
        this.myOutputStream = new InnerOutputStream();
        this.myInputStream = new fByteArrayQueueInputStream();
    }

    protected void push(byte[] byArray) {
        this.myInputStream.push(byArray);
    }

    protected class InnerOutputStream
    extends ByteArrayOutputStream {
        @Override
        public void close() throws IOException {
            super.close();
            try {
                fMultiplexDriver.this.close();
            }
            catch (fException fException2) {
                throw new IOException(fException2.getMessage());
            }
        }

        @Override
        public void flush() throws IOException {
            if (!fMultiplexDriver.this.myManager.isConnected() || fMultiplexDriver.this.isClosed()) {
                throw new IOException("Stream has been closed");
            }
            super.flush();
            byte[] byArray = this.toByteArray();
            this.reset();
            fMultiplexDriver.this.myManager.send(fMultiplexDriver.this.myId, byArray);
        }
    }
}

