/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers;

import com.pcbsys.foundation.base.fException;
import com.pcbsys.foundation.collections.fast.Long2ObjectOpenAddressingHashMap;
import com.pcbsys.foundation.drivers.MonitoredOutputStream;
import com.pcbsys.foundation.drivers.fAsyncReadListener;
import com.pcbsys.foundation.drivers.fConnectionDetails;
import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.drivers.fMultiplexDriver;
import com.pcbsys.foundation.drivers.fNIOOutputStream;
import com.pcbsys.foundation.drivers.fServerDriver;
import com.pcbsys.foundation.drivers.fServerHTTPDriver;
import com.pcbsys.foundation.drivers.handlers.fAcceptHandler;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fConnection;
import com.pcbsys.foundation.io.fConnectionAsyncReadHandler;
import com.pcbsys.foundation.memory.fMemoryManager;
import com.pcbsys.foundation.security.fPrincipal;
import com.pcbsys.foundation.security.fSubject;
import com.pcbsys.foundation.threads.fTask;
import com.pcbsys.foundation.threads.fThread;
import com.pcbsys.foundation.threads.fThreadPool;
import com.pcbsys.foundation.utils.fEnvironment;
import com.pcbsys.foundation.utils.fStringByteConverter;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class fMultiplexManager
implements fAsyncReadListener,
fTask {
    private static final byte sData = 16;
    private static final byte sOpen = 32;
    private static final byte sUserOpen = 37;
    private static final byte sClose = 48;
    private static final int sBufferSize = 10240;
    private static final boolean sDebug = fEnvironment.isDebugEnabled("multiplex");
    private final Long2ObjectOpenAddressingHashMap<fMultiplexDriver> myInstances;
    private final Object dataReadyLock = new Object();
    private final fAcceptHandler myServer;
    private final Closer closer;
    public final Object myReconnectMutex = new Object();
    private fStreamReader myReader;
    private fDriver myDriver;
    private OutputStream myOS;
    private InputStream myIS;
    private boolean isOpen;
    private boolean isQueued;
    private int myCount;
    private int myTXId;
    private int myRXId;
    private boolean isStarted;
    private boolean isDataReady;

    public fMultiplexManager(fDriver fDriver2, fAcceptHandler fAcceptHandler2) throws IOException {
        if (fDriver2 instanceof fMultiplexDriver) {
            throw new IOException("Can not create multiplex driver on top of another");
        }
        this.myReader = null;
        this.myDriver = fDriver2;
        if (fAcceptHandler2 != null) {
            if (fAcceptHandler2 instanceof fServerHTTPDriver) {
                fAcceptHandler2 = ((fServerHTTPDriver)fAcceptHandler2).myAcceptHandler;
            }
            this.myServer = fAcceptHandler2;
        } else {
            this.myServer = null;
        }
        this.myInstances = new Long2ObjectOpenAddressingHashMap();
        this.myOS = this.myDriver.getOutputStream();
        this.myIS = this.myDriver.getInputStream();
        this.myCount = 1;
        this.isOpen = true;
        this.isQueued = false;
        this.isStarted = false;
        this.closer = new Closer(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        if (this.myDriver.supportAsyncReading()) {
            Object object;
            try {
                object = this.create(0);
                ((fMultiplexDriver)object).registerListener(this.myDriver.getListener());
                this.myDriver.registerListener(this);
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
            this.isStarted = true;
            if (this.isDataReady) {
                this.dataReady();
            }
            if (this.myOS instanceof MonitoredOutputStream && (object = ((MonitoredOutputStream)this.myOS).getBaseOutputStream()) instanceof fNIOOutputStream) {
                fNIOOutputStream fNIOOutputStream2 = (fNIOOutputStream)object;
                fNIOOutputStream2.registerCallback(null);
            }
        } else {
            fMultiplexManager fMultiplexManager2 = this;
            synchronized (fMultiplexManager2) {
                this.myReader = new fStreamReader();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized fMultiplexDriver create(String string) throws IOException {
        String string2 = Thread.currentThread().getName();
        Thread.currentThread().setName("multiplex");
        try {
            Object object;
            fMultiplexDriver fMultiplexDriver2 = new fMultiplexDriver(this.myCount, this, this.myDriver.myAuthHandler);
            try {
                this.myInstances.put(this.myCount, fMultiplexDriver2);
            }
            catch (Exception exception) {
                throw new IOException("Duplicate multiplex Ids");
            }
            if (string == null) {
                object = new byte[9];
                OutputStream outputStream = this.myOS;
                synchronized (outputStream) {
                    fMultiplexManager.packHeader(object, (byte)32, this.myCount, -1, this.myTXId++);
                    this.myOS.write((byte[])object);
                }
            }
            object = new byte[9 + string.length() + 2];
            OutputStream outputStream = this.myOS;
            synchronized (outputStream) {
                fMultiplexManager.packHeader(object, (byte)37, this.myCount, -1, this.myTXId++, fStringByteConverter.convert(string));
                this.myOS.write((byte[])object);
            }
            this.myOS.flush();
            ++this.myCount;
            object = fMultiplexDriver2;
            return object;
        }
        finally {
            Thread.currentThread().setName(string2);
        }
    }

    public synchronized fMultiplexDriver create(int n) throws IOException {
        if (!this.isOpen) {
            if (sDebug) {
                fMultiplexManager.log("Multiplexed manager has been closed, no new drivers can be created");
            }
            throw new IOException("Multiplexed manager has been closed, no new drivers can be created");
        }
        if (n == 0 && this.find(n) != null) {
            return this.find(n);
        }
        fMultiplexDriver fMultiplexDriver2 = new fMultiplexDriver(n, this, this.myDriver.myAuthHandler);
        try {
            this.myInstances.put(n, fMultiplexDriver2);
        }
        catch (Exception exception) {
            throw new IOException("Duplicate multiplex ids");
        }
        return fMultiplexDriver2;
    }

    public synchronized void reconnectDriver(fConnection fConnection2) throws IOException {
        this.myInstances.clear();
        this.myDriver = fConnection2.getDriver();
        this.myCount = 1;
        this.myTXId = 0;
        this.myRXId = 0;
        this.myOS = this.myDriver.getOutputStream();
        this.myIS = this.myDriver.getInputStream();
        this.isOpen = true;
        this.isQueued = false;
        if (this.myDriver.supportAsyncReading()) {
            try {
                fMultiplexDriver fMultiplexDriver2 = this.create(0);
                fMultiplexDriver2.registerListener(this.myDriver.getListener());
                this.myDriver.registerListener(this);
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
        } else if (this.myReader != null) {
            this.myReader = new fStreamReader();
        } else if (sDebug) {
            fMultiplexManager.log("reconnectDriver - already have a reader");
        }
        fConnection2.initialiseMultipexedDriver(this);
    }

    public boolean isSecure() {
        return this.myDriver.isSecure();
    }

    public String getID() {
        return this.myDriver.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(int n) throws IOException {
        byte[] byArray = new byte[9];
        OutputStream outputStream = this.myOS;
        synchronized (outputStream) {
            fMultiplexManager.packHeader(byArray, (byte)48, n, -1, this.myTXId++);
            this.myOS.write(byArray);
        }
        this.myOS.flush();
        if (this.remove(n) != null) {
            if (sDebug) {
                fMultiplexManager.log("closed requested for (ID:" + this.myDriver.getId() + ")(Local:" + this.myDriver.getLocalId() + ")-" + n + " Vended:" + this.myInstances.size());
            }
        } else if (sDebug) {
            fMultiplexManager.log("No known vended driver (ID:" + this.myDriver.getId() + ")(Local:" + this.myDriver.getLocalId() + ")-" + n + " Vended:" + this.myInstances.size());
        }
        if (this.myInstances.size() == 0) {
            if (sDebug) {
                fMultiplexManager.log("Closing base driver (ID:" + this.myDriver.getId() + ")(Local:" + this.myDriver.getLocalId() + ")");
            }
            try {
                this.isOpen = false;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.myDriver.close();
            }
            catch (fException fException2) {
                // empty catch block
            }
        }
    }

    public String getLocalId() {
        return this.myDriver.getLocalId();
    }

    public fConnectionDetails getConnectionDetails() {
        return this.myDriver.getConnectionDetails();
    }

    public fSubject getSubject() {
        return this.myDriver.getSubject();
    }

    public String getType() {
        return this.myDriver.getType();
    }

    public boolean isConnected() {
        return !this.myDriver.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRead() throws IOException {
        int n;
        InputStream inputStream = this.myIS;
        synchronized (inputStream) {
            n = this.myIS.read();
        }
        switch (n) {
            case -1: {
                throw new IOException("Stream closed");
            }
            case 16: {
                byte[] byArray = new byte[12];
                boolean bl = false;
                this.readComplete(byArray);
                int n2 = this.unpackHeader(byArray, 0);
                int n3 = this.unpackHeader(byArray, 4);
                int n4 = this.unpackHeader(byArray, 8);
                if (sDebug) {
                    fMultiplexManager.log("Receiving " + n3 + " bytes");
                    if (n4 != this.myRXId) {
                        fMultiplexManager.log("Data RX id out of sync <" + n4 + " - " + this.myRXId + "> Len:" + n3 + " (ID:" + this.myDriver.getId() + ")(Local:" + this.myDriver.getLocalId() + ")-" + n2);
                    }
                }
                this.myRXId = n4 + 1;
                fMultiplexDriver fMultiplexDriver2 = this.find(n2);
                if (fMultiplexDriver2 == null) {
                    if (sDebug) {
                        fMultiplexManager.log("clearing stream for unknown driver " + n2 + " len:" + n3);
                    }
                    bl = true;
                    InputStream inputStream2 = this.myIS;
                    synchronized (inputStream2) {
                        while (n3 != 0) {
                            if (this.myIS.read() == -1) {
                                throw new IOException("Socket closed");
                            }
                            --n3;
                        }
                    }
                } else {
                    this.readFromStream(fMultiplexDriver2, n3);
                }
                if (!bl) break;
                this.close(n2);
                break;
            }
            case 32: {
                byte[] byArray = new byte[8];
                this.readComplete(byArray);
                if (this.myServer == null) break;
                int n5 = this.unpackHeader(byArray, 0);
                int n6 = this.unpackHeader(byArray, 4);
                if (n6 != this.myRXId && sDebug) {
                    fMultiplexManager.log("Open RX id out of sync <" + n6 + " - " + this.myRXId + "> (ID:" + this.myDriver.getId() + ")(Local:" + this.myDriver.getLocalId() + ")-" + n5);
                }
                this.myRXId = n6 + 1;
                fMultiplexDriver fMultiplexDriver3 = this.create(n5);
                if (sDebug) {
                    fMultiplexManager.log("New driver : " + n5 + " Size:" + this.myInstances.size() + " (ID:" + this.myDriver.getId() + ")(Local:" + this.myDriver.getLocalId() + ")-" + n5);
                }
                this.myServer.accept(fMultiplexDriver3, (fServerDriver)this.myDriver.getVendingDriver());
                break;
            }
            case 37: {
                byte[] byArray = new byte[10];
                this.readComplete(byArray);
                if (this.myServer == null) break;
                int n7 = this.unpackHeader(byArray, 0);
                int n8 = this.unpackHeader(byArray, 4);
                if (n8 != this.myRXId && sDebug) {
                    fMultiplexManager.log("Open RX id out of sync <" + n8 + " - " + this.myRXId + "> (ID:" + this.myDriver.getId() + ")(Local:" + this.myDriver.getLocalId() + ")-" + n7);
                }
                this.myRXId = n8 + 1;
                int n9 = byArray[8] << 8;
                byte[] byArray2 = new byte[n9 += byArray[9] & 0xFF];
                this.readComplete(byArray2);
                fMultiplexDriver fMultiplexDriver4 = this.create(n7);
                fSubject fSubject2 = new fSubject(fStringByteConverter.convert(byArray2).toLowerCase(), fMultiplexDriver4.getSubject().getHost());
                if (this.myDriver.isSecure() && this.myDriver.isRequireClientAuth()) {
                    for (fPrincipal fPrincipal2 : fMultiplexDriver4.getSubject().getPrincipals()) {
                        if (!fPrincipal2.equals(fSubject2.getPrincipalUser(0))) continue;
                        if (sDebug) {
                            fMultiplexManager.log("Underlying driver uses SSL client certificate authentication and specified user is one of existing subject's principals, reusing existing subject for multiplex connection (ID:" + this.myDriver.getId() + ")(Local:" + this.myDriver.getLocalId() + ")-" + n7);
                        }
                        fSubject2 = new fSubject(fMultiplexDriver4.getSubject());
                        break;
                    }
                }
                fMultiplexDriver4.setSubject(fSubject2);
                if (sDebug) {
                    fMultiplexManager.log("New driver : " + n7 + " Size:" + this.myInstances.size() + " (ID:" + this.myDriver.getId() + ")(Local:" + this.myDriver.getLocalId() + ")-" + n7 + " username " + fMultiplexDriver4.getSubject().getUser());
                }
                this.myServer.accept(fMultiplexDriver4, (fServerDriver)this.myDriver.getVendingDriver());
                break;
            }
            case 48: {
                byte[] byArray = new byte[8];
                this.readComplete(byArray);
                int n10 = this.unpackHeader(byArray, 0);
                int n11 = this.unpackHeader(byArray, 4);
                if (n11 != this.myRXId && sDebug) {
                    fMultiplexManager.log("Close RX id out of sync <" + n11 + " - " + this.myRXId + ">");
                }
                this.myRXId = n11 + 1;
                fMultiplexDriver fMultiplexDriver5 = this.remove(n10);
                if (fMultiplexDriver5 != null) {
                    if (sDebug) {
                        fMultiplexManager.log("close driver : " + n10 + " Left:" + this.myInstances.size() + " TXID:" + this.myTXId + " (ID:" + this.myDriver.getId() + ")(Local:" + this.myDriver.getLocalId() + ")-" + n10);
                    }
                    try {
                        fMultiplexDriver5.close();
                        break;
                    }
                    catch (fException fException2) {
                        throw new IOException(fException2.getMessage());
                    }
                }
                if (!sDebug) break;
                fMultiplexManager.log("close unknown driver : " + n10);
                break;
            }
            default: {
                this.handleDriverFailure(new Exception("Unknown command received : " + n));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.isOpen) {
            try {
                this.handleRead();
            }
            catch (Throwable throwable) {
                fMultiplexManager fMultiplexManager2 = this;
                synchronized (fMultiplexManager2) {
                    this.isOpen = false;
                    this.myReader = null;
                }
                if (this.myDriver.isClosed() || this.myInstances.size() == 0) continue;
                this.handleDriverFailure(throwable);
            }
        }
    }

    private synchronized fMultiplexDriver find(long l) {
        fMultiplexDriver fMultiplexDriver2 = this.myInstances.get(l);
        if (fMultiplexDriver2 == null) {
            return null;
        }
        return fMultiplexDriver2;
    }

    private synchronized fMultiplexDriver remove(long l) {
        fMultiplexDriver fMultiplexDriver2 = this.myInstances.remove(l);
        if (fMultiplexDriver2 == null) {
            return null;
        }
        return fMultiplexDriver2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDriverFailure(Throwable throwable) {
        if (throwable == null) {
            fConstants.logger.info("Unknown Exception");
        } else if (throwable instanceof EOFException) {
            fConstants.logger.warn("Driver error - " + throwable);
        } else {
            fConstants.logger.warn(throwable);
        }
        ArrayList<fMultiplexDriver> arrayList = new ArrayList<fMultiplexDriver>();
        fMultiplexManager fMultiplexManager2 = this;
        synchronized (fMultiplexManager2) {
            Iterator<fMultiplexDriver> object = this.myInstances.iterator();
            while (object.hasNext()) {
                arrayList.add(object.next());
            }
        }
        for (fMultiplexDriver fMultiplexDriver2 : arrayList) {
            try {
                fMultiplexDriver2.close();
            }
            catch (Exception exception) {}
        }
        try {
            this.myDriver.close();
        }
        catch (Exception exception) {
            fConstants.logger.warn(exception);
        }
        this.isOpen = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void send(int n, byte[] byArray) {
        block7: {
            try {
                if (byArray == null || byArray.length == 0) {
                    this.myOS.flush();
                    break block7;
                }
                OutputStream outputStream = this.myOS;
                synchronized (outputStream) {
                    byte[] byArray2 = new byte[13];
                    fMultiplexManager.packHeader(byArray2, (byte)16, n, byArray.length, this.myTXId++);
                    this.myOS.write(byArray2);
                    this.myOS.write(byArray);
                    if (sDebug) {
                        fMultiplexManager.log("Sending TX  <" + this.myTXId + "> Len:" + byArray.length + " (ID:" + this.myDriver.getId() + ")(Local:" + this.myDriver.getLocalId() + ")-" + n);
                    }
                }
                this.myOS.flush();
            }
            catch (Throwable throwable) {
                this.handleDriverFailure(throwable);
            }
        }
    }

    private void readFromStream(fMultiplexDriver fMultiplexDriver2, int n) throws IOException {
        byte[] byArray;
        int n2;
        boolean bl = false;
        for (n2 = n; n2 >= 10240; n2 -= 10240) {
            byArray = fMemoryManager.getInstance().allocateBuffer(10240);
            this.readComplete(byArray);
            fMultiplexDriver2.push(byArray);
            if (bl) continue;
            bl = true;
            if (fMultiplexDriver2.myListener == null) continue;
            fMultiplexDriver2.myListener.dataReady();
        }
        if (n2 > 0) {
            byArray = fMemoryManager.getInstance().allocateBuffer(n2);
            this.readComplete(byArray);
            fMultiplexDriver2.push(byArray);
        }
        if (fMultiplexDriver2.myListener != null) {
            fMultiplexDriver2.myListener.dataReady();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readComplete(byte[] byArray) throws IOException {
        InputStream inputStream = this.myIS;
        synchronized (inputStream) {
            int n;
            for (int i = 0; i < byArray.length; i += n) {
                n = this.myIS.read(byArray, i, byArray.length - i);
                if (n != -1) continue;
                throw new EOFException("Socket Stream reach EOF");
            }
        }
    }

    private int unpackHeader(byte[] byArray, int n) {
        int n2 = 24;
        long l = 0L;
        for (int i = 0; i < 4; ++i) {
            l = ((long)byArray[n + i] & 0xFFL) << n2 | l;
            n2 -= 8;
        }
        return (int)l;
    }

    private static void packHeader(byte[] byArray, byte by, int n, int n2, int n3) {
        int n4;
        byArray[0] = by;
        int n5 = 1;
        int n6 = 24;
        for (n4 = 0; n4 < 4; ++n4) {
            byArray[n5] = (byte)(n >> n6 & 0xFF);
            ++n5;
            n6 -= 8;
        }
        if (n2 != -1) {
            n6 = 24;
            for (n4 = 0; n4 < 4; ++n4) {
                byArray[n5] = (byte)(n2 >> n6 & 0xFF);
                ++n5;
                n6 -= 8;
            }
        }
        n6 = 24;
        for (n4 = 0; n4 < 4; ++n4) {
            byArray[n5] = (byte)(n3 >> n6 & 0xFF);
            ++n5;
            n6 -= 8;
        }
        if (n2 > 0) {
            // empty if block
        }
    }

    private static void packHeader(byte[] byArray, byte by, int n, int n2, int n3, byte[] byArray2) {
        int n4;
        byArray[0] = by;
        int n5 = 1;
        int n6 = 24;
        for (n4 = 0; n4 < 4; ++n4) {
            byArray[n5] = (byte)(n >> n6 & 0xFF);
            ++n5;
            n6 -= 8;
        }
        if (n2 != -1) {
            n6 = 24;
            for (n4 = 0; n4 < 4; ++n4) {
                byArray[n5] = (byte)(n2 >> n6 & 0xFF);
                ++n5;
                n6 -= 8;
            }
        }
        n6 = 24;
        for (n4 = 0; n4 < 4; ++n4) {
            byArray[n5] = (byte)(n3 >> n6 & 0xFF);
            ++n5;
            n6 -= 8;
        }
        byArray[n5] = (byte)(byArray2.length >> 8);
        byArray[++n5] = (byte)(byArray2.length & 0xFF);
        System.arraycopy(byArray2, 0, byArray, ++n5, byArray2.length);
        if (n2 > 0) {
            // empty if block
        }
    }

    private static void log(String string) {
        if (sDebug) {
            System.err.println(string);
            fConstants.logger.error("MultiplexManager: " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataReady() throws IOException {
        Object object = this.dataReadyLock;
        synchronized (object) {
            if (!this.isStarted) {
                this.isDataReady = true;
                return;
            }
            if (!this.isQueued && this.myReader == null) {
                this.isQueued = true;
                fThreadPool.getReadPool().addTask(this);
            }
        }
    }

    @Override
    public void close() {
        this.closer.scheduleCloser();
    }

    @Override
    public void execute() {
        try {
            while (this.myIS.available() != 0) {
                this.handleRead();
            }
        }
        catch (Exception exception) {
            this.handleDriverFailure(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reQueue() {
        if (this.isOpen && this.myReader == null) {
            Object object = this.dataReadyLock;
            synchronized (object) {
                try {
                    boolean bl = this.isQueued = this.myIS.available() != 0;
                    if (!this.isQueued) {
                        this.myDriver.resumeReading();
                    }
                    return this.isQueued;
                }
                catch (IOException iOException) {
                    this.handleDriverFailure(iOException);
                }
            }
        }
        return false;
    }

    private static class Closer
    implements fTask {
        private final fMultiplexManager myManager;
        boolean isQueued = false;

        Closer(fMultiplexManager fMultiplexManager2) {
            this.myManager = fMultiplexManager2;
        }

        synchronized void scheduleCloser() {
            if (!this.isQueued) {
                this.isQueued = true;
                fConnectionAsyncReadHandler.getClosePool().addTask(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() {
            this.myManager.handleDriverFailure(null);
            Closer closer = this;
            synchronized (closer) {
                this.isQueued = false;
            }
        }

        @Override
        public boolean reQueue() {
            return false;
        }
    }

    public final class fStreamReader
    extends fThread {
        public fStreamReader() {
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void run() {
            fMultiplexManager.this.run();
        }
    }
}

