/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers;

import com.pcbsys.foundation.drivers.jdk.fBufferManagement;
import com.pcbsys.foundation.drivers.jdk.fJDKHelper;

public class fNIOManager {
    private static boolean allowBufferReuse = true;
    private static boolean isAvailable = fNIOManager.test();
    private static boolean isAsyncNIOAvailable = fNIOManager.testAsync();
    private static boolean sUseDirectByteBuffers = true;
    private static int myBufferSize = 102400;
    private static int myBufferCount = 100;
    private static int myBufferManagerCount = 1;
    private static fBufferManagement[] myBufferManager;

    public static boolean available() {
        return isAvailable;
    }

    public static boolean asyncAvailable() {
        return fNIOManager.testAsync();
    }

    public static void setAvailable(boolean bl) {
        isAvailable = bl && fNIOManager.test() ? bl : false;
    }

    public static int getBufferManagerSize() {
        return myBufferManagerCount;
    }

    public static void setBufferManagerSize(int n) {
        myBufferManagerCount = n;
    }

    public static boolean useDirectByteBuffers() {
        return sUseDirectByteBuffers;
    }

    public static void setDirectByteBuffers(boolean bl) {
        if (bl != sUseDirectByteBuffers) {
            sUseDirectByteBuffers = bl;
        }
    }

    public static int getBufferSize() {
        return myBufferSize;
    }

    public static boolean allowBufferReuse() {
        return allowBufferReuse;
    }

    public static void allowBufferReuse(boolean bl) {
        allowBufferReuse = bl;
    }

    public static synchronized void setBufferSize(int n) {
        myBufferSize = n;
        if (isAvailable && myBufferManager != null) {
            for (int i = 0; i < myBufferManager.length; ++i) {
                myBufferManager[i].setBufferSize(n);
            }
        }
    }

    public static int getBufferCount() {
        return myBufferCount;
    }

    public static synchronized void setBufferCount(int n) {
        myBufferCount = n;
        if (isAvailable && myBufferManager != null) {
            for (int i = 0; i < myBufferManager.length; ++i) {
                myBufferManager[i].setBufferCount(n);
            }
        }
    }

    public static synchronized fBufferManagement[] getBufferManager() {
        if (!isAvailable) {
            return null;
        }
        if (myBufferManager == null) {
            myBufferManager = new fBufferManagement[myBufferManagerCount];
            for (int i = 0; i < myBufferManager.length; ++i) {
                fNIOManager.myBufferManager[i] = fJDKHelper.getNewBufferManagement();
            }
        }
        return myBufferManager;
    }

    protected static boolean test() {
        try {
            Class.forName("java.nio.ShortBuffer");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    protected static boolean testAsync() {
        try {
            Class.forName("java.nio.channels.CompletionHandler");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

