/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers;

import com.pcbsys.foundation.drivers.configuration.fBaseDriverConfig;
import com.pcbsys.foundation.drivers.configuration.fBaseSSLConfig;
import com.pcbsys.foundation.drivers.configuration.fDriverConfig;
import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.drivers.fSSLSocketDriver;
import com.pcbsys.foundation.drivers.fServerSocketDriver;
import com.pcbsys.foundation.drivers.fSubjectHelper;
import com.pcbsys.foundation.drivers.handlers.fAcceptHandler;
import com.pcbsys.foundation.drivers.jdk.fJDKHelper;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.threads.fThread;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.security.cert.X509Certificate;

public class fSSLServerSocketDriver
extends fServerSocketDriver {
    private boolean myClientRequired;

    public fSSLServerSocketDriver(fBaseDriverConfig fBaseDriverConfig2, fAcceptHandler fAcceptHandler2, String string) throws IOException {
        super(fBaseDriverConfig2, fAcceptHandler2, string);
    }

    @Override
    protected void createServerSocket(fBaseDriverConfig fBaseDriverConfig2) throws IOException {
        SSLContext sSLContext = (SSLContext)fJDKHelper.getSSLContextFactory().getContext((fBaseSSLConfig)((Object)fBaseDriverConfig2));
        SSLServerSocketFactory sSLServerSocketFactory = sSLContext.getServerSocketFactory();
        SSLServerSocket sSLServerSocket = (SSLServerSocket)sSLServerSocketFactory.createServerSocket(fBaseDriverConfig2.getPort(), fBaseDriverConfig2.getBacklog(), InetAddress.getByName(fBaseDriverConfig2.getAdapter()));
        sSLServerSocket.setReceiveBufferSize(fBaseDriverConfig2.getReadBufferSize());
        fBaseSSLConfig fBaseSSLConfig2 = (fBaseSSLConfig)((Object)fBaseDriverConfig2);
        sSLServerSocket.setNeedClientAuth(fBaseSSLConfig2.getCertRequired());
        if (fBaseSSLConfig2.getEnabledCiphers() != null) {
            sSLServerSocket.setEnabledCipherSuites(fBaseSSLConfig2.getEnabledCiphers());
        } else {
            fBaseSSLConfig2.setEnabledCiphers(sSLServerSocket.getEnabledCipherSuites());
        }
        fBaseSSLConfig2.setConfigredCiphers(sSLServerSocket.getSupportedCipherSuites());
        this.logCipherList(fBaseDriverConfig2, sSLServerSocket.getEnabledCipherSuites());
        this.myContext.setConnectionValidator(fSubjectHelper.loadValidator(fBaseDriverConfig2));
        this.myClientRequired = fBaseSSLConfig2.getCertRequired();
        this.myServerSocket = sSLServerSocket;
    }

    private void logCipherList(fDriverConfig fDriverConfig2, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            fConstants.logger.log("SSL CipherList for " + fDriverConfig2.getURL() + " " + stringArray[i]);
        }
    }

    @Override
    public boolean validate(fDriver fDriver2) throws IOException {
        if (fDriver2 instanceof fSSLSocketDriver) {
            HandshakeComplete handshakeComplete = new HandshakeComplete((SSLSocket)((fSSLSocketDriver)fDriver2).mySocket);
        }
        return true;
    }

    @Override
    protected fDriver createDriver(Socket socket) throws Exception {
        fSSLSocketDriver fSSLSocketDriver2 = new fSSLSocketDriver(socket, this.myContext);
        fSSLSocketDriver2.setProtocolId(this.myProtocolId);
        fSSLSocketDriver2.setRequireClientAuth(this.myClientRequired);
        return fSSLSocketDriver2;
    }

    private class HandshakeComplete
    implements HandshakeCompletedListener {
        SSLSocket aSocket;
        boolean handShakeEnded = false;

        public HandshakeComplete(SSLSocket sSLSocket) throws IOException {
            this.aSocket = sSLSocket;
            this.validate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void validate() throws IOException {
            X509Certificate[] x509CertificateArray;
            long l = 0L;
            if (fConstants.logger.isInfoEnabled()) {
                l = System.currentTimeMillis();
            }
            if (fConstants.logger.isDebugEnabled()) {
                fConstants.logger.debug("SSL handshake starting with remote host : " + this.aSocket.getInetAddress().getHostAddress());
            }
            Object object = this;
            synchronized (object) {
                this.aSocket.addHandshakeCompletedListener(this);
                try {
                    x509CertificateArray = new fSSLHandShake(this.aSocket);
                }
                catch (Throwable throwable) {
                    this.aSocket.close();
                    throw new IOException("Unable to allocate a SSL Handshake completion thread");
                }
                if (!this.handShakeEnded) {
                    try {
                        this.wait(fSSLServerSocketDriver.this.myTimeout);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (!this.handShakeEnded) {
                fConstants.logger.error("SSL handshake time out failure with remote host : " + this.aSocket.getInetAddress().getHostAddress());
                try {
                    this.aSocket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new IOException("Unable to complete SSL handshake within time frame");
            }
            if (fConstants.logger.isDebugEnabled()) {
                fConstants.logger.debug("SSL Handshake took " + (System.currentTimeMillis() - l));
            }
            if (fSSLServerSocketDriver.this.myClientRequired) {
                try {
                    object = this.aSocket.getSession();
                    x509CertificateArray = object.getPeerCertificateChain();
                    for (int i = 0; i < x509CertificateArray.length; ++i) {
                        x509CertificateArray[i].checkValidity();
                    }
                }
                catch (Exception exception) {
                    fConstants.logger.log("SSL Peer unverified. Peer host = " + fServerSocketDriver.sMyHostName + " Reason: " + exception.getMessage());
                    throw new IOException("SSL Peer unverified");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
            HandshakeComplete handshakeComplete = this;
            synchronized (handshakeComplete) {
                this.handShakeEnded = true;
                this.notify();
            }
            handshakeCompletedEvent.getSocket().removeHandshakeCompletedListener(this);
        }

        private class fSSLHandShake
        extends fThread {
            private SSLSocket mySSLSocket;

            public fSSLHandShake(SSLSocket sSLSocket) {
                this.mySSLSocket = sSLSocket;
                this.setName("SSL-HandshakeThread-" + sSLSocket.getInetAddress().getHostAddress());
                this.setDaemon(true);
                this.start();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    this.mySSLSocket.startHandshake();
                }
                catch (Exception exception) {
                    fConstants.logger.error("SSL handshake failure with remote host : " + this.mySSLSocket.getInetAddress().getHostAddress());
                    fConstants.logger.error(exception.getMessage());
                    try {
                        this.mySSLSocket.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    HandshakeComplete handshakeComplete = HandshakeComplete.this;
                    synchronized (handshakeComplete) {
                        HandshakeComplete.this.notify();
                    }
                }
            }
        }
    }
}

