/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers;

import com.pcbsys.foundation.base.fException;
import com.pcbsys.foundation.base.fFile;
import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.drivers.fConnectionDetails;
import com.pcbsys.foundation.drivers.fCustomKeyManager;
import com.pcbsys.foundation.drivers.fCustomNSSCryptoSocketFactory;
import com.pcbsys.foundation.drivers.fCustomNSSSocketFactory;
import com.pcbsys.foundation.drivers.fCustomSSLSocketFactory;
import com.pcbsys.foundation.drivers.fDriverConstants;
import com.pcbsys.foundation.drivers.fSSLDriver;
import com.pcbsys.foundation.drivers.fSocketDriver;
import com.pcbsys.foundation.drivers.fSubjectHelper;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fConnectionSettings;
import com.pcbsys.foundation.security.fClientLoginContext;
import com.pcbsys.foundation.security.fLoginContext;
import com.pcbsys.foundation.security.fLoginContextSSLAttributes;
import com.pcbsys.foundation.security.fSubject;
import com.pcbsys.foundation.threads.fScheduledTask;
import com.pcbsys.foundation.threads.fThreadScheduler;
import com.pcbsys.foundation.utils.fSystemConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509KeyManager;
import javax.security.cert.X509Certificate;

public class fSSLSocketDriver
extends fSocketDriver
implements fSSLDriver {
    private long myStartCloseTime = 0L;
    private boolean requireClientAuth = true;
    private KeyManager[] customKeyManager;

    fSSLSocketDriver(Socket socket, fLoginContext fLoginContext2) throws Exception {
        super(socket, fLoginContext2);
        this.myType = fConnectionDetails.getProtocolString(2);
    }

    public fSSLSocketDriver(String string, int n, fLoginContext fLoginContext2) throws Exception {
        super(string, n, fLoginContext2);
        this.myType = fConnectionDetails.getProtocolString(2);
    }

    public fSSLSocketDriver(String string, int n, fLoginContext fLoginContext2, Socket socket) throws Exception {
        super(fLoginContext2);
        this.myType = fConnectionDetails.getProtocolString(2);
        this.createSocket(socket, string, n);
        this.socketSetup();
    }

    protected void createSocket(Socket socket, String string, int n) throws IOException {
        SSLSocketFactory sSLSocketFactory;
        try {
            sSLSocketFactory = this.getSSLFact();
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IOException(exception);
        }
        SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(socket, string, n, false);
        SSLSession sSLSession = sSLSocket.getSession();
        try {
            X509Certificate[] x509CertificateArray = sSLSession.getPeerCertificateChain();
            X509Certificate x509Certificate = x509CertificateArray[x509CertificateArray.length - 1];
            x509Certificate.checkValidity();
        }
        catch (Exception exception) {
            if (!(exception instanceof ClassNotFoundException)) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new IOException(exception);
            }
            fConstants.logger.info(exception);
            fConstants.logger.info(exception);
        }
        this.mySocket = sSLSocket;
    }

    @Override
    protected void createSocket(String string, int n) throws IOException {
        SSLSocketFactory sSLSocketFactory;
        try {
            sSLSocketFactory = this.getSSLFact();
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IOException(exception);
        }
        SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket();
        sSLSocket.bind(null);
        sSLSocket.connect(new InetSocketAddress(string, n), fConnectionSettings.getSocketConnectTimeout());
        SSLSession sSLSession = sSLSocket.getSession();
        try {
            X509Certificate[] x509CertificateArray = sSLSession.getPeerCertificateChain();
            X509Certificate x509Certificate = x509CertificateArray[x509CertificateArray.length - 1];
            x509Certificate.checkValidity();
        }
        catch (Exception exception) {
            if (exception instanceof ClassNotFoundException) {
                fConstants.logger.info(exception);
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IOException(exception);
        }
        this.mySocket = sSLSocket;
    }

    private SSLSocketFactory getSSLFact() throws Exception {
        Object object;
        SSLSocketFactory sSLSocketFactory = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String[] stringArray = null;
        String string7 = null;
        String string8 = null;
        if (this.myAuthHandler instanceof fLoginContextSSLAttributes) {
            object = (fLoginContextSSLAttributes)((Object)this.myAuthHandler);
            string = object.getKeyStorePath();
            string2 = object.getKeyStorePass();
            string3 = object.getKeyStoreCert();
            string4 = object.getTrustStorePath();
            string5 = object.getTrustStorePass();
            string6 = object.getProtocol();
            stringArray = object.getEnabledCiphers();
            string7 = object.getPKCS11NSSConfigFile();
            string8 = object.getPKCS11NSSName();
        }
        if (fDriverConstants.sUseNSSFIPS) {
            sSLSocketFactory = new fCustomNSSSocketFactory(string2, string7, string8, string6, stringArray);
        } else if (fDriverConstants.sUseNSSCrypto) {
            sSLSocketFactory = new fCustomNSSCryptoSocketFactory(string, string2, string3, string4, string5, string6, stringArray, string7, string8);
        } else if (string != null || string4 != null || string6 != null) {
            sSLSocketFactory = new fCustomSSLSocketFactory(string, string2, string3, string4, string5, string6, stringArray);
        } else if (fConnectionSettings.sCertificateAlias != null && fConnectionSettings.sCertificateAlias.length() != 0) {
            try {
                object = SSLContext.getDefault().getDefaultSSLParameters().getProtocols()[0];
                SSLContext sSLContext = SSLContext.getInstance((String)object);
                if (this.customKeyManager == null) {
                    KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    try (KeyManager[] keyManagerArray = fFile.openFileInputStream(fSystemConfiguration.getProperty("javax.net.ssl.keyStore"));){
                        keyStore.load((InputStream)keyManagerArray, fSystemConfiguration.getProperty("javax.net.ssl.keyStorePassword").toCharArray());
                    }
                    keyManagerFactory.init(keyStore, fSystemConfiguration.getProperty("javax.net.ssl.keyStorePassword").toCharArray());
                    keyManagerArray = keyManagerFactory.getKeyManagers();
                    this.customKeyManager = new KeyManager[]{new fCustomKeyManager((X509KeyManager)keyManagerArray[0])};
                }
                sSLContext.init(this.customKeyManager, null, null);
                sSLSocketFactory = sSLContext.getSocketFactory();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            fConstants.logger.warn("Getting Default SSL SocketFactory");
            sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        return sSLSocketFactory;
    }

    void setRequireClientAuth(boolean bl) {
        this.requireClientAuth = bl;
    }

    @Override
    public boolean isRequireClientAuth() {
        return this.requireClientAuth;
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    @Override
    public fSubject getSubject() {
        fSubject fSubject2 = super.getSubject();
        if (fSubject2 == null) {
            fSubject2 = this.mySubject = fSubjectHelper.extractSubject("", this.mySocket, ((SSLSocket)this.mySocket).getSession(), this.requireClientAuth, this.myAuthHandler);
        }
        return fSubject2;
    }

    @Override
    public void updateResource(String string, Object[] objectArray) throws fException {
        if (this.myAuthHandler instanceof fClientLoginContext) {
            fClientLoginContext fClientLoginContext2 = (fClientLoginContext)this.myAuthHandler;
            fClientLoginContext2.setResource(string, objectArray);
            this.setSubject(fClientLoginContext2.getSubject());
        }
    }

    @Override
    public void close() throws IOException, fException {
        this.setClosed(true);
        CloseWatcher closeWatcher = new CloseWatcher();
        fThreadScheduler.getInstance().addTask(closeWatcher, 40000L);
        try {
            this.myAuthHandler.logout(this);
            super.remove();
            this.myStartCloseTime = fTimer.getTicks();
            try {
                this.mySocket.setSoLinger(false, 10);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mySocket.close();
            if (fTimer.getTicks() - this.myStartCloseTime > 1000L) {
                fConstants.logger.info("Socket Close took " + (fTimer.getTicks() - this.myStartCloseTime));
            }
            if (fConstants.logger.isDebugEnabled()) {
                fConstants.logger.debug("Protocol: NSPS: " + this.getId() + " disconnected.");
            }
        }
        finally {
            fThreadScheduler.getInstance().delTask(closeWatcher);
        }
    }

    @Override
    public SSLSession getSSLSession() {
        return ((SSLSocket)this.mySocket).getSession();
    }

    public static class CloseWatcher
    extends fScheduledTask {
        @Override
        public void execute() {
            fConstants.logger.error("SSL-Socket> Close thread is blocked");
        }

        @Override
        public String getName() {
            return "I/O Close monitor";
        }

        @Override
        public long reSchedule() {
            return -1L;
        }
    }
}

