/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers;

import com.pcbsys.foundation.base.fFile;
import com.pcbsys.foundation.drivers.fCustomKeyManager;
import com.pcbsys.foundation.utils.fSystemConfiguration;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509KeyManager;

public class fSSLSocketFactory
extends SSLSocketFactory {
    private SSLSocketFactory sslFact;

    @Override
    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        SSLSocketFactory sSLSocketFactory = this.getSSLSocketFactory();
        return sSLSocketFactory.createSocket(inetAddress, n);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        SSLSocketFactory sSLSocketFactory = this.getSSLSocketFactory();
        return sSLSocketFactory.createSocket(inetAddress, n, inetAddress2, n2);
    }

    @Override
    public Socket createSocket(String string, int n) throws IOException {
        SSLSocketFactory sSLSocketFactory = this.getSSLSocketFactory();
        return sSLSocketFactory.createSocket(string, n);
    }

    @Override
    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        SSLSocketFactory sSLSocketFactory = this.getSSLSocketFactory();
        return sSLSocketFactory.createSocket(string, n, inetAddress, n2);
    }

    @Override
    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException {
        SSLSocketFactory sSLSocketFactory = this.getSSLSocketFactory();
        return sSLSocketFactory.createSocket(socket, string, n, bl);
    }

    private SSLSocketFactory getSSLSocketFactory() {
        if (this.sslFact == null) {
            try {
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                FileInputStream fileInputStream = fFile.openFileInputStream(fSystemConfiguration.getProperty("javax.net.ssl.keyStore"));
                keyStore.load(fileInputStream, fSystemConfiguration.getProperty("javax.net.ssl.keyStorePassword").toCharArray());
                fileInputStream.close();
                keyManagerFactory.init(keyStore, fSystemConfiguration.getProperty("javax.net.ssl.keyStorePassword").toCharArray());
                KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
                SSLContext sSLContext = SSLContext.getInstance("TLS");
                sSLContext.init(new KeyManager[]{new fCustomKeyManager((X509KeyManager)keyManagerArray[0])}, null, null);
                this.sslFact = sSLContext.getSocketFactory();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.sslFact;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return ((SSLSocketFactory)SSLSocketFactory.getDefault()).getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return ((SSLSocketFactory)SSLSocketFactory.getDefault()).getSupportedCipherSuites();
    }
}

