/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers;

import com.pcbsys.foundation.base.fBaseObject;
import com.pcbsys.foundation.base.fException;
import com.pcbsys.foundation.base.fMonitor;
import com.pcbsys.foundation.base.fMonitorState;
import com.pcbsys.foundation.base.fMonitorable;
import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.drivers.configuration.fDriverConfig;
import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.drivers.fUsage;
import com.pcbsys.foundation.drivers.fVendorDriver;
import com.pcbsys.foundation.drivers.handlers.fAcceptHandler;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.security.auth.fAuthenticationException;
import com.pcbsys.foundation.security.fDriverConnectionMonitor;
import com.pcbsys.foundation.security.fDriverMonitorEntry;
import com.pcbsys.foundation.threads.fTask;
import com.pcbsys.foundation.threads.fThread;
import com.pcbsys.foundation.threads.fThreadPool;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.login.LoginException;
import javax.security.sasl.SaslException;

public abstract class fServerDriver
extends fBaseObject
implements fVendorDriver,
fMonitorable {
    private static final int sThreadPoolMinimumSize = 2;
    public static long myInactiveDriverTimeout = 300000L;
    protected final List<fDriver> myActive = Collections.synchronizedList(new ArrayList());
    protected final fAcceptHandler myAcceptHandler;
    private final fAcceptThread myAcceptThread;
    protected fUsage myUsage;
    protected final fDriverConnectionMonitor myConnectionMonitor;
    private final fThreadPool myThreadPool;
    protected boolean isActive;
    private AtomicLong myConCount = new AtomicLong(0L);
    private long myFailedCount = 0L;
    private long myAuthTime = 0L;
    private int myNoOfThreads;
    private String myName;
    private volatile boolean isClosed = false;
    private final boolean isVirtual;
    protected fDriverConfig config;

    public fServerDriver(fAcceptHandler fAcceptHandler2, fDriverConfig fDriverConfig2) {
        this.config = fDriverConfig2;
        this.myAcceptHandler = fAcceptHandler2;
        this.isActive = true;
        this.myName = this.config.getName();
        this.myNoOfThreads = this.config.getThreadCount();
        this.myUsage = new fUsage(this.myName);
        this.myConnectionMonitor = new fDriverConnectionMonitor("ServerDriver:" + this.config.getName(), this.config.getBacklog(), this.config.getAuthTimeOut(), 1);
        fMonitor.getInstance().add(this);
        this.myAcceptThread = new fAcceptThread(this);
        this.isVirtual = false;
        this.myThreadPool = new fThreadPool(this.myName, 2, this.myNoOfThreads);
    }

    protected fServerDriver(fAcceptHandler fAcceptHandler2, String string) {
        this.myAcceptHandler = fAcceptHandler2;
        this.isActive = true;
        this.myName = string;
        this.myNoOfThreads = 0;
        this.myUsage = new fUsage(this.myName);
        fMonitor.getInstance().add(this);
        this.myConnectionMonitor = null;
        this.isVirtual = false;
        this.myAcceptThread = null;
        this.myThreadPool = null;
    }

    public fDriverConfig getConfig() {
        return this.config;
    }

    public abstract boolean validate(fDriver var1) throws IOException;

    public void setName(String string) {
        this.myName = string;
    }

    public void close() throws IOException {
        this.myAcceptThread.stop();
        if (this.myConnectionMonitor != null) {
            this.myConnectionMonitor.close();
        }
        this.stop();
        this.myUsage.close();
        fMonitor.getInstance().del(this);
        this.isClosed = true;
        for (fDriver fDriver2 : new ArrayList<fDriver>(this.myActive)) {
            try {
                fDriver2.close();
            }
            catch (Exception exception) {}
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public fUsage getUsage() {
        return this.myUsage;
    }

    public fAcceptHandler getAcceptHandler() {
        return this.myAcceptHandler;
    }

    public int getCurrentConnections() {
        return this.myActive.size();
    }

    public long getZeroThreadTime() {
        return 0L;
    }

    public int getZeroThreadCount() {
        return 0;
    }

    public int getThreadIdleCount() {
        if (this.myThreadPool != null) {
            return this.myThreadPool.getIdleCount();
        }
        return 0;
    }

    public int getCurrentThreadSize() {
        if (this.myThreadPool != null) {
            return this.myThreadPool.getSize();
        }
        return 0;
    }

    public long getAuthTime() {
        return this.myAuthTime;
    }

    public abstract void setAuthenticationTimeout(long var1);

    public long getTotalConnections() {
        return this.myConCount.get();
    }

    public long getTotalFailedConnections() {
        return this.myFailedCount;
    }

    public void setCurrentThreadSize(int n) {
        this.myNoOfThreads = n;
        if (this.myThreadPool != null) {
            this.myThreadPool.setMaxSize(n);
        }
    }

    public abstract fDriver performAccept() throws IOException;

    public abstract String getName() throws IOException;

    @Override
    public void remove(fDriver fDriver2) {
        this.myActive.remove(fDriver2);
    }

    public void addDriverMonitor(fDriver fDriver2) {
        this.myActive.add(fDriver2);
    }

    protected void start() {
        this.myAcceptThread.begin();
    }

    protected void stop() {
        this.isActive = false;
        if (this.myThreadPool != null) {
            this.myThreadPool.close();
        }
    }

    public void completeDriverConnection(fDriver fDriver2) throws Exception {
        boolean bl = false;
        try {
            fDriver2.open();
        }
        catch (fException fException2) {
            if (!"Policy request received".equals(fException2.getMessage())) {
                throw fException2;
            }
            bl = true;
        }
        if (this.myAcceptHandler == null) {
            fConstants.logger.fatal("CommsServer: No accept handlers have been registered so can not process new connection");
            fDriver2.close();
        } else if (!bl) {
            this.myAcceptHandler.accept(fDriver2, this);
            this.myConCount.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public fMonitorState state() {
        if (this.isClosed) {
            fMonitor.getInstance().del(this);
            return fMonitorState.OK;
        }
        if (fConstants.logger.isDebugEnabled()) {
            fConstants.logger.debug("Monitor>Scanning " + this.myName + " for inactive drivers");
        }
        long l = fTimer.getTicks() - myInactiveDriverTimeout;
        List<fDriver> list = this.myActive;
        synchronized (list) {
            for (fDriver fDriver2 : this.myActive) {
                if (!fDriver2.isClosed() && fDriver2.getLastRead() >= l && fDriver2.getLastWrite() >= l) continue;
                return fMonitorState.FAIL;
            }
        }
        return fMonitorState.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rectify() throws Exception {
        long l = fTimer.getTicks() - myInactiveDriverTimeout;
        ArrayList<fDriver> arrayList = new ArrayList<fDriver>();
        List<fDriver> list = this.myActive;
        synchronized (list) {
            for (fDriver fDriver2 : this.myActive) {
                if (!fDriver2.isClosed() && fDriver2.getLastRead() >= l && fDriver2.getLastWrite() >= l) continue;
                arrayList.add(fDriver2);
            }
        }
        int n = arrayList.size();
        fConstants.logger.log("Monitor>Detected " + n + " inactive drivers bound to " + this.myName + ",  timeout(ms) " + myInactiveDriverTimeout);
        for (fDriver fDriver2 : arrayList) {
            if (fDriver2.isClosed()) {
                this.remove(fDriver2);
                continue;
            }
            try {
                long l2 = fTimer.getTicks();
                fConstants.logger.log("Monitor>Inactive driver on adapter " + this.myName + ", will be closed: " + fDriver2.getId() + " " + fDriver2.getSubject() + " time(ms) elapsed since last Read: " + (l2 - fDriver2.getLastRead()) + " Write: " + (l2 - fDriver2.getLastWrite()));
                fDriver2.close();
            }
            catch (Exception exception) {
                this.remove(fDriver2);
            }
        }
    }

    public fThreadPool getInterfaceThreadPool() {
        return this.myThreadPool;
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    private static class fWorkerTask
    implements fTask {
        private final fDriverMonitorEntry aDriver;
        private final fServerDriver myServerDriver;

        public fWorkerTask(fServerDriver fServerDriver2, fDriverMonitorEntry fDriverMonitorEntry2) {
            this.aDriver = fDriverMonitorEntry2;
            this.myServerDriver = fServerDriver2;
        }

        @Override
        public boolean reQueue() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() {
            block17: {
                this.myServerDriver.myAcceptThread.decrementOutstandingConnection();
                try {
                    if (this.aDriver == null) break block17;
                    this.myServerDriver.addDriverMonitor(this.aDriver.getDriver());
                    this.aDriver.getDriver().myServer = this.myServerDriver;
                    try {
                        long l = fTimer.getTicks();
                        if (this.myServerDriver.validate(this.aDriver.getDriver())) {
                            this.aDriver.getDriver().open();
                            if (this.myServerDriver.myAcceptHandler == null) {
                                fConstants.logger.fatal("CommsServer: No accept handlers have been registered so can not process new connection");
                                this.aDriver.getDriver().close();
                            } else if (!this.aDriver.getDriver().isClosed()) {
                                this.myServerDriver.myAcceptHandler.accept(this.aDriver.getDriver(), this.myServerDriver);
                                this.myServerDriver.myConCount.incrementAndGet();
                                l = fTimer.getTicks() - l;
                                if (l > 500L && fConstants.logger.isDebugEnabled() && fConstants.logger.isDebugEnabled()) {
                                    fConstants.logger.debug("CommsServer: Authentication took " + l + "ms");
                                }
                                fServerDriver fServerDriver2 = this.myServerDriver;
                                fServerDriver2.myAuthTime = fServerDriver2.myAuthTime + l;
                            }
                        }
                        this.myServerDriver.myConnectionMonitor.remove(this.aDriver);
                    }
                    catch (Throwable throwable) {
                        if (!"Policy request received".equals(throwable.getMessage())) {
                            try {
                                this.myServerDriver.myFailedCount++;
                                fConstants.logger.error("CommsServer: driver=" + this.aDriver.getDriver().getClass().getSimpleName() + "/" + this.aDriver.getDriver() + " - " + throwable);
                                if (!(throwable instanceof fException) || !(throwable.getCause() instanceof fAuthenticationException) && !(throwable.getCause() instanceof SaslException) && !(throwable.getCause() instanceof LoginException)) {
                                    fConstants.logger.error(throwable);
                                }
                                try {
                                    this.aDriver.getDriver().close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                break block17;
                            }
                            finally {
                                this.myServerDriver.remove(this.aDriver.getDriver());
                                this.myServerDriver.myConnectionMonitor.remove(this.aDriver);
                            }
                        }
                        this.myServerDriver.myConCount.incrementAndGet();
                        this.myServerDriver.myConnectionMonitor.remove(this.aDriver);
                    }
                }
                catch (Throwable throwable) {
                    if (this.myServerDriver.isClosed) break block17;
                    if (throwable instanceof IOException) {
                        fConstants.logger.info(throwable.toString());
                    }
                    fConstants.logger.warn(throwable);
                }
            }
        }
    }

    public static final class fAcceptThread
    extends fThread {
        private final fServerDriver myServerDriver;
        private final AtomicInteger currentOutstandingConnections = new AtomicInteger(0);
        private boolean running = true;
        private final AtomicBoolean threadStarted = new AtomicBoolean(false);

        public fAcceptThread(fServerDriver fServerDriver2) {
            this.myServerDriver = fServerDriver2;
            this.setName(this.myServerDriver.myName + " Accept Thread");
            this.setDaemon(true);
        }

        public void decrementOutstandingConnection() {
            this.currentOutstandingConnections.decrementAndGet();
        }

        public void begin() {
            this.threadStarted.getAndSet(true);
            this.start();
        }

        public void stop() {
            this.running = false;
            if (!this.threadStarted.get()) {
                this.begin();
                int n = 0;
                while (this.isAlive() && n++ < 100) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        @Override
        public void run() {
            while (this.running) {
                try {
                    fDriver fDriver2 = this.myServerDriver.performAccept();
                    if (fDriver2 == null) continue;
                    try {
                        if (this.currentOutstandingConnections.get() > this.myServerDriver.myConnectionMonitor.getMaxCount()) {
                            fConstants.logger.info("CommsServer: Backlog queue exceeded limit, unable to process incoming connection from " + fDriver2.getId());
                            try {
                                fDriver2.close();
                            }
                            catch (fException fException2) {}
                            continue;
                        }
                        fDriverMonitorEntry fDriverMonitorEntry2 = new fDriverMonitorEntry(fDriver2);
                        this.myServerDriver.myConnectionMonitor.add(fDriverMonitorEntry2);
                        this.myServerDriver.myThreadPool.addTask(new fWorkerTask(this.myServerDriver, fDriverMonitorEntry2));
                        this.currentOutstandingConnections.incrementAndGet();
                    }
                    catch (IOException iOException) {
                        fConstants.logger.info(iOException.getMessage());
                        try {
                            fDriver2.close();
                        }
                        catch (fException fException3) {
                        }
                    }
                }
                catch (IOException iOException) {
                    if (!this.running) continue;
                    fConstants.logger.error(iOException);
                }
            }
        }
    }
}

