/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers;

import com.pcbsys.foundation.base.fBaseObject;
import com.pcbsys.foundation.drivers.configuration.fBaseDriverConfig;
import com.pcbsys.foundation.drivers.configuration.fDriverConfig;
import com.pcbsys.foundation.drivers.configuration.fHTTPConfig;
import com.pcbsys.foundation.drivers.configuration.fHTTPSConfig;
import com.pcbsys.foundation.drivers.configuration.fRDMAConfig;
import com.pcbsys.foundation.drivers.configuration.fSSLConfig;
import com.pcbsys.foundation.drivers.configuration.fSharedMemoryConfig;
import com.pcbsys.foundation.drivers.configuration.fSocketConfig;
import com.pcbsys.foundation.drivers.fConnectionDetails;
import com.pcbsys.foundation.drivers.fServerDriver;
import com.pcbsys.foundation.drivers.fServerHTTPDriver;
import com.pcbsys.foundation.drivers.handlers.fAcceptHandler;
import com.pcbsys.foundation.drivers.jdk.fJDKHelper;
import com.pcbsys.foundation.drivers.rdma.fRDMAServerDriver;
import com.pcbsys.foundation.drivers.shm.fSHMServerDriver;
import com.pcbsys.foundation.system.memory.Constants;
import java.io.IOException;

public class fServerDriverFactory
extends fBaseObject {
    public static fServerDriver getServerDriver(fDriverConfig fDriverConfig2, fAcceptHandler fAcceptHandler2, String string) throws IOException {
        fServerDriver fServerDriver2 = null;
        int n = fConnectionDetails.getProtocolType(fDriverConfig2.getProtocol());
        if (string != null) {
            n = fConnectionDetails.getProtocolType(string);
        }
        switch (n) {
            case 0: {
                fServerDriver2 = fJDKHelper.getServerDriver((fBaseDriverConfig)fDriverConfig2, fAcceptHandler2, fDriverConfig2.getProtocol());
                break;
            }
            case 2: {
                fServerDriver2 = fJDKHelper.getSSLServerDriver((fBaseDriverConfig)fDriverConfig2, fAcceptHandler2, fDriverConfig2.getProtocol());
                break;
            }
            case 1: {
                fServerDriver2 = new fServerHTTPDriver((fBaseDriverConfig)fDriverConfig2, fAcceptHandler2);
                break;
            }
            case 3: {
                fServerDriver2 = new fServerHTTPDriver((fBaseDriverConfig)fDriverConfig2, fAcceptHandler2);
                break;
            }
            case 4: {
                fServerDriver2 = fJDKHelper.getServerDriver((fBaseDriverConfig)fDriverConfig2, fAcceptHandler2, string);
                break;
            }
            case 5: {
                fServerDriver2 = fJDKHelper.getSSLServerDriver((fBaseDriverConfig)fDriverConfig2, fAcceptHandler2, string);
                break;
            }
            case 12: {
                if (Constants.sMappingSupported) {
                    fServerDriver2 = new fSHMServerDriver((fSharedMemoryConfig)fDriverConfig2, fAcceptHandler2);
                    break;
                }
                throw new IOException("SHM protocol is not supported on current platform");
            }
            case 13: {
                fServerDriver2 = new fRDMAServerDriver((fRDMAConfig)fDriverConfig2, fAcceptHandler2);
                break;
            }
            default: {
                throw new IOException("Unsupported Protocol " + fDriverConfig2.getProtocol());
            }
        }
        return fServerDriver2;
    }

    public static fServerDriver getServerDriver(int n, String string, int n2, String string2, fAcceptHandler fAcceptHandler2, int n3, int n4) throws IOException {
        fDriverConfig fDriverConfig2 = null;
        switch (n) {
            case 0: {
                fDriverConfig2 = new fSocketConfig("NSP", string, n2);
                break;
            }
            case 2: {
                fDriverConfig2 = new fSSLConfig("NSPS", string, n2);
                break;
            }
            case 1: {
                fDriverConfig2 = new fHTTPConfig("NHP", string, n2);
                break;
            }
            case 3: {
                fDriverConfig2 = new fHTTPSConfig("NHPS", string, n2);
                break;
            }
            case 4: {
                fDriverConfig2 = new fSocketConfig("NSP", fConnectionDetails.getProtocolString(4), string, n2, false);
                break;
            }
            case 5: {
                fDriverConfig2 = new fSSLConfig("NSPS", string, n2, false);
            }
        }
        fDriverConfig2.setAuthTimeOut(n4);
        ((fBaseDriverConfig)fDriverConfig2).setThreadCount(n3);
        return fServerDriverFactory.getServerDriver((fBaseDriverConfig)fDriverConfig2, fAcceptHandler2);
    }

    public static fServerDriver getServerDriver(fBaseDriverConfig fBaseDriverConfig2, fAcceptHandler fAcceptHandler2) throws IOException {
        return fServerDriverFactory.getServerDriver(fBaseDriverConfig2, fAcceptHandler2, null);
    }
}

