/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers;

import com.pcbsys.foundation.base.fBaseObject;
import com.pcbsys.foundation.drivers.configuration.fBaseDriverConfig;
import com.pcbsys.foundation.drivers.configuration.fHTTPConfig;
import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.drivers.fHTTPDSession;
import com.pcbsys.foundation.drivers.fHTTPInstanceDriver;
import com.pcbsys.foundation.drivers.fNIOManager;
import com.pcbsys.foundation.drivers.handlers.fAcceptHandler;
import com.pcbsys.foundation.drivers.http.HttpHeaderDefinitions;
import com.pcbsys.foundation.drivers.http.fBaseCometDriver;
import com.pcbsys.foundation.drivers.http.fBaseHTTPDriver;
import com.pcbsys.foundation.drivers.http.fClientDriverMap;
import com.pcbsys.foundation.drivers.http.fCometDriver;
import com.pcbsys.foundation.drivers.http.fCookieGenerator;
import com.pcbsys.foundation.drivers.http.fHTTP10Driver;
import com.pcbsys.foundation.drivers.http.fHTTP11Driver;
import com.pcbsys.foundation.drivers.http.fHTTPDriver;
import com.pcbsys.foundation.drivers.http.fHTTPHeader;
import com.pcbsys.foundation.drivers.http.fLongPollDriver;
import com.pcbsys.foundation.drivers.http.fServerHTTPBaseDriver;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.security.auth.fAuthenticationException;
import com.pcbsys.foundation.security.fSubject;
import com.pcbsys.foundation.threads.fTask;
import com.pcbsys.foundation.threads.fThreadPool;
import com.pcbsys.foundation.utils.fStringByteConverter;
import java.io.IOException;
import java.io.InputStream;

public class fServerHTTPDriver
extends fServerHTTPBaseDriver {
    fServerHTTPDriver(fBaseDriverConfig fBaseDriverConfig2, fAcceptHandler fAcceptHandler2) throws IOException {
        super(fAcceptHandler2, (fHTTPConfig)fBaseDriverConfig2);
        if (fNIOManager.available() && fBaseDriverConfig2.isAllowNIO()) {
            fConstants.logger.warn("Protocol: HTTPD: Enabling HTTP1.1 since NIO is enabled");
        } else {
            fConstants.logger.warn("Protocol: HTTPD: Restricting to HTTP1.0 since NIO is not enabled");
        }
        this.commsInit();
    }

    @Override
    protected void handleRequestPacket(fHTTPHeader fHTTPHeader2, fHTTPDriver fHTTPDriver2, InputStream inputStream) throws Exception {
        if (fHTTPHeader2.getLongCookie() != 0L) {
            this.handleClientRequest(fHTTPHeader2, fHTTPDriver2, inputStream);
        } else {
            if (fConstants.logger.isWarningEnabled()) {
                if (fHTTPHeader2.getCookie() != null) {
                    fConstants.logger.warn("Protocol: HTTPD: Invalid protocol handshake detected. Has requested a request but no valid cookie. Warning " + fHTTPDriver2.getId() + " Supplied Cookie: " + new String(fHTTPHeader2.getCookie()));
                } else {
                    fConstants.logger.warn("Protocol: HTTPD: Invalid protocol handshake detected. Has requested a request but no valid cookie. Warning " + fHTTPDriver2.getId() + " Supplied Cookie: <Not Supplied>");
                }
            }
            fHTTPDriver2.sendNotOKHeaders();
            fHTTPDriver2.close();
        }
    }

    @Override
    public fAcceptHandler getAcceptHandler() {
        return this.myAcceptHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleClientRequest(fHTTPHeader fHTTPHeader2, fHTTPDriver fHTTPDriver2, InputStream inputStream) throws Exception {
        long l = fHTTPHeader2.getLongCookie();
        fHTTPInstanceDriver fHTTPInstanceDriver2 = this.mySessions.get(l);
        if (fHTTPInstanceDriver2 != null) {
            if (fHTTPInstanceDriver2 instanceof fLongPollDriver) {
                if (fHTTPInstanceDriver2.pushData(inputStream, fHTTPDriver2, fHTTPHeader2)) {
                    fHTTPHeader2.setCorsSupport(((fLongPollDriver)fHTTPInstanceDriver2).isCORSSupport());
                    fHTTPDriver2.sendOKHeaders(fHTTPHeader2, fHTTPHeader2.isCometCloseRequest());
                }
            } else {
                fHTTPInstanceDriver fHTTPInstanceDriver3 = fHTTPInstanceDriver2;
                synchronized (fHTTPInstanceDriver3) {
                    if (fHTTPInstanceDriver2.pushData(inputStream, fHTTPDriver2, fHTTPHeader2)) {
                        if (fHTTPInstanceDriver2 instanceof fCometDriver) {
                            fHTTPHeader2.setCorsSupport(((fCometDriver)fHTTPInstanceDriver2).isCORSSupport());
                            fHTTPHeader2.setCometChunking(((fCometDriver)fHTTPInstanceDriver2).isChunking());
                            fHTTPDriver2.sendOKHeaders(fHTTPHeader2, fHTTPHeader2.isCometCloseRequest());
                        } else {
                            fHTTPDriver2.sendOKHeaders(fHTTPHeader2, false);
                        }
                    }
                }
            }
            if (fConstants.logger.isDebugEnabled()) {
                fConstants.logger.debug("Protocol: HTTPD: " + fHTTPInstanceDriver2.getKey() + ": passing data to upstream driver " + fHTTPDriver2.getId() + " Len:" + fHTTPHeader2.ContentLength());
            }
            if (!fHTTPDriver2.supportMultipleRequests() && !fHTTPDriver2.isAllocated()) {
                fHTTPDriver2.close();
            }
        } else {
            fClientDriverMap fClientDriverMap2 = this.myUnauthorizedSessions;
            synchronized (fClientDriverMap2) {
                fHTTPInstanceDriver2 = this.myUnauthorizedSessions.get(l);
                if (fHTTPInstanceDriver2 != null) {
                    this.mySessions.put(fHTTPInstanceDriver2.getKey(), fHTTPInstanceDriver2);
                    fHTTPInstanceDriver fHTTPInstanceDriver4 = fHTTPInstanceDriver2;
                    synchronized (fHTTPInstanceDriver4) {
                        if (fHTTPInstanceDriver2 instanceof fCometDriver) {
                            fHTTPHeader2.setCorsSupport(((fCometDriver)fHTTPInstanceDriver2).isCORSSupport());
                            fHTTPHeader2.setCometChunking(((fCometDriver)fHTTPInstanceDriver2).isChunking());
                        }
                        if (fHTTPInstanceDriver2 instanceof fBaseCometDriver) {
                            fHTTPDriver2.sendOKHeaders(fHTTPHeader2, fHTTPHeader2.isCometCloseRequest());
                        } else {
                            fHTTPDriver2.sendOKHeaders(fHTTPHeader2, false);
                        }
                        fHTTPInstanceDriver2.pushData(inputStream, fHTTPDriver2, fHTTPHeader2);
                    }
                    if (!fHTTPDriver2.supportMultipleRequests() && !fHTTPDriver2.isAllocated()) {
                        fHTTPDriver2.close();
                    }
                    fThreadPool.getReadPool().addTask(new OpenConnection(fHTTPInstanceDriver2, fHTTPDriver2.getId(), this));
                } else {
                    if (fHTTPHeader2.getCookie() != null) {
                        fConstants.logger.log("Protocol: HTTPD: Invalid protocol handshake detected. Has cookie but no such session exists. Warning " + fHTTPDriver2.getId() + " Supplied Cookie: " + new String(fHTTPHeader2.getCookie()));
                    } else {
                        fConstants.logger.log("Protocol: HTTPD: Invalid protocol handshake detected. Has cookie but no such session exists. Warning " + fHTTPDriver2.getId() + " Supplied Cookie: <Not Supplied>");
                    }
                    fHTTPDriver2.sendNotOKHeaders();
                    fHTTPDriver2.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleConnectPacket(fHTTPHeader fHTTPHeader2, fHTTPDriver fHTTPDriver2) throws Exception {
        fBaseObject fBaseObject2;
        if (fHTTPHeader2.getLongCookie() != 0L) {
            if (fConstants.logger.isDebugEnabled()) {
                fConstants.logger.debug("Protocol: HTTPD: Initialising multiple HTTP Nirvana protocol for " + fHTTPDriver2.getId());
            }
            if ((fBaseObject2 = this.mySessions.get(fHTTPHeader2.getLongCookie())) != null) {
                ((fDriver)fBaseObject2).close();
                this.mySessions.remove(fHTTPHeader2.getLongCookie());
            }
        } else if (fConstants.logger.isDebugEnabled()) {
            fConstants.logger.debug("Protocol: HTTPD: Initialising HTTP Nirvana protocol for " + fHTTPDriver2.getId());
        }
        fBaseObject2 = null;
        if (this.isSSL) {
            fBaseObject2 = fHTTPDriver2.getSubject();
        }
        fServerHTTPDriver.handleCookie(fHTTPHeader2, (fSubject)fBaseObject2, fHTTPDriver2, this.myCookieId);
        fHTTPInstanceDriver fHTTPInstanceDriver2 = null;
        if (fHTTPHeader2.getConnectionType() == HttpHeaderDefinitions.ConnectionType.connect) {
            if (fHTTPDriver2 instanceof fHTTP11Driver) {
                fHTTPDriver2 = new fHTTP10Driver((fHTTP11Driver)fHTTPDriver2);
            }
            fHTTPInstanceDriver2 = new fHTTPDSession((fBaseHTTPDriver)fHTTPDriver2, this.myLoginCtx, (fSubject)fBaseObject2, fHTTPHeader2.getLongCookie(), fHTTPHeader2.ClientHostName(), this, fHTTPHeader2.getCookie());
            fHTTPInstanceDriver2.myServer = this;
            fClientDriverMap fClientDriverMap2 = this.myUnauthorizedSessions;
            synchronized (fClientDriverMap2) {
                this.myUnauthorizedSessions.put(fHTTPHeader2.getLongCookie(), fHTTPInstanceDriver2);
            }
            fHTTPDriver2.sendInitOKHeaders(fHTTPHeader2);
        } else {
            if (fHTTPHeader2.isLongPoll()) {
                fHTTPInstanceDriver2 = new fLongPollDriver(fHTTPDriver2, this.myLoginCtx, (fSubject)fBaseObject2, fHTTPHeader2, this);
                fHTTPInstanceDriver2.myServer = this;
                ((fLongPollDriver)fHTTPInstanceDriver2).setIdleWait(((fHTTPConfig)this.config).getAjaxLPIdleDelay());
                ((fLongPollDriver)fHTTPInstanceDriver2).setCompletionWait(((fHTTPConfig)this.config).getAjaxLPActiveDelay());
            } else if (fHTTPHeader2.getConnectionType() == HttpHeaderDefinitions.ConnectionType.connectJS) {
                if (fHTTPHeader2.isCometChunking() && fHTTPHeader2.getVersion() == HttpHeaderDefinitions.HttpVersion.version_1_0) {
                    fHTTPDriver2.sendNotOKHeaders();
                    if (fConstants.logger.isDebugEnabled()) {
                        fConstants.logger.debug("Protocol: HTTPD: Closed HTTP client handshake as request Chunked but HTTP version is 1.0 which is not possible driver ID: " + fHTTPDriver2.getId());
                    }
                    this.mySessions.remove(fHTTPHeader2.getLongCookie());
                    fHTTPDriver2.close();
                    return;
                }
                if (fHTTPHeader2.isCometChunking()) {
                    fHTTPDriver2.sendInitOKHeaders(fHTTPHeader2);
                } else {
                    if (fHTTPDriver2 instanceof fHTTP11Driver) {
                        fHTTPDriver2 = new fHTTP10Driver((fHTTP11Driver)fHTTPDriver2);
                    }
                    fHTTPDriver2.sendInitOKHeaders(fHTTPHeader2);
                }
                fHTTPInstanceDriver2 = new fCometDriver(fHTTPDriver2, this.myLoginCtx, (fSubject)fBaseObject2, fHTTPHeader2, this);
                fHTTPInstanceDriver2.myServer = this;
            }
            if (fHTTPInstanceDriver2 != null) {
                fHTTPInstanceDriver fHTTPInstanceDriver3 = this.mySessions.get(fHTTPHeader2.getLongCookie());
                if (fHTTPInstanceDriver3 != null) {
                    fHTTPInstanceDriver3.close();
                    this.mySessions.remove(fHTTPHeader2.getLongCookie());
                }
                this.mySessions.put(fHTTPHeader2.getLongCookie(), fHTTPInstanceDriver2);
                this.myAcceptHandler.accept(fHTTPInstanceDriver2, this);
                fHTTPInstanceDriver2.pushData(((fDriver)((Object)fHTTPDriver2)).getInputStream(), fHTTPDriver2, fHTTPHeader2);
            }
            if (fConstants.logger.isDebugEnabled()) {
                fConstants.logger.debug("Protocol: HTTPD: Finished HTTP client handshake. Attempting normal operation " + fHTTPDriver2.getId());
            }
        }
        if (fConstants.logger.isDebugEnabled()) {
            fConstants.logger.debug("Protocol: HTTPD: Waiting for client to finish initial handshake " + fHTTPDriver2.getId());
        }
    }

    private static void handleCookie(fHTTPHeader fHTTPHeader2, fSubject fSubject2, fHTTPDriver fHTTPDriver2, String string) {
        if (!fHTTPHeader2.hasCookie()) {
            if (fSubject2 != null) {
                fHTTPHeader2.setCookie(fStringByteConverter.convert(fCookieGenerator.generateHardenedSessionId(string, fSubject2.getHost(), fSubject2.getUser())));
            } else {
                fHTTPHeader2.setCookie(fStringByteConverter.convert(fCookieGenerator.generateHardenedSessionId(string, fHTTPDriver2.getId(), fHTTPDriver2.getId())));
            }
        }
    }

    private class OpenConnection
    implements fTask {
        private final fHTTPInstanceDriver myDriver;
        private final String myDriverID;
        private final fServerHTTPDriver myLocalServerDriver;

        private OpenConnection(fHTTPInstanceDriver fHTTPInstanceDriver2, String string, fServerHTTPDriver fServerHTTPDriver3) {
            this.myDriver = fHTTPInstanceDriver2;
            this.myDriverID = string;
            this.myLocalServerDriver = fServerHTTPDriver3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() {
            fClientDriverMap fClientDriverMap2 = fServerHTTPDriver.this.myUnauthorizedSessions;
            synchronized (fClientDriverMap2) {
                try {
                    this.myDriver.open();
                }
                catch (Throwable throwable) {
                    if (!fAuthenticationException.isReason(throwable, 2)) {
                        fConstants.logger.trace("Protocol: HTTPD: Failed to connect session " + this.myDriverID + " - " + throwable);
                    }
                    fServerHTTPDriver.this.myUnauthorizedSessions.remove(this.myDriver.getKey());
                    try {
                        this.myDriver.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                fServerHTTPDriver.this.myAcceptHandler.accept(this.myDriver, this.myLocalServerDriver);
                fServerHTTPDriver.this.myUnauthorizedSessions.remove(this.myDriver.getKey());
                fConstants.logger.trace("Protocol: HTTPD: Finished HTTP client handshake. Attempting normal operation " + this.myDriverID);
                fConstants.logger.trace("Protocol: HTTPD: Correctly established session " + fStringByteConverter.convert(this.myDriver.getCookieAsBytes()));
            }
        }

        @Override
        public boolean reQueue() {
            return false;
        }
    }
}

