/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers;

import com.pcbsys.foundation.drivers.configuration.fBaseDriverConfig;
import com.pcbsys.foundation.drivers.fConnectionDetails;
import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.drivers.fServerDriver;
import com.pcbsys.foundation.drivers.fSocketDriver;
import com.pcbsys.foundation.drivers.handlers.fAcceptHandler;
import com.pcbsys.foundation.drivers.jdk.fJDKHelper;
import com.pcbsys.foundation.security.fServerLoginContext;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class fServerSocketDriver
extends fServerDriver {
    protected static String sMyHostName = fServerSocketDriver.hostName();
    protected ServerSocket myServerSocket;
    protected String myProtocolId;
    protected int myTimeout;
    protected fServerLoginContext myContext;
    protected fConnectionDetails myConDetails;
    protected int myRecvBufferSize;
    protected int mySendBufferSize;

    private static String hostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            return "localhost";
        }
    }

    public fServerSocketDriver(fBaseDriverConfig fBaseDriverConfig2, fAcceptHandler fAcceptHandler2, String string) throws IOException {
        super(fAcceptHandler2, fBaseDriverConfig2);
        this.myContext = fServerLoginContext.getInstance(string);
        this.myContext.setConfig(fBaseDriverConfig2);
        this.myRecvBufferSize = fBaseDriverConfig2.getReadBufferSize();
        this.mySendBufferSize = fBaseDriverConfig2.getWriteBufferSize();
        this.createServerSocket(fBaseDriverConfig2);
        this.myProtocolId = string;
        this.myTimeout = fBaseDriverConfig2.getAuthTimeOut();
        this.myConDetails = new fConnectionDetails(fBaseDriverConfig2.getURL());
        this.start();
    }

    protected void createServerSocket(fBaseDriverConfig fBaseDriverConfig2) throws IOException {
        this.myServerSocket = new ServerSocket();
        this.myServerSocket.setReceiveBufferSize(fBaseDriverConfig2.getReadBufferSize());
        InetSocketAddress inetSocketAddress = fBaseDriverConfig2.getAdapter().equals("0.0.0.0") ? new InetSocketAddress(fBaseDriverConfig2.getPort()) : new InetSocketAddress(InetAddress.getByName(fBaseDriverConfig2.getAdapter()), fBaseDriverConfig2.getPort());
        this.myServerSocket.bind(inetSocketAddress, fBaseDriverConfig2.getBacklog());
    }

    @Override
    public fDriver performAccept() throws IOException {
        Socket socket = this.myServerSocket.accept();
        fJDKHelper.setupSocket(socket, this.myRecvBufferSize, this.mySendBufferSize);
        try {
            socket.setSoTimeout(this.myTimeout);
            return this.createDriver(socket);
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    @Override
    public boolean validate(fDriver fDriver2) throws IOException {
        return true;
    }

    @Override
    public void setAuthenticationTimeout(long l) {
        this.myTimeout = (int)l;
    }

    @Override
    public void close() throws IOException {
        this.stop();
        this.myServerSocket.close();
        super.close();
    }

    @Override
    public String getName() throws IOException {
        return InetAddress.getLocalHost().getHostAddress();
    }

    protected fDriver createDriver(Socket socket) throws Exception {
        fSocketDriver fSocketDriver2 = new fSocketDriver(socket, this.myContext);
        fSocketDriver2.setProtocolId(this.myProtocolId);
        return fSocketDriver2;
    }
}

