/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers;

import com.pcbsys.foundation.base.fException;
import com.pcbsys.foundation.drivers.fConnectionDetails;
import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.drivers.jdk.fJDKHelper;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.security.fDefaultLoginContext;
import com.pcbsys.foundation.security.fLoginContext;
import com.pcbsys.foundation.utils.fReverseDNSUtility;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;

public class fSocketDriver
extends fDriver {
    Socket mySocket;
    private OutputStream out;
    private InputStream in;

    public fSocketDriver(Socket socket, fLoginContext fLoginContext2) throws Exception {
        super(fLoginContext2);
        this.mySocket = socket;
        this.myType = fConnectionDetails.getProtocolString(0);
        this.socketSetup();
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public boolean isRequireClientAuth() {
        return false;
    }

    public fSocketDriver(String string, int n, fLoginContext fLoginContext2) throws Exception {
        super(fLoginContext2);
        this.myType = fConnectionDetails.getProtocolString(0);
        this.createSocket(string, n);
        try {
            fJDKHelper.setupSocket(this.mySocket);
        }
        catch (Exception exception) {
            fConstants.logger.info("Unable to set socket options for optimal performance : " + exception.getMessage());
        }
        this.socketSetup();
    }

    fSocketDriver(fLoginContext fLoginContext2) throws Exception {
        super(fLoginContext2);
        this.myType = fConnectionDetails.getProtocolString(0);
    }

    protected void createSocket(String string, int n) throws IOException {
        this.mySocket = fJDKHelper.createSocket(string, n);
    }

    void socketSetup() throws Exception {
        this.in = new BufferedInputStream(new SocketInput(this.mySocket.getInputStream()));
        this.out = new BufferedOutputStream(new SocketOutput(this.mySocket.getOutputStream()));
    }

    @Override
    public boolean supportAsyncReading() {
        return false;
    }

    @Override
    public boolean supportAsyncWriting() {
        return false;
    }

    @Override
    public String getId() {
        if (this.myID == null) {
            this.myID = this.mySocket.getInetAddress().getHostAddress() + ":" + this.mySocket.getPort();
        }
        return this.myID;
    }

    @Override
    public String getLocalId() {
        if (this.myLocalID == null) {
            this.myLocalID = this.mySocket.getLocalAddress().getHostAddress() + ":" + this.mySocket.getLocalPort();
        }
        return this.myLocalID;
    }

    @Override
    public int getLocalPort() {
        return this.mySocket.getLocalPort();
    }

    @Override
    public void updateResource(String string, Object[] objectArray) throws fException {
        if (this.myAuthHandler instanceof fDefaultLoginContext) {
            fDefaultLoginContext fDefaultLoginContext2 = (fDefaultLoginContext)this.myAuthHandler;
            fDefaultLoginContext2.setResource(string, objectArray);
            this.setSubject(fDefaultLoginContext2.getSubject());
        }
    }

    @Override
    public int getTimeout() {
        try {
            return this.mySocket.getSoTimeout();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    public void setTimeout(int n) {
        try {
            this.mySocket.setSoTimeout(n);
        }
        catch (Exception exception) {
            fConstants.logger.error("Unable to set time out on socket : Exception > " + exception.getMessage());
        }
    }

    @Override
    public fConnectionDetails getConnectionDetails() {
        int n = 0;
        int n2 = 0;
        String string = fReverseDNSUtility.resolveAddress(this.mySocket.getInetAddress());
        try {
            n = this.mySocket.getLocalPort();
            if (this.myProtocolId != null) {
                n2 = fConnectionDetails.getProtocolType(this.myProtocolId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new fConnectionDetails(n2, string, n, "");
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.createInputStream(this.in);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.createOutputStream(this.out);
    }

    @Override
    public void close() throws IOException, fException {
        super.close();
        try {
            this.mySocket.setSoLinger(false, 10);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mySocket.close();
        if (fConstants.logger.isDebugEnabled()) {
            fConstants.logger.debug("Protocol: NSP: " + this.getId() + " disconnected.");
        }
    }

    public InetAddress getLocalAddress() {
        return this.mySocket.getLocalAddress();
    }

    public class SocketOutput
    extends OutputStream {
        private OutputStream mySource;

        SocketOutput(OutputStream outputStream) {
            this.mySource = outputStream;
        }

        @Override
        public void flush() throws IOException {
            fSocketDriver.this.setLastRead();
            this.mySource.flush();
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.mySource.write(byArray);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.mySource.write(byArray, n, n2);
        }

        @Override
        public void write(int n) throws IOException {
            this.mySource.write(n);
        }
    }

    public class SocketInput
    extends InputStream {
        private InputStream mySource;

        SocketInput(InputStream inputStream) {
            this.mySource = inputStream;
        }

        @Override
        public int available() throws IOException {
            return this.mySource.available();
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            fSocketDriver.this.setLastRead();
            return this.mySource.read(byArray);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            fSocketDriver.this.setLastRead();
            return this.mySource.read(byArray, n, n2);
        }

        @Override
        public int read() throws IOException {
            fSocketDriver.this.setLastRead();
            return this.mySource.read();
        }

        @Override
        public long skip(long l) throws IOException {
            throw new IOException("Not Supported");
        }

        @Override
        public void close() throws IOException {
            throw new IOException("Not Supported");
        }

        @Override
        public synchronized void mark(int n) {
            throw new Error("Not Supported");
        }

        @Override
        public synchronized void reset() throws IOException {
            throw new IOException("Not Supported");
        }

        @Override
        public boolean markSupported() {
            throw new Error("Not Supported");
        }
    }
}

