/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers;

import com.pcbsys.foundation.collections.Vector;
import com.pcbsys.foundation.drivers.configuration.fBaseSSLConfig;
import com.pcbsys.foundation.drivers.configuration.fDriverConfig;
import com.pcbsys.foundation.drivers.fCRLHandler;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.security.fConnectionValidator;
import com.pcbsys.foundation.security.fCredential;
import com.pcbsys.foundation.security.fLoginContext;
import com.pcbsys.foundation.security.fPrincipal;
import com.pcbsys.foundation.security.fServerLoginContext;
import com.pcbsys.foundation.security.fSubject;
import com.pcbsys.foundation.utils.fReverseDNSUtility;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.Socket;
import java.util.StringTokenizer;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.CertificateExpiredException;
import javax.security.cert.CertificateNotYetValidException;
import javax.security.cert.X509Certificate;

public class fSubjectHelper {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static fConnectionValidator loadValidator(fDriverConfig fDriverConfig2) throws IOException {
        fConnectionValidator fConnectionValidator2 = null;
        if (!(fDriverConfig2 instanceof fBaseSSLConfig)) return fConnectionValidator2;
        fBaseSSLConfig fBaseSSLConfig2 = (fBaseSSLConfig)((Object)fDriverConfig2);
        if (fBaseSSLConfig2.getCRL() == null) return fConnectionValidator2;
        try {
            if (fBaseSSLConfig2.getCRLClassName() == null) return new fCRLHandler(fBaseSSLConfig2.getCRL());
            Class<?> clazz = Class.forName(fBaseSSLConfig2.getCRLClassName());
            if (clazz == null) return fConnectionValidator2;
            Class[] classArray = new Class[]{String.class, String.class};
            Object var5_6 = null;
            Constructor<?> constructor = clazz.getConstructor(classArray);
            if (constructor != null) {
                Object[] objectArray = new Object[]{fDriverConfig2.getName(), fBaseSSLConfig2.getCRL()};
                var5_6 = constructor.newInstance(objectArray);
            } else {
                var5_6 = clazz.newInstance();
            }
            if (!(var5_6 instanceof fConnectionValidator)) throw new Exception("Class " + fBaseSSLConfig2.getCRLClassName() + " is not of required type, please contact support");
            fConnectionValidator2 = var5_6;
            fConstants.logger.log("Security, loaded certificate revocation class " + fBaseSSLConfig2.getCRLClassName());
            return fConnectionValidator2;
        }
        catch (Exception exception) {
            fConstants.logger.fatal(exception);
            throw new IOException("Unable to load CRL : " + exception.getMessage());
        }
    }

    public static fSubject extractSubject(String string, Socket socket, SSLSession sSLSession, boolean bl, fLoginContext fLoginContext2) {
        fSubject fSubject2 = null;
        boolean bl2 = true;
        X509Certificate[] x509CertificateArray = null;
        if (bl) {
            try {
                x509CertificateArray = sSLSession.getPeerCertificateChain();
                Vector<fPrincipal> vector = new Vector<fPrincipal>();
                Vector<fCredential> vector2 = new Vector<fCredential>();
                fPrincipal fPrincipal2 = null;
                try {
                    fServerLoginContext fServerLoginContext2;
                    if (fLoginContext2 instanceof fServerLoginContext && (fServerLoginContext2 = (fServerLoginContext)fLoginContext2).getConnectionValidator() != null && !fServerLoginContext2.getConnectionValidator().isValid(string, socket.getRemoteSocketAddress(), sSLSession.getPeerCertificates())) {
                        bl2 = false;
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                for (int i = 0; i < x509CertificateArray.length; ++i) {
                    try {
                        Object object;
                        Object object2;
                        x509CertificateArray[i].checkValidity();
                        if (i == 0) {
                            object2 = x509CertificateArray[i].getSubjectDN().getName();
                            object = fSubjectHelper.extractCN((String)object2);
                            String string2 = fReverseDNSUtility.resolveAddress(socket.getInetAddress());
                            fPrincipal2 = new fPrincipal((String)object + "@" + string2);
                            fPrincipal2.setHashCode(98);
                            vector.add(fPrincipal2);
                        }
                        object2 = new fPrincipal(x509CertificateArray[i].getSubjectDN().toString());
                        ((fPrincipal)object2).setHashCode(98 - (i + 1));
                        vector.add((fPrincipal)object2);
                        object = new fCredential("SerialNumber", x509CertificateArray[i].getSerialNumber().toByteArray());
                        vector2.add((fCredential)object);
                        continue;
                    }
                    catch (CertificateExpiredException certificateExpiredException) {
                        fConstants.logger.log("Certificate has expired, id=" + socket.getInetAddress().toString() + " Not After:" + x509CertificateArray[i].getNotAfter().toString());
                        bl2 = false;
                        continue;
                    }
                    catch (CertificateNotYetValidException certificateNotYetValidException) {
                        fConstants.logger.log("Certificate not yet valid, id=" + socket.getInetAddress().toString() + " Not Before:" + x509CertificateArray[i].getNotBefore().toString());
                        bl2 = false;
                    }
                }
                fSubject2 = new fSubject(vector, vector2, null, true);
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                fConstants.logger.log("SSL Peer unverified. Peer host = " + socket.getInetAddress().toString() + " Reason:" + sSLPeerUnverifiedException.getMessage());
                bl2 = false;
            }
            if (!bl2) {
                fConstants.logger.log("Session will now be terminated for " + socket.getInetAddress().toString());
                try {
                    socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                fSubject2 = null;
            } else if (fConstants.logger.isDebugEnabled()) {
                fConstants.logger.debug("Certificate validated successfully for " + socket.getInetAddress().toString());
                for (int i = 0; i < x509CertificateArray.length; ++i) {
                    fConstants.logger.debug("Cert[" + i + "] DN = " + x509CertificateArray[i].getSubjectDN().toString());
                    fConstants.logger.debug("Cert[" + i + "] Serial Number = " + x509CertificateArray[i].getSerialNumber().toString());
                }
            }
        }
        return fSubject2;
    }

    public static String extractCN(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        StringBuilder stringBuilder = new StringBuilder();
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = stringTokenizer.nextToken();
            int n = string3.indexOf("=");
            if (n == -1 || !(string2 = string3.substring(0, n).trim()).equalsIgnoreCase("CN")) continue;
            stringBuilder.append(string3.substring(n + 1).trim());
        }
        return stringBuilder.toString();
    }
}

