/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers;

import com.pcbsys.foundation.base.fException;
import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.drivers.fConnectionDetails;
import com.pcbsys.foundation.drivers.fCustomSSLSocketFactory;
import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.drivers.http.HttpHeaderDefinitions;
import com.pcbsys.foundation.drivers.jdk.URLHandler.fHTTPResponse;
import com.pcbsys.foundation.drivers.jdk.URLHandler.fURLHandler;
import com.pcbsys.foundation.drivers.jdk.fJDKHelper;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fConnectionSettings;
import com.pcbsys.foundation.security.fClientLoginContext;
import com.pcbsys.foundation.security.fLoginContext;
import com.pcbsys.foundation.security.fLoginContextSSLAttributes;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.StringTokenizer;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;

public class fURLDriver
extends fDriver {
    private static String sMyServletParam = "";
    private static final int sMyRetryCount = 6;
    private static final int sMyRetrySleep = 500;
    private static final int sReadTimeout = 120000;
    private final SSLSocketFactory mySSLSocketFactory;
    private fURLHandler con;
    private OutputStream myOs;
    private URL request;
    private String myCookie;
    private String myRequestCookie;
    private String myHTTPCookie;
    private InputStream myIn;
    private boolean isSSL;

    public fURLDriver(String string, int n, String string2, fLoginContext fLoginContext2, boolean bl) throws fException, CertificateException, UnrecoverableKeyException, NoSuchAlgorithmException, IOException, KeyManagementException, KeyStoreException {
        super(fLoginContext2);
        this.isSSL = bl;
        this.myOs = new fURLOutputStream();
        super.setID("Not Connected");
        String string3 = "http";
        this.myType = "nhp";
        if (bl) {
            string3 = "https";
            this.myType = "nhps";
            fLoginContextSSLAttributes fLoginContextSSLAttributes2 = (fLoginContextSSLAttributes)((Object)this.myAuthHandler);
            this.mySSLSocketFactory = fLoginContextSSLAttributes2.getKeyStorePath() != null || fLoginContextSSLAttributes2.getTrustStorePath() != null || fLoginContextSSLAttributes2.getProtocol() != null ? new fCustomSSLSocketFactory(fLoginContextSSLAttributes2.getKeyStorePath(), fLoginContextSSLAttributes2.getKeyStorePass(), fLoginContextSSLAttributes2.getKeyStoreCert(), fLoginContextSSLAttributes2.getTrustStorePath(), fLoginContextSSLAttributes2.getTrustStorePass(), fLoginContextSSLAttributes2.getProtocol(), fLoginContextSSLAttributes2.getEnabledCiphers()) : null;
        } else {
            this.mySSLSocketFactory = null;
        }
        if (fConstants.logger.isInfoEnabled()) {
            fURLDriver.debugLog("URL Driver initialisation started: Protocol : " + this.myType + " Server : " + string + " Port : " + n);
        }
        try {
            string2 = string2 == null ? sMyServletParam : string2 + sMyServletParam;
            this.request = new URL(string3, string, n, string2);
            if (fConstants.logger.isInfoEnabled()) {
                fURLDriver.debugLog("URL Driver configuring remote connection object");
            }
            this.con = fJDKHelper.getURLHandler(this.request, this.mySSLSocketFactory);
            this.con.setRequestProperty("Connection-Type", HttpHeaderDefinitions.ConnectionType.connect.toString());
            this.con.setDoOutput(true);
            this.con.setUseCaches(false);
            this.con.setReadTimeOut(120000);
        }
        catch (Throwable throwable) {
            fConstants.logger.error(throwable);
            this.con.abort();
            throw new fException("Driver failure", throwable);
        }
        try {
            long l = fTimer.currentTimeMillis();
            this.makeConnection();
            if (fConstants.logger.isInfoEnabled()) {
                fURLDriver.debugLog("URL Driver time taken to establish physical connection with host " + (fTimer.currentTimeMillis() - l) + "ms, Cookie=" + this.myCookie);
            }
            super.setID(string + ":" + n);
        }
        catch (Throwable throwable) {
            this.con.abort();
            if (throwable instanceof IOException) {
                String string4 = "NHP;";
                if (bl) {
                    string4 = "NHPS";
                }
                fConstants.logger.error("Failed to initialise fURLDriver for " + string + ":" + n + "/ssl=" + bl + " with LoginContext=" + fLoginContext2 + ". Ensure the interface you are connecting to is an " + string4 + " interface - " + throwable);
                if (throwable.getCause() != null && throwable.getCause() instanceof SSLException) {
                    throw new fException(throwable.getCause());
                }
            } else {
                fConstants.logger.error(throwable);
            }
            throw new fException(throwable);
        }
    }

    @Override
    public boolean isSecure() {
        return this.isSSL;
    }

    @Override
    public boolean isRequireClientAuth() {
        return false;
    }

    @Override
    public boolean supportAsyncReading() {
        return false;
    }

    @Override
    public boolean supportAsyncWriting() {
        return false;
    }

    @Override
    public int getLocalPort() {
        return 0;
    }

    @Override
    public int getTimeout() {
        return 0;
    }

    public static void setHTTPURLParameter(String string) {
        sMyServletParam = string;
    }

    @Override
    public fConnectionDetails getConnectionDetails() {
        if (this.myConnDet == null) {
            String string = null;
            int n = 0;
            int n2 = 1;
            try {
                string = this.request.getHost();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                n = this.request.getPort();
                n2 = fConnectionDetails.getProtocolType(this.myProtocolId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.myConnDet = new fConnectionDetails(n2, string, n, "");
        }
        return this.myConnDet;
    }

    @Override
    public void setTimeout(int n) {
        this.con.setConnectTimeOut(n);
    }

    @Override
    public void updateResource(String string, Object[] objectArray) throws fException {
        if (this.myAuthHandler instanceof fClientLoginContext) {
            fClientLoginContext fClientLoginContext2 = (fClientLoginContext)this.myAuthHandler;
            fClientLoginContext2.setResource(string, objectArray);
            this.setSubject(fClientLoginContext2.getSubject());
        }
    }

    @Override
    public void open() throws IOException, fException {
        super.open();
        fConstants.logger.info(this.getType().toUpperCase() + " User " + this.getSubject() + " logged in.");
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.createInputStream(this.myIn);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.createOutputStream(this.myOs);
    }

    @Override
    public String getId() {
        return this.myID;
    }

    @Override
    public String getLocalId() {
        return this.myLocalID;
    }

    @Override
    public void close() throws IOException, fException {
        if (fConstants.logger.isInfoEnabled()) {
            fURLDriver.debugLog("URL Driver close() requested");
        }
        if (this.con != null) {
            this.con.close();
            if (fConstants.logger.isDebugEnabled()) {
                fConstants.logger.debug("fURLDriver : closed httpURLConnection, client will now reconnect");
            }
        }
        this.myOs.close();
        super.close();
        fConstants.logger.info(this.getType() + " User " + this.getSubject() + " logged out.");
    }

    public String get3rdPartyCookies() {
        if (fConnectionSettings.getHonour3rdPartyCookies()) {
            return this.myHTTPCookie;
        }
        return null;
    }

    private void makeConnection() throws IOException {
        Object object;
        int n;
        Object object2;
        this.con.connect();
        if (fConnectionSettings.getHonour3rdPartyCookies() && (object2 = this.con.getHeaderField("Set-Cookie")) != null && (n = ((String)object2).indexOf(";")) != -1) {
            object = new StringTokenizer((String)object2, ";");
            StringBuilder stringBuilder = null;
            while (((StringTokenizer)object).hasMoreElements()) {
                String string = ((StringTokenizer)object).nextToken().trim();
                if (string.startsWith("path")) continue;
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(string);
                } else {
                    stringBuilder.append(string);
                }
                stringBuilder.append(";");
            }
            if (stringBuilder != null) {
                this.myHTTPCookie = stringBuilder.toString();
            }
        }
        this.myCookie = this.con.getHeaderField("SessionId");
        if (this.myCookie == null) {
            object2 = null;
            try {
                object2 = this.con.getHeaderField(0);
            }
            catch (Exception exception) {
                fConstants.logger.log(".getHeaderField caused an exception - " + exception);
            }
            if (object2 == null) {
                fConstants.logger.log("fURLDriver: response is null");
                object2 = "[unknown - null returned]";
            }
            if (fConstants.logger.isDebugEnabled()) {
                fConstants.logger.debug("fURLDriver: Could not establish session cookie:" + (String)object2);
            }
            throw new IOException("Could not establish session cookie");
        }
        this.myCookie = this.myCookie.trim();
        if (this.myCookie.contains(";")) {
            fConstants.logger.log("HTTPD: Parsing Cookie string for Nirvana Cookie");
            object2 = new StringTokenizer(this.myCookie, ";");
            n = 0;
            while (n == 0 && ((StringTokenizer)object2).hasMoreElements()) {
                object = ((StringTokenizer)object2).nextElement().toString();
                if (!((String)object).startsWith("nirvana")) continue;
                this.myCookie = object;
                n = 1;
            }
            if (n == 0) {
                object = null;
                try {
                    object = this.con.getHeaderField(0);
                }
                catch (Exception exception) {
                    fConstants.logger.log(".getHeaderField caused an exception - " + exception);
                }
                if (object == null) {
                    fConstants.logger.log("fURLDriver: response is null");
                    object = "[unknown - null returned]";
                }
                fConstants.logger.log("fURLDriver: Could not establish session cookie:" + (String)object);
                throw new IOException("Could not establish session cookie");
            }
        }
        if (fConstants.logger.isDebugEnabled()) {
            fConstants.logger.debug("fURLDriver: Established connection with server, Cookie = " + this.myCookie);
        }
        this.myRequestCookie = (Object)((Object)HttpHeaderDefinitions.ConnectionType.request) + ":" + this.myCookie;
        this.myIn = this.con.getInputStream();
        this.myIn.read();
    }

    private void doFlush(byte[] byArray) throws IOException, fException {
        boolean bl = true;
        int n = 0;
        if (fConstants.logger.isInfoEnabled()) {
            fURLDriver.debugLog("URL Driver sending request to server, with " + byArray.length + " bytes");
        }
        this.con.startFlush();
        while (n < 3 && bl) {
            try {
                bl = !this.actualFlush(byArray);
                if (!bl) continue;
                ++n;
            }
            catch (Throwable throwable) {
                if (throwable.getMessage().equals("Reset received")) {
                    bl = true;
                    n = 3;
                }
                fConstants.logger.info("fURLDriver: Request caused an exception " + throwable);
                ++n;
            }
        }
        this.con.endFlush();
        if (fConstants.logger.isInfoEnabled()) {
            fURLDriver.debugLog("URL Driver completed request");
        }
        if (bl) {
            this.close();
            throw new IOException("Session has been reset");
        }
    }

    private boolean actualFlush(byte[] byArray) throws Exception {
        fURLHandler fURLHandler2 = fJDKHelper.getURLHandler(this.request, this.mySSLSocketFactory);
        fURLHandler2.setReadTimeOut(120000);
        fURLHandler2.setRequestProperty("Content-Type", "text/html");
        fURLHandler2.setDoInput(true);
        fURLHandler2.setDoOutput(true);
        fURLHandler2.setUseCaches(false);
        if (this.myHTTPCookie != null) {
            fURLHandler2.setRequestProperty("Cookie", this.myHTTPCookie);
        }
        if (!this.isSecure()) {
            fURLHandler2.setRequestProperty("Content-Length", Integer.toString(byArray.length));
        }
        fURLHandler2.setRequestProperty("Connection-Type", this.myRequestCookie);
        OutputStream outputStream = null;
        int n = 0;
        while (outputStream == null) {
            try {
                outputStream = fURLHandler2.getOutputStream();
            }
            catch (ConnectException connectException) {
                ++n;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (n > 6) {
                    if (fConstants.logger.isInfoEnabled()) {
                        fURLDriver.debugLog("URL Driver unable to establish link with server " + n + " times, aborting request, will result in loss of connection - " + connectException);
                    }
                    fURLHandler2.close();
                    throw connectException;
                }
                if (!fConstants.logger.isInfoEnabled()) continue;
                fURLDriver.debugLog("URL Driver unable to establish link with server " + n + " times, retrying - " + connectException);
            }
            catch (Exception exception) {
                if (fConstants.logger.isInfoEnabled()) {
                    fURLDriver.debugLog("URL Driver failed to connect - " + exception);
                }
                fURLHandler2.close();
                throw exception;
            }
        }
        try {
            outputStream.write(byArray, 0, byArray.length);
            outputStream.flush();
            outputStream.close();
        }
        catch (IOException iOException) {
            if (fConstants.logger.isInfoEnabled()) {
                fURLDriver.debugLog("URL Driver failed to connect - " + iOException);
            }
            fURLHandler2.close();
            throw iOException;
        }
        int n2 = 0;
        while (n2 < 3) {
            try {
                fURLHandler2.connect();
                n2 = 5;
            }
            catch (Exception exception) {
                if (++n2 != 3) continue;
                fURLHandler2.close();
                throw exception;
            }
        }
        fHTTPResponse fHTTPResponse2 = fURLHandler2.isResponseOK();
        fURLHandler2.close();
        if (fConstants.logger.isInfoEnabled()) {
            fURLDriver.debugLog("URL Driver received " + fHTTPResponse2.getResponse() + " code from server");
        }
        if (fHTTPResponse2.getResponse() == 205) {
            throw new IOException("Reset received");
        }
        return fHTTPResponse2.getResponse() == 200;
    }

    public class fURLOutputStream
    extends OutputStream {
        private ByteArrayOutputStream baos = new ByteArrayOutputStream(this.maxBufSize);
        private int maxBufSize = 10000;

        fURLOutputStream() {
        }

        @Override
        public void close() throws IOException {
            this.baos.close();
        }

        @Override
        public synchronized void flush() throws IOException {
            try {
                byte[] byArray = this.baos.toByteArray();
                this.baos.reset();
                if (byArray.length != 0) {
                    fURLDriver.this.doFlush(byArray);
                }
            }
            catch (Exception exception) {
                this.close();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new IOException(exception);
            }
        }

        @Override
        public synchronized void write(byte[] byArray) throws IOException {
            try {
                this.baos.write(byArray);
                if (this.baos.size() > this.maxBufSize) {
                    this.flush();
                }
            }
            catch (Exception exception) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new IOException(exception);
            }
        }

        @Override
        public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                this.baos.write(byArray, n, n2);
                if (this.baos.size() > this.maxBufSize) {
                    this.flush();
                }
            }
            catch (Exception exception) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new IOException(exception);
            }
        }

        @Override
        public synchronized void write(int n) throws IOException {
            try {
                this.baos.write(n);
                if (this.baos.size() > this.maxBufSize) {
                    this.flush();
                }
            }
            catch (Exception exception) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new IOException(exception);
            }
        }
    }
}

