/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.http;

import java.util.Random;

public final class ByteArrayHash {
    private static final long sHashStartPrime = 5600748293801L;
    private static final long sHashMultiplier = 0x4000FFFFL;
    private static final short[] sHashLookupTable = new short[256];

    public static long hash(byte[] byArray) {
        return ByteArrayHash.hash(byArray, 0, byArray.length);
    }

    public static long hash(byte[] byArray, int n, int n2) {
        long l = 5600748293801L;
        for (int i = n; i < n + n2; ++i) {
            l = l * 0x4000FFFFL ^ (long)sHashLookupTable[byArray[i] & 0xFF];
        }
        return l;
    }

    static {
        Random random = new Random(System.nanoTime());
        long l = 0L;
        while (l == 0L) {
            l = random.nextLong();
        }
        for (int i = 0; i < sHashLookupTable.length; ++i) {
            for (int j = 0; j < 31; ++j) {
                l = l >>> 7 ^ l;
                l = l << 11 ^ l;
                l = l >>> 10 ^ l;
            }
            ByteArrayHash.sHashLookupTable[i] = (short)(l & 0xFFL);
        }
    }
}

