/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.http;

import com.pcbsys.foundation.utils.fStringByteConverter;

public class HttpHeaderDefinitions {
    public static final String HTTP_VERSION_BASE = "HTTP/";
    public static final String HEADER_UM_COOKIE = "nirvana_";
    public static final String HEADER_UM_CONNECTION_TYPE = "Connection-Type";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_CONTENT_LENGTH = "Content-Length";
    public static final String HEADER_USER_AGENT = "User-Agent";
    public static final String HEADER_TRANSFER_ENCODING = "Transfer-Encoding";
    public static final String HEADER_X_FORWARDED_FOR = "X-Forwarded-For";
    public static final String HEADER_UPGRADE = "Upgrade";
    public static final String HEADER_WEBSOCKET_VERSION = "Sec-WebSocket-Version";
    public static final String HEADER_WEBSOCKET_KEY = "Sec-WebSocket-Key";
    public static final String HEADER_ORIGIN = "Origin";
    public static final String CONTENT_TYPE_TEXT_HTML = "text/html";

    public static enum RequestMethods {
        unknown("UNKNOWN"),
        get("GET"),
        post("POST"),
        put("PUT"),
        delete("DELETE"),
        head("HEAD"),
        options("OPTIONS");

        private final String verb;
        private final byte[] verbBytes;

        private RequestMethods(String string2) {
            this.verb = string2;
            this.verbBytes = fStringByteConverter.convert(this.verb);
        }

        public byte[] getVerbBytes() {
            return this.verbBytes;
        }

        public String toString() {
            return this.verb;
        }
    }

    public static enum HttpVersion {
        unknown("UNKNOWN"),
        version_1_0("1.0"),
        version_1_1("1.1");

        private final String verb;
        private final byte[] verbBytes;

        private HttpVersion(String string2) {
            this.verb = string2;
            this.verbBytes = fStringByteConverter.convert(this.verb);
        }

        public byte[] getVerbBytes() {
            return this.verbBytes;
        }

        public String toString() {
            return this.verb;
        }
    }

    public static enum ConnectionType {
        unknown("UNKNOWN"),
        request("REQUEST"),
        connect("CONNECT"),
        requestJS("JR"),
        connectJS("JC");

        private final String verb;
        private final byte[] verbBytes;

        private ConnectionType(String string2) {
            this.verb = string2;
            this.verbBytes = fStringByteConverter.convert(this.verb);
        }

        public byte[] getVerbBytes() {
            return this.verbBytes;
        }

        public String toString() {
            return this.verb;
        }
    }
}

