/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.http;

import com.pcbsys.foundation.base.fException;
import com.pcbsys.foundation.drivers.fAsyncReadListener;
import com.pcbsys.foundation.drivers.fHTTPInstanceDriver;
import com.pcbsys.foundation.drivers.http.fHTTPDriver;
import com.pcbsys.foundation.drivers.http.fHTTPHeader;
import com.pcbsys.foundation.drivers.http.fServerHTTPBaseDriver;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.PipedInputStream;
import com.pcbsys.foundation.io.PipedOutputStream;
import com.pcbsys.foundation.security.fLoginContext;
import com.pcbsys.foundation.security.fSubject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicLong;

public abstract class fBaseCometDriver
extends fHTTPInstanceDriver {
    private static final byte[] packing = "&".getBytes();
    private static final AtomicLong sUniqueId = new AtomicLong(10L);
    static int sPipedBufferSize = 5120;
    protected final boolean isSSL;
    protected final long myKey;
    final fServerHTTPBaseDriver myBase;
    final PipedInputStream myPis;
    final boolean corsSupport;
    private final PipedOutputStream myPos;
    private final byte[] myCookie;
    private final String myId;
    private final String myLocalId;
    private final int myLocalPort;
    int myNextRequestNumber;

    public static void setBufferSize(int n) {
        if (n > 1024 && n < 102400) {
            sPipedBufferSize = n;
        }
    }

    public static int getBufferSize() {
        return sPipedBufferSize;
    }

    private static String generateId(String string) {
        int n = string.indexOf(":");
        if (n != -1) {
            return string.substring(0, n) + ":" + sUniqueId.getAndIncrement();
        }
        return string;
    }

    fBaseCometDriver(fHTTPDriver fHTTPDriver2, fLoginContext fLoginContext2, fSubject fSubject2, fHTTPHeader fHTTPHeader2, fServerHTTPBaseDriver fServerHTTPBaseDriver2) throws IOException {
        super(fLoginContext2);
        this.myBase = fServerHTTPBaseDriver2;
        this.myKey = fHTTPHeader2.getLongCookie();
        this.myCookie = fHTTPHeader2.getCookie();
        this.myPis = new PipedInputStream(sPipedBufferSize);
        this.myPos = new PipedOutputStream(this.myPis);
        this.mySubject = fSubject2;
        this.isSSL = fHTTPDriver2.getLowerDriver().isSecure();
        this.myLocalId = fHTTPDriver2.getLowerDriver().getLocalId();
        this.myId = fBaseCometDriver.generateId(fHTTPDriver2.getLowerDriver().getId());
        this.myLocalPort = fHTTPDriver2.getLowerDriver().getLocalPort();
        this.corsSupport = fHTTPHeader2.isCORSSupport();
    }

    @Override
    public boolean sendTimeOutEvent() {
        return false;
    }

    @Override
    public boolean isSecure() {
        return this.isSSL;
    }

    @Override
    public boolean isRequireClientAuth() {
        return false;
    }

    @Override
    public boolean isNative() {
        return false;
    }

    @Override
    public void setTimeout(int n) {
    }

    @Override
    public void open() throws IOException, fException {
        super.open();
        if (fConstants.logger.isDebugEnabled()) {
            String string = this.isSSL ? "comets" : "comet";
            fConstants.logger.debug("Protocol: " + string + ": " + this.getId() + " connected.");
        }
    }

    @Override
    public void registerListener(fAsyncReadListener fAsyncReadListener2) throws Exception {
        super.registerListener(fAsyncReadListener2);
        if (this.myPis.available() != 0) {
            this.myListener.dataReady();
        }
    }

    @Override
    public InputStream getInputStream() {
        return this.myPis;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.myOutputStream;
    }

    @Override
    public void close() throws IOException, fException {
        if (!this.isClosed()) {
            if (fConstants.logger.isDebugEnabled()) {
                String string = this.isSSL ? "NHPS" : "NHP";
                fConstants.logger.debug("Protocol: " + string + ": " + this.getId() + " disconnected.");
            }
            this.setClosed(true);
            this.myBase.closeDriver(this);
            this.myPis.close();
            super.close();
            this.myPos.close();
            this.myOutputStream.close();
            if (this.myListener != null) {
                this.myListener.close();
            }
            this.myOutputStream = null;
        }
    }

    @Override
    public fSubject getSubject() {
        return this.mySubject;
    }

    @Override
    public void setSubject(fSubject fSubject2) {
        this.mySubject = fSubject2;
    }

    @Override
    public boolean pushData(InputStream inputStream, fHTTPDriver fHTTPDriver2, fHTTPHeader fHTTPHeader2) throws IOException {
        boolean bl = true;
        if (fHTTPHeader2.cometRequestNumber() <= this.myNextRequestNumber && this.myNextRequestNumber != 0) {
            bl = false;
        }
        if (fHTTPHeader2.getParametersEndIndex() == -1) {
            throw new IOException("Received request but no parameters found in request");
        }
        fHTTPHeader2.loadRemaining(inputStream);
        if (bl) {
            if (fHTTPHeader2.ContentLength() > 0) {
                this.pushData(fHTTPHeader2.getBuffer(), fHTTPHeader2.getParametersStartIndex(), fHTTPHeader2.getParametersEndIndex() - fHTTPHeader2.getParametersStartIndex(), fHTTPHeader2.getEndoOfHeaderLocation(), fHTTPHeader2.ContentLength());
            } else {
                this.pushData(fHTTPHeader2.getBuffer(), fHTTPHeader2.getParametersStartIndex(), fHTTPHeader2.getParametersEndIndex() - fHTTPHeader2.getParametersStartIndex(), -1, 0);
            }
        }
        return true;
    }

    synchronized void pushData(byte[] byArray, int n, int n2, int n3, int n4) throws IOException {
        this.pushSize(n2 + (n3 > 0 ? n4 + 1 : 0));
        if (this.myListener != null) {
            this.myListener.dataReady();
        }
        this.pushAll(byArray, n, n2);
        if (n3 > -1) {
            this.pushAll(packing, 0, 1);
            this.pushAll(byArray, n3, n4);
        }
    }

    private void pushSize(int n) throws IOException {
        this.myPos.write(n >> 24 & 0xFF);
        this.myPos.write(n >> 16 & 0xFF);
        this.myPos.write(n >> 8 & 0xFF);
        this.myPos.write(n & 0xFF);
        this.myPos.flush();
    }

    private void pushAll(byte[] byArray, int n, int n2) throws IOException {
        this.myPos.write(byArray, n, n2);
        this.myPos.flush();
    }

    @Override
    public long getKey() {
        return this.myKey;
    }

    @Override
    public byte[] getCookieAsBytes() {
        return this.myCookie;
    }

    @Override
    public String getId() {
        return this.myId;
    }

    @Override
    public String getLocalId() {
        return this.myLocalId;
    }

    @Override
    public int getLocalPort() {
        return this.myLocalPort;
    }

    public boolean isCORSSupport() {
        return this.corsSupport;
    }
}

