/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.http;

import com.pcbsys.foundation.base.fException;
import com.pcbsys.foundation.drivers.configuration.fHTTPConfig;
import com.pcbsys.foundation.drivers.fConnectionDetails;
import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.drivers.http.fHTTPDriver;
import com.pcbsys.foundation.drivers.http.fHTTPHeader;
import com.pcbsys.foundation.drivers.http.fServerHTTPBaseDriver;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.security.fSubject;
import com.pcbsys.foundation.utils.fStringByteConverter;
import com.pcbsys.foundation.utils.fSystemConfiguration;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;

public abstract class fBaseHTTPDriver
extends fDriver
implements fHTTPDriver {
    static final String sMyServerString;
    static final byte[] sEnd;
    static final byte[] sCookieHeader;
    static final byte[] sNonWebPadding;
    static final int sGenericPadding = 0;
    static final int sFirefoxPadding = 1;
    private static final String[] sPropertyNames;
    private static final String[] sDefaultValues;
    private static final byte[] sJSOrigin;
    private static final byte[] sJSOriginCredentials;
    static final byte[][] sPadding;
    static final byte[][] sPaddingSize;
    boolean isAllocated;
    final fDriver myBase;
    protected final fServerHTTPBaseDriver myParent;
    protected final OutputStream myOut;
    protected fHTTPHeader myHeader;

    private static String setupServerString() {
        String string = System.getProperty("ServerHeader", "my-Channels");
        if (!string.isEmpty()) {
            string = "Server: " + string + "\r\n";
        }
        return string;
    }

    private static void loadPadding(int n, String string, String string2) {
        String string3 = fSystemConfiguration.getProperty(string, string2);
        int n2 = Integer.parseInt(string3);
        fBaseHTTPDriver.sPadding[n] = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            fBaseHTTPDriver.sPadding[n][i] = (byte)((i + 32) % 128);
        }
        fBaseHTTPDriver.sPaddingSize[n] = fStringByteConverter.convert(string3.trim() + "\r\n");
    }

    protected fBaseHTTPDriver() {
        super(null);
        this.myParent = null;
        this.myBase = null;
        this.myOut = null;
    }

    protected fBaseHTTPDriver(fServerHTTPBaseDriver fServerHTTPBaseDriver2, fHTTPHeader fHTTPHeader2, fDriver fDriver2) throws Exception {
        super(null);
        this.myParent = fServerHTTPBaseDriver2;
        this.myHeader = fHTTPHeader2;
        this.myBase = fDriver2;
        this.isAllocated = false;
        this.myOut = this.myBase.getOutputStream();
    }

    @Override
    public long getLastRead() {
        return this.myBase.getLastRead();
    }

    @Override
    public long getLastWrite() {
        return this.myBase.getLastWrite();
    }

    @Override
    public void setLastWrite() {
        this.myBase.setLastWrite();
    }

    @Override
    public void setLastRead() {
        this.myBase.setLastRead();
    }

    @Override
    public void close() throws IOException, fException {
        this.myBase.close();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.createOutputStream(this.myOut);
    }

    @Override
    public void setTimeout(int n) {
        this.myBase.setTimeout(n);
    }

    @Override
    public int getTimeout() {
        return this.myBase.getTimeout();
    }

    @Override
    public String getId() {
        if (this.myBase == null) {
            return "";
        }
        return this.myBase.getId();
    }

    @Override
    public boolean supportAsyncReading() {
        return this.myBase.supportAsyncReading();
    }

    @Override
    public boolean supportAsyncWriting() {
        return this.myBase.supportAsyncWriting();
    }

    @Override
    public fSubject getSubject() {
        return this.myBase.getSubject();
    }

    @Override
    public void setSubject(fSubject fSubject2) {
        this.myBase.setSubject(fSubject2);
    }

    @Override
    public fDriver getLowerDriver() {
        return this.myBase;
    }

    @Override
    public String getLocalId() {
        return this.myBase.getLocalId();
    }

    @Override
    public int getLocalPort() {
        return this.myBase.getLocalPort();
    }

    @Override
    public fConnectionDetails getConnectionDetails() {
        return this.myBase.getConnectionDetails();
    }

    @Override
    public boolean isSecure() {
        return this.myBase.isSecure();
    }

    @Override
    public boolean isRequireClientAuth() {
        return this.myBase.isRequireClientAuth();
    }

    private void writeOrigin(OutputStream outputStream, String string) throws IOException {
        if (this.hasMatchingOrigin(string, outputStream)) {
            if (((fHTTPConfig)this.myParent.getConfig()).isAllowCrossOriginCredentials()) {
                outputStream.write(sJSOriginCredentials);
            }
        } else if (fConnectionDetails.sEnableConnectionDebug) {
            fBaseHTTPDriver.log("[CORS] CORS Connection " + string + " reject as did not match " + ((fHTTPConfig)this.myParent.getConfig()).getAllowedOrigins());
        }
    }

    protected void writeOrigin(OutputStream outputStream, fHTTPHeader fHTTPHeader2) throws IOException {
        int n = fHTTPHeader2.getOriginStartIndex();
        if (n == -1) {
            return;
        }
        if (n > -1) {
            String string = fStringByteConverter.convert(fHTTPHeader2.getBuffer(), n, fHTTPHeader2.getOriginEndIndex() - n);
            this.writeOrigin(outputStream, string);
        } else {
            fConstants.logger.warn("Failed to write Origin with start < -1");
        }
    }

    public void writeOrigin(OutputStream outputStream, Hashtable hashtable) throws IOException {
        Object v = hashtable.get("Origin");
        if (v == null) {
            return;
        }
        String string = v.toString();
        this.writeOrigin(outputStream, string);
    }

    private boolean matchOrigin(String[] stringArray, String string, OutputStream outputStream) throws IOException {
        for (String string2 : stringArray) {
            for (String string3 : string.split(" ")) {
                if (!string2.equals(string3)) continue;
                if (outputStream != null) {
                    outputStream.write(sJSOrigin);
                    outputStream.write(string3.getBytes());
                    outputStream.write(sEnd);
                }
                return true;
            }
        }
        return false;
    }

    protected boolean hasMatchingOrigin(String string, OutputStream outputStream) throws IOException {
        String[] stringArray = ((fHTTPConfig)this.myParent.getConfig()).getAllowedOriginsAsArray();
        if (((fHTTPConfig)this.myParent.getConfig()).isAllowedAllOrigins()) {
            if (outputStream != null) {
                outputStream.write(sJSOrigin);
                outputStream.write("*".getBytes());
                outputStream.write(sEnd);
            }
            return true;
        }
        if (stringArray == null) {
            return false;
        }
        boolean bl = this.matchOrigin(stringArray, string, outputStream);
        return bl;
    }

    static {
        sEnd = "\r\n".getBytes();
        sCookieHeader = "SessionId: ".getBytes();
        sNonWebPadding = "n".getBytes();
        sPropertyNames = new String[]{"SILVERLIGHT_PADDING", "SILVERLIGHT_PADDING_FIREFOX"};
        sDefaultValues = new String[]{"4000", "32000"};
        sJSOrigin = "Access-Control-Allow-Origin: ".getBytes();
        sJSOriginCredentials = "Access-Control-Allow-Credentials: true\r\n".getBytes();
        sMyServerString = fBaseHTTPDriver.setupServerString();
        sPadding = new byte[sPropertyNames.length][];
        sPaddingSize = new byte[sPropertyNames.length][];
        for (int i = 0; i < sPropertyNames.length; ++i) {
            fBaseHTTPDriver.loadPadding(i, sPropertyNames[i], sDefaultValues[i]);
        }
    }
}

