/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.http;

import com.pcbsys.foundation.base.fException;
import com.pcbsys.foundation.drivers.fAsyncReadListener;
import com.pcbsys.foundation.drivers.fConnectionDetails;
import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.drivers.http.fBaseCometDriver;
import com.pcbsys.foundation.drivers.http.fHTTPDriver;
import com.pcbsys.foundation.drivers.http.fHTTPHeader;
import com.pcbsys.foundation.drivers.http.fServerHTTPBaseDriver;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fChunkedOutputStream;
import com.pcbsys.foundation.io.javascript.fChunkedStreamWrapper;
import com.pcbsys.foundation.io.javascript.fScriptTagInsertion;
import com.pcbsys.foundation.io.javascript.fServerSentEvents;
import com.pcbsys.foundation.security.fLoginContext;
import com.pcbsys.foundation.security.fSubject;
import com.pcbsys.foundation.utils.fSystemConfiguration;
import java.io.IOException;
import java.io.InputStream;

public class fCometDriver
extends fBaseCometDriver {
    private static final byte[] chunkedPrelude = fCometDriver.createChunkedPrelude();
    private static final byte[] iFrameData = fCometDriver.createIframeContent();
    private static final String cometType = "comet";
    private static final String cometSType = "comets";
    private final fDriver myLowerDriver;
    private final boolean isChunking;

    public fCometDriver(fHTTPDriver fHTTPDriver2, fLoginContext fLoginContext2, fSubject fSubject2, fHTTPHeader fHTTPHeader2, fServerHTTPBaseDriver fServerHTTPBaseDriver2) throws IOException {
        super(fHTTPDriver2, fLoginContext2, fSubject2, fHTTPHeader2, fServerHTTPBaseDriver2);
        this.myType = this.isSSL ? cometSType : cometType;
        this.isChunking = fHTTPHeader2.isCometChunking();
        this.myLowerDriver = fHTTPDriver2.getLowerDriver();
        if (this.isChunking) {
            this.myOutputStream = new fChunkedStreamWrapper(new fChunkedOutputStream(this.myLowerDriver.getOutputStream()));
            this.myOutputStream.write(chunkedPrelude);
        } else if (fHTTPHeader2.isCometSSE()) {
            this.myOutputStream = new fServerSentEvents(this.myLowerDriver.getOutputStream());
        } else {
            this.myOutputStream = new fScriptTagInsertion(this.myLowerDriver.getOutputStream());
            this.myOutputStream.write(iFrameData);
        }
        this.myLowerDriver.setProtocolId(this.myType);
        this.myOutputStream.flush();
    }

    private static byte[] createIframeContent() {
        StringBuilder stringBuilder = new StringBuilder();
        if (Boolean.parseBoolean(fSystemConfiguration.getProperty("EnableIframeNoCatch"))) {
            stringBuilder.append("<html><head><script>function a(go){window.parent.onMessage(go); var b=window.document.getElementsByTagName(\"script\")[0].parentNode;while(b.hasChildNodes()&&b.childNodes.length>1){b.removeChild(b.lastChild);}}</script></head><body>");
        } else {
            stringBuilder.append("<html><head><script>function a(go){try{window.parent.onMessage(go)}catch(error){} var b=window.document.getElementsByTagName(\"script\")[0].parentNode;while(b.hasChildNodes()&&b.childNodes.length>1){b.removeChild(b.lastChild);}}</script></head><body>");
        }
        for (int i = 0; i < 40; ++i) {
            stringBuilder.append("                                                                                                    ");
        }
        return stringBuilder.toString().getBytes();
    }

    private static byte[] createChunkedPrelude() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 20; ++i) {
            stringBuilder.append("                                                                                                    ");
        }
        return stringBuilder.toString().getBytes();
    }

    @Override
    public void open() throws IOException, fException {
        super.open();
        if (fConstants.logger.isDebugEnabled()) {
            fConstants.logger.debug("Protocol: " + this.myType + ": " + this.getId() + " connected.");
        }
    }

    @Override
    public void close() throws IOException, fException {
        if (this.isClosed()) {
            return;
        }
        if (this.myLowerDriver != null) {
            this.myLowerDriver.close();
            try {
                this.myLowerDriver.registerListener(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            super.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public int getTimeout() {
        return this.myLowerDriver.getTimeout();
    }

    @Override
    public void setTimeout(int n) {
        super.setTimeout(n);
        try {
            this.myLowerDriver.setTimeout(n);
        }
        catch (Exception exception) {
            fConstants.logger.error(exception);
        }
    }

    @Override
    public fConnectionDetails getConnectionDetails() {
        fConnectionDetails fConnectionDetails2 = this.myLowerDriver.getConnectionDetails();
        return new fConnectionDetails(9, fConnectionDetails2.getHost(), fConnectionDetails2.getPort(), fConnectionDetails2.getFile());
    }

    @Override
    public long getLastRead() {
        return this.myLowerDriver.getLastRead();
    }

    @Override
    public long getLastWrite() {
        return this.myLowerDriver.getLastWrite();
    }

    @Override
    public void setLastWrite() {
        this.myLowerDriver.setLastWrite();
    }

    @Override
    public void setLastRead() {
        this.myLowerDriver.setLastRead();
    }

    @Override
    public boolean supportAsyncReading() {
        return this.myLowerDriver.supportAsyncReading();
    }

    @Override
    public boolean supportAsyncWriting() {
        return this.myLowerDriver.supportAsyncWriting();
    }

    @Override
    public void registerListener(fAsyncReadListener fAsyncReadListener2) throws Exception {
        if (this.myLowerDriver instanceof fHTTPDriver) {
            ((fHTTPDriver)((Object)this.myLowerDriver)).getLowerDriver().registerListener(new AsyncListener());
        }
        super.registerListener(fAsyncReadListener2);
    }

    @Override
    public boolean pushData(InputStream inputStream, fHTTPDriver fHTTPDriver2, fHTTPHeader fHTTPHeader2) throws IOException {
        this.myLowerDriver.setLastRead();
        fHTTPDriver2.getLowerDriver().setTimeout(fServerHTTPBaseDriver.getReadTimeOut());
        return super.pushData(inputStream, fHTTPDriver2, fHTTPHeader2);
    }

    public boolean isChunking() {
        return this.isChunking;
    }

    public class AsyncListener
    implements fAsyncReadListener {
        @Override
        public void dataReady() throws IOException {
            try {
                fCometDriver.this.myLowerDriver.getInputStream().available();
            }
            catch (IOException iOException) {
                this.close();
            }
        }

        @Override
        public void close() {
            try {
                fCometDriver.this.close();
            }
            catch (Throwable throwable) {
                fConstants.logger.warn(throwable);
            }
        }
    }
}

