/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.http;

import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.drivers.http.fBaseHTTPDriver;
import com.pcbsys.foundation.drivers.http.fHTTP11Driver;
import com.pcbsys.foundation.drivers.http.fHTTPHeader;
import com.pcbsys.foundation.drivers.http.fServerHTTPBaseDriver;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fChunkedInputStream;
import com.pcbsys.foundation.utils.fStringByteConverter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

public class fHTTP10Driver
extends fBaseHTTPDriver {
    private static final byte[] myResetString = ("HTTP/1.0 205 reset\r\nDate: " + new Date() + "\r\nCache-Control: no-cache\r\nNrvResp: Invalid\r\n\r\n").getBytes();
    private static final byte[] sOKHeaders = ("HTTP/1.0 200 OK\r\nDate: " + new Date().toString() + "\r\n" + sMyServerString + "Cache-Control: no-cache\r\n\r\n").getBytes();
    private static final byte[] sOKHeaderInit = ("HTTP/1.0 200 OK\r\nDate: " + new Date() + "\r\n" + sMyServerString + "Content-Type: ").getBytes();
    private static final byte[] sOKHeaderUnFinished = ("HTTP/1.0 200 OK\r\nDate: " + new Date().toString() + "\r\n" + sMyServerString + "Cache-Control: no-cache\r\n").getBytes();
    private static final byte[] sNoCacheHeader = fHTTP10Driver.noCacheHeaders();
    protected final InputStream myIn;

    private static byte[] noCacheHeaders() {
        if (System.getProperties().containsKey("HTTPKEEPALIVEREMOVE10")) {
            return "Cache-Control: no-cache\r\nPragma: no-cache\r\n".getBytes();
        }
        return "Cache-Control: no-cache\r\nPragma: no-cache\r\nKeep-Alive: timeout=15\r\n".getBytes();
    }

    public fHTTP10Driver(fHTTP11Driver fHTTP11Driver2) throws Exception {
        super(fHTTP11Driver2.myParent, fHTTP11Driver2.myHeader, fHTTP11Driver2.myBase);
        this.myIn = this.myBase.getInputStream();
    }

    public fHTTP10Driver(fServerHTTPBaseDriver fServerHTTPBaseDriver2, fHTTPHeader fHTTPHeader2, fDriver fDriver2) throws Exception {
        super(fServerHTTPBaseDriver2, fHTTPHeader2, fDriver2);
        this.myIn = fHTTPHeader2.isChunkedInput() ? new fChunkedInputStream(this.myBase.getInputStream()) : this.myBase.getInputStream();
        this.myParent.processRequest(this.myHeader, this, this.myIn);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.createInputStream(this.myIn);
    }

    @Override
    public String getVersion() {
        return "1.0";
    }

    @Override
    public void sendOKHeaders(fHTTPHeader fHTTPHeader2, boolean bl) {
        try {
            if (fServerHTTPBaseDriver.myDebugManager != null && fServerHTTPBaseDriver.myDebugManager.getConfig(this.myBase.getId()) != null) {
                fConstants.logger.error("Protocol: HTTPD: Response to " + this.myBase.getId() + " Headers : " + fStringByteConverter.convert(sOKHeaders));
            }
            this.myOut.write(sOKHeaderUnFinished);
            this.writeOrigin(this.myOut, fHTTPHeader2);
            this.myOut.write(sEnd);
            this.myOut.flush();
        }
        catch (Exception exception) {
            fConstants.logger.error(exception);
        }
    }

    @Override
    public boolean supportMultipleRequests() {
        return false;
    }

    @Override
    public void allocate() {
        this.isAllocated = true;
    }

    @Override
    public void deallocate() {
        this.isAllocated = false;
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isAllocated() {
        return this.isAllocated;
    }

    @Override
    public void sendInitOKHeaders(fHTTPHeader fHTTPHeader2) {
        try {
            String string;
            this.myOut.write(sOKHeaderInit);
            if (fHTTPHeader2.isNativeNirvana()) {
                this.myOut.write(this.myParent.getContentEncoding());
            } else if (fHTTPHeader2.isCometSSE()) {
                this.myOut.write(this.myParent.getContentEncodingJavascriptSSE());
            } else {
                this.myOut.write(this.myParent.getContentEncodingJavascript());
            }
            this.myOut.write(sEnd);
            if (!fHTTPHeader2.isJavascript()) {
                this.myOut.write(sCookieHeader);
                this.myOut.write(fHTTPHeader2.getCookie());
                this.myOut.write(sEnd);
            }
            if (fHTTPHeader2.isJavascript() || fHTTPHeader2.isForwarded()) {
                this.myOut.write(sNoCacheHeader);
            }
            this.writeOrigin(this.myOut, fHTTPHeader2);
            if (this.myParent.getHeaderFactory().getSize() > 0 && (string = this.myParent.getHeaderFactory().getHeaders(fHTTPHeader2.UserAgent())) != null) {
                this.myOut.write(string.getBytes());
            }
            this.myOut.write(sEnd);
            if (fServerHTTPBaseDriver.myDebugManager != null && fServerHTTPBaseDriver.myDebugManager.getConfig(this.myBase.getId()) != null) {
                fConstants.logger.error("Protocol: HTTPD: Response to " + this.myBase.getId());
            }
            if (fHTTPHeader2.isWebBasedClient()) {
                this.myOut.write(fHTTPHeader2.getCookie());
                this.myOut.write(sEnd);
                if (fHTTPHeader2.isFirefox()) {
                    this.myOut.write(sPaddingSize[1]);
                    this.myOut.write(sPadding[1], 0, sPadding[1].length - (fHTTPHeader2.getCookie().length + 2 + sPaddingSize[1].length));
                } else {
                    this.myOut.write(sPaddingSize[0]);
                    this.myOut.write(sPadding[0], 0, sPadding[0].length - (fHTTPHeader2.getCookie().length + 2 + sPaddingSize[0].length));
                }
            } else if (!fHTTPHeader2.isJavascript()) {
                this.myOut.write(sNonWebPadding);
            }
            if (fHTTPHeader2.isNativeNirvana() || fHTTPHeader2.isCometChunking()) {
                this.myOut.flush();
            }
        }
        catch (Exception exception) {
            fConstants.logger.error("Error initialising client communications : " + exception.getMessage());
        }
    }

    @Override
    public void sendNotOKHeaders() {
        try {
            if (fServerHTTPBaseDriver.myDebugManager != null && fServerHTTPBaseDriver.myDebugManager.getConfig(this.myBase.getId()) != null) {
                fConstants.logger.error("Protocol: HTTPD: Response to " + this.myBase.getId() + " Headers : " + fStringByteConverter.convert(myResetString));
            }
            this.myOut.write(myResetString);
            this.myOut.flush();
        }
        catch (Exception exception) {
            fConstants.logger.error(exception);
        }
    }
}

