/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.http;

import com.pcbsys.foundation.base.fException;
import com.pcbsys.foundation.drivers.fAsyncReadListener;
import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.drivers.http.HttpHeaderDefinitions;
import com.pcbsys.foundation.drivers.http.fBaseHTTPDriver;
import com.pcbsys.foundation.drivers.http.fHTTPHeader;
import com.pcbsys.foundation.drivers.http.fServerHTTPBaseDriver;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.security.fDriverMonitorEntry;
import com.pcbsys.foundation.threads.fTask;
import com.pcbsys.foundation.threads.fThreadPool;
import com.pcbsys.foundation.utils.fStringByteConverter;
import com.pcbsys.foundation.utils.fSystemConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

public class fHTTP11Driver
extends fBaseHTTPDriver {
    private static final int sKeepAliveTimeoutInMillis = Integer.parseInt(fSystemConfiguration.getProperty("HTTPKeepAliveTimeout", "120"));
    private static final byte[] myResetString = ("HTTP/1.1 205 reset\r\nDate: " + new Date() + "\r\nCache-Control: no-store,no-cache\r\nNrvResp: Invalid\r\nContent-Length: 0\r\n\r\n").getBytes();
    private static final byte[] sMainHeader = ("HTTP/1.1 200 OK\r\nDate: " + new Date() + "\r\n" + sMyServerString + "Cache-Control: no-store,no-cache\r\nContent-Length: 0\r\n").getBytes();
    static final byte[] sOKHeaders = fHTTP11Driver.oKHeaders();
    private static final byte[] sOKHeaderInit = ("HTTP/1.1 200 OK\r\nDate: " + new Date() + "\r\n" + sMyServerString + "Content-Type: ").getBytes();
    private static final byte[] sNoCacheHeader = fHTTP11Driver.noCacheHeaders();
    private static final byte[] sOriginHeader = "Transfer-Encoding: chunked\r\n".getBytes();
    private static final byte[] sKeepAliveHeader = "Connection: keep-alive\r\n".getBytes();
    private static final byte[] sCloseHeader = "Connection: close\r\n".getBytes();
    private final Object mutex = new Object();
    private boolean isReadable = true;
    private boolean initialRun = true;
    private final RequestSelector mySelector;
    private final fThreadPool myThreadPool;
    private fDriverMonitorEntry myMonitorEntry;

    private static byte[] noCacheHeaders() {
        if (sKeepAliveTimeoutInMillis > 0 || System.getProperties().containsKey("HTTPKEEPALIVEREMOVE11")) {
            return "Cache-Control: no-cache\r\nPragma: no-cache\r\n".getBytes();
        }
        return ("Cache-Control: no-cache\r\nPragma: no-cache\r\nKeep-Alive: timeout=" + sKeepAliveTimeoutInMillis + "\r\n").getBytes();
    }

    private static byte[] oKHeaders() {
        String string = "HTTP/1.1 200 OK\r\nDate: " + new Date().toString() + "\r\n" + sMyServerString + "Cache-Control: no-store,no-cache\r\nContent-Length: 0\r\nConnection: keep-alive\r\n";
        if (sKeepAliveTimeoutInMillis > 0) {
            string = string + "Keep-Alive: timeout=" + sKeepAliveTimeoutInMillis + "\r\n";
        }
        return string.getBytes();
    }

    fHTTP11Driver(fServerHTTPBaseDriver fServerHTTPBaseDriver2, fHTTPHeader fHTTPHeader2, fDriver fDriver2, fThreadPool fThreadPool2) throws Exception {
        super(fServerHTTPBaseDriver2, fHTTPHeader2, fDriver2);
        this.myThreadPool = fThreadPool2;
        this.myParent.release(fHTTPHeader2.createNew());
        this.mySelector = new RequestSelector();
        fDriver2.registerListener(this.mySelector);
        this.mySelector.dataReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException, fException {
        if (this.myBase == null) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            this.mutex.notify();
        }
        super.close();
        if (this.myMonitorEntry != null) {
            this.myParent.myConnectionMonitor.remove(this.myMonitorEntry);
        }
        this.setClosed(true);
    }

    @Override
    public boolean supportMultipleRequests() {
        return true;
    }

    @Override
    public String getVersion() {
        return "1.1";
    }

    @Override
    public void allocate() {
        this.isAllocated = true;
    }

    @Override
    public void deallocate() {
        this.isAllocated = false;
        try {
            this.mySelector.restart();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isAllocated() {
        return this.isAllocated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeRead() {
        Object object = this.mutex;
        synchronized (object) {
            this.isReadable = false;
            this.mutex.notify();
        }
    }

    @Override
    public void sendOKHeaders(fHTTPHeader fHTTPHeader2, boolean bl) {
        try {
            if (fHTTPHeader2.isJavascript()) {
                this.myOut.write(sMainHeader);
                if (bl) {
                    this.myOut.write(sCloseHeader);
                } else {
                    this.myOut.write(sKeepAliveHeader);
                }
            } else {
                this.myOut.write(sOKHeaders);
            }
            this.writeOrigin(this.myOut, fHTTPHeader2);
            this.myOut.write(sEnd);
            this.myOut.flush();
            if (fServerHTTPBaseDriver.myDebugManager != null && fServerHTTPBaseDriver.myDebugManager.getConfig(this.myBase.getId()) != null) {
                fConstants.logger.error("Protocol: HTTPD: Response to " + this.myBase.getId() + " Headers : " + fStringByteConverter.convert(sOKHeaders));
            }
        }
        catch (Exception exception) {
            fConstants.logger.error(exception);
        }
    }

    public void completedRequest() throws Exception {
        if (this.myMonitorEntry == null) {
            this.myMonitorEntry = new fDriverMonitorEntry(this.myBase);
        } else {
            this.myMonitorEntry.refresh();
        }
        this.myParent.myConnectionMonitor.add(this.myMonitorEntry);
        this.mySelector.restart();
    }

    @Override
    public void resumeReading() {
        this.myBase.resumeReading();
    }

    public boolean isReadable() {
        return this.isReadable;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.createInputStream(this.myBase.getInputStream());
    }

    @Override
    public void registerListener(fAsyncReadListener fAsyncReadListener2) throws Exception {
        this.myBase.registerListener(fAsyncReadListener2);
    }

    @Override
    public void sendInitOKHeaders(fHTTPHeader fHTTPHeader2) {
        try {
            String string;
            this.myOut.write(sOKHeaderInit);
            if (fHTTPHeader2.isNativeNirvana()) {
                this.myOut.write(this.myParent.getContentEncoding());
            } else if (fHTTPHeader2.isCometSSE()) {
                this.myOut.write(this.myParent.getContentEncodingJavascriptSSE());
            } else {
                this.myOut.write(this.myParent.getContentEncodingJavascript());
            }
            this.myOut.write(sEnd);
            if (!fHTTPHeader2.isJavascript()) {
                this.myOut.write(sCookieHeader);
                this.myOut.write(fHTTPHeader2.getCookie());
                this.myOut.write(sEnd);
            }
            this.writeOrigin(this.myOut, fHTTPHeader2);
            if (fHTTPHeader2.isJavascript()) {
                if (fHTTPHeader2.isCometCloseRequest()) {
                    this.myOut.write(sCloseHeader);
                } else if (fHTTPHeader2.isCometSSE()) {
                    this.myOut.write(sKeepAliveHeader);
                }
            }
            if (this.myParent.getHeaderFactory().getSize() > 0 && (string = this.myParent.getHeaderFactory().getHeaders(fHTTPHeader2.UserAgent())) != null) {
                this.myOut.write(string.getBytes());
            }
            if (fHTTPHeader2.isJavascript() || fHTTPHeader2.isForwarded()) {
                this.myOut.write(sNoCacheHeader);
                this.myOut.write(sOriginHeader);
            }
            this.myOut.write(sEnd);
            if (fServerHTTPBaseDriver.myDebugManager != null && fServerHTTPBaseDriver.myDebugManager.getConfig(this.myBase.getId()) != null) {
                fConstants.logger.error("Protocol: HTTPD: Response to " + this.myBase.getId());
            }
            if (fHTTPHeader2.isWebBasedClient()) {
                this.myOut.write(fHTTPHeader2.getCookie());
                this.myOut.write(sEnd);
                if (fHTTPHeader2.isFirefox()) {
                    this.myOut.write(sPaddingSize[1]);
                    this.myOut.write(sPadding[1], 0, sPadding[1].length - (fHTTPHeader2.getCookie().length + 2 + sPaddingSize[1].length));
                } else {
                    this.myOut.write(sPaddingSize[0]);
                    this.myOut.write(sPadding[0], 0, sPadding[0].length - (fHTTPHeader2.getCookie().length + 2 + sPaddingSize[0].length));
                }
            } else if (!fHTTPHeader2.isJavascript()) {
                this.myOut.write(sNonWebPadding);
            }
            if (fHTTPHeader2.isNativeNirvana() || fHTTPHeader2.isCometChunking()) {
                this.myOut.flush();
            }
        }
        catch (Exception exception) {
            fConstants.logger.error(exception);
        }
    }

    @Override
    public void sendNotOKHeaders() {
        if (fServerHTTPBaseDriver.myDebugManager != null && fServerHTTPBaseDriver.myDebugManager.getConfig(this.myBase.getId()) != null) {
            fConstants.logger.error("Protocol: HTTPD: Response to " + this.myBase.getId() + " Headers : " + fStringByteConverter.convert(myResetString));
        }
        try {
            this.myOut.write(myResetString);
            this.myOut.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class RequestSelector
    implements fAsyncReadListener,
    fTask {
        boolean added = false;
        boolean inRead = false;
        boolean exitTask = false;

        RequestSelector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dataReady() {
            RequestSelector requestSelector = this;
            synchronized (requestSelector) {
                if (!this.added) {
                    fHTTP11Driver.this.myThreadPool.addTask(this);
                    this.added = true;
                } else if (fHTTP11Driver.this.myBase.isClosed()) {
                    this.close();
                }
            }
        }

        @Override
        public void close() {
            try {
                try {
                    fHTTP11Driver.this.myBase.registerListener(null);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                fHTTP11Driver.this.close();
            }
            catch (IOException iOException) {
            }
            catch (fException fException2) {
                // empty catch block
            }
        }

        public void restart() throws Exception {
            if (fHTTP11Driver.this.isAllocated()) {
                return;
            }
            if (fHTTP11Driver.this.isClosed()) {
                return;
            }
            if (fHTTP11Driver.this.myBase.isClosed()) {
                return;
            }
            this.added = false;
            this.exitTask = false;
            fHTTP11Driver.this.myBase.registerListener(this);
            fHTTP11Driver.this.myBase.resumeReading();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() {
            try {
                RequestSelector requestSelector = this;
                synchronized (requestSelector) {
                    block37: {
                        if (!this.inRead) break block37;
                        return;
                    }
                    this.inRead = true;
                }
                boolean bl = true;
                while (bl) {
                    fHTTPHeader fHTTPHeader2;
                    if (!fHTTP11Driver.this.initialRun) {
                        fHTTPHeader2 = fHTTP11Driver.this.myHeader.createNew();
                        fHTTPHeader2.readHeader(fHTTP11Driver.this.myBase.getInputStream());
                    } else {
                        fHTTPHeader2 = fHTTP11Driver.this.myHeader;
                    }
                    fHTTP11Driver.this.initialRun = false;
                    if (fHTTPHeader2.getConnectionType() == HttpHeaderDefinitions.ConnectionType.unknown || fHTTPHeader2.getConnectionType() == HttpHeaderDefinitions.ConnectionType.connect || fHTTPHeader2.getConnectionType() == HttpHeaderDefinitions.ConnectionType.connectJS && !fHTTPHeader2.isLongPoll()) {
                        if (fHTTP11Driver.this.myMonitorEntry != null) {
                            fHTTP11Driver.this.myParent.myConnectionMonitor.remove(fHTTP11Driver.this.myMonitorEntry);
                        }
                        fHTTP11Driver.this.myBase.registerListener(null);
                        fHTTP11Driver.this.myParent.processRequest(fHTTPHeader2, fHTTP11Driver.this, fHTTP11Driver.this.myBase.getInputStream());
                        this.exitTask = true;
                        return;
                    }
                    if (fHTTP11Driver.this.myMonitorEntry != null) {
                        fHTTP11Driver.this.myMonitorEntry.refresh();
                    }
                    fHTTP11Driver.this.myParent.processRequest(fHTTPHeader2, fHTTP11Driver.this, fHTTP11Driver.this.myBase.getInputStream());
                    bl = !fHTTP11Driver.this.myBase.isClosed() && !fHTTP11Driver.this.isAllocated && fHTTP11Driver.this.myBase.getInputStream().available() != 0;
                }
                if (!fHTTP11Driver.this.isAllocated) {
                    fHTTP11Driver.this.myBase.resumeReading();
                }
            }
            catch (Throwable throwable) {
                try {
                    fHTTP11Driver.this.myBase.abortAllIO();
                    fHTTP11Driver.this.myBase.close();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                try {
                    this.close();
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
            }
            finally {
                RequestSelector requestSelector = this;
                synchronized (requestSelector) {
                    this.inRead = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean reQueue() {
            if (this.exitTask) {
                return false;
            }
            RequestSelector requestSelector = this;
            synchronized (requestSelector) {
                try {
                    if (fHTTP11Driver.this.myBase != null && !fHTTP11Driver.this.myBase.isClosed()) {
                        if (fHTTP11Driver.this.myBase.getInputStream().available() == 0) {
                            fHTTP11Driver.this.myBase.resumeReading();
                            this.added = false;
                        } else {
                            this.added = true;
                        }
                    } else {
                        this.added = false;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return this.added;
            }
        }
    }
}

