/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.http;

import com.pcbsys.foundation.drivers.http.ByteArrayHash;
import com.pcbsys.foundation.drivers.http.HttpHeaderDefinitions;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.memory.fMemoryManager;
import com.pcbsys.foundation.utils.fAsciiByteArrayToPrimitiveType;
import com.pcbsys.foundation.utils.fStringByteConverter;
import com.pcbsys.foundation.utils.fSystemConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public class fHTTPHeader {
    private static final byte[] sHTTP = fHTTPHeader.processHeader("HTTP/");
    private static final byte[] sConnectionType = fHTTPHeader.processHeader("Connection-Type");
    private static final byte[] sContentLength = fHTTPHeader.processHeader("Content-Length");
    private static final byte[] sCookie = fHTTPHeader.processHeader("nirvana_");
    private static final byte[] sUserAgent = fHTTPHeader.processHeader("User-Agent");
    private static final byte[] sTransferEncoding = fHTTPHeader.processHeader("Transfer-Encoding");
    private static final byte[] sTransferEncodingChunked = fHTTPHeader.processHeader("chunked");
    private static final byte[] sXForwardedFor = fHTTPHeader.processHeader("X-Forwarded-For");
    private static final byte[] sUpgrade = fHTTPHeader.processHeader("Upgrade");
    private static final byte[] sUpgradeWebsocket = fHTTPHeader.processHeader("websocket");
    private static final byte[] sWSVersion = fHTTPHeader.processHeader("Sec-WebSocket-Version");
    private static final byte[] sWSSecKey = fHTTPHeader.processHeader("Sec-WebSocket-Key");
    private static final byte[] sOrigin = fHTTPHeader.processHeader("Origin");
    private static final byte[] sFirefox = fHTTPHeader.processHeader("Firefox");
    private static final byte[] sCometCloseRequest = fHTTPHeader.processHeader("F=30");
    private static final byte[] sLongPollFlush = fHTTPHeader.processHeader("F=3");
    private static final byte[] sLongPollFlushAlt = fHTTPHeader.processHeader("F=1");
    private static final byte[] sCometRequestCount = fHTTPHeader.processHeader("R=");
    private static final byte[] sJavacriptProtocolParamater = fHTTPHeader.processHeader("P=");
    private static final byte[] sCometChunkedDetection = fHTTPHeader.processHeader("NCC");
    private static final byte[] sCometSSEDetection = fHTTPHeader.processHeader("NSSE");
    private static final byte[] sLongPollDetectionJsonP = fHTTPHeader.processHeader("NLPJ");
    private static final byte[] sLongPollDetectionCors = fHTTPHeader.processHeader("NLPC");
    private static final byte[] sLongPollDetection = fHTTPHeader.processHeader("NLP");
    private static final int sHeaderLines = 30;
    private static final int sHeaderBufSize = fHTTPHeader.init();
    private final int[] headerLinePositions = new int[30];
    private byte[] buffer = new byte[sHeaderBufSize];
    private int endOfHeaderPosition;
    private int endOfBuffer;
    private int parametersStartIndex;
    private int parametersEndIndex;
    private HttpHeaderDefinitions.ConnectionType connectionType;
    private HttpHeaderDefinitions.RequestMethods requestMethod;
    private HttpHeaderDefinitions.HttpVersion version;
    private int contentLength;
    private int userAgentStartIndex;
    private int userAgentEndIndex;
    private int clientHostNameEndIndex;
    private int clientHostNameStartIndex;
    private int lastLineIndexPosition;
    private int wsVersion;
    private int wsSecKeyEndIndex;
    private boolean isForwarded;
    private boolean isWebBasedClient;
    private boolean isNativeNirvana;
    private boolean chunkedInput;
    private boolean foundTransferEncoding;
    private boolean webSocket;
    private boolean javascript;
    private boolean cometChunked;
    private int cookieStartIndex;
    private int cookieEndIndex;
    private int originStartIndex;
    private int originEndIndex;
    private byte[] cookie;
    private boolean checkedJavascriptProtocol;
    private boolean serverSentEvents;
    private boolean longPoll;
    private boolean longPollJsonP;
    private boolean corsSupport;
    private boolean extended = false;

    private static int init() {
        int n = 5120;
        String string = fSystemConfiguration.getProperty("HTTPHeaderSize", "" + n);
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    private static byte[] processHeader(String string) {
        return fStringByteConverter.convert(string.toUpperCase());
    }

    public fHTTPHeader() {
        this.clear();
    }

    fHTTPHeader createNew() {
        return new fHTTPHeader();
    }

    public void clear() {
        for (int i = 0; i < 30; ++i) {
            this.headerLinePositions[i] = -1;
        }
        this.version = HttpHeaderDefinitions.HttpVersion.unknown;
        this.endOfHeaderPosition = 0;
        this.endOfBuffer = 0;
        this.connectionType = HttpHeaderDefinitions.ConnectionType.unknown;
        this.contentLength = -1;
        this.isForwarded = false;
        this.isWebBasedClient = false;
        this.isNativeNirvana = false;
        this.requestMethod = HttpHeaderDefinitions.RequestMethods.unknown;
        this.parametersEndIndex = -1;
        this.parametersStartIndex = -1;
        this.userAgentStartIndex = -1;
        this.userAgentEndIndex = -1;
        this.clientHostNameStartIndex = -1;
        this.clientHostNameEndIndex = -1;
        this.chunkedInput = false;
        this.foundTransferEncoding = false;
        this.lastLineIndexPosition = 0;
        this.webSocket = false;
        this.wsVersion = -1;
        this.javascript = false;
        this.cometChunked = false;
        this.cookieEndIndex = -1;
        this.cookieStartIndex = -1;
        this.wsSecKeyEndIndex = -1;
        this.cookie = null;
        this.originEndIndex = 0;
        this.originStartIndex = -1;
        this.corsSupport = false;
        this.checkedJavascriptProtocol = false;
        this.serverSentEvents = false;
        this.longPoll = false;
        this.longPollJsonP = false;
    }

    Hashtable<String, Object> getHashTable() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        try {
            int n = this.headerLinePositions[0];
            hashtable.put("Command", fStringByteConverter.convert(this.buffer, 0, this.headerLinePositions[0]));
            hashtable.put("HTTP_Version", "" + (Object)((Object)this.version));
            int n2 = this.endOfBuffer - this.endOfHeaderPosition;
            if (n2 > 0) {
                byte[] byArray = new byte[this.endOfBuffer - this.endOfHeaderPosition];
                System.arraycopy(this.buffer, this.endOfHeaderPosition, byArray, 0, byArray.length);
                hashtable.put("buffer", byArray);
            }
            for (int i = 1; i < this.lastLineIndexPosition && this.headerLinePositions[i] != -1; ++i) {
                if (this.headerLinePositions[i] - n <= 2) continue;
                String string = fStringByteConverter.convert(this.buffer, n, this.headerLinePositions[i] - n);
                string = string.trim();
                String string2 = string.substring(0, string.indexOf(":"));
                String string3 = string.substring(string.indexOf(":") + 1);
                hashtable.put(string2, string3);
                n = this.headerLinePositions[i];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashtable;
    }

    void growBuffer() throws IOException {
        if (this.extended) {
            IOException iOException = new IOException("HTTP-Accept: Exceeded buffer size of " + sHeaderBufSize * 2);
            fConstants.logger.log("Header too large: \n" + this.toString());
            fConstants.logger.log(iOException);
            throw iOException;
        }
        byte[] byArray = new byte[sHeaderBufSize * 2];
        System.arraycopy(this.buffer, 0, byArray, 0, this.buffer.length);
        this.buffer = byArray;
        this.extended = true;
    }

    void loadRemaining(InputStream inputStream) throws IOException {
        int n;
        if (this.contentLength > 0 && (n = this.contentLength + this.endOfHeaderPosition - this.endOfBuffer) > 0) {
            if (this.endOfBuffer + n > this.buffer.length) {
                byte[] byArray = this.buffer;
                this.buffer = fMemoryManager.getInstance().allocateBuffer(this.contentLength + this.endOfHeaderPosition);
                System.arraycopy(byArray, 0, this.buffer, 0, byArray.length);
            }
            while (n != 0) {
                int n2 = inputStream.read(this.buffer, this.endOfBuffer, n);
                if (n2 == -1) {
                    throw new IOException("End of stream");
                }
                this.endOfBuffer += n2;
                n -= n2;
            }
        }
    }

    boolean checkIfNativeProtocol() {
        if (this.endOfBuffer >= 4) {
            return this.buffer[0] <= 0 && this.buffer[1] == 0 && this.buffer[2] == 0 && (this.buffer[3] == 0 || this.buffer[3] == 1);
        }
        return false;
    }

    boolean readHeader(InputStream inputStream) throws IOException {
        try {
            this.endOfBuffer = 0;
            this.lastLineIndexPosition = 0;
            this.endOfHeaderPosition = 0;
            do {
                int n;
                if (this.buffer.length <= this.endOfBuffer) {
                    this.growBuffer();
                }
                if ((n = inputStream.read(this.buffer, this.endOfBuffer, this.buffer.length - this.endOfBuffer)) == 0) {
                    throw new IOException("Failed to read HTTP header");
                }
                if (n == -1) {
                    throw new IOException("EOF Reached on socket");
                }
                this.endOfBuffer += n;
                if (!this.checkIfNativeProtocol()) continue;
                return false;
            } while (this.continueSearchingForEndOfHeader());
            this.processBuffer();
            return true;
        }
        catch (RuntimeException runtimeException) {
            fConstants.logger.fatal("Error during preProcessBuffer lineIDX=" + this.lastLineIndexPosition + "/" + this.headerLinePositions.length + " bufferIndex=" + this.endOfHeaderPosition + "/" + this.buffer.length + " EndOfBuffer=" + this.endOfBuffer + "/" + this.buffer.length);
            fConstants.logger.fatal(runtimeException);
            throw runtimeException;
        }
    }

    boolean processBufferFull() {
        try {
            this.lastLineIndexPosition = 0;
            this.endOfHeaderPosition = 0;
            if (this.continueSearchingForEndOfHeader()) {
                return false;
            }
            try {
                this.processBuffer();
            }
            catch (IOException iOException) {
                return false;
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            fConstants.logger.fatal("Error during preProcessBuffer lineIDX=" + this.lastLineIndexPosition + "/" + this.headerLinePositions.length + " bufferIndex=" + this.endOfHeaderPosition + "/" + this.buffer.length + " EndOfBuffer=" + this.endOfBuffer + "/" + this.buffer.length);
            fConstants.logger.fatal(runtimeException);
            throw runtimeException;
        }
    }

    private boolean continueSearchingForEndOfHeader() {
        while (this.endOfHeaderPosition + 3 < this.endOfBuffer) {
            if (this.buffer[this.endOfHeaderPosition] == 13 && this.buffer[this.endOfHeaderPosition + 1] == 10) {
                this.endOfHeaderPosition += 2;
                if (this.buffer[this.endOfHeaderPosition] == 13 && this.buffer[this.endOfHeaderPosition + 1] == 10) {
                    this.endOfHeaderPosition += 2;
                    this.headerLinePositions[this.lastLineIndexPosition++] = this.endOfHeaderPosition - 1;
                    return false;
                }
                this.headerLinePositions[this.lastLineIndexPosition++] = this.endOfHeaderPosition;
                continue;
            }
            ++this.endOfHeaderPosition;
        }
        return true;
    }

    private void processBuffer() throws IOException {
        int n = this.findRequestType();
        this.processHeaderValues();
        this.processUrlParameterLocations(n);
        if (this.parametersStartIndex == -1) {
            return;
        }
        this.processUrlParameter();
    }

    private int findRequestType() throws IOException {
        int n = 0;
        while (this.requestMethod == HttpHeaderDefinitions.RequestMethods.unknown) {
            if (n >= this.endOfBuffer) {
                throw new IOException("Unable to find supported request header");
            }
            for (HttpHeaderDefinitions.RequestMethods requestMethods : HttpHeaderDefinitions.RequestMethods.values()) {
                if (!fHTTPHeader.checkCharacterArray(this.buffer, n, requestMethods.getVerbBytes())) continue;
                this.requestMethod = requestMethods;
                n = fHTTPHeader.findNonWhiteSpaceAfterField(this.buffer, n, requestMethods.getVerbBytes().length);
                break;
            }
            ++n;
        }
        return n;
    }

    private void processHeaderValues() {
        int n = 0;
        block0: while (n < this.lastLineIndexPosition && this.headerLinePositions[n] != -1) {
            int n2 = this.headerLinePositions[n++];
            if (this.connectionType == HttpHeaderDefinitions.ConnectionType.unknown && fHTTPHeader.checkCharacterArray(this.buffer, n2, sConnectionType)) {
                if (fHTTPHeader.checkCharacterArray(this.buffer, n2 = fHTTPHeader.findNonWhiteSpaceAfterField(this.buffer, n2, sConnectionType.length), HttpHeaderDefinitions.ConnectionType.request.getVerbBytes())) {
                    this.isNativeNirvana = true;
                    this.connectionType = HttpHeaderDefinitions.ConnectionType.request;
                    for (n2 = fHTTPHeader.findNonWhiteSpaceAfterField(this.buffer, n2, HttpHeaderDefinitions.ConnectionType.request.getVerbBytes().length); n2 < this.headerLinePositions[n]; ++n2) {
                        if (!fHTTPHeader.checkCharacterArray(this.buffer, n2, sCookie)) continue;
                        this.cookieStartIndex = n2;
                        this.cookieEndIndex = this.headerLinePositions[n] - 2;
                        continue block0;
                    }
                    continue;
                }
                if (fHTTPHeader.checkCharacterArray(this.buffer, n2, HttpHeaderDefinitions.ConnectionType.connect.getVerbBytes())) {
                    this.connectionType = HttpHeaderDefinitions.ConnectionType.connect;
                    this.isNativeNirvana = true;
                    continue;
                }
                if (fHTTPHeader.checkCharacterArray(this.buffer, n2, HttpHeaderDefinitions.ConnectionType.requestJS.getVerbBytes())) {
                    this.connectionType = HttpHeaderDefinitions.ConnectionType.requestJS;
                    this.javascript = true;
                    continue;
                }
                if (!fHTTPHeader.checkCharacterArray(this.buffer, n2, HttpHeaderDefinitions.ConnectionType.connectJS.getVerbBytes())) continue;
                this.connectionType = HttpHeaderDefinitions.ConnectionType.connectJS;
                this.javascript = true;
                continue;
            }
            if (this.requestMethod == HttpHeaderDefinitions.RequestMethods.post && this.contentLength == -1 && fHTTPHeader.checkCharacterArray(this.buffer, n2, sContentLength)) {
                n2 = fHTTPHeader.findNonWhiteSpaceAfterField(this.buffer, n2, sContentLength.length);
                this.contentLength = fAsciiByteArrayToPrimitiveType.convertToInt(this.buffer, n2, this.headerLinePositions[n] - n2);
                continue;
            }
            if (this.userAgentStartIndex == -1 && fHTTPHeader.checkCharacterArray(this.buffer, n2, sUserAgent)) {
                this.userAgentStartIndex = fHTTPHeader.findNonWhiteSpaceAfterField(this.buffer, n2, sUserAgent.length);
                this.userAgentEndIndex = this.headerLinePositions[n] - 2;
                continue;
            }
            if (!this.foundTransferEncoding && fHTTPHeader.checkCharacterArray(this.buffer, n2, sTransferEncoding)) {
                this.foundTransferEncoding = true;
                if (!fHTTPHeader.checkCharacterArray(this.buffer, fHTTPHeader.findNonWhiteSpaceAfterField(this.buffer, n2, sTransferEncoding.length), sTransferEncodingChunked)) continue;
                this.chunkedInput = true;
                continue;
            }
            if (!this.isForwarded && fHTTPHeader.checkCharacterArray(this.buffer, n2, sXForwardedFor)) {
                this.isForwarded = true;
                this.clientHostNameStartIndex = fHTTPHeader.findNonWhiteSpaceAfterField(this.buffer, n2, sXForwardedFor.length);
                this.clientHostNameEndIndex = this.headerLinePositions[n] - 2;
                continue;
            }
            if (!this.webSocket && fHTTPHeader.checkCharacterArray(this.buffer, n2, sUpgrade)) {
                this.webSocket = fHTTPHeader.checkCharacterArray(this.buffer, fHTTPHeader.findNonWhiteSpaceAfterField(this.buffer, n2, sUpgrade.length), sUpgradeWebsocket);
            }
            if (this.originStartIndex != -1 || !fHTTPHeader.checkCharacterArray(this.buffer, n2, sOrigin)) continue;
            this.originStartIndex = fHTTPHeader.findNonWhiteSpaceAfterField(this.buffer, n2, sOrigin.length);
            this.originEndIndex = this.headerLinePositions[n] - 2;
        }
    }

    private void processUrlParameterLocations(int n) {
        while (n < this.headerLinePositions[0]) {
            if (this.parametersStartIndex == -1 && this.buffer[n] == 63) {
                this.parametersStartIndex = n + 1;
            } else if (this.parametersEndIndex == -1 && this.buffer[n] == 32) {
                this.parametersEndIndex = n;
            } else if (this.parametersEndIndex > -1 && fHTTPHeader.checkCharacterArray(this.buffer, n, sHTTP)) {
                if (fHTTPHeader.checkCharacterArray(this.buffer, n += sHTTP.length, HttpHeaderDefinitions.HttpVersion.version_1_1.getVerbBytes())) {
                    this.version = HttpHeaderDefinitions.HttpVersion.version_1_1;
                    break;
                }
                if (!fHTTPHeader.checkCharacterArray(this.buffer, n, HttpHeaderDefinitions.HttpVersion.version_1_0.getVerbBytes())) break;
                this.version = HttpHeaderDefinitions.HttpVersion.version_1_0;
                break;
            }
            ++n;
        }
    }

    private void processUrlParameter() {
        boolean bl = true;
        int n = this.parametersStartIndex;
        while (n < this.parametersEndIndex) {
            if (this.buffer[n] == 38) {
                ++n;
                bl = true;
                continue;
            }
            if (!bl) {
                ++n;
                continue;
            }
            if (this.connectionType == HttpHeaderDefinitions.ConnectionType.unknown && fHTTPHeader.checkCharacterArray(this.buffer, n, sConnectionType)) {
                if (fHTTPHeader.checkCharacterArray(this.buffer, n += sConnectionType.length + 1, HttpHeaderDefinitions.ConnectionType.request.getVerbBytes())) {
                    this.isWebBasedClient = true;
                    this.isNativeNirvana = true;
                    this.connectionType = HttpHeaderDefinitions.ConnectionType.request;
                    n += HttpHeaderDefinitions.ConnectionType.request.getVerbBytes().length;
                } else if (fHTTPHeader.checkCharacterArray(this.buffer, n, HttpHeaderDefinitions.ConnectionType.connect.getVerbBytes())) {
                    n += HttpHeaderDefinitions.ConnectionType.connect.getVerbBytes().length;
                    this.connectionType = HttpHeaderDefinitions.ConnectionType.connect;
                    this.isWebBasedClient = true;
                    this.isNativeNirvana = true;
                } else if (fHTTPHeader.checkCharacterArray(this.buffer, n, HttpHeaderDefinitions.ConnectionType.requestJS.getVerbBytes())) {
                    n += HttpHeaderDefinitions.ConnectionType.requestJS.getVerbBytes().length;
                    this.connectionType = HttpHeaderDefinitions.ConnectionType.requestJS;
                    this.javascript = true;
                } else if (fHTTPHeader.checkCharacterArray(this.buffer, n, HttpHeaderDefinitions.ConnectionType.connectJS.getVerbBytes())) {
                    n += HttpHeaderDefinitions.ConnectionType.connectJS.getVerbBytes().length;
                    this.connectionType = HttpHeaderDefinitions.ConnectionType.connectJS;
                    this.javascript = true;
                }
            } else {
                if (this.cookieEndIndex == -1 && fHTTPHeader.checkCharacterArray(this.buffer, n, sCookie)) {
                    this.cookieStartIndex = n;
                    this.cookieEndIndex = n = fHTTPHeader.findEndOfParameter(this.buffer, n, this.parametersEndIndex);
                    continue;
                }
                if (this.javascript && !this.checkedJavascriptProtocol && fHTTPHeader.checkCharacterArray(this.buffer, n, sJavacriptProtocolParamater)) {
                    this.checkedJavascriptProtocol = true;
                    if (fHTTPHeader.checkCharacterArray(this.buffer, n += sJavacriptProtocolParamater.length, sCometChunkedDetection)) {
                        this.cometChunked = true;
                        this.corsSupport = true;
                        n += sCometChunkedDetection.length;
                    } else if (fHTTPHeader.checkCharacterArray(this.buffer, n, sLongPollDetectionJsonP)) {
                        this.longPollJsonP = true;
                        this.longPoll = true;
                        n += sLongPollDetectionJsonP.length;
                    } else if (fHTTPHeader.checkCharacterArray(this.buffer, n, sLongPollDetectionCors)) {
                        this.corsSupport = true;
                        this.longPoll = true;
                        n += sLongPollDetectionCors.length;
                    } else if (fHTTPHeader.checkCharacterArray(this.buffer, n, sLongPollDetection)) {
                        this.longPoll = true;
                        n += sLongPollDetection.length;
                    } else if (fHTTPHeader.checkCharacterArray(this.buffer, n, sCometSSEDetection)) {
                        this.serverSentEvents = true;
                        n += sCometSSEDetection.length;
                    }
                }
            }
            bl = false;
        }
    }

    private static boolean checkCharacterArray(byte[] byArray, int n, byte[] byArray2) {
        for (byte by : byArray2) {
            if (fHTTPHeader.checkCharacter(byArray[n++], by)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkCharacter(byte by, byte by2) {
        return by == by2 || by == (by2 | 0x20) && by2 >= 65 && by2 <= 90;
    }

    private static int findNonWhiteSpaceAfterField(byte[] byArray, int n, int n2) {
        n += n2;
        while (byArray[n] == 32 || byArray[n] == 9 || byArray[n] == 58) {
            ++n;
        }
        return n;
    }

    private static int findEndOfParameter(byte[] byArray, int n, int n2) {
        while (n < n2 && byArray[n] != 32 && byArray[n] != 38) {
            ++n;
        }
        return n;
    }

    boolean isLongPollFlush() {
        return this.checkForParameter(sLongPollFlush) || this.checkForParameter(sLongPollFlushAlt);
    }

    public boolean isCometCloseRequest() {
        return this.checkForParameter(sCometCloseRequest);
    }

    private boolean checkForParameter(byte[] byArray) {
        return this.findParameterPosition(byArray) > -1;
    }

    private int findParameterPosition(byte[] byArray) {
        if (this.parametersStartIndex > -1) {
            boolean bl = true;
            for (int i = this.parametersStartIndex; i < this.parametersEndIndex; ++i) {
                if (this.buffer[i] == 38) {
                    bl = true;
                    continue;
                }
                if (!bl) continue;
                if (fHTTPHeader.checkCharacterArray(this.buffer, i, byArray) && (i + byArray.length == this.parametersEndIndex || this.buffer[i + byArray.length] == 38)) {
                    return i;
                }
                bl = false;
            }
        }
        return -1;
    }

    int cometRequestNumber() {
        int n = this.findParameterPosition(sCometRequestCount);
        if (n > -1) {
            int n2 = fHTTPHeader.findEndOfParameter(this.buffer, n += sCometRequestCount.length, this.parametersEndIndex);
            return fAsciiByteArrayToPrimitiveType.convertToInt(this.buffer, n, n2 - n);
        }
        return -1;
    }

    public int ContentLength() {
        if (this.contentLength == -1) {
            return 0;
        }
        return this.contentLength;
    }

    public boolean isGet() {
        return this.requestMethod == HttpHeaderDefinitions.RequestMethods.get;
    }

    int getParametersStartIndex() {
        return this.parametersStartIndex;
    }

    int getParametersEndIndex() {
        return this.parametersEndIndex;
    }

    public boolean hasCookie() {
        return this.cookieEndIndex > -1;
    }

    public long getLongCookie() {
        if (this.cookieEndIndex != -1) {
            return ByteArrayHash.hash(this.buffer, this.cookieStartIndex, this.cookieEndIndex - this.cookieStartIndex);
        }
        if (this.cookie != null) {
            return ByteArrayHash.hash(this.cookie);
        }
        return 0L;
    }

    public byte[] getCookie() {
        return this.cookie;
    }

    public String ClientHostName() {
        if (this.isForwarded) {
            return fStringByteConverter.convert(this.buffer, this.clientHostNameStartIndex, this.clientHostNameEndIndex - this.clientHostNameStartIndex);
        }
        return null;
    }

    String UserAgent() {
        return fStringByteConverter.convert(this.buffer, this.userAgentStartIndex, this.userAgentEndIndex - this.userAgentStartIndex);
    }

    public boolean isCometChunking() {
        return this.cometChunked;
    }

    boolean isCometSSE() {
        return this.serverSentEvents;
    }

    boolean isLongPollJsonP() {
        return this.longPollJsonP;
    }

    public boolean isLongPoll() {
        return this.longPoll;
    }

    boolean isCORSSupport() {
        return this.corsSupport;
    }

    public void setCorsSupport(boolean bl) {
        this.corsSupport = bl;
    }

    public void setCometChunking(boolean bl) {
        this.cometChunked = bl;
    }

    int getOriginStartIndex() {
        return this.originStartIndex;
    }

    int getOriginEndIndex() {
        return this.originEndIndex;
    }

    public HttpHeaderDefinitions.ConnectionType getConnectionType() {
        return this.connectionType;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int getEndoOfHeaderLocation() {
        return this.endOfHeaderPosition;
    }

    public int getEndOfBuffer() {
        return this.endOfBuffer;
    }

    public HttpHeaderDefinitions.HttpVersion getVersion() {
        return this.version;
    }

    public void setVersion(HttpHeaderDefinitions.HttpVersion httpVersion) {
        this.version = httpVersion;
    }

    void setEndOfBuffer(int n) {
        this.endOfBuffer = n;
    }

    public void setCookie(byte[] byArray) {
        this.cookie = byArray;
    }

    boolean isForwarded() {
        return this.isForwarded;
    }

    boolean isWebBasedClient() {
        return this.isWebBasedClient;
    }

    public boolean isChunkedInput() {
        return this.chunkedInput;
    }

    boolean isWebSocket() {
        return this.webSocket;
    }

    int getWSVersion() {
        if (this.wsVersion == -1) {
            int n = 0;
            while (n < this.lastLineIndexPosition && this.headerLinePositions[n] != -1) {
                int n2;
                if (!fHTTPHeader.checkCharacterArray(this.buffer, n2 = this.headerLinePositions[n++], sWSVersion)) continue;
                this.wsVersion = fAsciiByteArrayToPrimitiveType.convertToInt(this.buffer, fHTTPHeader.findNonWhiteSpaceAfterField(this.buffer, n2, sWSVersion.length), this.headerLinePositions[n] - 2);
                break;
            }
        }
        return this.wsVersion;
    }

    int getWSSecKeyStart() {
        int n = 0;
        while (n < this.lastLineIndexPosition && this.headerLinePositions[n] != -1) {
            int n2;
            if (!fHTTPHeader.checkCharacterArray(this.buffer, n2 = this.headerLinePositions[n++], sWSSecKey)) continue;
            this.wsSecKeyEndIndex = this.headerLinePositions[n] - 2;
            return fHTTPHeader.findNonWhiteSpaceAfterField(this.buffer, n2, sWSSecKey.length);
        }
        return -1;
    }

    int getWsSecKeyEnd() {
        return this.wsSecKeyEndIndex;
    }

    public boolean isJavascript() {
        return this.javascript;
    }

    boolean isNativeNirvana() {
        return this.isNativeNirvana;
    }

    boolean isFirefox() {
        for (int i = this.userAgentStartIndex; i < this.userAgentEndIndex; ++i) {
            if (!fHTTPHeader.checkCharacterArray(this.buffer, i, sFirefox)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return fStringByteConverter.convert(this.buffer) + "\n";
    }
}

